<?php

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modellist');

/**
 * Component Items Model
 */
class TaxiBookingModelOrders extends JModelList {

    /**
     * Items data
     *
     * @var object
     */
    var $_data = null;

    /**
     * Items total
     *
     * @var integer
     */
    var $_total = null;

    /**
     * Pagination object
     *
     * @var object
     */
    var $_pagination = null;

    /**
    * Model context string.
    *
    * @var		string
    */
    protected $_context = 'com_taxibooking.orders';

    /**
     * Constructor
     *
     * @since 1.0
     */
    function __construct() {
        parent::__construct();
    }
    
    protected function populateState($ordering = null, $direction = null) {
            
        // Initialise variables.
        $app = JFactory::getApplication();

        // List state information
        $limit = $app->getUserStateFromRequest('global.list.limit', 'limit', $app->getCfg('list_limit'));
        $this->setState('list.limit', $limit);

        $limitstart = JRequest::getVar('limitstart', 0, '', 'int');
        $this->setState('list.start', $limitstart);

        // List state information.
        parent::populateState();
    }
    
    /**
     * Return all the users of Group Driver
     * @return type 
     */
    function getPaymentMethods() {

        $extPlgTable = '#__extensions';
        $extField1 = 'extension_id';
        $extField2 = 'element';

        $select = 'id AS value, title AS text  ';

        $q = 'SELECT v.id AS value, v.title AS text FROM  `#__taxibooking_paymentmethods` as v ';
        $q .= ' LEFT JOIN `' . $extPlgTable . '` as j ON j.`' . $extField1 . '` =  v.`payment_plugin_id` ';
        $q .= ' WHERE v.`published` = "1" AND j.`folder` = "tbpayment"';
        $q .= ' ORDER BY v.`ordering`';

        $this->_db->setQuery ($q);

        $this->methods = $this->_db->loadObjectList();

        return $this->methods;
    }
    
    /**
     * Method to get item data
     *
     * @access public
     * @return object
     */
    function getData() {
        // Lets load the Items if it doesn't already exist
        if (empty($this->_data)) {
            $query = $this->_buildQuery();
            //$this->_data = $this->_getList($query, $this->getState('list.start'), $this->getState('list.limit'));
            $this->_data = $this->_getList($query);
        }

        return $this->_data;
    }

    /**
     * Method to get the total nr of the Items
     *
     * @access public
     * @return integer
     */
    function getTotal() {
        // Lets load the Items if it doesn't already exist
        if (empty($this->_total)) {
            $query = $this->_buildQuery();
            $this->_total = $this->_getListCount($query);
        }

        return $this->_total;
    }


    /**
     * Method to get a pagination object for the Items
     *
     * @access public
     * @return object
     */
    function getPagination() {
        // Lets load the Items if it doesn't already exist
        if (empty($this->_pagination)) {
            jimport('joomla.html.pagination');
            $this->_pagination = new JPagination($this->getTotal(), $this->getState('list.start'), $this->getState('list.limit'));
        }

        return $this->_pagination;
    }

    /**
     * Method to build the query for the Items
     *
     * @access private
     * @return string
     * @since 1.0
     */
    function _buildQuery() {
        // Get the WHERE and ORDER BY clauses for the query
        $where = $this->_buildContentWhere();
        $orderby = $this->_buildContentOrderBy();

        $query = 'SELECT u.name AS drivername, od.*, pm.title AS payment_method '
                . 'FROM #__taxibooking_orders AS od '
                . 'LEFT JOIN #__users AS u ON u.id = od.driver_id '
                . 'LEFT JOIN #__taxibooking_paymentmethods AS pm ON pm.id = od.payment '
                . $where
                . $orderby
        ;

        return $query;
    }

    /**
     * Method to build the orderby clause of the query for the Items
     *
     * @access private
     * @return string
     * @since 1.0
     */
    function _buildContentOrderBy() {
        $filter_order = $this->getUserStateFromRequest($this->context . '.orders.filter_order', 'filter_order', 'datetime1', 'cmd'); //$mainframe->getUserStateFromRequest( $option.'.points.filter_order', 		'filter_order', 	'p.ordering', 'cmd' );
        $filter_order_Dir = $this->getUserStateFromRequest($this->context . '.orders.filter_order_Dir', 'filter_order_Dir', ' DESC', 'word'); // $mainframe->getUserStateFromRequest( $option.'.points.filter_order_Dir',	'filter_order_Dir',	'', 'word' );

        if (trim($filter_order) == '')
            $filter_order = ' datetime1 ';
        if (trim($filter_order_Dir) == '')
            $filter_order_Dir = ' DESC ';

        $orderby = ' ORDER BY ' . $filter_order . ' ' . $filter_order_Dir . ', created DESC ';

        return $orderby;
    }

    /**
     * Method to build the where clause of the query for the Items
     *
     * @access private
     * @return string
     * @since 1.0
     */
    function _buildContentWhere()
    {
        $mainframe = JFactory::getApplication();
        $elsettings =  booking_helper::config();
        $user =  JFactory::getUser();
        $isAdmin = booking_helper::userIsInAdminGroups($user->get('id'));
        
        $fromdate = JRequest::getVar('fromdate', '');
        $todate = JRequest::getVar('todate', '');
        
        /*if($fromdate!="" && $elsettings->date_format=='mm-dd-yy') {
            $date1_arr = explode('-',$fromdate);
            $fromdate =  $date1_arr[1].'-'.$date1_arr[0].'-'.$date1_arr[2];
        }
        if($todate!="" && $elsettings->date_format=='mm-dd-yy') {
            $date2_arr = explode('-',$todate);
            $todate =  $date2_arr[1].'-'.$date2_arr[0].'-'.$date2_arr[2];
        }*/
        
        $filter_state = $this->getUserStateFromRequest($this->context . '.orders.filter_state', 'filter_state', '', 'word');
        $filter_payment = JRequest::getInt('filter_payment', 0);
        $filter_driver = $this->getUserStateFromRequest($this->context . '.orders.filter_driver', 'filter_driver', '', 'string');
        $filter_car = $this->getUserStateFromRequest($this->context . '.orders.filter_car', 'filter_car', '', 'string');
        $search = $this->getUserStateFromRequest($this->context . '.orders.search', 'search', '', 'string');
        $search = $this->_db->getEscaped(trim(JString::strtolower($search)));

        $where = array();

        if ($filter_state) {
            if ($filter_state == 'P') {
                $where[] = 'od.state = 1';
            } else if ($filter_state == 'U') {
                $where[] = 'od.state = 0';
            } else if ($filter_state == 'A') {
                $where[] = 'od.state = -1';
            } else if ($filter_state == 'W') {
                $where[] = 'od.state = -2';
            }
        }
        if ($filter_car) {
            $where[] = 'od.vehicletype = "' . $filter_car . '"';
        }
        
        if ($filter_driver) {
            $where[] = 'od.driver_id = "' . $filter_driver . '"';
        }

        if ($filter_payment>0) {
            $where[] = 'od.payment = '.(int)$filter_payment;
        }
        
        // collect copied users orders
	$copy_orders_sql = '';
	$copy_order_ids = array();
	if (!$isAdmin) {
	    $query = $this->_db->getQuery(true);
	    $query->select('DISTINCT order_id');
	    $query->from('#__taxibooking_order_copyusers');
	    $query->where('user_id = '.(int)$user->get('id'));
	    $this->_db->setQuery((string)$query);
	    $copy_order_ids = $this->_db->loadColumn();
	    if(!empty($copy_order_ids)){
		$copy_orders_sql = ' OR od.id IN ('.implode(',',$copy_order_ids).')';
	    }
	}
        
        // registered users will see his orders only
        if (!$isAdmin) {
            $user_email = $user->get('email');
            $where[] = '(od.email = '.$this->_db->Quote($user_email). $copy_orders_sql.')';
        }
        
        if($fromdate!='' && $todate != '')
        {
            $fromtime = JRequest::getVar('fromtime', '00:00');
            $totime = JRequest::getVar('totime', '23:59');
            
            $from_time_str = strtotime($fromdate.' '.$fromtime);
            $to_time_str = strtotime($todate.' '.$totime);
            
            JRequest::setVar('from_time_str', $from_time_str);
            JRequest::setVar('to_time_str', $to_time_str);
            
            $where[] = '( (od.datetime1 BETWEEN ' . $this->_db->Quote($from_time_str) . ' AND ' . $this->_db->Quote($to_time_str) . ')
                        OR (od.datetime2 BETWEEN ' . $this->_db->Quote($from_time_str) . ' AND ' . $this->_db->Quote($to_time_str) . ') )';
        }

        if ($search) {
            $where[] = ' LOWER(od.title) LIKE ' . $this->_db->Quote('%' . $this->_db->getEscaped($search, true) . '%', false);
        }
        $where = ( count($where) ? ' WHERE ' . implode(' AND ', $where) : '' );

        return $where;
    }
}