<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_users
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('behavior.tooltip');

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
?>

<link rel="stylesheet" type="text/css" media="screen" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/modal_table.css" />

<form action="index.php?option=com_taxibooking&view=addresses&layout=modal&tmpl=component" method="post" name="adminForm" id="adminForm">
	<fieldset class="filter">
		<label class="filter-search-lbl" for="filter-search"><?php echo JText::_('JSEARCH_FILTER_LABEL'); ?></label>
		<input type="text" class="inputbox" name="filter-search" id="filter-search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" />
		<button type="submit"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
		<button type="button" onclick="document.getElementById('filter-search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
	</fieldset>

	<table class="adminlist table table-striped table-condensed">
		<thead>
			<tr>
				<th class="left">
					<?php echo JHtml::_('grid.sort', 'MYORDERS_USER_ADDRESS_TITLE', 'a.title', $listDirn, $listOrder); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="2">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
		<?php
			$i = 0;
			foreach ($this->items as $item) : ?>
			<tr class="row<?php echo $i % 2; ?>">
				<td>
					<a href="javascript:void(0);" onclick="if (window.parent) window.parent.selectAddress('<?php echo $item->id; ?>', '<?php echo $this->escape(addslashes($item->title)); ?>', '<?php echo $this->escape(addslashes($item->lat)); ?>', '<?php echo $this->escape(addslashes($item->lng)); ?>', '<?php echo $this->section;?>');">
						<?php echo $this->escape($item->title); ?>
					</a>
				</td>
			</tr>
		<?php endforeach; ?>
		</tbody>
	</table>
	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<input type="hidden" name="layout" value="modal" />
		<input type="hidden" name="tmpl" value="component" />
		<input type="hidden" name="section" value="<?php echo $this->section; ?>" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
</form>
