<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/table.css" />


<form action="<?php echo JRoute::_('index.php');?>" method="post" name="adminForm" id="adminForm">

    <table class="adminlist" cellspacing="0" border="0" width="100%">
	
	<?php if($this->user_type=='admin'){ ?>
        <tr>
            <td><?php echo JText::_('DRIVER'); ?>:</td>
            <td>
                <?php echo $this->lists['driver']; ?>
            </td>
        </tr>
        <tr><td><?php echo JText::_('STATE');?>:</td><td><?php echo $this->lists['state'];?></td></tr>
	<?php } ?>
	
        <tr>
            <td colspan="2"><b>DETAILS PROVIDED FROM USER</b></td>
        </tr>
        
        <tr><td><?php echo JText::_('NAME');?>:</td><td><?php echo $this->row_queue->names;?></td></tr>
        <tr><td><?php echo JText::_('EMAIL');?>:</td><td><?php echo $this->row_queue->email;?></td></tr>
        <tr><td><?php echo JText::_('PHONE');?>:</td><td><?php echo $this->row_queue->phone;?></td></tr>
	
        <tr><td><?php echo JText::_('PASSENGERS');?>:</td><td><?php echo $this->row_queue->selpassengers; ?></td></tr>
	<tr><td><?php echo JText::_('CHECK_IN_LAGUAGE');?>:</td><td><?php echo $this->row_queue->selluggage; ?></td></tr>
	
	<?php if($this->row_queue->selinfantseats > 0){ ?>
        <tr><td><?php echo JText::_('INFANT_SEATS');?>:</td><td><?php echo $this->row_queue->selinfantseats;?></td></tr>
	<?php } ?>
	
	<?php if($this->row_queue->selchildseats > 0){ ?>
        <tr><td><?php echo JText::_('CHILD_SEATS');?>:</td><td><?php echo $this->row_queue->selchildseats;?></td></tr>
	<?php } ?>
	
	<?php if($this->row_queue->selboosterseats > 0){ ?>
        <tr><td><?php echo JText::_('BOOSTER_SEATS');?>:</td><td><?php echo $this->row_queue->selboosterseats;?></td></tr>
	<?php } ?>
	
        <tr><td><?php echo JText::_('CAR'); ?>:</td><td><?php echo booking_helper::get_order_car($this->row_queue); ?></td></tr>
	
	<tr><td><?php echo JText::_('TRIP_DURATION'); ?>:</td><td><?php echo $this->row_queue->duration_text;?></td></tr>
	
	<?php if($this->row_queue->booking_type!='hourly'){ ?>
        <tr class='tr_col_from'><td><?php echo JText::_('FROM'); ?>:</td><td><?php echo $this->row_queue->begin;?></td></tr>
	<?php } ?>
	
	<?php
	if($this->row_queue->poi_additional_charges != '')
	{
		$poi_additional_charges = unserialize($this->row_queue->poi_additional_charges);
		if(!empty($poi_additional_charges['pickup']))
		{
	?>
	<tr>
		<td><?php echo $poi_additional_charges['pickup']['fld_label'];?>:</td>
		<td><?php echo booking_helper::price_display($poi_additional_charges['pickup']['charge'], $this->elsettings);?></td>
	</tr>
	<?php
		}
	}
	?>
	
	<?php
	if($this->row_queue->extras != '')
	{
	    $extras = unserialize($this->row_queue->extras);
	    if(!empty($extras['pickup']))
	    {
		    $counter = 0;
		    foreach($extras['pickup'] as $extra)
		    {
			    $addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
		    ?>
		    <tr>
			    <td><?php echo $extra['name'];?>:</td>
			    <td>
				    <?php echo $extra['value'];?>
				    <?php if($extra['price']>0){
					echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
				    }?>
			    </td>
		    </tr>
		    <?php
		    $counter++;
		    }
	    }
	}
	?>
	
        <tr class='tr_col_from'>
            <td><?php echo JText::_('ORDER_DETAILS_PICKUP_DATE');?>:</td>
            <td>
		<?php echo booking_helper::get_order_pickup_date($this->row_queue, $this->elsettings); ?>
	    </td>
        </tr>
	
	<?php if($this->row_queue->booking_type=='hourly'){ ?>
	<tr class='tr_col_from'>
		<td><?php echo JText::_('HOURLY_HIRE_VEHICLE_HIRED_FOR'); ?>:</td>
		<td><?php echo $this->row_queue->hourly_hr.':'.$this->row_queue->hourly_min;?> hours</td>
	</tr>
	<?php } ?>
	
	<?php
	$stops = unserialize($this->row_queue->stops);
	if(!empty($stops))
	{
	?>
        <tr>
	    <td><?php echo JText::_('STOPS'); ?>:</td>
	    <td>
		<table border="0" width="100%">
		    <?php foreach($stops as $key => $stop_row) { ?>
		    <tr width="100%">
			<td width="100%"><?php echo $stop_row['stop'].' - '.$stop_row['stop_interval'].' mins';?></td>
		    </tr>
		    <?php } ?>
		</table>
	    </td>
	</tr>
	<?php } ?>

	<?php if($this->row_queue->booking_type!='hourly'){ ?>
        <tr class='tr_col_to'><td><?php echo JText::_('TO'); ?>:</td><td><?php echo $this->row_queue->end;?></td></tr>
	<?php } ?>
	
	<?php
	if($this->row_queue->poi_additional_charges != '')
	{
		$poi_additional_charges = unserialize($this->row_queue->poi_additional_charges);
		if(!empty($poi_additional_charges['dropoff']))
		{
	?>
	<tr>
		<td><?php echo $poi_additional_charges['dropoff']['fld_label'];?>:</td>
		<td><?php echo booking_helper::price_display($poi_additional_charges['dropoff']['charge'], $this->elsettings);?></td>
	</tr>
	<?php
		}
	}
	?>
	
	<?php
	if($this->row_queue->extras != '')
	{
	    $extras = unserialize($this->row_queue->extras);
	    if(!empty($extras['dropoff']))
	    {
		    $counter = 0;
		    foreach($extras['dropoff'] as $extra)
		    {
			    $addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
		    ?>
		    <tr>
			    <td><?php echo $extra['name'];?>:</td>
			    <td>
				    <?php echo $extra['value'];?>
				    <?php if($extra['price']>0){
					echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
				    }?>
			    </td>
		    </tr>
		    <?php
		    $counter++;
		    }
	    }
	}
	?>
	
	<?php
	if($this->row_queue->booking_type=='hourly')
	{
	    if($this->row_queue->extras != '')
	    {
		$extras = unserialize($this->row_queue->extras);
		if(!empty($extras['hourly_hire']))
		{
			$counter = 0;
			foreach($extras['hourly_hire'] as $extra)
			{
				$addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
			?>
			<tr>
				<td><?php echo $extra['name'];?>:</td>
				<td>
					<?php echo $extra['value'];?>
					<?php if($extra['price']>0){
					    echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
					}?>
				</td>
			</tr>
			<?php
			$counter++;
			}
		}
	    }
	}
	?>
	
	<?php
	if($this->row_queue->extras != '')
	{
	    $extras = unserialize($this->row_queue->extras);
	    if(!empty($extras['user_details']))
	    {
		    $counter = 0;
		    foreach($extras['user_details'] as $extra)
		    {
			    $addtional_class = (($counter+1)==count($extras)) ? ' last' : '';
		    ?>
		    <tr>
			    <td><?php echo $extra['name'];?>:</td>
			    <td>
				    <?php echo $extra['value'];?>
				    <?php if($extra['price']>0){
					echo '('.booking_helper::price_display('+'.$extra['price'], $this->elsettings).')';
				    }?>
			    </td>
		    </tr>
		    <?php
		    $counter++;
		    }
	    }
	}
	?>
	
	<?php if($this->row_queue->booking_type!='hourly'){ ?>
        <tr><td><?php echo JText::_('RETURN_TRIP'); ?>:</td><td><?php echo ($this->row_queue->returntrip?'YES':'NO');?></td></tr>
	<?php } ?>
	
        <?php if($this->row_queue->returntrip){ ?>
	    
	    <?php if($this->row_queue->return_wait_hr==-1 && $this->row_queue->datetime2!=""){ ?>
            <tr class='tr_col_to'>
                <td><?php echo JText::_('DATE_RETURN_TRIP'); ?>:</td>
                <td>
		    <?php echo booking_helper::get_order_return_date($this->row_queue, $this->elsettings); ?>
		</td>
            </tr>
	    <?php } else { ?>
	    <tr class='tr_col_to'>
                <td><?php echo JText::_('RETURN_TRIP_WAIT_TIME'); ?>:</td>
                <td>
		    <?php echo JText::sprintf('NEW_ORDER_EMAIL_RETURN_WAIT_TIME', $this->row_queue->return_wait_hr, $this->row_queue->return_wait_discount.'%');; ?>
		</td>
            </tr>
	    <?php } ?>
	<?php }else { ?>
	<input name='date2' value='' type='hidden' /><input name='time2' value='' type='hidden' />
	<?php }?>
        
	<tr>
		<td><?php echo JText::_('SUB_TOTAL');?>:</td>
		<td><?php echo booking_helper::price_display($this->row_queue->sub_total, $this->elsettings);?></td>
	</tr>
	
	<?php if($this->row_queue->flat_cost>0){ ?>
	<tr>
		<td><?php echo JText::_('FLAT_COST');?>:</td>
		<td><?php echo booking_helper::price_display($this->row_queue->flat_cost, $this->elsettings);?></td>
	</tr>
	<?php } ?>

	<?php if($this->row_queue->percentage_cost>0){ ?>
	<tr>
		<td><?php echo JText::_('PERCENTAGE_COST');?>:</td>
		<td><?php echo booking_helper::price_display($this->row_queue->percentage_cost, $this->elsettings);?></td>
	</tr>
	<?php } ?>
	
	<tr>
		<td><?php echo JText::_('GRAND_TOTAL');?>:</td>
		<td><?php echo booking_helper::price_display($this->row_queue->cprice, $this->elsettings);?></td>
	</tr>
</table>

<?php echo JHTML::_( 'form.token' ); ?>

    <?php
    if($this->user_type=='admin'){
    ?>	
	<input type="submit" class="button" name="submit" value="<?php echo JText::_('JSAVE');?>" />
	<input type="button" class="button" name="cancel" value="<?php echo JText::_('JCANCEL');?>" onclick="window.history.go(-1);" />
    <?php
    } else {
    ?>
    <input type="button" class="button" name="orders" value="<?php echo JText::_('JPREVIOUS');?>" onclick="window.history.go(-1);" />
    <?php } ?>
    
    <input type="hidden" name="option" value="com_taxibooking" />
    <input type="hidden" name="id" value="<?php echo $this->row_queue->id; ?>" />
    <input type="hidden" name="controller" value="orders" />
    <input type="hidden" name="view" value="order" />
    <input type="hidden" name="task" value="save" />
</form>

<?php
//keep session alive while editing
JHTML::_('behavior.keepalive');
?>