<?php

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * View class
 */
class TaxiBookingViewOrder extends JViewLegacy
{
    function display($tpl = null)
    {
        //initialise variables
        $app = JFactory::getApplication();
        $editor =  JFactory::getEditor();
        $document =  JFactory::getDocument();
        $user =  JFactory::getUser();
        $db =  JFactory::getDBO();
        $lang =  JFactory::getLanguage();
        $elsettings =  booking_helper::config();
        
        $groups = $user->get('groups');
        $gid = array_keys($groups);

        $order_id = JRequest::getInt('cid', 0);
        
        // Get the page/component configuration
        $params = $app->getParams();
        
        $isAdmin = booking_helper::userIsInAdminGroups($user->get('id'));
        if($isAdmin){
            $user_type = 'admin';
        }
        else {
            $user_type = 'user';
            $user_order_ids = booking_helper::getUserOrders();
        
            if(!in_array($order_id, $user_order_ids)){
                JError::raiseWarning('SOME_ERROR_CODE', JText::_('ORDER_ACCESS_DENIED'));
                $app->redirect('index.php?option=com_taxibooking&view=orders&Itemid='.TaxibookingHelperRoute::getOrdersItemid());
            }
        }
        
        /*
         * Handle the metadata for the categories list
         */
        $this->document->setTitle($params->get('page_title'));
        $this->document->setMetadata('keywords', $params->get('page_title'));

        if ($app->getCfg('MetaTitle') == '1') {
            $this->document->setMetadata('title', $params->get('page_title'));
        }

        /**
         * Validating user group only to admin 
         */
        $driver_group = $this->getDriverGroup();
        
        JHTML::_('behavior.tooltip');
        $nullDate = $db->getNullDate();

        //Get data from the model
        $row =  $this->get('Item');

        $lists = array();
        /**
         * Prapring dropdown to Drivers select box 
         */
        $drivers = booking_helper::getDrivers();
        $driver_options = array();
        if (count($drivers) > 0) {
            $driver_options[] = JHTML::_('select.option', 0, JText::_('SELECT_OPTION'));
            foreach ($drivers As $d) {
                $driver_options[] = JHTML::_('select.option', $d->user_id, $d->name);
            }
        }
        else
        {
            $driver_options[] = JHTML::_('select.option', "", JText::_('ORDER_DETAILS_DRIVER_CREATE_GROUP'));
        }
        $lists['driver'] = JHTML::_('select.genericlist', $driver_options, 'driverid', '', 'value', 'text', $row->driver_id);

        //build state list
        $booking_date = is_numeric( $row->payment) ? $row->datetime1 : strtotime( booking_helper::DateTimeHuman( $row->datetime1));
        $return_date = ($row->datetime2!="" && is_numeric($row->payment)) ? $row->datetime2 : strtotime( booking_helper::DateTimeHuman( $row->datetime2));
        
        //build state list
        $state = array();
        if ( $booking_date > time() || $return_date >time() )
        {
            $state[] = JHTML::_('select.option', 1, JText::_('Accepted'));
            $state[] = JHTML::_('select.option', 0, JText::_('Rejected'));
            $state[] = JHTML::_('select.option', -1, JText::_('Archived'));
            $state[] = JHTML::_('select.option', -2, JText::_('Waiting'));
        }
        else // for past periods - only Reject or Archive
        {
            $state[] = JHTML::_('select.option', 0, JText::_('Rejected'));
            $state[] = JHTML::_('select.option', -1, JText::_('Archived'));
        }
        $lists['state'] = JHTML::_('select.genericlist', $state, 'state', '', 'value', 'text', $row->state);

        //assign data to template
        $this->assignRef('user_type', $user_type);
        $this->assignRef('lists', $lists);
        $this->assignRef('row_queue', $row);
        $this->assignRef('elsettings', $elsettings);
        
        $isDriver = 0;
        if (in_array($driver_group, $gid))// pass the reference to template to enable/disable edit option
            $isDriver = 1;
        $this->assignRef('ISDRIVER', $isDriver);

        parent::display($tpl);
    }

    /*
     * Return the dirver group id
     */

    function getDriverGroup()
    {
        $db =  JFactory::getDBO();
        $query = 'SELECT id, parent_id'
                . ' FROM #__usergroups'
                . ' WHERE title = "Driver"'
                . ' LIMIT 1'
        ;
        $db->setQuery($query);
        $db->query();
        $driver = $db->loadObject();
        if($driver){
            return $driver->id;
        }
        else {
            return false;
        }
    }
}