<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die('Restricted access');

if (isset($_POST['fromdate']))
    $fromdate = $_POST['fromdate']; else
    $fromdate = "";
    
if (isset($_POST['fromtime'])){
    $fromtime = $_POST['fromtime'];
} else {
    $fromtime = '00:00';
}

if (isset($_POST['todate']))
    $todate = $_POST['todate']; else
    $todate = "";  //24/10/2008
    
if (isset($_POST['totime'])){
    $totime = $_POST['totime'];
} else {
    $totime = '23:59';
}

$from_time_str = JRequest::getVar('from_time_str', '');
$to_time_str = JRequest::getVar('to_time_str', '');

if($this->elsettings->date_format=='mm-dd-yy') {
    $format = '%m-%d-%Y';
}
else {
    $format = '%d-%m-%Y';
}
$format = '%Y-%m-%d';
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery-ui.css" />
<link rel="stylesheet" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/table.css" />

<div class="booking">
    <form action="<?php echo JRoute::_('index.php?option=com_taxibooking&view=orders&Itemid='.JRequest::getInt('Itemid')); ?>" method="post" name="adminForm">

        <table class="adminform">
            <tr>
                <td>
		    <div class="admin_wrap">
			    <h3><?php echo JText::_('ORDERS_TABLE_SEARCH'); ?><br></h3>
			    <div class="admin_fromwrap">
				    <label><?php echo JText::_('ORDERS_TABLE_SEARCH_FROM'); ?> (d/m/y):</label>						
				    <input type="text" name="fromdate" id="fromdate" readonly="readonly" class="calender" value="<?php echo ($from_time_str!="")? date('Y-m-d', $from_time_str) : '';?>" />
				    <input name="fromtime" class="text_area"  size="5" maxlength='5' value="<?php echo $fromtime; ?>" />&nbsp;&nbsp; 
			    </div>
			    <div class="admin_towrap">
				    <label><?php echo JText::_('ORDERS_TABLE_SEARCH_TO'); ?>(d/m/y):</label>						
				    <input type="text" name="todate" id="todate" readonly="readonly" class="calender" value="<?php echo ($to_time_str!="")? date('Y-m-d', $to_time_str) : '';?>" />
				    <input name="totime" class="text_area"  size="5" value="<?php echo $totime; ?>" maxlength='5' />
			    </div>
			    <div class="admin_buttonwrap">
				    <button class="button art-button" onclick="this.form.submit();"><?php echo JText::_('ORDERS_TABLE_SEARCH_GO'); ?></button>
				    <button class="button art-button" onclick="this.form.getElementById('fromdate').value='';this.form.getElementById('todate').value='';this.form.submit();"><?php echo JText::_('ORDERS_TABLE_SEARCH_RESET'); ?></button>
			    </div>
		    </div>
		    <div class="admin_searchWrap">
			    <?php echo $this->lists['car_list']; ?>
			    <?php echo $this->lists['driver']; ?>
			    <?php echo $this->lists['payment']; ?>
			    <?php echo $this->lists['state']; ?>
		    </div>
                </td>
            </tr>
        </table>

		
<div id="no-more-tables">
	<table class="table-striped table-bordered table-condensed" cellpadding="0" cellspacing="0" style="border: 1px solid #ccc;">
		<thead>
			<tr>
				<th><?php echo JText::_('NUM'); ?></th>
				<th><?php echo JText::_('NAME'); ?></th>
				<th class="numeric"><?php echo JText::_('PICKUP'); ?></th>
				<th class="numeric"><?php echo JText::_('FROM'); ?></th>
				<th class="numeric"><?php echo JText::_('TO'); ?></th>
				<th class="numeric"><?php echo JText::_('RETURN_TRIP'); ?></th>
				<th class="numeric"><?php echo JText::_('CAR'); ?></th>
				<th class="numeric"><?php echo JText::_('PASSENGERS'); ?></th>
				<th class="numeric"><?php echo JText::_('DRIVER_ID'); ?></th>
				<th class="numeric"><?php echo JText::_('PRICE'); ?></th>
				<th class="numeric"><?php echo JText::_('ORDERS_TABLE_HEADER_PAYMENT'); ?></th>
				<th class="numeric"><?php echo JText::_('STATE'); ?></th>
				<th class="numeric"><?php echo JText::_('ORDER_ID'); ?></th>
				<th class="numeric"><?php echo JText::_('INVOICE'); ?></th>
			</tr>
		</thead>	
		
		<tbody>
			<?php
			$k = 0;
			for ($i = 0, $n = count($this->rows); $i < $n; $i++) {
				$row = $this->rows[$i];
				
				//$pdf_invoice_url = "index.php?option=com_taxibooking&task=pdf_invoice&cid=". $row->id;
				//$invoice_link = "<a href=\"javascript:void window.open('$pdf_invoice_url', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');\">";
                    
				$link = 'index.php?option=com_taxibooking&view=order&cid=' . $row->id.'&Itemid='.JRequest::getInt('Itemid', 0);
				//$car_obj = booking_helper::get_car_details($row->vehicletype);

				if ($row->state == 1) {
					$img = 'tick.png';
					$inv_img = 'j_button2_readmore.png';
					$alt = JText::_('ACCEPTED');
					$inv_alt = JText::_('Invoice');
					$state = 1;
				} else if ($row->state == 0) {
					$img = 'publish_x.png';
					$alt = JText::_('REJECTED');
					$state = 0;
				} else if ($row->state == -1) {
					$img = 'disabled.png';
					$alt = JText::_('ARCHIVED');
					$state = -1;
				} else if ($row->state == -2) {
					$img = 'publish_r.png';
					$alt = JText::_('WAITING');
					$state = -2;
				}
				?>		
		
			<tr class="<?php echo "row$k"; ?>">
			    <td data-title="Num"><?php echo $this->pageNav->getRowOffset($i); ?></td>
			    <td data-title="<?php echo JText::_('NAME'); ?>"><a href="<?php echo JRoute::_($link, false); ?>"><?php echo $row->names; ?></a></td>
			    <td class="numeric" data-title="<?php echo JText::_('PICKUP'); ?>">
				<?php echo booking_helper::get_order_pickup_date($row, $this->elsettings); ?>
			    </td>
			    <td class="numeric" data-title="<?php echo JText::_('FROM'); ?>">
				<?php echo ($row->begin!='') ? $row->begin : '&nbsp;';?>
			    </td>
			    <td class="numeric" data-title="<?php echo JText::_('TO'); ?>">
				<?php echo ($row->end!='') ? $row->end : '&nbsp;';?>
			    </td>
			    <td class="numeric" data-title="<?php echo JText::_('RETURN_TRIP'); ?>">
				<?php echo ($row->datetime2=="") ? JText::_('JNO') : booking_helper::get_order_return_date($row, $this->elsettings); ?>
			    </td>
			    <td class="numeric" data-title="<?php echo JText::_('CAR'); ?>">
				<?php echo booking_helper::get_order_car($row); ?>
			    </td>
			    <td class="numeric" data-title="<?php echo JText::_('PASSENGERS'); ?>">
				<?php echo $row->selpassengers;?>
			    </td>
			    <td class="numeric" data-title="<?php echo JText::_('DRIVER_ID'); ?>">
				<?php echo ($row->drivername!='') ? $row->drivername : '&nbsp;';?>
			    </td>
			    <td class="numeric" data-title="<?php echo JText::_('PRICE'); ?>"><?php echo booking_helper::price_display($row->cprice, $this->elsettings); ?></td>
			    <td class="numeric" data-title="<?php echo JText::_('PAYMENT'); ?>">
				<?php echo booking_helper::get_order_payment($row); ?>
			    </td>
			    <td class="numeric" data-title="<?php echo JText::_('STATE'); ?>">
				<img src="<?php echo JURI::base(); ?>components/com_taxibooking/assets/images/<?php echo $img; ?>" width="16" height="16" border="0" title="<?php echo $alt; ?>" alt="<?php echo $alt; ?>" />
			    </td>
			    <td class="numeric" data-title="<?php echo JText::_('ORDER_ID'); ?>"><?php echo $row->id; ?></td>
			    <td class="numeric" data-title="<?php echo JText::_('INVOICE'); ?>">
				<?php
				$order_id = $row->id;
				$pdf_invoice = JPATH_COMPONENT_ADMINISTRATOR . DS . "documents".DS.$row->invoice_title;
				if ($row->state == 1 && ($row->invoice_title!="") && file_exists($pdf_invoice)){
				    //echo $invoice_link;
				    ?>
				    <a href="javascript:void(0);" class="invoice_download_trigger" data-cid="<?php echo $row->id;?>">
					<img src="<?php echo JURI::base();?>components/com_taxibooking/assets/images/pdf.png" width="25" height="25" title="<?php echo $inv_alt; ?>" alt="<?php echo $inv_alt; ?>" />
				    </a>                
				<?php }
				else {
				    echo '&nbsp;';
				}?>
			    </td>
			</tr>
                        <?php $k = 1 - $k;
                    }
                    ?>
		    </tbody>		
	    </table>
	    <div class="list_footerWrap clearfix">
		    <?php //echo $this->pageNav->getListFooter(); ?>
	    </div>		
	</div>
		
        <input type="hidden" name="boxchecked" value="0" />
        <input type="hidden" name="option" value="com_taxibooking" />
	<input type="hidden" name="controller" value="orders" />
        <input type="hidden" name="view" value="orders" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>" />
        <input type="hidden" name="filter_order_Dir" value="" />
	<?php echo JHTML::_('form.token'); ?>
    </form>
</div>

<?php //if($this->elsettings->load_jquery==1){ ?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<script type="text/javascript">
var tbjQuery = $.noConflict( true );
</script>
<?php //} ?>

<?php //if($this->elsettings->load_jqueryui==1){ ?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-ui.js"></script>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.ui.datepicker-en-GB.js"></script>
<?php //} ?>

<script type="text/javascript">
tbjQuery(document).ready(function(){
    tbjQuery( "#fromdate" ).datepicker({
        dateFormat: 'yy-mm-dd'
    })
    tbjQuery( "#todate" ).datepicker({
        dateFormat: 'yy-mm-dd'
    })
    tbjQuery('a.invoice_download_trigger').click(function(){
	var cid = tbjQuery(this).data('cid');
	// create the form
	var formHtml = '<form action="<?php echo JRoute::_('index.php?option=com_taxibooking&task=pdf_invoice'); ?>" method="POST" id="exportForm" name="exportForm">';
	formHtml += '<input type="hidden" name="cid" value="'+cid+'" />';
	formHtml += '<?php echo JHTML::_('form.token'); ?>';
	formHtml += '</form>';
	
	jQuery('body').append(formHtml);

	var exportForm = jQuery("#exportForm");
	exportForm.submit();
	exportForm.remove();
    })
})
</script>