<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

class TaxiBookingViewPayment extends JViewLegacy
{
    /**
     * Creates View
     *
     */
    function display($tpl = null)
    {
	//initialize variables
        $app = JFactory::getApplication();
	$user =  JFactory::getUser();
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();
        $uri =  JFactory::getURI();
        $session =  JFactory::getSession();
	
	$booking_form_url = TaxibookingHelperRoute::getBookingFormRoute($lang_tag);
	if($session->get('tmpl','')=='component'){
	    $booking_form_url .= '&tmpl=component';
	}
	
	if($user->get('guest')==1){
            $app->redirect('index.php?option=com_users&view=login&return='.base64_encode($booking_form_url), false);
	    return FALSE;
        }
	
	$cid = $app->input->get('cid', '');
	$order = booking_helper::get_order_by_order_number($cid);
	
	if($cid=="" || empty($order)){
	    $app->enqueueMessage ('Order not found!', 'warning');
	    $app->redirect(JRoute::_($booking_form_url, false));
	}
	
	if ($order->state == 1)
	{
	    $app->enqueueMessage ('Order is already Paid and Approved!', 'warning');
	    $app->redirect(JRoute::_($booking_form_url, false));
	}
	
	if ($order->state == 0)
	{
	    $app->enqueueMessage ('Order is already Rejected!', 'warning');
	    $app->redirect(JRoute::_($booking_form_url, false));
	}
	
	if ($order->state == -1)
	{
	    $app->enqueueMessage ('Order is already Archived!', 'warning');
	    $app->redirect(JRoute::_($booking_form_url, false));
	}
	
	if(!class_exists('tbPaymentPlugin')) require(JPATH_COMPONENT.DS.'classes'.DS.'tbpayment_plugin_helper.php');
	JPluginHelper::importPlugin('tbpayment');
	$dispatcher = JDispatcher::getInstance();
	$html = '';
	$returnValues = $dispatcher->trigger('plgTbOrderPayNow', array($order, &$html));
	
	$this->assignRef('html', $html);
        
	parent::display($tpl);
    }
}