<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );
?>

<div id="area_operation_wrapper">
    <div id="area_operation_dialog">
	<div id="service_unavailable_msg"><?php echo JText::_('PICKUP_DROPOFF_SERVICE_UNAVAILABLE');?></div>
	<div id="map-canvas-operation"></div>
    </div>
</div>

<style type="text/css">
#map-canvas-operation {
	min-height: 350px; 
	height: 350px; 
	width: 100%;	
}

#map-canvas-operation img {
	max-width: inherit !important;
}

#service_unavailable_msg {
color: red;
font-weight: bold;
margin-bottom: 10px;
}
</style>

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<script type="text/javascript">
var tbjQuery = $.noConflict( true );
var BASE_URL = '<?php echo JURI::root();?>';

var map, mapOptions, areaOfOperation;

var selectedAreaVerticesStr = '<?php echo $this->elsettings->operation_area_vertices; ?>';
var triangleCoords = new Array();
var selectedAreaVerticesArr = JSON.parse(selectedAreaVerticesStr);
</script>

<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o&v=3.exp&libraries=places"></script>

<script type="text/javascript">
function initialize() {
    
    for (var i =0; i < selectedAreaVerticesArr.length; i++) {
	triangleCoords.push(new google.maps.LatLng(selectedAreaVerticesArr[i][0],selectedAreaVerticesArr[i][1]));
    }

    // area of operation map
    var areaOfOperation_mapOptions = {
	zoom: 8,
	center: new google.maps.LatLng(selectedAreaVerticesArr[0][0],selectedAreaVerticesArr[0][1]),
	mapTypeId: google.maps.MapTypeId.ROADMAP
    };
  
    var areaOfOperation_map = new google.maps.Map(document.getElementById('map-canvas-operation'), areaOfOperation_mapOptions);
    
    // Construct the polygon.
    areaOfOperation = new google.maps.Polygon({
	paths: triangleCoords,
	strokeColor: '#FF0000',
	strokeOpacity: 0.8,
	strokeWeight: 2,
	fillColor: '#FF0000',
	fillOpacity: 0.35,
	draggable: false,
	editable: false
    });
  
    areaOfOperation.setMap(areaOfOperation_map);
    
    var bounds = new google.maps.LatLngBounds();
    for (var i =0; i < selectedAreaVerticesArr.length; i++) {
	bounds.extend(new google.maps.LatLng(selectedAreaVerticesArr[i][0],selectedAreaVerticesArr[i][1]));
    }
    google.maps.event.addListenerOnce(areaOfOperation_map, 'idle', function() {
	areaOfOperation_map.fitBounds(bounds);
    });
}

google.maps.event.addDomListener(window, 'load', initialize);

</script>