<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

$session =  JFactory::getSession();

if($this->elsettings->distance_unit=='kM'){
    $distance_unit = 'kM';
} else {
    $distance_unit = 'Mile';
}

// get disabled dates text from cache file
$filename = JPATH_ROOT.DS.'plugins'.DS.'system'.DS.'tbschedules'.DS.'cache.txt';
if (file_exists($filename)) {
    $contents = file_get_contents($filename);
    $disabled_dates = array();
    if(explode(',', $contents)){
	$disabled_dates = explode(',', $contents);
    }
}
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery-ui.css" />
<link rel="stylesheet" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery.selectbox.css" />

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<script type="text/javascript">
var tbjQuery = $.noConflict( true );
</script>

<?php
$booking_type = $session->get('booking_type', $this->default_tab_title);
$bgcolor = substr($this->elsettings->booking_form_bgcolor, 1);
$acttab = substr($this->elsettings->booking_form_active_tab_color, 1);
$inacttab = substr($this->elsettings->booking_form_inactive_tab_color, 1);
$boxcolor = substr($this->elsettings->booking_form_boxcolor, 1);
$fontcolor = substr($this->elsettings->booking_form_fontcolor, 1);
$headers_fontcolor = substr($this->elsettings->booking_form_header_tabs_fontcolor, 1);
$boxes_fontcolor = substr($this->elsettings->booking_form_boxes_fontcolor, 1);
$btncolor = substr($this->elsettings->booking_form_btncolor, 1);
$highlightscolor = substr($this->elsettings->highlights_color, 1);
$otherfontcolor = substr($this->elsettings->other_steps_fontcolor, 1);

$max_stop_time = $this->elsettings->max_stop_time;
$stop_duration_interval = $this->elsettings->stop_duration_interval;

$url_dynamic_params = booking_helper::getURLDynamicParams();
$url_consists_dynamic_param = 0;
if(!empty($url_dynamic_params))
{
    foreach($url_dynamic_params as $key => $val)
    {
	if(isset($_REQUEST[$key])){
	    $url_consists_dynamic_param = 1;
	    break;
	}
    }
}
?>
<link rel="stylesheet" type="text/css" media="screen" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/media_onepage.css.php?bgcolor=<?php echo $bgcolor;?>&acttab=<?php echo $acttab;?>&inacttab=<?php echo $inacttab;?>&btncolor=<?php echo $btncolor;?>&boxcolor=<?php echo $boxcolor;?>&headers_fontcolor=<?php echo $headers_fontcolor;?>&fontcolor=<?php echo $fontcolor;?>&boxes_fontcolor=<?php echo $boxes_fontcolor;?>&otherfontcolor=<?php echo $otherfontcolor;?>&highlightscolor=<?php echo $highlightscolor;?>" >
<link rel="stylesheet" type="text/css" media="screen" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/font-awesome.css" />

<div id="onepage_booking_accordion">
    <h3 class="onepage_booking_accordion_header"><?php echo JText::_('ONEPAGE_BOOKING_FIRST_STEP_HEADER'); ?></h3>
    <div class="onepage_booking_accordion_slide">

	<div id="verticle_booking_wrap_outer">
	    <form name="price_form" id="price_form" method="POST" action="index.php">
		<input type="hidden" name="booking_form_itemid" value="<?php echo $this->active_menu_id;?>" />
		<input type="hidden" id="distance_unit" value="<?php echo $this->elsettings->distance_unit;?>" />
		<input type="hidden" id="date_format" value="<?php echo $this->elsettings->date_format;?>" />
		<input type="hidden" id="time_format" value="<?php echo $this->elsettings->time_format;?>" />
		<input type="hidden" id="locale" value="<?php echo $this->lang_tag;?>" />
		<input type="hidden" id="route_swapped" name="route_swapped" value="<?php echo $session->get('route_swapped', 0);?>" />
		<input type="hidden" id="booking_type" name="booking_type" value="<?php echo $booking_type;?>" />
		<input type="hidden" id="datepicker_type" name="datepicker_type" value="<?php echo $this->elsettings->datepicker_type;?>" />
		<input type="hidden" id="show_poi_categories" name="show_poi_categories" value="<?php echo $this->elsettings->show_poi_categories;?>" />
		<input type="hidden" id="show_return_extras" name="show_return_extras" value="<?php echo $this->elsettings->show_return_extras;?>" />
		<input type="hidden" id="module_shuttle_passengers" value="<?php echo $session->get('shuttle_passengers', 0);?>" />
		<input type="hidden" id="tmpl" name="tmpl" value="<?php echo JRequest::getVar('tmpl', '');?>" />
		<input type="hidden" id="url_booking_type" name="url_booking_type" value="<?php echo JRequest::getVar('booking_type', '');?>" />
		<input type="hidden" id="data_source" name="data_source" value="<?php echo $session->get('data_source', 'component');?>" />


	    <div id="verticle_booking_wrap" class="clearfix">
		<ul class="tab_wrapper">
		    <?php if( (int)$this->elsettings->show_address_tab==1 && ($this->elsettings->show_from_poi==1 || $this->elsettings->show_from_address==1)
			     && ($this->elsettings->show_to_poi==1 || $this->elsettings->show_to_address==1)) { ?>
		    <li><a id="address" href="#tabs_address"><?php echo JText::_('ADDRESS_SEARCH_TAB_LABEL'); ?></a></li>
		    <?php } ?>

		    <?php if( (int)$this->elsettings->show_offers_tab==1 && $this->lists['has_any_route']){ ?>
		    <li><a id="offers" href="#tabs_special_routes"><?php echo JText::_('SPECIAL_OFFERS_TAB_LABEL'); ?></a></li>
		    <?php } ?>

		    <?php if( (int)$this->elsettings->show_hourly_tab==1 && $this->is_hourly_rate_enabled){ ?>
		    <li><a id="hourly" href="#tabs_hourly_hire"><?php echo JText::_('HOURLY_HIRE_TAB_LABEL'); ?></a></li>
		    <?php } ?>

		    <?php if( (int)$this->elsettings->show_shuttles_tab==1 && $this->is_shuttles_enabled){ ?>
		    <li><a id="shuttle" href="#tabs_shuttles"><?php echo JText::_('SHUTTLES_TAB_LABEL'); ?></a></li>
		    <?php } ?>

		    <li><a id="myorders" href="#tabs_myorders"><?php echo JText::_('MYORDERS_TAB_LABEL'); ?></a></li>
		</ul>

		<?php if( (int)$this->elsettings->show_address_tab==1 && ($this->elsettings->show_from_poi==1 || $this->elsettings->show_from_address==1)
		    && ($this->elsettings->show_to_poi==1 || $this->elsettings->show_to_address==1)) { ?>

		<div class="verticl_booking_toppart clearfix" id="tabs_address">

                <div class="steps">
                    <div class="step active">
                        <span>1</span> Route
                    </div>
                        <div class="step">
                            <span>2</span> Prices
                        </div>
                        <div class="step">
                            <span>3</span> Passengers
                        </div>
                    <div class="step">
                        <span>4</span> Payment
                    </div>
                </div>

		    <div class="topouterWrap left pickup_wrap clearfix">

			<?php if ($this->elsettings->show_from_poi==1 || $this->elsettings->show_from_address==1) { ?>
			<div class="topinnerWrap clearfix">
			    <label><?php echo JText::_('TAXI_FROM'); ?></label>
			    <div class="top_ver_input_wrap clearfix">

			    <?php if($this->elsettings->show_from_address==1) { ?>
			    <div class="getlocationField">
				    <a class="pickup_direction" href="javascript:void(0);" onclick="get_user_location('pickup', this);"><?php echo JText::_('GET_LOCATION'); ?></a>
			    </div>
			    <?php } ?>

			    <?php
			    $additional_class = '';
			    $additional_class .= ($this->elsettings->show_from_poi==0) ? ' poi_disabled' : '';
			    $additional_class .= ($this->elsettings->show_from_address==0) ? ' address_disabled' : '';
			    ?>
			    <div class="inputField<?php echo $additional_class;?>">
				<input type="text" class="inputbox" name="address_from" id="address_from" value="<?php echo $session->get('address_from', '');?>" placeholder="<?php echo ($this->elsettings->show_from_address==1)?JText::_('ENTER_ADDRESS'):JText::_('SELECT_PLACE'); ?>" />
				<input type="hidden" name="address_from_lat" id="address_from_lat" value="<?php echo $session->get('address_from_lat', '');?>" />
				<input type="hidden" name="address_from_lng" id="address_from_lng" value="<?php echo $session->get('address_from_lng', '');?>" />
				<input type="hidden" name="pickup_poi" id="pickup_poi" value="<?php echo $session->get('pickup_poi', 0);?>" />

			    </div>

			    <?php if($this->elsettings->show_from_poi==1) { ?>
			    <div class="selectField-wrap">
				<div class="selectField">
				    <div class="arrow_wrapper poi_options_trigger">trigger_icon</div>
				    <div class="poi_dropdown_wrapper" style="display:none;">
				    <?php echo $this->lists['pickup_poi_options_html']; ?>
				    </div>
				</div>
			    </div>
			    <?php } ?>
			    </div>

			    <div class="select_addressbook pickupWrap">
					<?php if($this->user->get('id') > 0 && $this->has_any_address){ ?>
					<a href="javascript:void(0);" class="select_addressbook pickup"><?php echo JText::_('SELECT_FROM_ADDRESSBOOK');?></a>
					<?php } ?>
				</div>

			    <!-- From Extras -->
			    <div class="ver_pickup_extra_wrapper" id="pickup_extra_wrapper">
				    <?php echo booking_helper::get_selected_extras('pickup');?>
			    </div>
			    <!-- From Extras -->
			</div>
			<?php } ?>
		    </div>

		    <div class="topouterWrap right dropoff_wrap clearfix">

			<?php if($this->elsettings->enable_stops==1) { ?>
			<div id="stops_wrapper">

			    <?php
			    $waypoints = $session->get('waypoints', array());
			    $waypoints_lat = $session->get('waypoints_lat', array());
			    $waypoints_lng = $session->get('waypoints_lng', array());
			    $waypoints_stop_duration = $session->get('waypoints_stop_duration', array());

			    for($i = 0; $i < count($waypoints); $i++)
			    {
				$stop_additional_class = (($i+1)==count($waypoints)) ? ' last' : '';
			    ?>
			    <div class="topinnerWrap stops_wrap<?php echo $stop_additional_class;?> clearfix">
				<div class="top_ver_input_wrapOuter clearfix">
				    <div class="top_ver_input_wrap clearfix">

					<?php if($this->elsettings->show_stop_address==1) { ?>
					<div class="getlocationField">
						<a class="dropoff_direction" href="javascript:void(0);" onclick="get_user_location('waypoints', this);"><?php echo JText::_('GET_LOCATION'); ?></a>
					</div>
					<?php } ?>

					<?php
					$additional_class = '';
					$additional_class .= ($this->elsettings->show_stop_poi==0) ? ' poi_disabled' : '';
					$additional_class .= ($this->elsettings->show_stop_address==0) ? ' address_disabled' : '';
					?>
					<div class="inputField<?php echo $additional_class;?>">
					    <input type="text" class="inputbox waypoints" name="waypoints[<?php echo $i;?>]" value="<?php echo $waypoints[$i];?>" placeholder="<?php echo ($this->elsettings->show_stop_address==1)?JText::_('ENTER_ADDRESS'):JText::_('SELECT_PLACE'); ?>" />
					    <input type="hidden" name="waypoints_lat[<?php echo $i;?>]" id="waypoint_lat" value="<?php echo $waypoints_lat[$i];?>" />
					    <input type="hidden" name="waypoints_lng[<?php echo $i;?>]" id="waypoint_lng" value="<?php echo $waypoints_lng[$i];?>" />
					</div>

					<?php if($this->elsettings->show_stop_poi==1) { ?>
					<div class="selectField-wrap">
					    <div class="selectField">
						<div class="arrow_wrapper poi_options_trigger">trigger_icon</div>
						<div class="poi_dropdown_wrapper" style="display:none;">
						<?php
						if(!empty($this->lists['all_places_data'])){
						    foreach($this->lists['all_places_data'] as $place){
						?>
						<div class="poi_link" data-poiid="<?php echo $place->id;?>" data-poilat="<?php echo $place->lat;?>" data-poilng="<?php echo $place->long;?>">
						<?php echo ($place->image!="") ? '<img src="'.JURI::base().$place->image.'" alt="'.$place->cattitle.'" title="'.$place->cattitle.'" class="poicat_icon" />&nbsp;' : '';?>
						<span><?php echo $place->title;?></span></div>
						<?php
						    }
						}
						?>
						</div>
					    </div>
					</div>
					<?php } ?>
				    </div>

				    <?php if($this->user->get('id') > 0 && $this->has_any_address){ ?>
				    <div class="select_addressbook pickupWrap"><a href="javascript:void(0);" class="select_addressbook stops stop<?php echo $i;?>"><?php echo JText::_('SELECT_FROM_ADDRESSBOOK');?></a></div>
				    <?php } ?>

				    <div class="time_at_stop clearfix">
					<div class="title_stops"><?php echo JText::_('TIME_AT_STOP'); ?></div>
					<select name="waypoints_stop_duration[<?php echo $i;?>]" class="stop_interval_options" tabindex="1">
						<!--option value="0"><?php echo JText::_('SELECT_OPTION');?></option-->
					<?php
					for($interval_counter = $stop_duration_interval; $interval_counter <= ($max_stop_time*60); $interval_counter = $interval_counter + $stop_duration_interval){
						$selected = ($interval_counter==$waypoints_stop_duration[$i]) ? ' selected="selected"' : '' ;
					?>
						<option value="<?php echo $interval_counter;?>"<?php echo $selected;?>><?php echo JText::sprintf('STOP_INTERVAL_MINS', $interval_counter);?></option>
					<?php } ?>
					</select>
				    </div>
				    <a href="javascript:void(0);" class="remove_stops"><?php echo JText::_('REMOVE_STOP');?></a>
				</div>
			    </div>
			    <?php } ?>
			</div>
			<?php } ?>

			<?php if ($this->elsettings->show_to_poi==1 || $this->elsettings->show_to_address==1) { ?>
			<div class="topinnerWrap nonstop_wrap clearfix">
			    <label><?php echo JText::_('TAXI_TO'); ?></label>
			    <div class="top_ver_input_wrap clearfix">
			    <?php if($this->elsettings->show_to_address==1) { ?>
			    <div class="getlocationField">
				    <a class="dropoff_direction" href="javascript:void(0);" onclick="get_user_location('dropoff', this);"><?php echo JText::_('GET_LOCATION'); ?></a>
			    </div>
			    <?php } ?>

			    <?php
			    $additional_class = '';
			    $additional_class .= ($this->elsettings->show_to_poi==0) ? ' poi_disabled' : '';
			    $additional_class .= ($this->elsettings->show_to_address==0) ? ' address_disabled' : '';
			    ?>

			    <div class="inputField<?php echo $additional_class;?>">
				<input type="text" class="inputbox" name="address_to" id="address_to" value="<?php echo $session->get('address_to', '');?>" placeholder="<?php echo ($this->elsettings->show_to_address==1)?JText::_('ENTER_ADDRESS'):JText::_('SELECT_PLACE'); ?>" />
				<input type="hidden" name="address_to_lat" id="address_to_lat" value="<?php echo $session->get('address_to_lat', '');?>" />
				<input type="hidden" name="address_to_lng" id="address_to_lng" value="<?php echo $session->get('address_to_lng', '');?>" />
				<input type="hidden" name="dropoff_poi" id="dropoff_poi" value="<?php echo $session->get('dropoff_poi', 0);?>" />

			    </div>

			    <?php if($this->elsettings->show_to_poi==1) { ?>
			    <div class="selectField-wrap">
				<div class="selectField">
				    <div class="arrow_wrapper poi_options_trigger">trigger_icon</div>
				    <div class="poi_dropdown_wrapper" style="display:none;">
				    <?php echo $this->lists['dropoff_poi_options_html']; ?>
				    </div>
				</div>
			    </div>
			    <?php } ?>
			    </div>

				<div class="select_addressbook dropoffwrap">
					<?php if($this->user->get('id') > 0 && $this->has_any_address){ ?>
					<a href="javascript:void(0);" class="select_addressbook dropoff"><?php echo JText::_('SELECT_FROM_ADDRESSBOOK');?></a>
					<?php } ?>
				</div>

			    <!-- To Extras -->
			    <div class="ver_dropoff_extra_wrapper" id="dropoff_extra_wrapper">
				    <?php echo booking_helper::get_selected_extras('dropoff');?>
			    </div>
			    <!-- To Extras -->
			</div>
			<?php } ?>

			<?php if($this->elsettings->enable_stops==1) { ?>
			<div class="topinnerWrap clearfix">
				<a href="javascript:void(0);" class="addstop" title="<?php echo JText::_('MAXIMUM_NUMBER_STOPS');?>"><?php echo JText::_('ADD_STOPS'); ?></a>
			</div>
			<?php } ?>
		    </div>
		</div>
		<?php } ?>


		<?php if( (int)$this->elsettings->show_offers_tab==1 && $this->lists['has_any_route']){ ?>
		<div class="verticl_booking_toppart clearfix<?php echo ($this->total_available_booking_types>2) ? ' my_order_extra_gap' : '';?>" id="tabs_special_routes">

		    <div class="ver_input_wrap clearfix">

			<div class="routes_wrapper_from">

			    <?php
			    $show_route_pickup = true;
			    if($this->elsettings->show_poi_categories==1){

				if($session->get('route_category', 0) > 0){
				    $show_route_pickup = true;
				}
				else {
				    $show_route_pickup = false;
				}
			    ?>
			    <div class="routecategory_wrapper_from clearfix" style="width: 100%;">
				<div class="routes_wrapper">
				    <label><?php echo JText::_('PICKUP_ROUTE_CATEGORY'); ?></label>
				    <div class="routestestWrap">
					<div class="routestest clearfix">
					    <input type="text" class="ver_inputbox required" id="route_category_fld" name="route_category_fld" value="<?php echo $session->get('route_category_fld', '');?>" />
					    <input type="hidden" id="route_category" name="route_category" value="<?php echo $session->get('route_category', 0);?>" />
					    <div class="routecategory_dropdown_wrapper" style="display:none;">
						<?php echo $this->lists['route_categories_html']; ?>
					    </div>
					    <div class="arrow_wrapper routecategory_options_trigger"></div>
					</div>
				    </div>
				</div>
			    </div>
			    <div id="routefrom_loader"></div>
			    <?php }  ?>

			    <div class="routes_from_inner clearfix" style="<?php echo ($show_route_pickup) ? 'display:block':'display:none';?>">
				<label><?php echo JText::_('TAXI_FROM'); ?></label>
				<div class="routes_wrapper">
				    <div class="routestest clearfix" style="position: relative; width: 100%; float: left;">
					<input type="text" class="ver_inputbox required" id="route_from_fld" name="route_from_fld" value="<?php echo $session->get('route_from_fld', '');?>" />
					<input type="hidden" id="route_from" name="route_from" value="<?php echo $session->get('route_from', 0);?>" />
					<div class="routefrom_dropdown_wrapper" style="display:none;">
					<?php echo $this->lists['pickup_route_options_html']; ?>
					</div>
					<div class="arrow_wrapper routefrom_options_trigger"></div>
				    </div>
				</div>
			    </div>
			    <div class="clearfix"></div>

			    <!-- From Extras -->
			    <div class="ver_dropoff_extra_wrapper" id="routefrom_extra_wrapper">
				    <?php echo booking_helper::get_selected_extras('route_pickup');?>
			    </div>
			    <!-- From Extras -->
			</div>

			<div class="routes_wrapper_to" style="<?php echo ($session->get('route_from', 0)>0) ? 'display:block;':'display:none;';?>">
				<?php
				$show_route_dropoff = true;
				if($this->elsettings->show_poi_categories==1){

				    if($session->get('route_category_dropoff', 0) > 0){
					$show_route_dropoff = true;
				    }
				    else {
					$show_route_dropoff = false;
				    }
				?>
				<div class="routecategory_wrapper_from clearfix" style="width: 100%;">
				    <div class="routes_wrapper">
					<label><?php echo JText::_('DROPOFF_ROUTE_CATEGORY'); ?></label>
					<div class="routestestWrap drop">
					    <div class="routestest clearfix">
						<input type="text" class="ver_inputbox required" id="route_category_dropoff_fld" name="route_category_dropoff_fld" value="<?php echo $session->get('route_category_dropoff_fld', '');?>" />
						<input type="hidden" id="route_category_dropoff" name="route_category_dropoff" value="<?php echo $session->get('route_category_dropoff', 0);?>" />
						<div class="routecategory_dropoff_dropdown_wrapper" style="display:none;">
						    <?php echo $this->lists['route_categories_dropoff_html']; ?>
						</div>
						<div class="arrow_wrapper routecategory_dropoff_options_trigger"></div>
					    </div>
					</div>
				    </div>
				</div>
				<div id="routefrom_loader"></div>
				<?php } ?>

				<div class="routes_to_inner clearfix" style="<?php echo ($show_route_dropoff) ? 'display:block':'display:none';?>">
					<label><?php echo JText::_('TAXI_TO'); ?></label>
					<div class="routes_wrapper" id="route_to_wrap">
					    <div class="routestest clearfix" style="position: relative; width: 100%; float: left;">


					    <div class="routes_indicator" style="<?php echo ($session->get('route_from', 0)>0) ? 'display:block;':'display:none;';?>">
						    <div class="routes_wrapper_change" style="">
							<?php if($this->elsettings->enable_route_swap==1){?>
								<a href="javascript:void(0);" class="swap_routes">
								    <i class="icon-exchange"></i><span><img src="<?php echo JURI::base(); ?>components/com_taxibooking/assets/images/swap_border.jpg" alt="Border" title="Border" /></span>
								</a>
							<?php } ?>
						    </div>
						    <div class="routes_wrapper_loader" id="route_loader" style="margin-left:-8px;display:none;">
							    <img src="<?php echo JURI::base(); ?>components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" title="Loading" />
						    </div>
					    </div>


					    <input type="text" class="ver_inputbox required" id="route_to_fld" name="route_to_fld" value="<?php echo $session->get('route_to_fld', JText::_('TAXI_TO'));?>" />
					    <input type="hidden" id="route_to" name="route_to" value="<?php echo $session->get('route_to', 0);?>" />
					    <div class="routeto_dropdown_wrapper" style="display:none;">
						    <?php echo $this->lists['dropoff_route_options_html']; ?>
					    </div>

					    <div class="arrow_wrapper routeto_options_trigger"></div>
					</div>
				    </div>
				</div>
			    <div class="clearfix"></div>

			    <!-- To Extras -->
			    <div class="ver_dropoff_extra_wrapper" id="routeto_extra_wrapper">
				<?php echo booking_helper::get_selected_extras('route_dropoff');?>
			    </div>
			    <!-- To Extras -->
			</div>
		    </div>

		</div>
		<?php } ?>

		<?php if( (int)$this->elsettings->show_hourly_tab==1 && $this->is_hourly_rate_enabled){ ?>
		<div class="verticl_booking_toppart clearfix<?php echo ($this->total_available_booking_types>2) ? ' my_order_extra_gap' : '';?>" id="tabs_hourly_hire">

		    <div class="ver_input_wrap hourly clearfix">
			<div class="controls hourly clearfix" style="">
				<div class="houtly_inner clearfix">
					<label><?php echo JText::_('HOURLY_HIRE_HR_LABEL');?></label>
					<?php echo $this->lists['hourly_hr_list']; ?>
				</div>
			</div>
			<!--div class="clearfix"></div-->
			<div class="controls hourly clearfix" style="">
				<div class="houtly_inner clearfix">
					<label><?php echo JText::_('HOURLY_HIRE_MIN_LABEL');?></label>
					<?php echo $this->lists['hourly_min_list']; ?>
				</div>
			</div>
		    </div>

		    <div class="ver_dropoff_extra_wrapper" id="hourly_extra_wrapper">
				<?php echo booking_helper::get_selected_extras('hourly_hire');?>
		    </div>

		</div>
		<?php } ?>

		<?php if( (int)$this->elsettings->show_shuttles_tab==1 && $this->is_shuttles_enabled){ ?>
		<div class="verticl_booking_toppart clearfix" id="tabs_shuttles">

		    <div class="topouterWrap left shuttle_pickup_wrap clearfix">

			<div class="topinnerWrap clearfix">
			    <label><?php echo JText::_('TAXI_FROM'); ?></label>
			    <div class="top_ver_input_wrap clearfix">

			    <?php
			    $additional_class = ' address_disabled';
			    ?>
			    <div class="inputField<?php echo $additional_class;?>">
				<input type="text" class="inputbox required" name="shuttle_pickup" id="shuttle_pickup" value="<?php echo $session->get('shuttle_pickup', '');?>" placeholder="<?php echo JText::_('SELECT_PLACE'); ?>" />
				<input type="hidden" name="shuttle_pickup_poi" id="shuttle_pickup_poi" value="<?php echo $session->get('shuttle_pickup_poi', 0);?>" />
			    </div>

			    <div class="selectField-wrap">
				<div class="selectField">
				    <div class="arrow_wrapper poi_options_trigger">trigger_icon</div>
				    <div class="poi_dropdown_wrapper" style="display:none;">
				    <?php echo $this->lists['shuttle_pickup_options_html']; ?>
				    </div>
				</div>
			    </div>
			    </div>

			    <div class="ver_pickup_extra_wrapper" id="shuttle_pickup_extra_wrapper">
				<?php echo booking_helper::get_selected_extras('shuttle_pickup');?>
			    </div>
			</div>
		    </div>

		    <div class="topouterWrap right shuttle_dropoff_wrap clearfix">

			<div class="topinnerWrap clearfix">
			    <label><?php echo JText::_('TAXI_TO'); ?></label>
			    <div class="top_ver_input_wrap clearfix">

			    <?php
			    $additional_class = ' address_disabled';
			    ?>

			    <div class="inputField<?php echo $additional_class;?>">
				<input type="text" class="inputbox required" name="shuttle_dropoff" id="shuttle_dropoff" value="<?php echo $session->get('shuttle_dropoff', '');?>" placeholder="<?php echo JText::_('SELECT_PLACE'); ?>" />
				<input type="hidden" name="shuttle_dropoff_poi" id="shuttle_dropoff_poi" value="<?php echo $session->get('shuttle_dropoff_poi', 0);?>" />
			    </div>

			    <div class="selectField-wrap">
				<div class="selectField">
				    <div class="arrow_wrapper poi_options_trigger">trigger_icon</div>
				    <div class="poi_dropdown_wrapper" style="display:none;">
				    </div>
				</div>
			    </div>
			    </div>

			    <div class="ver_pickup_extra_wrapper" id="shuttle_dropoff_extra_wrapper">
				<?php echo booking_helper::get_selected_extras('shuttle_dropoff');?>
			    </div>
			</div>

		    </div>
		</div>
		<?php } ?>

		<div class="verticl_booking_toppart clearfix<?php echo ($this->total_available_booking_types>2) ? ' my_order_extra_gap' : '';?>" id="tabs_myorders">

		    <div id="myorders_accordion">
			<h3 class="myorders_accordion_header"><?php echo JText::_('MYORDERS_USER_PROFILE_HEADER'); ?></h3>
			<div class="myorders_accordion_slide">
			    <?php echo $this->loadTemplate('login');?>
			</div>

			<h3 class="myorders_accordion_header"><?php echo JText::_('MYORDERS_ORDER_LIST_HEADER'); ?></h3>
			<div class="myorders_accordion_slide">
			    <?php echo $this->loadTemplate('orders');?>
			</div>

			<h3 class="myorders_accordion_header"><?php echo JText::_('MYORDERS_ADDRESSBOOK_HEADER'); ?></h3>
			<div class="myorders_accordion_slide">
			    <?php echo $this->loadTemplate('addressbook');?>
			</div>

			<!-- Taxibooking Corporate Invoices slide will be visible
			    only if Corporate Extension is installed and
			    user is a Corporate Client -->
			<?php
			$path = JPATH_ROOT.DS."components".DS."com_tbcorporate";
			if( $this->user->get('id')>0 && file_exists ( $path.DS.'tbcorporate.php' ) && $this->tbuserObj->is_corporate_client==1){
			?>
			<h3 class="myorders_accordion_header"><?php echo JText::_('MYORDERS_CORPORATE_INVOICES_HEADER'); ?></h3>
			<div class="myorders_accordion_slide">
			    <?php echo $this->loadTemplate('corporateinvoices');?>
			</div>
			<?php } ?>
		    </div>
		</div>


		<div class="separator nonshuttle"><!-- --></div>

		<div class="verticl_booking_midpart nonshuttle clearfix">
		    <div class="seats_wrap left">
			    <div class="seat_input_wrap passengers clearfix">
				    <label><?php echo JText::_('PASSENGER_SEATS');?></label>
				    <?php echo $this->lists['passengers']; ?>
			    </div>

			    <?php if((int)$this->elsettings->show_suitcase_select==1){ ?>
			    <div class="seat_input_wrap suitcases clearfix">
				    <label><?php echo JText::_('SUITCASE_NO');?></label>
				    <?php echo $this->lists['suitcases']; ?>
			    </div>
			    <?php } ?>
		    </div>

		    <div class="seats_wrap right">

			    <?php if($this->lists['has_booster_seats'] && (int)$this->elsettings->show_booster_select==1){ ?>
			    <div class="seat_input_wrap boosterseats clearfix">
				    <label><?php echo JText::_('BOOSTER_SEATS');?></label>
				    <?php echo $this->lists['boosterseats']; ?>
			    </div>
          <div class="seat_input_wrap boosterseats2 clearfix">
				    <label><?php echo JText::_('BOOSTER_SEATS');?></label>
				    <?php echo $this->lists['boosterseats2']; ?>
			    </div>
			    <?php } ?>

			    <?php if($this->lists['has_infant_seats'] && (int)$this->elsettings->show_infant_select==1){ ?>
			    <div class="seat_input_wrap infantseats clearfix">
				    <label><?php echo JText::_('INFANT_SEATS');?></label>
				    <?php echo $this->lists['infantseats']; ?>
			    </div>
			    <?php } ?>

			    <?php if($this->lists['has_chseats'] && (int)$this->elsettings->show_child_select==1){ ?>
			    <div class="seat_input_wrap childseats clearfix">
				    <label><?php echo JText::_('CHILD_SEATS');?></label>
				    <?php echo $this->lists['chseats']; ?>
			    </div>
          <div class="seat_input_wrap childseats2 clearfix">
				    <label><?php echo JText::_('CHILD_SEATS');?></label>
				    <?php echo $this->lists['chseats2']; ?>
			    </div>
          <div class="seat_input_wrap childseats3 clearfix">
				    <label><?php echo JText::_('CHILD_SEATS');?></label>
				    <?php echo $this->lists['chseats3']; ?>
			    </div>
			    <?php } ?>
		    </div>
		</div>

		<div class="separator"><!-- --></div>

		<?php
		// prepare hr and min dropdown data
		if($this->elsettings->date_format=='mm-dd-yy') {
		    $date_format = 'm-d-Y';
		}
		else {
		    $date_format = 'd-m-Y';
		}

		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		date_default_timezone_set($siteOffset);
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = strtotime($dtnow->format('Y-m-d H:i:s', true));
		$minimum_time_allowed = $now+($this->elsettings->restrict_time+1)*3600;
		$min_pickup_hr = date('H', $minimum_time_allowed);

		// search pickup date in URL
		$url_booking_type = JRequest::getVar('booking_type', "");
		$url_pickup_date = JRequest::getVar('pickup_date', "");
		$url_pickup_hr = JRequest::getVar('pickup_hr', "");
		$url_pickup_min = JRequest::getVar('pickup_min', "");
		if($url_booking_type!="" && $url_pickup_date!="" && $url_pickup_hr!="" && $url_pickup_min!="")
		{
		    $url_pickup_time = strtotime($url_pickup_date.' '.$url_pickup_hr.':'.$url_pickup_min.':00');

		    $pickup_date = booking_helper::date_format($url_pickup_time, $date_format, $this->elsettings);

		    if($this->elsettings->time_format=='24hr') {
			$pickup_hr = booking_helper::date_format($url_pickup_time, 'H', $this->elsettings);
			$pickup_min = booking_helper::date_format($url_pickup_time, 'i', $this->elsettings);
		    }
		    else {
			$pickup_hr = booking_helper::date_format($url_pickup_time, 'h', $this->elsettings);
			$pickup_min = booking_helper::date_format($url_pickup_time, 'i', $this->elsettings);
			$pickup_ampm = booking_helper::date_format($url_pickup_time, 'A', $this->elsettings);
		    }
		}
		elseif($session->get('timestr1', '')!=''){
		    $pickup_date = booking_helper::date_format($session->get('timestr1', ''), $date_format, $this->elsettings);

		    if($this->elsettings->time_format=='24hr') {
			$pickup_hr = booking_helper::date_format($session->get('timestr1', ''), 'H', $this->elsettings);
			$pickup_min = booking_helper::date_format($session->get('timestr1', ''), 'i', $this->elsettings);
		    }
		    else {
			$pickup_hr = booking_helper::date_format($session->get('timestr1', ''), 'h', $this->elsettings);
			$pickup_min = booking_helper::date_format($session->get('timestr1', ''), 'i', $this->elsettings);
			$pickup_ampm = booking_helper::date_format($session->get('timestr1', ''), 'A', $this->elsettings);
		    }
		}
		else {
		    if($this->elsettings->load_current_date){

			$pickup_date = date($date_format, $minimum_time_allowed);

			if($this->elsettings->time_format=='24hr') {
			    $pickup_hr = date('H', $minimum_time_allowed);
			    $pickup_min = '00';
			}
			else {
			    $pickup_hr = date('h', $minimum_time_allowed);
			    $pickup_min = '00';
			    $pickup_ampm = date('A', $minimum_time_allowed);
			}
		    }
		    else {
			$pickup_date = JText::_('ORDER_DATE');
			$pickup_hr = '';
			$pickup_min = '';
			$pickup_ampm = 'AM';
		    }
		}

		$return_date = ($session->get('timestr2', '')!='') ? booking_helper::date_format($session->get('timestr2', ''), 'Y-m-d', $this->elsettings) : JText::_('ORDER_RETURN_DATE');

		$hr_options = array();
		$hr_options[] = JHTML::_('select.option', '', JText::_('HRS'));
		if($this->elsettings->time_format=='24hr') {
		    $hr_start = '0';
		    $hr_end_limit = '24';
		}
		else {
		    $hr_start = '1';
		    $hr_end_limit = '13';
		}

		for($i = $hr_start; $i < $hr_end_limit; $i++)
		{
		    $i = ($i < 10) ? "0$i" : $i;
		    $hr_options[] = JHTML::_('select.option', $i, $i);
		}

		$min_options = array();
		$min_options[] = JHTML::_('select.option', '', JText::_('MINS'));
		for ($i = 0; $i <= 55; $i = $i + 5)
		{
		    $i = ($i < 10) ? "0$i" : $i;
		    $min_options[] = JHTML::_('select.option', $i, $i);
		}

		if($session->get('booking_type')=='shuttle'){
		    $shuttle_display = 'display:block';
		    $nonshuttle_display = 'display:none';

		    $shuttle_pickup_date = $pickup_date;
		}
		elseif($url_booking_type=='shuttle'){
		    $shuttle_display = 'display:block';
		    $nonshuttle_display = 'display:none';

		    $url_shuttle_pickup_date = JRequest::getVar('shuttle_pickup_date', "");
		    $url_shuttle_pickup_time = strtotime($url_shuttle_pickup_date);
		    $shuttle_pickup_date = booking_helper::date_format($url_shuttle_pickup_time, $date_format, $this->elsettings);
		}
		else {
		    $shuttle_display = 'display:none';
		    $nonshuttle_display = 'display:block';
		    $shuttle_pickup_date = $pickup_date;
		}
		?>

		<div class="verticl_booking_bottompart clearfix">
		    <label><?php echo JText::_('BOOKING_FORM_SELECT_DATE_LABEL');?></label>
		    <div class="date_Wrap left">
			<?php
			if($this->elsettings->datepicker_type=='inline'){
			?>
			<div class="date_input nonshuttle clearfix">
			<?php
			    $day_options = array();
			    for($i=1;$i<=31;$i++){
				$day_options[$i] = $i;
			    }
			    $month_options = array(1=> JText::_('JANUARY'),
						   2=> JText::_('FEBRUARY'),
						   3=> JText::_('MARCH'),
						   4=> JText::_('APRIL'),
						   5=> JText::_('MAY'),
						   6=> JText::_('JUNE'),
						   7=> JText::_('JULY'),
						   8=> JText::_('AUGUST'),
						   9=> JText::_('SEPTEMBER'),
						   10=> JText::_('OCTOBER'),
						   11=> JText::_('NOVEMBER'),
						   12=> JText::_('DECEMBER')
						);
			    $year_options = array();
			    for($i=date('Y');$i<date('Y')+10;$i++){
				$year_options[$i] = $i;
			    }

			    if($url_booking_type!="" && $url_pickup_date!="")
			    {
				$date1_arr = explode('-',$url_pickup_date);
				$sel_pickup_day = $date1_arr[2];
				$sel_pickup_month = $date1_arr[1];
				$sel_pickup_year = $date1_arr[0];
			    }
			    elseif($session->get('date1', '')!=''){
				$date1 = $session->get('date1', '');
				$date1_arr = explode('-',$date1);
				$sel_pickup_day = $date1_arr[0];
				$sel_pickup_month = $date1_arr[1];
				$sel_pickup_year = $date1_arr[2];
			    }
			    else {
				$sel_pickup_day = date('d');
				$sel_pickup_month = date('m');
				$sel_pickup_year = date('Y');
			    }

			    if($this->elsettings->date_format=='mm-dd-yy') {
				echo JHTML::_('select.genericlist', $month_options, 'pickup_month', 'class="month inline required" tabindex="1"', 'value', 'text', $sel_pickup_month);
				echo JHTML::_('select.genericlist', $day_options, 'pickup_day', 'class="day inline required" tabindex="1"', 'value', 'text', $sel_pickup_day);
			    }
			    else {
				echo JHTML::_('select.genericlist', $day_options, 'pickup_day', 'class="day inline required" tabindex="1"', 'value', 'text', $sel_pickup_day);
				echo JHTML::_('select.genericlist', $month_options, 'pickup_month', 'class="month inline required" tabindex="1"', 'value', 'text', $sel_pickup_month);
			    }
			    echo JHTML::_('select.genericlist', $year_options, 'pickup_year', 'class="year inline required" tabindex="1"', 'value', 'text', $sel_pickup_year);
			?>
			</div>

			<div class="date_input shuttle clearfix">
			    <input type="text" name="orderdate_shuttle" id="orderdate_shuttle" readonly="readonly" class="date_inputbox required" value="<?php echo $shuttle_pickup_date; ?>" />
			</div>

			<div class="date_input hr_min nonshuttle clearfix">
			    <?php
			    echo JHTML::_('select.genericlist', $hr_options, 'selPtHr1', 'class="hrs required" tabindex="1"', 'value', 'text', $pickup_hr);
			    echo JHTML::_('select.genericlist', $min_options, 'selPtMn1', 'class="mins required" tabindex="1"', 'value', 'text', $pickup_min);
			    if($this->elsettings->time_format=='12hr') {
				echo JHTML::_('select.genericlist', array('AM'=>JText::_('AM'),'PM'=>JText::_('PM')), 'seltimeformat1', 'class="mins" tabindex="1"', 'value', 'text', $pickup_ampm);
			    }
			    ?>
			</div>

			<?php
			}
			else {
			?>
			<div class="date_input nonshuttle clearfix">
			    <input type="text" name="orderdate" id="orderdate" readonly="readonly" class="date_inputbox required" value="<?php echo $pickup_date; ?>" />
			</div>

			<?php if( (int)$this->elsettings->show_shuttles_tab==1 && $this->is_shuttles_enabled){ ?>
			<div class="date_input shuttle clearfix">
			    <input type="text" name="orderdate_shuttle" id="orderdate_shuttle" readonly="readonly" class="date_inputbox required" value="<?php echo $shuttle_pickup_date; ?>" />
			</div>
			<?php } ?>

			<div class="date_input hr_min nonshuttle clearfix">
			    <input type="text" name="selPtHr1" id="selPtHr1" readonly="readonly" class="date_inputbox required" value="<?php echo $pickup_hr; ?>" style="width: 48px; margin-right: 5px;" />
			    <input type="text" name="selPtMn1" id="selPtMn1" readonly="readonly" class="date_inputbox required" value="<?php echo $pickup_min; ?>" style="width: 48px; margin-right: 5px;" />
			    <?php
			    if($this->elsettings->time_format=='12hr') {
				echo JHTML::_('select.genericlist', array('AM'=>JText::_('AM'),'PM'=>JText::_('PM')), 'seltimeformat1', 'class="mins" tabindex="1"', 'value', 'text', $pickup_ampm);
			    }
			    ?>
			</div>
			<?php } ?>

			<?php if( (int)$this->elsettings->show_shuttles_tab==1 && $this->is_shuttles_enabled){ ?>
			<div class="date_input hr_min shuttle clearfix" style="<?php echo $shuttle_display;?>"></div>
			<?php } ?>
		    </div>

		    <?php
		    if((int)$this->elsettings->show_return_option==1){ // show return option if set to Yes

			$url_booking_type = JRequest::getVar('booking_type', "");
			$url_return = JRequest::getInt('return', 0);
			$url_return_date = JRequest::getVar('return_date', "");
			$url_return_hr = JRequest::getVar('return_hr', "");
			$url_return_min = JRequest::getVar('return_min', "");
		    ?>

		    <div class="date_Wrap right" id="return_label">

			<div class="return">
<span>
<input name="returnjurney" value="returnjurney" type="checkbox" class="checkboxcosmin" id="returnjurney" <?php echo ($this->returnjurney==1||$url_return==1) ? 'checked="checked"' : ""; ?> />
</span>
			    <?php echo JText::_('BOOK_RETURN'); ?>
			    <?php if($this->elsettings->discount > 0) {
				echo JText::sprintf('BOOK_RETURN_DISCOUNT_MESSAGE', $this->elsettings->discount.'%');
			    } ?>
			</div>

			<?php
			if($this->returnjurney==1 || $url_return==1){
			    $return_wrapper_style = 'block';
			} else {
			    $return_wrapper_style = 'none';
			}
			?>
			<div id="return_date_wrapper" class="wait_time" style="display:<?php echo $return_wrapper_style;?>">

			    <?php if($this->elsettings->wait_time_return_discount=="1"){ ?>
			    <div class="date_input clearfix">
				<label><?php echo JText::_('WAIT_TIME_HRS');?></label>
				<?php
				$return_options = array();
				$return_discounts_arr = $this->elsettings->return_discounts;
				if(!empty($return_discounts_arr))
				{
				    foreach($return_discounts_arr as $key => $val){
					$hr = (int) $val[0];
					$return_options[$hr] = $val[0];
				    }
				    $return_options['-1'] = JText::_('LOAD_MORE_WAIT_TIME');
				}

				echo JHTML::_('select.genericlist', $return_options, 'return_wait_hr', 'class="wait_time_options required" tabindex="1"', 'value', 'text', $session->get('return_wait_hr', ''));
				?>
			    </div>
			    <?php } ?>

			    <div id="return_datepicker_wrapper" style="<?php echo ($this->elsettings->wait_time_return_discount=='1') ? 'display:none':'';?>">
				<?php
				if($url_booking_type!="" && $url_return==1 && $url_return_date!="" && $url_return_hr!="" && $url_return_min!="")
				{
				    $url_return_time = strtotime($url_return_date.' '.$url_return_hr.':'.$url_return_min.':00');

				    $return_date = booking_helper::date_format($url_return_time, $date_format);

				    if($this->elsettings->time_format=='24hr') {
					$return_hr = booking_helper::date_format($url_return_time, 'H');
					$return_min = booking_helper::date_format($url_return_time, 'i');
				    }
				    else {
					$return_hr = booking_helper::date_format($url_return_time, 'h');
					$return_min = booking_helper::date_format($url_return_time, 'i');
					$return_meridian = booking_helper::date_format($url_return_time, 'A');
				    }
				}
				elseif($session->get('time2', '')!=""){
				    $time2 = $session->get('time2', '');
				    $time2Arr = explode(':', $time2);
				    $return_hr = $time2Arr[0];
				    if(isset($time2Arr[1])){
					$return_min = substr($time2Arr[1], 0, 2);
					$return_meridian = substr($time2Arr[1], 2);
				    }
				    else {
					$return_min = '00';
					$return_meridian = 'AM';
				    }
				}
				else {
				    $return_hr = $pickup_hr;
				    $return_min = $pickup_min;
				    $return_meridian = $pickup_ampm;
				}

				if($this->elsettings->datepicker_type=='inline')
				{
				    ?>
				<div class="date_input clearfix">
				    <?php
				    $day_options = array();
				    for($i=1;$i<=31;$i++){
					$day_options[$i] = $i;
				    }
				    $month_options = array(1=> JText::_('JANUARY'),
							   2=> JText::_('FEBRUARY'),
							   3=> JText::_('MARCH'),
							   4=> JText::_('APRIL'),
							   5=> JText::_('MAY'),
							   6=> JText::_('JUNE'),
							   7=> JText::_('JULY'),
							   8=> JText::_('AUGUST'),
							   9=> JText::_('SEPTEMBER'),
							   10=> JText::_('OCTOBER'),
							   11=> JText::_('NOVEMBER'),
							   12=> JText::_('DECEMBER')
							);
				    $year_options = array();
				    for($i=date('Y');$i<date('Y')+10;$i++){
					$year_options[$i] = $i;
				    }

				    if($url_booking_type!="" && $url_return==1 && $url_return_date!="")
				    {
					$date2_arr = explode('-',$url_return_date);
					$sel_return_day = $date2_arr[2];
					$sel_return_month = $date2_arr[1];
					$sel_return_year = $date2_arr[0];
				    }
				    elseif($session->get('date2', '')!=''){
					$date2 = $session->get('date2', '');
					$date2_arr = explode('-',$date2);
					$sel_return_day = $date2_arr[0];
					$sel_return_month = $date2_arr[1];
					$sel_return_year = $date2_arr[2];
				    }
				    else {
					$sel_return_day = date('d');
					$sel_return_month = date('m');
					$sel_return_year = date('Y');
				    }

				    if($this->elsettings->date_format=='mm-dd-yy') {
					echo JHTML::_('select.genericlist', $month_options, 'return_month', 'class="month inline required" tabindex="1"', 'value', 'text', $sel_return_month);
					echo JHTML::_('select.genericlist', $day_options, 'return_day', 'class="day inline required" tabindex="1"', 'value', 'text', $sel_return_day);
				    }
				    else {
					echo JHTML::_('select.genericlist', $day_options, 'return_day', 'class="day inline required" tabindex="1"', 'value', 'text', $sel_return_day);
					echo JHTML::_('select.genericlist', $month_options, 'return_month', 'class="month inline required" tabindex="1"', 'value', 'text', $sel_return_month);
				    }
				    echo JHTML::_('select.genericlist', $year_options, 'return_year', 'class="year inline required" tabindex="1"', 'value', 'text', $sel_return_year);
				    ?>
				</div>

				<div class="date_input clearfix">
				    <?php
				    echo JHTML::_('select.genericlist', $hr_options, 'selPtHr2', 'class="hrs required" tabindex="1"', 'value', 'text', $return_hr);
				    echo JHTML::_('select.genericlist', $min_options, 'selPtMn2', 'class="mins required" tabindex="1"', 'value', 'text', $return_min);
				    if($this->elsettings->time_format=='12hr') {
					echo JHTML::_('select.genericlist', array('AM'=>JText::_('AM'),'PM'=>JText::_('PM')), 'seltimeformat2', 'class="mins" tabindex="1"', 'value', 'text', $return_meridian);
				    }
				    ?>
				</div>
				<?php
				}
				else { ?>
				<div class="date_input clearfix">
				    <input type="text" name="orderdatereturn" id="orderdatereturn" readonly="readonly" class="date_inputbox" value="<?php echo $return_date; ?>" />
				</div>

				<div class="date_input clearfix">
				    <input type="text" name="selPtHr2" id="return_selPtHr2" readonly="readonly" class="date_inputbox required" value="<?php echo $return_hr; ?>" style="width: 48px; margin-right: 5px;" />
				    <input type="text" name="selPtMn2" id="return_selPtMn2" readonly="readonly" class="date_inputbox required" value="<?php echo $return_min; ?>" style="width: 48px; margin-right: 5px;" />
				    <?php
				    if($this->elsettings->time_format=='12hr') {
					echo JHTML::_('select.genericlist', array('AM'=>JText::_('AM'),'PM'=>JText::_('PM')), 'seltimeformat2', 'class="mins" tabindex="1"', 'value', 'text', $return_meridian);
				    }
				    ?>
				</div>
				<?php } ?>
			    </div>
			</div>
		    </div>

		    <?php
		    if((int)$this->elsettings->show_return_extras==1 )
		    {
			$show_return_extra_wrapper = ' display:none;';
			if($this->returnjurney == 1 ){
			    $show_return_extra_wrapper = ' display:block;';
			}
			?>
			<div class="ver_input_wrap clearfix bottom" id="return_extra_wrapper" style="<?php echo $show_return_extra_wrapper;?>">
			    <?php echo booking_helper::get_selected_return_extras();?>
			</div>
		    <?php } ?>
		    <?php } ?>

		</div>

		<div class="separator"><!-- --></div>

		<?php if( (int)$this->elsettings->show_shuttles_tab==1 && $this->is_shuttles_enabled){ ?>
		<div class="verticl_booking_bottompart shuttle clearfix">
		    <div class="date_Wrap left">
			<div class="date_input clearfix">
			    <label><?php echo JText::_('SHUTTLES_AVAILABLE_SEATS');?></label>
			    <input type="text" name="shuttle_passengers" id="shuttle_passengers" readonly="readonly" class="date_inputbox" value="" />
			</div>
		    </div>
		</div>
		<?php } ?>

		<div class="uk-text-center booknow"><input type="button" class="uk-button uk-button-large uk-button-primary submit see_price" id="see_price_but" onClick="fbq('track', 'Lead')" value="<?php echo JText::_('SEE_PRICE'); ?>" /></div>

    <!-- Add Pixel Events to the button's click handler -->
<!-- <script type="text/javascript">
  var button = document.getElementById('see_price_but');
  button.addEventListener(
    'click',
    function() {
      fbq('track', 'Lead');
    },
    false
  );
</script> -->

		<?php if((int)$this->elsettings->booking_cancellation_allowed==1){ ?>
		<br/><br/>
		<div class="separator"><!-- --></div>

		<div class="verticl_booking_bottompart clearfix">
		    <div class="date_Wrap left">
			<div class="date_input clearfix">
			    <label><span class="cancel_booking_tooltip" title="<?php echo JText::_('BOOKING_FORM_CANCEL_BOOKING_EXPLAIN');?>"><?php echo JText::_('BOOKING_FORM_CANCEL_BOOKING');?></span></label>
			    <input type="text" name="cancel_cid" id="cancel_cid" class="date_inputbox" value="" placeholder="<?php echo JText::_('BOOKING_FORM_CANCEL_BOOKING_REFERENCE');?>" />
			    <input type="button" class="btn submit cancel_booking_btn" value="<?php echo JText::_('BOOKING_FORM_CANCEL_BOOKING_BTN'); ?>" />
			</div>
		    </div>
		</div>

		<?php } ?>

	    </div>

	    </form>
	</div>
    </div>

    <h3 class="onepage_booking_accordion_header ui-state-disabled"><?php echo JText::_('ONEPAGE_BOOKING_SECOND_STEP_HEADER'); ?></h3>
    <div class="onepage_booking_accordion_slide">
	<div id="verticle_booking_wrap_outer">
	    <?php
	    if ($this->booking_maps[$booking_type]==1){
		$map_wrapper_style = 'display:block';
		$map_canvas_style = 'height:'.$this->elsettings->map_height.'px';
	    } else {
		$map_wrapper_style = 'display:none';
		$map_canvas_style = '';
	    }
	    ?>

	    <div class="messagewrap" id="warning_msg" style="display:none;">
		<div class="messagetext"></div>
	    </div>

	    <div id="map_wrapper" style="position:relative;<?php echo $map_wrapper_style;?>">
            <div class="steps">
                <div class="step done">
                    <a href="javascript:void(0);" class="back_previous one">
                        <span><i class="fa fa-check"></i></span> Route
                    </a>
                </div>
                    <div class="step active">
                        <span>2</span> Prices
                    </div>
                    <div class="step">
                        <span>3</span> Passengers
                    </div>
                <div class="step">
                    <span>4</span> Payment
                </div>
            </div>
		<div id="map_processing" class="dataTables_processing" style="visibility: hidden;">
		    <img width="128" height="15" alt="Processing..." title="Processing" src="<?php echo JURI::base(); ?>components/com_taxibooking/assets/images/ajax-loader-bar.gif" />
		</div>
		<div id="map_canvas" style="<?php echo $map_canvas_style; ?>"></div>
	    </div>

	    <div id="directions_panel" style="height:<?php echo $this->elsettings->dir_height;?>px;"></div>

	    <div class="messagewrap" id="journey_details" style="display:none;">
		<div class="messagetitle">
		    <?php echo JText::_('TAXI_SERVICES_FROM'); ?>
		    <span id="journey_msg">
			<?php echo JText::_('JOURNEY_FROM'); ?> <span id="origin"></span> <?php echo JText::_('JOURNEY_TO'); ?> <span id="destination"></span>
			(<span id="distance"></span>)
		    </span>
		</div>
	    </div>


	    <div id="vehicle_wrapper_div" style="position:relative;display:none;">
		<div id="vehicle_processing" class="dataTables_processing" style="visibility: hidden;">
		    <img width="128" height="15" alt="Processing..." title="Processing" src="<?php echo JURI::base(); ?>components/com_taxibooking/assets/images/ajax-loader-bar.gif" />
		</div>
		<div id="vehicle_wrapper"></div>
	    </div>

	    <a href="javascript:void(0);" class="back_previous one"><img src="<?php echo JURI::base();?>components/com_taxibooking/assets/images/arrow_black_up.gif" alt="Back" title="Back" />&nbsp;<?php echo JText::_('BACK_TO_PREVIOUS');?></a>
	</div>
    </div>

    <h3 class="onepage_booking_accordion_header ui-state-disabled"><?php echo JText::_('ONEPAGE_BOOKING_THIRD_STEP_HEADER'); ?></h3>
    <div class="onepage_booking_accordion_slide">

	<div class="container info">
        <div class="steps">
            <div class="step done">
                <span><i class="fa fa-check"></i></span> Route
            </div>
                <div class="step done">
                    <a href="javascript:void(0);" class="back_previous two">
                        <span><i class="fa fa-check"></i></span> Prices
                    </a>
                </div>
                <div class="step active">
                    <span>3</span> Passengers
                </div>
            <div class="step">
                <span>4</span> Payment
            </div>
        </div>
	    <div class="info_top">
		    <h3><?php echo JText::_('BOOKING_FORM_STEP2_TEXT'); ?></h3>

		    <div class="not_for_hourly">
			<?php echo JText::_('FROM');?>: <span class="begin_text"></span><br>

			<?php if($this->elsettings->enable_stops==1) { ?>
			<span id="summary_stops"><?php echo JText::_('STOPS');?>: <span class="summary_stop_text"></span></span>
			<?php } ?>
			<?php echo JText::_('TO');?>: <span class="end_text"></span>
		    </div>

		    <span class="not_for_hourly" id="return_text" style="display:none;"><?php echo JText::_('USER_DETAILS_RETURN_LABEL');?></span>

		    <div class="price" id="price" style="display:none;text-align:center;color:red;font-size:20px;">
		    <?php echo JText::_('PRICE'); ?>: <span id="price_wrap"></span>
		    </div>

		    <table width="100%" border="0">
			<tr>
			    <td valign="bottom">
				<a href="javascript:void(0);" id="edit_direction_trigger"><?php echo JText::_('EDIT_DIRECTIONS'); ?></a>
			    </td>
			</tr>
		    </table>
	    </div>

	    <form name="user_form" id="user_form" action="" method="post">
		<div class="info_wrap">
		    <?php
		    if($session->get('name', '')==""){
			$nameValue = ($this->tbuserObj) ? $this->tbuserObj->name : '';
		    }
		    else {
			$nameValue = $session->get('name', '');
		    }
		    if($session->get('email', '')==""){
			$emailValue = ($this->tbuserObj) ? $this->tbuserObj->email : '';
		    }
		    else {
			$emailValue = $session->get('email', '');
		    }
		    if($session->get('phone', '')==""){
			$phoneValue = ($this->tbuserObj) ? $this->tbuserObj->phone : '';
		    }
		    else {
			$phoneValue = $session->get('phone', '');
		    }
		    ?>

		    <div class="info_input_wrap clearfix">
			    <label for="" class="info_label"><?php echo JText::_('NAME'); ?></label>
			    <div class="info_inputbox">
				<input class="input1 required" name="name" type="text" id="name" value="<?php echo $nameValue; ?>"/>
				<span class="error"><?php echo $session->get('name_error', ''); ?></span>
			    </div>
		    </div>
		    <div class="info_input_wrap clearfix">
			    <label for="" class="info_label"><?php echo JText::_('EMAIL'); ?></label>
			    <div class="info_inputbox">
				<input class="input1 required email" name="email" type="text" id="email" value="<?php echo $emailValue; ?>"/>
				<span class="error"><?php echo $session->get('email_error', ''); ?></span>
			    </div>
		    </div>
		    <div class="info_input_wrap clearfix">
			    <label for="" class="info_label"><?php echo JText::_('PHONE'); ?></label>
			    <div class="info_inputbox">
				<input class="input1 required phone" name="phone" type="text" id="phone" value="<?php echo $phoneValue; ?>"/>
				<span class="error"><?php echo $session->get('phone_error', ''); ?></span>
				<?php if((int)$this->elsettings->send_user_sms==1){?>
				<label class="check">
				    <input type="checkbox" name="receive_sms" class="checkb0" value="1" style="float:left;width:20px;"<?php echo ($session->get('receive_sms', 0)==1) ? ' checked="checked"' : '';?> />
				    <span class="label_tooltip" title="<?php echo JText::_('RECEIVE_ORDER_SMS_EXPLAIN');?>"><?php echo JText::_('RECEIVE_ORDER_SMS');?></span>
				</label>
				<?php } ?>
			    </div>
		    </div>

		    <!-- User details Extras -->
		    <div class="clearfix" id="user_details_extra_wrapper"></div>

		    <?php if((int)$this->elsettings->send_order_copy==1) { ?>
		    <div class="info_input_wrap clearfix">
			<label for="" class="info_label" style="padding-top:0;margin:0;">
			    <span class="label_tooltip" title="<?php echo JText::_('BOOKING_FORM_SEND_ORDER_COPY_EXPLAIN');?>">
				<?php echo JText::_('BOOKING_FORM_SEND_ORDER_COPY_LABEL');?>
			    </span>
			</label>
			<div class="info_inputbox">
			    <a href="javascript:void(0);" id="addordercopy"><?php echo JText::_('BOOKING_FORM_ADD_ORDER_COPY_LABEL'); ?></a>
			</div>
		    </div>
		    <div id="ordercopy_wrap">

			<?php
			$order_copy_users = $session->get('order_copy_users', array());
			if(!empty($order_copy_users)){
			    foreach($order_copy_users as $k => $order_copy_user){
			?>
			<div class="info_input_wrap clearfix">
			    <label for="" class="info_label">&nbsp;</label>
			    <div class="info_inputbox">
				<input class="input1 required" name="order_copy[<?php echo $k;?>][name]" type="text" value="<?php echo $order_copy_user['name'];?>" placeholder="<?php echo JText::_('BOOKING_FORM_SEND_ORDER_COPY_NAME');?>" />
				<input class="input1 required email" name="order_copy[<?php echo $k;?>][email]" type="text" value="<?php echo $order_copy_user['email'];?>" placeholder="<?php echo JText::_('BOOKING_FORM_SEND_ORDER_COPY_EMAIL');?>" />
				<a href="javascript:void(0);" class="remove_order_copy"><?php echo JText::_('BOOKING_FORM_REMOVE_ORDER_COPY_LABEL');?></a>
			    </div>
			</div>
			<?php
			    }
			}
			?>
		    </div>
		    <?php } ?>

		    <div class="info_input_wrap clearfix" id="payment_found_wrapper">
			<div class="info_input_wrap payment clearfix">
			    <label for="" class="info_label addnone"><?php echo JText::_('BOOKING_FORM_STEP2_PAYMENT_TEXT'); ?></label>
			    <div class="info_inputbox clearfix" id="payment_selectors"></div>
			    <span class="error" style="margin-left:138px;color:#FF0000;display:none;float:left;width:100%;"><?php echo JText::_('SELECT_PAYMENT_METHOD'); ?></span>
			</div>
			<div class="info_input_wrap from clearfix">
				<b>** <?php echo JText::_('FILL_ALL_FIELDS') ?></b>
			</div>
			<div class="info_input_wrap buttons clearfix">
				<label>&nbsp;</label>
			    <div class="info_last">
				<input type="button" name="submit" class="step_submit_button see_summary" value="<?php echo JText::_('NEXT') ;?>">
				<img src="<?php echo JURI::base();?>components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" title="Loading" id="summary_loader" style="display:none;margin-left:10px;" />
			    </div>
			</div>
		    </div>
		    <div id="payment_not_found_text"><?php echo JText::_('PAYMENT_METHOD_DISABLED');?></div>
		</div>
	    </form>
	    <a href="javascript:void(0);" class="back_previous two"><img src="<?php echo JURI::base();?>components/com_taxibooking/assets/images/arrow_black_up.gif" alt="Back" title="Back" />&nbsp;<?php echo JText::_('BACK_TO_PREVIOUS');?></a>
	</div>
    </div>

    <h3 class="onepage_booking_accordion_header ui-state-disabled"><?php echo JText::_('ONEPAGE_BOOKING_FOURTH_STEP_HEADER'); ?></h3>
    <div class="onepage_booking_accordion_slide">

	<div class="container check">
        <div class="steps">
            <div class="step done">
                <span><i class="fa fa-check"></i></span> Route
            </div>
                <div class="step done">
                    <span><i class="fa fa-check"></i></span> Prices
                </div>
                <div class="step done">
                    <a href="javascript:void(0);" class="back_previous three">
                        <span><i class="fa fa-check"></i></span> Passengers
                    </a>
                </div>
            <div class="step active">
                <span>4</span> Payment
            </div>
        </div>
	    <h3><?php echo JText::_('CHECK_YOUR_ORDER') ?></h3>
	    <div class="check_wrap">
		<div class="check_box">
		    <div class="check_box_wrap clearfix">
			    <div class="check_name"><?php echo JText::_('NAME');?>:</div>
			    <div class="check_desc" id="user_name"></div>
		    </div>
		    <div class="check_box_wrap clearfix">
			    <div class="check_name"><?php echo JText::_('EMAIL');?>:</div>
			    <div class="check_desc" id="user_email"></div>
		    </div>
		    <div class="check_box_wrap clearfix">
			    <div class="check_name"><?php echo JText::_('PHONE');?>:</div>
			    <div class="check_desc" id="user_phone"></div>
		    </div>

		    <?php if((int)$this->elsettings->send_order_copy==1) { ?>
		    <div class="check_box_wrap clearfix">
			<div class="check_name"><?php echo JText::_('BOOKING_FORM_SUMMARY_ORDER_COPY_LABEL');?>:</div>
			<div class="check_desc" id="order_copy_summary_wrap"></div>
		    </div>

		    <?php } ?>

		    <div class="check_box_wrap clearfix">
			    <div class="check_name"><?php echo JText::_('VEHICLE_TYPE');?>:</div>
			    <div class="check_desc" id="vehicle_type"></div>
		    </div>

		    <div class="check_box_wrap clearfix" id="begin_wrap">
			    <div class="check_name"><?php echo JText::_('FROM');?>:</div>
			    <div class="check_desc begin_text"></div>
		    </div>

		    <!-- Pickup Extras -->
		    <div id="pickup_extra_wrap"></div>

		    <div class="check_box_wrap clearfix" id="PickupAddr1_wrap" style="display:none;">
			    <div class="check_name"><?php echo JText::_('ADDITIONAL_INFORMATION');?>:</div>
			    <div class="check_desc" id="PickupAddr1"></div>
		    </div>

		    <div id="pickup_poi_additional"></div>

		    <div class="check_box_wrap clearfix">
			<div class="check_name"><?php echo JText::_('ORDER_DATE');?>:</div>
			<div class="check_desc" id="pickup_date"></div>
		    </div>

		    <?php if($this->elsettings->enable_stops==1) { ?>
		    <div class="check_box_wrap clearfix" id="summary_stops">
			    <div class="check_name"><?php echo JText::_('STOPS');?>:</div>
			    <div class="check_desc summary_stop_text"></div>
		    </div>
		    <?php } ?>

		    <div class="check_box_wrap clearfix" id="end_wrap">
			    <div class="check_name"><?php echo JText::_('TO');?>:</div>
			    <div class="check_desc end_text"></div>
		    </div>

		    <!-- Dropoff Extras -->
		    <div id="dropoff_extra_wrap"></div>

		    <div class="check_box_wrap clearfix" id="PickupAddr4_wrap" style="display:none;">
			    <div class="check_name"><?php echo JText::_('ADDITIONAL_INFORMATION');?>:</div>
			    <div class="check_desc" id="PickupAddr4"></div>
		    </div>

		    <div id="dropoff_poi_additional"></div>

		    <div class="check_box_wrap clearfix" id="hourly_hired_wrap">
			    <div class="check_name"><?php echo JText::_('HOURLY_HIRE_VEHICLE_HIRED_FOR');?>:</div>
			    <div class="check_desc" id="hourly_hired_text"></div>
		    </div>

		    <!-- Hourly Extras -->
		    <div id="hourly_extra_wrap"></div>

		    <div class="check_box_wrap clearfix" id="return_trip_wrap">
			    <div class="check_name"><?php echo JText::_('RETURN_TRIP');?>:</div>
			    <div class="check_desc" id="return_trip_text"></div>
		    </div>

		    <div id="additional_seats_wrap"></div>

		    <div id="return_trip_info_wrap">

			<div class="check_box_wrap clearfix">
				<div class="check_name"><?php echo JText::_('DATE_RETURN_TRIP');?>:</div>
				<div class="check_desc" id="return_date"></div>
			</div>

			<div class="check_box_wrap clearfix">
				<div class="check_name"><?php echo JText::_('WAIT_TIME_HRS');?>:</div>
				<div class="check_desc" id="return_wait_time"></div>
			</div>

			<div class="check_box_wrap clearfix">
				<div class="check_name"><?php echo JText::_('RETURN_WAIT_DISCOUNT');?>:</div>
				<div class="check_desc" id="return_wait_discount"></div>
			</div>

			<!-- Return Extras -->
			<div id="return_extra_wrap"></div>

		    </div>

		    <!-- Dropoff Extras -->
		    <div id="user_details_extra_wrap"></div>

		    <div class="check_box_wrap clearfix last" id="customer_note_wrap" style="display:none;">
			    <div class="check_name"><?php echo JText::_('MESSAGE');?>:</div>
			    <div class="check_desc" id="customer_note"></div>
		    </div>

		    <div class="check_box_wrap clearfix" id="sub_total_wrap">
			    <div class="check_name"><?php echo JText::_('SUB_TOTAL');?>:</div>
			    <div class="check_desc" id="sub_total"></div>
		    </div>

		    <div class="check_box_wrap clearfix" id="flat_cost_wrap">
			    <div class="check_name"><?php echo JText::_('FLAT_COST');?>:</div>
			    <div class="check_desc" id="flat_cost"></div>
		    </div>

		    <div class="check_box_wrap clearfix" id="percentage_cost_wrap">
			    <div class="check_name"><?php echo JText::_('PERCENTAGE_COST');?>:</div>
			    <div class="check_desc" id="percentage_cost"></div>
		    </div>

		    <div class="check_box_wrap clearfix" id="user_group_discount_wrap">
			    <div class="check_name"><?php echo JText::_('BOOKING_FORM_SUMMARY_USER_GROUP_DISCOUNT');?>:</div>
			    <div class="check_desc" id="user_group_discount"></div>
		    </div>

		    <div class="check_box_wrap clearfix" id="grand_total_wrap">
			    <div class="check_name"><?php echo JText::_('GRAND_TOTAL');?>:</div>
			    <div class="check_desc" id="grand_total"></div>
		    </div>

		    <div class="check_box_wrap clearfix last">
			    <div class="check_name"><?php echo JText::_('PAYMENT_METHOD');?>:</div>
			    <div class="check_desc" id="payment_method_name"></div>
		    </div>

		    <div id="payment_labels"></div>

		    <form name="captcha_form" id="captcha_form" method="POST" action="<?php echo JRoute::_('index.php');?>">

		    <input type="hidden" name="booking_form_itemid" value="<?php echo $this->active_menu_id;?>" />

		    <?php if(booking_helper::has_any_coupon()){ ?>
		    <div class="check_box_wrap clearfix" id="coupon_code_wrap">
			<div class="check_name"><?php echo JText::_('BOOKING_FORM_COUPON_CODE');?>:</div>
			<div class="check_desc">
			    <input id="coupon_code" type="text" name="coupon_code" value="" style="width:130px;" />
			    <img id="coupon_loader" style="margin:5px 0 0 5px;float:right;display:none;" alt="Loading" title="Loading" src="<?php echo JURI::base();?>components/com_taxibooking/assets/images/ajax-loader.gif" />
			    <div id="coupon_code_msg" style="color:red;"></div>
			</div>
		    </div>
		    <?php } ?>

		    <?php if((int)$this->elsettings->enable_gratuity==1){ ?>
		    <div class="check_box_wrap clearfix">
			<div class="check_name gratuity_lbl" title="<?php echo JText::_('BOOKING_FORM_GRATUITY_EXPLAIN');?>"><?php echo JText::_('BOOKING_FORM_GRATUITY_LABEL');?>:</div>
			<div id="gratuities_wrap"></div>
		    </div>
		    <?php } ?>

		    <div class="check_box_wrap clearfix detail">
			<div class="check_name"><a href="javascript:void(0);" id="edit_details_trigger"><?php echo JText::_('EDIT_PERSONAL_DETAILS');?></a></div>
		    </div>

		    <div class="check_box_wrap">

			<?php if((int)$this->elsettings->use_terms==1){?>
			<label class="check" style="display:block;margin-bottom:5px;">
			    <input type="checkbox" name="cbox" class="checkb0" value="<?php echo JText::_('TERMS_CONDITION');?>" style="vertical-align: top;"/>&nbsp;
			    <?php echo JText::_('PLEASE_CHECK_TO_ACCEPT');?>&nbsp;
			    <a id="terms_trigger" href="<?php echo JURI::root();?>index.php?option=com_taxibooking&view=terms&tmpl=component">
				<?php echo JText::_('TERMS_CONDITION');?>
			    </a>
			</label>
			<?php } ?>

			<div id="captcha_wrap" style="display:none;">
			    <label for="security_code" class="security_code"><?php echo JText::_('CAPTCHA');?>: </label><br>
			    <span id="captcha_image"></span>&nbsp;&nbsp;&nbsp;
			    <input id="security_code" style="margin-top: 5px;" name="security_code" type="text" maxlength="5" />
			</div>

			<div style="margin-top:10px;">
			    <input name="submitCash" value="<?php echo JText::_('MAKE_BOOKING');?>" type="button" class="button step_submit_button"  />
			    <img src="<?php echo JURI::base();?>components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" title="Loading" id="make_booking_loader" style="margin-left:10px;display:none;" />
			    <span class="security_code_error"></span>
			</div>
		    </div>

		    <?php echo JHtml::_('form.token'); ?>
		    </form>
		</div>
	    </div>
	    <a href="javascript:void(0);" class="back_previous three"><img src="<?php echo JURI::base();?>components/com_taxibooking/assets/images/arrow_black_up.gif" alt="Back" title="Back" />&nbsp;<?php echo JText::_('BACK_TO_PREVIOUS');?></a>
	</div>
    </div>
</div>

<div id="dialog-hrs" title="<?php echo JText::_('HRS');?>" style="display:none;">
   <div id="hrs-wrapper"></div>
</div>
<div id="dialog-mins" title="<?php echo JText::_('MINS');?>" style="display:none;">
   <div id="mins-wrapper"></div>
</div>
<div id="dialog-return-hrs" title="<?php echo JText::_('HRS');?>" style="display:none;">
   <div id="return-hrs-wrapper"></div>
</div>
<div id="dialog-return-mins" title="<?php echo JText::_('MINS');?>" style="display:none;">
   <div id="return-mins-wrapper"></div>
</div>
<div id="dialog-shuttle-passengers" title="<?php echo JText::_('SHUTTLES_AVAILABLE_SEATS');?>" style="display:none;">
   <div id="shuttle-passengers-wrapper"></div>
</div>

<script type="text/javascript">
var BASE_URL = '<?php echo JURI::root();?>';
var USER_LOGGED_IN = '<?php echo $this->user->get('id');?>';
var USER_IS_CORPORATE_CLIENT = '0';
<?php if( $this->user->get('id')>0 && file_exists ( JPATH_ROOT.DS."components".DS."com_tbcorporate".DS.'tbcorporate.php' ) && $this->tbuserObj->is_corporate_client==1){ ?>
var USER_IS_CORPORATE_CLIENT = '1';
<?php }?>
var HOURLY_HIRE_TAB_LABEL = "<?php echo JText::_('HOURLY_HIRE_TAB_LABEL');?>";
var SHUTTLES_TAB_LABEL = "<?php echo JText::_('SHUTTLES_TAB_LABEL');?>";
var MYORDERS_TAB_LABEL = "<?php echo JText::_('MYORDERS_TAB_LABEL');?>";
var ORDER_RETURN_DATE_TXT = "<?php echo JText::_('ORDER_RETURN_DATE');?>";
var HRS_TXT="<?php echo JText::_('HRS');?>";
var MINS_TXT="<?php echo JText::_('MINS');?>";
var ERR_MESSAGE_FIELD_REQUIRED = "<?php echo JText::_('ERR_MESSAGE_FIELD_REQUIRED');?>";
var ERR_MESSAGE_VALID_EMAIL = "<?php echo JText::_('ERR_MESSAGE_VALID_EMAIL');?>";
var ERR_MESSAGE_VALID_PHONE = "<?php echo JText::_('ERR_MESSAGE_VALID_PHONE');?>";
var ERR_MESSAGE_VALID_NUMERIC = "<?php echo JText::_('ERR_MESSAGE_VALID_NUMERIC');?>";

var MYORDERS_TABLE_SEARCH_LABEL = "<?php echo JText::_('MYORDERS_TABLE_SEARCH_LABEL');?>";
var MYORDERS_TABLE_SHOW_LABEL = "<?php echo JText::_('MYORDERS_TABLE_SHOW_LABEL');?>";
var MYORDERS_TABLE_ZERO_RECORDS_LABEL = "<?php echo JText::_('MYORDERS_TABLE_ZERO_RECORDS_LABEL');?>";
var MYORDERS_TABLE_SHOW_INFO_LABEL = "<?php echo JText::_('MYORDERS_TABLE_SHOW_INFO_LABEL');?>";
var MYORDERS_TABLE_INFO_EMPTY_LABEL = "<?php echo JText::_('MYORDERS_TABLE_INFO_EMPTY_LABEL');?>";
var MYORDERS_TABLE_INFO_FILTERED_LABEL = "<?php echo JText::_('MYORDERS_TABLE_INFO_FILTERED_LABEL');?>";
var MYORDERS_TABLE_PAGINATE_START_LABEL = "<?php echo JText::_('MYORDERS_TABLE_PAGINATE_START_LABEL');?>";
var MYORDERS_TABLE_PAGINATE_PREVIOUS_LABEL = "<?php echo JText::_('MYORDERS_TABLE_PAGINATE_PREVIOUS_LABEL');?>";
var MYORDERS_TABLE_PAGINATE_NEXT_LABEL = "<?php echo JText::_('MYORDERS_TABLE_PAGINATE_NEXT_LABEL');?>";
var MYORDERS_TABLE_PAGINATE_END_LABEL = "<?php echo JText::_('MYORDERS_TABLE_PAGINATE_END_LABEL');?>";

var geocoder, map, mapOptions, areaOfOperation;
var selectedAreaVerticesStr = '<?php echo $this->elsettings->operation_area_vertices; ?>';
var triangleCoords = new Array();
var selectedAreaVerticesArr = JSON.parse(selectedAreaVerticesStr);

var url_booking_type = '<?php echo JRequest::getVar('booking_type', ""); ?>';
if(url_booking_type!="")
{
    tbjQuery('#booking_type').val(url_booking_type);
    var pickup_type = '<?php echo JRequest::getVar('pickup_type', 'poi'); ?>';
    var pickup_poi = '<?php echo JRequest::getInt('pickup_poi', 0); ?>';
    var pickup_address = '<?php echo urldecode(JRequest::getVar('pickup_address', '')); ?>';
    var pickup_lat = '<?php echo JRequest::getVar('pickup_lat', ''); ?>';
    var pickup_lng = '<?php echo JRequest::getVar('pickup_lng', ''); ?>';
    var dropoff_type = '<?php echo JRequest::getVar('dropoff_type', 'poi'); ?>';
    var dropoff_poi = '<?php echo JRequest::getInt('dropoff_poi', 0); ?>';
    var dropoff_address = '<?php echo urldecode(JRequest::getVar('dropoff_address', '')); ?>';
    var dropoff_lat = '<?php echo JRequest::getVar('dropoff_lat', ''); ?>';
    var dropoff_lng = '<?php echo JRequest::getVar('dropoff_lng', ''); ?>';
    var route_pickup_category = '<?php echo JRequest::getInt('route_pickup_category', 0); ?>';
    var route_pickup_poi = '<?php echo JRequest::getInt('route_pickup_poi', 0); ?>';
    var route_dropoff_category = '<?php echo JRequest::getInt('route_dropoff_category', 0); ?>';
    var route_dropoff_poi = '<?php echo JRequest::getInt('route_dropoff_poi', 0); ?>';
    var hourly_hr = '<?php echo JRequest::getInt('hourly_hr', 0); ?>';
    var hourly_min = '<?php echo JRequest::getInt('hourly_min', 0); ?>';
    var shuttle_pickup_poi = '<?php echo JRequest::getInt('shuttle_pickup_poi', 0); ?>';
    var shuttle_dropoff_poi = '<?php echo JRequest::getInt('shuttle_dropoff_poi', 0); ?>';
    var shuttle_pickup_date = '<?php echo JRequest::getVar('shuttle_pickup_date', ''); ?>';
    var shuttle_pickup_time = '<?php echo JRequest::getVar('pickup_time', ''); ?>';
    var shuttle_passengers = '<?php echo JRequest::getInt('shuttle_passengers', 0); ?>';
    var url_coupon_id = '<?php echo JRequest::getInt('coupons', 0); ?>';
    var url_extras = '<?php echo json_encode(JRequest::getVar('extras', array()));?>';

    if(url_booking_type=='orders'){
	var url_order_number = '<?php echo JRequest::getVar('oid', "");?>';
    }
}

var disabledDates = [];
<?php
if(!empty($disabled_dates)){
    $js_array = json_encode($disabled_dates);
    echo "disabledDates = ". $js_array . ";\n";
}
?>

var tbConfig = {
    default_tab: <?php echo $this->default_tab_index;?>,
    pickup_in_area_operation: <?php echo (int)$this->elsettings->pickup_in_area;?>,
    dropoff_in_area_operation:<?php echo (int)$this->elsettings->dropoff_in_area;?>,
    pickup_dropoff_in_area_operation:<?php echo (int)$this->elsettings->pickup_dropoff_in_area;?>,
    url_consists_dynamic_param: <?php echo $url_consists_dynamic_param;?>,
    show_maps_in_shuttle: <?php echo $this->booking_maps['shuttle'];?>,
    optimize_stops:<?php echo (int)$this->elsettings->optimize_stops;?>,
    show_address_tab:<?php echo (int)$this->elsettings->show_address_tab;?>
};
</script>

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-ui.js"></script>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.ui.datepicker-<?php echo $this->lang_tag;?>.js"></script>

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/fancybox/jquery.fancybox-1.3.4.pack.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo JURI::root();?>components/com_taxibooking/assets/fancybox/jquery.fancybox-1.3.4.css" media="screen" />

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/dataTables.responsive.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery.dataTables.css">
<link rel="stylesheet" type="text/css" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/dataTables.responsive.css">

<!-- CSS to style the file input field as button and adjust the Bootstrap progress bars -->
<link rel="stylesheet" type="text/css" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery.fileupload.css">
<!-- The basic File Upload plugin -->
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.fileupload.js"></script>
<!-- The File Upload processing plugin -->
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.fileupload-process.js"></script>
<!-- The File Upload validation plugin -->
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.fileupload-validate.js"></script>

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.Jcrop.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery.Jcrop.css">

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.selectbox-0.2.min.js"></script>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/onepage_taxibooking.js"></script>
<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o&v=3.exp&language=<?php echo substr($this->lang_tag,0,2);?>&libraries=places"></script>

<?php if( JRequest::getVar('booking_type', "")!="") { ?>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/onepage_urltaxibooking.js"></script>
<?php } ?>

<script type="text/javascript">
tbjQuery(document).ready(function(){
    if(url_booking_type=='orders')
    {
	var orders_tab_index = <?php echo $this->total_available_booking_types;?>;
	tbjQuery( "#verticle_booking_wrap" ).tabs( "option", "active", orders_tab_index );
	tbjQuery( "#myorders_accordion" ).accordion( "option", "active", 1 );
    }

    <?php if((int)$this->elsettings->use_terms==1){?>
    tbjQuery('[name="submitCash"]').attr('disabled', true);
    <?php } ?>

    // route autocomplete
    <?php if( (int)$this->elsettings->show_offers_tab==1 && $this->lists['has_any_route']){ ?>
    <?php if($session->get('route_swapped', 0)==0){ ?>
    tbjQuery("#route_category_fld").autocomplete({
        source: <?php echo $this->lists['route_categories_data'];?>,
        minLength: 2,
        open: function( event, ui ) {
            tbjQuery('div.routes_wrapper div.routecategory_dropdown_wrapper').hide();
        },
        select: function(event, ui) {
            tbjQuery('#route_category').val(ui.item.id);
	    tbjQuery('#route_category_fld').val(ui.item.value);
	    tbjQuery('div.routes_wrapper div.routecategory_dropdown_wrapper').hide();
	    // unset routes
	    tbjQuery('#route_from').val(0);
	    tbjQuery('#route_from_fld').val('');
	    tbjQuery('#route_to').val(0);
	    tbjQuery('#route_to_fld').val('');
	    // unset all the poi/address selection below
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery.fn.collectRouteFrom();
	    tbjQuery('#booking_type').val('offers');
        }
    })
    tbjQuery("#route_category_dropoff_fld").autocomplete({
        source: <?php echo $this->lists['route_categories_dropoff_data'];?>,
        minLength: 2,
        open: function( event, ui ) {
            tbjQuery('div.routes_wrapper div.routecategory_dropoff_dropdown_wrapper').hide();
        },
        select: function(event, ui) {
            tbjQuery('#route_category_dropoff').val(ui.item.id);
	    tbjQuery('#route_category_dropoff_fld').val(ui.item.value);
	    tbjQuery('div.routes_wrapper div.routecategory_dropoff_dropdown_wrapper').hide();
	    // unset routes
	    tbjQuery('#route_to').val(0);
	    tbjQuery('#route_to_fld').val('');
	    // unset all the poi/address selection below
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery.fn.collectRouteTo();
	    tbjQuery('#booking_type').val('offers');
        }
    })
    tbjQuery("#route_from_fld").autocomplete({
        source: <?php echo $this->lists['pickup_route_poi_data'];?>,
        minLength: 2,
        open: function( event, ui ) {
            tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').hide();
        },
        select: function(event, ui) {
            tbjQuery('#route_from').val(ui.item.id);
	    tbjQuery('#route_from_fld').val(ui.item.value);
	    tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').hide();
	    // unset all the poi/address selection below
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery.fn.getExtras('route_pickup');
	    tbjQuery.fn.collectRouteTo();
	    tbjQuery('#booking_type').val('offers');
        }
    })
    tbjQuery("#route_to_fld").autocomplete({
        source: <?php echo $this->lists['dropoff_route_poi_data'];?>,
        minLength: 2,
        open: function( event, ui ) {
            tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').hide();
        },
        select: function(event, ui) {
            tbjQuery('#route_to').val(ui.item.id);
	    tbjQuery('#route_to_fld').val(ui.item.value);
	    tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').hide();
	    // unset all the poi/address selection below
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery.fn.getExtras('route_dropoff');
	    tbjQuery('#booking_type').val('offers');
        }
    })
    <?php } ?>
    <?php } ?>

    // customer can't choose return date previous to the pickup date
    <?php if($session->get('timestr2', '')==''&&$this->returnjurney == 0){ ?>
    var order_date_day = tbjQuery('#pickup_day').val();
    tbjQuery('#return_day').val(order_date_day);
    var order_date_month = tbjQuery('#pickup_month').val();
    tbjQuery('#return_month').val(order_date_month);
    var order_date_year = tbjQuery('#pickup_year').val();
    tbjQuery('#return_year').val(order_date_year);
    <?php } ?>

    <?php if($this->elsettings->enable_stops==1) { ?>
    tbjQuery('a.addstop').click(function(){
	var stops_counter = tbjQuery('div.stops_wrap').length;
	if(stops_counter > 7){
	    alert("<?php echo JText::_('MAXIMUM_NUMBER_STOPS');?>");
	    return false;
	}
	tbjQuery('div.stops_wrap').removeClass('last');
	var html = '<div class="topinnerWrap stops_wrap last clearfix">'+
			'<div class="top_ver_input_wrapOuter clearfix">'+
			    '<div class="top_ver_input_wrap clearfix">';

	<?php if($this->elsettings->show_stop_address==1) { ?>
	html 	+= 	'<div class="getlocationField">'+
				'<a class="dropoff_direction" href="javascript:void(0);" onclick="get_user_location(\'waypoints\', this);">'+"<?php echo JText::_('GET_LOCATION'); ?>"+'</a>'+
			'</div>';
	<?php } ?>

	<?php
	$additional_class = '';
	$additional_class .= ($this->elsettings->show_stop_poi==0) ? ' poi_disabled' : '';
	$additional_class .= ($this->elsettings->show_stop_address==0) ? ' address_disabled' : '';
	?>

	html 	+= 	'<div class="inputField<?php echo $additional_class;?>">'+
			    '<input type="text" class="inputbox waypoints" name="waypoints['+stops_counter+']" id="waypoint_'+stops_counter+'" value="" placeholder="'+"<?php echo ($this->elsettings->show_stop_address==1)?JText::_('ENTER_ADDRESS'):JText::_('SELECT_PLACE'); ?>"+'" />'+
			    '<input type="hidden" name="waypoints_lat['+stops_counter+']" id="waypoint_lat" value="" />'+
			    '<input type="hidden" name="waypoints_lng['+stops_counter+']" id="waypoint_lng" value="" />'+
			'</div>';

	<?php if($this->elsettings->show_stop_poi==1) { ?>
	html   	+=	'<div class="selectField-wrap">'+
			    '<div class="selectField">'+
				'<div class="arrow_wrapper poi_options_trigger stop_'+stops_counter+'">trigger_icon</div>'+
				'<div class="poi_dropdown_wrapper stop_'+stops_counter+'" style="display:none;">';
	<?php
	if(!empty($this->lists['all_places_data'])){
	    foreach($this->lists['all_places_data'] as $place){
	?>
	html	+=	'<div class="poi_link" data-poiid="<?php echo $place->id;?>" data-poilat="<?php echo $place->lat;?>" data-poilng="<?php echo $place->long;?>">';
	html	+=	'<?php echo ($place->image!="") ? '<img src="'.JURI::base().$place->image.'" alt="'.$place->cattitle.'" title="'.$place->cattitle.'" class="poicat_icon" />&nbsp;' : '';?>';
	html	+=	"<span><?php echo $place->title;?></span></div>";
	<?php
	    }
	}
	?>
	html   	+=		'</div>'+
			    '</div>'+
			'</div>';
	<?php } ?>
	html 	+= '</div>';

	<?php if($this->user->get('id') > 0 && $this->has_any_address){ ?>
	html   	+= '<div class="select_addressbook pickupWrap"><a href="javascript:void(0);" class="select_addressbook stops stop'+stops_counter+'">'+"<?php echo JText::_('SELECT_FROM_ADDRESSBOOK');?>"+'</a></div>';
	<?php } ?>

	html += 	'<div class="time_at_stop clearfix">';
	html += 		'<div class="title_stops">'+"<?php echo JText::_('TIME_AT_STOP'); ?>"+'</div><select name="waypoints_stop_duration['+stops_counter+']" class="stop_interval_options" tabindex="1">';
	<?php
	for($i = $stop_duration_interval; $i <= ($max_stop_time*60); $i = $i + $stop_duration_interval){
	?>
	html 	+= '<option value="<?php echo $i;?>">'+"<?php echo JText::sprintf('STOP_INTERVAL_MINS', $i); ?>"+'</option>';
	<?php } ?>
	html += '</select></div><a href="javascript:void(0);" class="remove_stops">'+"<?php echo JText::_('REMOVE_STOP');?>"+'</a>';

	html 	+= 	'</div>'+
		    '</div>';

	tbjQuery('#stops_wrapper').append(html);
	tbjQuery(".stop_interval_options").selectbox();

	// bind place autocomplete to this waypoint
	<?php  if($this->elsettings->default_country!="") {?>
	var options = {
	    componentRestrictions: {country: '<?php echo $this->default_country;?>'}
	};
	<?php } else { ?>
	var options = {};
	<?php } ?>

	<?php if($this->elsettings->show_stop_address==1) { ?>
	var waypoint_field = document.getElementById('waypoint_'+stops_counter);
	var waypoint_autocomplete = new google.maps.places.Autocomplete(waypoint_field, options);
	google.maps.event.addListener(waypoint_autocomplete, 'place_changed', function() {
	    var place = waypoint_autocomplete.getPlace();
	    if (place.geometry) {
		tbjQuery(waypoint_field).siblings('#waypoint_lat').val(place.geometry.location.lat());
		tbjQuery(waypoint_field).siblings('#waypoint_lng').val(place.geometry.location.lng());
	    }
	});
	<?php } ?>

	<?php if($this->elsettings->show_stop_poi==1) { ?>
	tbjQuery('div.dropoff_wrap div.stops_wrap div.poi_options_trigger.stop_'+stops_counter).click(function(){
	    if(tbjQuery(this).hasClass('Open') == true){
		tbjQuery(this).removeClass("Open");
	    }
	    else {
		tbjQuery(this).addClass("Open");
	    }
	    if (tbjQuery(this).next('div.poi_dropdown_wrapper.stop_'+stops_counter).is(":visible") == true){
		tbjQuery(this).next('div.poi_dropdown_wrapper.stop_'+stops_counter).slideUp(250);
	    }
	    else {
		tbjQuery(this).next('div.poi_dropdown_wrapper.stop_'+stops_counter).slideDown(250);
	    }
	})
	tbjQuery("div.dropoff_wrap div.stops_wrap div.poi_dropdown_wrapper div.poi_link").click(function(){
	    tbjQuery(this).closest('div.stops_wrap').find('.waypoints').val(tbjQuery(this).children('span').html());
	    tbjQuery(this).closest('div.stops_wrap').find('#waypoint_lat').val(tbjQuery(this).data('poilat'));
	    tbjQuery(this).closest('div.stops_wrap').find('#waypoint_lng').val(tbjQuery(this).data('poilng'));
	    tbjQuery(this).closest('div.stops_wrap').find("div.poi_dropdown_wrapper").hide();
	    tbjQuery(this).closest('div.stops_wrap').find('.poi_options_trigger.stop_'+stops_counter).removeClass('Open');
	})
	<?php } ?>
    })
    tbjQuery('div.dropoff_wrap').on('click', '.remove_stops', function() { // code
	tbjQuery(this).closest('div.stops_wrap').remove();
    });
    <?php } ?>

    tbjQuery('a#addordercopy').click(function(){
	var i = tbjQuery('div#ordercopy_wrap div.info_input_wrap').length;
	var html = '<div class="info_input_wrap clearfix">';
	html += '<label for="" class="info_label">&nbsp;</label>';
	html += '<div class="info_inputbox">';
	html += '<input class="input1 required" name="order_copy['+i+'][name]" type="text" value="" placeholder="'+"<?php echo JText::_('BOOKING_FORM_SEND_ORDER_COPY_NAME');?>"+'" />';
	html += '<input class="input1 required email" name="order_copy['+i+'][email]" type="text" value="" placeholder="'+"<?php echo JText::_('BOOKING_FORM_SEND_ORDER_COPY_EMAIL');?>"+'" />';
	html += '<a href="javascript:void(0);" class="remove_order_copy">'+"<?php echo JText::_('BOOKING_FORM_REMOVE_ORDER_COPY_LABEL');?>"+'</a></div>';
	html += '</div>';
	tbjQuery('div#ordercopy_wrap').append(html);
    })
    tbjQuery('div#ordercopy_wrap').on('click', 'a.remove_order_copy', function() { // code
	tbjQuery(this).closest('div.info_input_wrap').remove();
    });
})
function initialize() {
    for (var i =0; i < selectedAreaVerticesArr.length; i++) {
	triangleCoords.push(new google.maps.LatLng(selectedAreaVerticesArr[i][0],selectedAreaVerticesArr[i][1]));
    }
    areaOfOperation = new google.maps.Polygon({
	paths: triangleCoords
    });

    <?php  if($this->elsettings->default_country!="") {?>
    var options = {
        componentRestrictions: {country: '<?php echo $this->default_country;?>'}
    };
    <?php } else { ?>
    var options = {};
    <?php } ?>

    <?php if( (int)$this->elsettings->show_address_tab==1 && (int)$this->elsettings->show_from_address==1) { ?>
    var address_from_input = document.getElementById('address_from');
    var address_from_autocomplete = new google.maps.places.Autocomplete(address_from_input, options);

    tbjQuery("#address_from").change(function(){
	tbjQuery('#address_from_lat').val("");
	tbjQuery('#address_from_lng').val("");
	tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').hide();
	tbjQuery('div#pickup_extra_wrapper').html('');
    });
    google.maps.event.addListener(address_from_autocomplete, 'place_changed', function() {
	tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').hide();
	var place = address_from_autocomplete.getPlace();
	if (place.geometry) {
	    tbjQuery('#address_from_lat').val(place.geometry.location.lat());
	    tbjQuery('#address_from_lng').val(place.geometry.location.lng());
	    // first check if this Address is in Area of Operation
	    <?php if( (int)$this->elsettings->pickup_in_area==1 || (int)$this->elsettings->pickup_dropoff_in_area==1) { ?>
	    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(place.geometry.location.lat(),place.geometry.location.lng()), areaOfOperation)) {
		showAreaOperationPopup();
		return false;
	    }
	    <?php }?>

	    tbjQuery('#address_from_lat').val(place.geometry.location.lat());
	    tbjQuery('#address_from_lng').val(place.geometry.location.lng());
	    tbjQuery.fn.unsetRoute();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery('div#pickup_extra_wrapper').html('');
	    tbjQuery('#booking_type').val('address');
	    tbjQuery("#address_from").removeClass('incorrect');
	    tbjQuery.fn.getExtras('address_pickup');

	    // regenerate return route with extra if Return Journey is selected
	    if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
		tbjQuery.fn.getReturnExtras();
	    }
	}
    });
    <?php } ?>

    <?php if((int)$this->elsettings->show_address_tab==1 && (int)$this->elsettings->show_to_address==1) { ?>
    var address_to_input = document.getElementById('address_to');
    var address_to_autocomplete = new google.maps.places.Autocomplete(address_to_input, options);

    tbjQuery("#address_to").change(function(){
	tbjQuery('#address_to_lat').val("");
	tbjQuery('#address_to_lng').val("");
	tbjQuery('div.dropoff_wrap div.poi_dropdown_wrapper').hide();
	tbjQuery('div#dropoff_extra_wrapper').html('');
    });
    google.maps.event.addListener(address_to_autocomplete, 'place_changed', function() {
	tbjQuery('div.dropoff_wrap div.poi_dropdown_wrapper').hide();
	var place = address_to_autocomplete.getPlace();
	if (place.geometry) {

	    <?php if( (int)$this->elsettings->dropoff_in_area==1 || (int)$this->elsettings->pickup_dropoff_in_area==1) { ?>
	    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(place.geometry.location.lat(),place.geometry.location.lng()), areaOfOperation)) {
		showAreaOperationPopup();
		return false;
	    }
	    <?php }?>

	    tbjQuery('#address_to_lat').val(place.geometry.location.lat());
	    tbjQuery('#address_to_lng').val(place.geometry.location.lng());
	    tbjQuery.fn.unsetRoute();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery('div#dropoff_extra_wrapper').html('');
	    tbjQuery('#booking_type').val('address');
	    tbjQuery("#address_to").removeClass('incorrect');
	    tbjQuery.fn.getExtras('address_dropoff');

	    // regenerate return route with extra if Return Journey is selected
	    if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
		tbjQuery.fn.getReturnExtras();
	    }
	}
    });
    <?php } ?>

    if(parseInt(USER_LOGGED_IN) > 0)
    {
	var addressbook_input = document.getElementById('new_address_title');
	var addressbook_autocomplete = new google.maps.places.Autocomplete(addressbook_input, options);
	google.maps.event.addListener(addressbook_autocomplete, 'place_changed', function() {
	    var place = addressbook_autocomplete.getPlace();
	    if (place.geometry) {
		tbjQuery('#new_address_lat').val(place.geometry.location.lat());
		tbjQuery('#new_address_lng').val(place.geometry.location.lng());
	    }
	});
    }

    tbjQuery('.waypoints').each(function(){
	var waypoint_field = this;
	var waypoint_autocomplete = new google.maps.places.Autocomplete(waypoint_field, options);
	google.maps.event.addListener(waypoint_autocomplete, 'place_changed', function() {
	    var place = waypoint_autocomplete.getPlace();
	    if (place.geometry) {
		tbjQuery(waypoint_field).siblings('#waypoint_lat').val(place.geometry.location.lat());
		tbjQuery(waypoint_field).siblings('#waypoint_lng').val(place.geometry.location.lng());
	    }
	});
    })

    // show a map centering to the default city set from admin panel
    <?php if($this->load_default_map){?>
    //load_default_map();
    <?php } ?>
}

function load_default_map() {
    geocoder = new google.maps.Geocoder();
    mapOptions = {
	zoom: <?php echo ($this->elsettings->map_zoom=="") ? '8' : $this->elsettings->map_zoom ;?>,
	mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    map = new google.maps.Map(document.getElementById('map_canvas'), mapOptions);
    var address = encodeURIComponent("<?php echo $this->elsettings->default_city.', '.$this->default_country;?>");
    geocoder.geocode( { 'address': address}, function(results, status) {
	if (status == google.maps.GeocoderStatus.OK) {
	    map.setCenter(results[0].geometry.location);
	} else {
	    alert("Geocode was not successful for the following reason: " + status);
	    return false;
	}
    });
    tbjQuery('div#directions_panel').html('').hide();
}
google.maps.event.addDomListener(window, 'load', initialize);
</script>
