<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined( '_JEXEC' ) or die( 'Restricted access' );

/**
 * HTML View class for the View
 */
class TaxiBookingViewTaxiBooking extends JViewLegacy {

    /**
     * Creates the Forms for the View
     *
     * @since 1.0
     */
    function display($tpl = null) {

        $app = JFactory::getApplication();

        //initialize variables
        $document =  JFactory::getDocument();
        $menus = $app->getMenu();
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();
        $menu = $menus->getActive();
        $uri = JFactory::getURI();
        $session = JFactory::getSession();
        $elsettings = booking_helper::config();
        $acl = JFactory::getACL();
        $this->user = JFactory::getUser();
        $this->tbuserObj = booking_helper::getTBUserInfo($this->user->get('id'));
        $this->active_menu_id = $menu->id;

        // check if EU Privacy plugin is installed and enabled
        // If not, EU privacy will be auto accepted
        $accepted = true;
        $path = JPATH_ROOT.DS."plugins".DS."system".DS."eprivacy";
        if(file_exists ( $path.DS.'eprivacy.php' ))
        {
            $plguinEnabled = JPluginHelper::isEnabled('system', 'eprivacy');
            if($plguinEnabled){
                $accepted = $app->input->cookie->get('plg_system_eprivacy',false);
            }
        }

        // if EU privacy is accepted, booking form will be shown
        // oterwise warning message at the top
        if($accepted)
        {
            // Get the page/component configuration
            $params = $app->getParams();

            // right from the menu item itself
            if (is_object($menu)) {
                $menu_params = new JRegistry;
                $menu_params->loadString($menu->params);

                if (!$menu_params->get('page_title')) {
                    $params->set('page_title', JText::_('TAXIBOOKING'));
                }
            }
            else {
                $params->set('page_title', JText::_('TAXIBOOKING'));
            }

            /*
             * Handle the metadata title
             */
            $document->setMetadata('keywords', $params->get('page_title'));

            if ($app->getCfg('MetaTitle') == '1') {
                $document->setTitle($params->get('page_title'));
            }

            // if URL booking type is set, clear prevvious session
            $url_booking_type = JRequest::getVar('booking_type', '');
            if($url_booking_type!=''){
                $this->clear_session();
            }

            $default_from_dest = ($elsettings->show_from_poi==1) ? 0 : 1;
            $default_to_dest = ($elsettings->show_to_poi==1) ? 0 : 1;

            $from_dest = $session->get('from_dest', $default_from_dest);
            $airports1 = $session->get('airports1', '');

            $to_dest = $session->get('to_dest', $default_to_dest);
            $airports2 = $session->get('airports2', '');

            $returnjurney = $session->get('returnjurney', 0);
            $vehicle = $session->get('vehicle', 0);

            $from_error = $session->get('from_error', '');
            $to_error = $session->get('to_error', '');
            $zip_error = $session->get('zip_error', '');
            $passenger_error = $session->get('passenger_error', '');

            $this->is_hourly_rate_enabled = booking_helper::is_hourly_rate_enabled();
            $this->is_shuttles_enabled = booking_helper::is_shuttles_enabled();
            $this->has_any_address = booking_helper::has_any_address();

            //Get the lists
            $lists = $this->_buildEditLists();

            $this->assign('action', $uri->toString());

            // get country 2 code for google autocomplete
            $country_2_code = booking_helper::get_country_field($elsettings->default_country, 'country_2_code');
            $country_2_code = ($country_2_code == '') ? 'US' : $country_2_code;
            $this->assignRef('default_country', $country_2_code);

            // get default tab
            $booking_type = $session->get('booking_type','address');
            $route_from = $session->get('route_from',0);
            $route_to = $session->get('route_to',0);
            $airports1 = $session->get('airports1','');
            $zipcode1 = $session->get('zipcode1','');
            $airports2 = $session->get('airports2','');
            $zipcode2 = $session->get('zipcode2','');

            $this->load_default_map = false;

            // detect default tab
            $available_booking_types = array();

            if((int)$elsettings->show_address_tab==1){
                $available_booking_types[] = 'address';
            }
            if((int)$elsettings->show_offers_tab==1 && $lists['has_any_route']){
                $available_booking_types[] = 'offers';
            }
            if((int)$elsettings->show_hourly_tab==1 && $this->is_hourly_rate_enabled){
                $available_booking_types[] = 'hourly';
            }
            if((int)$elsettings->show_shuttles_tab==1 && $this->is_shuttles_enabled){
                $available_booking_types[] = 'shuttle';
            }

            $this->total_available_booking_types = count($available_booking_types);
            $this->default_tab_index = 0;
            $this->default_tab_title = 'address';

            if(!empty($available_booking_types)){
                foreach($available_booking_types as $k => $v){
                    if($session->get('booking_type','')!=""){
                        if($v==$booking_type){
                            $this->default_tab_index = $k;
                            $this->default_tab_title = $v;
                            break;
                        }
                    }
                    else {
                        if($v==$elsettings->default_tab){
                            $this->default_tab_index = $k;
                            $this->default_tab_title = $v;
                            break;
                        }
                    }
                }
            }

            // if user uploaded new photo, My Orders tab will be active
            $new_photo_uploaded = $session->get('new_photo_uploaded', 0);
            if($new_photo_uploaded==1){
                $this->default_tab_index = count($available_booking_types);
                $session->clear('new_photo_uploaded');
            }

            // prepare showing map in different booking types
            $this->booking_maps = booking_helper::getBookingMapsState($elsettings);

            $this->assignRef('elsettings', $elsettings);
            $this->assignRef('from_dest', $from_dest);
            $this->assignRef('airports1', $airports1);
            $this->assignRef('to_dest', $to_dest);
            $this->assignRef('airports2', $airports2);
            $this->assignRef('returnjurney', $returnjurney);
            $this->assignRef('vehicle', $vehicle);
            $this->assignRef('from_error', $from_error);
            $this->assignRef('to_error', $to_error);
            $this->assignRef('zip_error', $zip_error);
            $this->assignRef('passenger_error', $passenger_error);
            $this->assignRef('lists', $lists);
            $this->assignRef('lang_tag', $lang_tag);

            parent::display($tpl);
        }
        else {
            $app->enqueueMessage(JText::_('EUPRIVACY_ACCEPT_COOKIE_WARNING'), 'warning');
            return;
        }
    }

    /**
     * Creates the item submit form
     *
     * @since 1.0
     */
    function _buildEditLists()
    {
        $session = JFactory::getSession();
        $elsettings = booking_helper::config();

        $db = JFactory::getDBO();
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();

        $booking_type = $session->get('booking_type','');
        $airports1 = $session->get('airports1', '');
        $seaports1 = $session->get('seaports1', '');

        $airports2 = $session->get('airports2', '');
        $seaports2 = $session->get('seaports2', '');

        $hourly_hr = $session->get('hourly_hr', 0);
        $hourly_min = $session->get('hourly_min', 0);

        // if booking type is present in URL
        $url_booking_type = JRequest::getVar('booking_type', "");
        if($url_booking_type!=""){
            $passengers = JRequest::getInt('passenger', 0);
            $suitcases = JRequest::getInt('suitcases', 0);
            $infantseats = JRequest::getInt('infantseats', 0);
            $chseats = JRequest::getInt('childseats', 0);
            $boosterseats = JRequest::getInt('boosterseats', 0);
        }
        else {
            $passengers = ($session->get('passengers', 0)>0) ? $session->get('passengers', 0) : $elsettings->default_adult_seat;
            $infantseats = $session->get('infantseats', 0);
            $chseats = $session->get('chseats', 0);
            $boosterseats = $session->get('boosterseats', 0);
            $suitcases = $session->get('suitcases', 0);
        }

        //build selectlist
        $lists = array();

        if((int)$elsettings->show_address_tab==1)
        {
            $pickup_poi = array();
            $pickup_poi[] = JHTML::_('select.option', '', JText::_('SELECT PLACE'));

            $dropoff_poi = array();
            $dropoff_poi[] = JHTML::_('select.option', '', JText::_('SELECT PLACE'));

            // get all the points of interest
            $query = 'SELECT poi.id, poi.title, poi.lat, poi.long, poi.show_on_pickup, poi.show_on_dropoff, poi_cat.image, poi_cat.title AS cattitle'
                    . ' FROM #__taxibooking_points AS poi'
                    . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                    . ' WHERE poi.published = 1'
                    . ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
                    . ' ORDER BY poi.title ASC'
            ;
            $db->setQuery($query);
            $db->query();
            $places = $db->loadObjectList();

            $lists['all_places_data'] = $places;

            $pickup_poi_options_html = '';
            $dropoff_poi_options_html = '';
            $all_poi_options_html = '';

            $pickup_poi_json_arr = array();
            $dropoff_poi_json_arr = array();

            if (!empty($places))
            {
                foreach ($places as $place)
                {
                    // enlist pickup poi
                    if((int)$place->show_on_pickup==1)
                    {
                        $pickup_poi_options_html .= '<div class="poi_link" data-poiid="'.$place->id.'" data-poilat="'.$place->lat.'" data-poilng="'.$place->long.'">';
                        $pickup_poi_options_html .= ($place->image!="") ? '<img src="'.JURI::base().$place->image.'" alt="'.$place->cattitle.'" title="'.$place->cattitle.'" class="poicat_icon" />&nbsp;' : '';
                        $pickup_poi_options_html .= '<span>'.$place->title.'</span></div>'."\n";

                        $pickup_poi[] = JHTML::_('select.option', $place->id, $place->title);

                        $pickup_poi_json_arr[] = array('label' => $place->title,
                                                    'value' => $place->title,
                                                    'id' => $place->id,
                                                   );
                    }
                    // enlist dropoff poi
                    if((int)$place->show_on_dropoff==1)
                    {
                        $dropoff_poi_options_html .= '<div class="poi_link" data-poiid="'.$place->id.'" data-poilat="'.$place->lat.'" data-poilng="'.$place->long.'">';
                        $dropoff_poi_options_html .= ($place->image!="") ? '<img src="'.JURI::base().$place->image.'" alt="'.$place->cattitle.'" title="'.$place->cattitle.'" class="poicat_icon" />&nbsp;' : '';
                        $dropoff_poi_options_html .= '<span>'.$place->title.'</span></div>'."\n";

                        $dropoff_poi[] = JHTML::_('select.option', $place->id, $place->title);

                        $dropoff_poi_json_arr[] = array('label' => $place->title,
                                                    'value' => $place->title,
                                                    'id' => $place->id,
                                                   );
                    }
                }
            }

            $lists['pickup_poi_options_html'] = $pickup_poi_options_html;
            $lists['dropoff_poi_options_html'] = $dropoff_poi_options_html;

            $lists['pickup_poi_json_data'] = json_encode($pickup_poi_json_arr);
            $lists['dropoff_poi_json_data'] = json_encode($dropoff_poi_json_arr);
        }

        // collect route cateory list
        if( (int)$elsettings->show_offers_tab==1)
        {
            $sel_route_category = $session->get('route_category', 0);
            $sel_route_category_dropoff = $session->get('route_category_dropoff', 0);

            $route_category_arr = array();
            $route_category_dropoff_arr = array();

            if($elsettings->show_poi_categories==1)
            {
                $query = 'SELECT DISTINCT poi.title, poi.id, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image, poi_cat.language AS cat_language'
                        . ' FROM #__taxibooking_points AS poi'
                        . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                        . ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_from'
                        . ' WHERE r.published = 1'
                        . ' AND poi.published = 1'
                        . ' AND poi.show_on_offers_pickup = 1'
                        . ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
                        . ' ORDER BY poi_cat.title ASC'
                ;
                $db->setQuery($query);
                $db->query();
                $rows = $db->loadObjectList();

                if (!empty($rows))
                {
                    foreach ($rows as $row)
                    {
                        if($row->cat_language=="*" || $row->cat_language==$lang_tag)
                        {
                            $route_category_arr[$row->catid] = array('cattitle' => $row->cattitle,
                                                                'catimage' => $row->cat_image);
                        }
                    }
                }

                // dropoff route category
                $sel_route_from = $session->get('route_from', 0);
                $query = 'SELECT DISTINCT poi.title, poi.id, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image, poi_cat.language AS cat_language'
                        . ' FROM #__taxibooking_points AS poi'
                        . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                        . ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
                        . ' WHERE r.published = 1'
                        . ' AND poi.published = 1'
                        . ' AND poi.show_on_offers_dropoff = 1'
                        . ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
                        . ' AND r.route_from = '.$db->Quote($sel_route_from)
                        . ' ORDER BY poi_cat.title ASC'
                ;
                $db->setQuery($query);
                $db->query();
                $rows = $db->loadObjectList();

                if (!empty($rows))
                {
                    foreach ($rows as $row)
                    {
                        if($row->cat_language=="*" || $row->cat_language==$lang_tag)
                        {
                            $route_category_dropoff_arr[$row->catid] = array('cattitle' => $row->cattitle,
                                                                'catimage' => $row->cat_image);
                        }
                    }
                }
            }

            $route_categories_html = '';
            $route_categories_data = array();
            if(!empty($route_category_arr))
            {
                $i = 0;
                foreach($route_category_arr as $catid => $catobj)
                {
                    $route_categories_html .= '<div class="poi_link" id="'.$catid.'">';
                    $route_categories_html .= ($catobj['catimage']!="") ? '<img src="'.JURI::base().$catobj['catimage'].'" alt="'.$catobj['cattitle'].'" title="'.$catobj['cattitle'].'" class="poicat_icon" />&nbsp;' : '';
                    $route_categories_html .= '<span>'.$catobj['cattitle'].'</span></div>'."\n";

                    $route_categories_data[$i]['label'] = $catobj['cattitle'];
                    $route_categories_data[$i]['value'] = $catobj['cattitle'];
                    $route_categories_data[$i]['id'] = $catid;

                    $i++;
                }
            }
            $lists['route_categories_html'] = $route_categories_html;
            $lists['route_categories_data'] = json_encode($route_categories_data);

            $route_categories_dropoff_html = '';
            $route_categories_dropoff_data = array();
            if(!empty($route_category_dropoff_arr))
            {
                $i = 0;
                foreach($route_category_dropoff_arr as $catid => $catobj)
                {
                    $route_categories_dropoff_html .= '<div class="poi_link" id="'.$catid.'">';
                    $route_categories_dropoff_html .= ($catobj['catimage']!="") ? '<img src="'.JURI::base().$catobj['catimage'].'" alt="'.$catobj['cattitle'].'" title="'.$catobj['cattitle'].'" class="poicat_icon" />&nbsp;' : '';
                    $route_categories_dropoff_html .= '<span>'.$catobj['cattitle'].'</span></div>'."\n";

                    $route_categories_dropoff_data[$i]['label'] = $catobj['cattitle'];
                    $route_categories_dropoff_data[$i]['value'] = $catobj['cattitle'];
                    $route_categories_dropoff_data[$i]['id'] = $catid;

                    $i++;
                }
            }
            $lists['route_categories_dropoff_html'] = $route_categories_dropoff_html;
            $lists['route_categories_dropoff_data'] = json_encode($route_categories_dropoff_data);

            // get the fixed routes from option
            $query = 'SELECT DISTINCT poi.title, poi.id, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image'
                    . ' FROM #__taxibooking_points AS poi'
                    . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                    . ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_from'
                    . ' WHERE r.published = 1 AND poi.published = 1 AND poi.show_on_offers_pickup = 1';

            if($sel_route_category>0) {
                $query .= ' AND poi_cat.id = '.$db->Quote($sel_route_category);
            }
            $query .= ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
                    . ' ORDER BY poi.title ASC'
            ;
            $db->setQuery($query);
            $db->query();
            $rows = $db->loadObjectList();

            $lists['has_any_route'] = false;
            $pickup_route_options_html = '';
            $pickup_route_poi_data = array();

            if (!empty($rows))
            {
                $lists['has_any_route'] = true;
                $i = 0;
                foreach ($rows as $row)
                {
                    $pickup_route_options_html .= '<div class="poi_link" id="'.$row->id.'">';
                    $pickup_route_options_html .= ($row->cat_image!="") ? '<img src="'.JURI::base().$row->cat_image.'" alt="'.$row->cattitle.'" title="'.$row->cattitle.'" class="poicat_icon" />&nbsp;' : '';
                    $pickup_route_options_html .= '<span>'.$row->title.'</span></div>'."\n";

                    $pickup_route_poi_data[$i]['label'] = $row->title;
                    $pickup_route_poi_data[$i]['value'] = $row->title;
                    $pickup_route_poi_data[$i]['id'] = $row->id;

                    $i++;
                }
            }

            $sel_route_from = $session->get('route_from', 0);
            $sel_route_to = $session->get('route_to', 0);

            $dropoff_route_options_html = '';
            $dropoff_route_poi_data = array();

            // if route is swapped, pickup routes will be dropoff routes
            $route_swapped = $session->get('route_swapped', 0);
            if($route_swapped==0)
            {
                if($sel_route_from > 0)
                {
                    $query = 'SELECT DISTINCT poi.id, poi.title, poi_cat.image AS cat_image, poi_cat.title AS cattitle'
                            . ' FROM #__taxibooking_points AS poi'
                            . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
                            . ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
                            . ' WHERE r.published = 1 AND poi.published = 1 AND poi.show_on_offers_dropoff = 1'
                            . ' AND r.route_from = '.$db->Quote($sel_route_from)
                            . ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")';

                    if($sel_route_category_dropoff>0) {
                        $query .= ' AND poi_cat.id = '.$db->Quote($sel_route_category_dropoff);
                    }
                    $query .= ' ORDER BY poi.title ASC';
                    $db->setQuery($query);
                    $db->query();
                    $rows = $db->loadObjectList();

                    if (!empty($rows)) {
                        $i = 0;
                        foreach ($rows as $row)
                        {
                            $dropoff_route_options_html .= '<div class="poi_link" id="'.$row->id.'">';
                            $dropoff_route_options_html .= ($row->cat_image!="") ? '<img src="'.JURI::base().$row->cat_image.'" alt="'.$row->cattitle.'" title="'.$row->cattitle.'" class="poicat_icon" />&nbsp;' : '';
                            $dropoff_route_options_html .= '<span>'.$row->title.'</span></div>'."\n";

                            $dropoff_route_poi_data[$i]['label'] = $row->title;
                            $dropoff_route_poi_data[$i]['value'] = $row->title;
                            $dropoff_route_poi_data[$i]['id'] = $row->id;

                            $i++;
                        }
                    }
                }

                $lists['pickup_route_options_html'] = $pickup_route_options_html;
                $lists['dropoff_route_options_html'] = $dropoff_route_options_html;
                $lists['pickup_route_poi_data'] = json_encode($pickup_route_poi_data);
                $lists['dropoff_route_poi_data'] = json_encode($dropoff_route_poi_data);
            }
        }

        // get the maximum passengers
        $query = 'SELECT MAX(passenger_no) AS max_passenger, MAX(suitcase_no) AS max_suitcase, '
                . ' MAX(booster_seat_no) AS max_booster, MAX(child_seat_no) AS max_child, MAX(infant_seat_no) AS max_infant'
                . ' FROM #__taxibooking_cars'
        ;
        $db->setQuery($query);
        $db->query();
        $max = $db->loadObject();
        $max_passenger = isset($max->max_passenger) ? $max->max_passenger : 8;
        $max_suitcase = isset($max->max_suitcase) ? $max->max_suitcase : 9;
        $max_booster = isset($max->max_booster) ? $max->max_booster : 5;
        $max_child = isset($max->max_child) ? $max->max_child : 5;
        $max_infant = isset($max->max_infant) ? $max->max_infant : 5;

        $passenger_options = array('0' => JText::_('SELECT_OPTION'));
        for ($i = 1; $i <= $max_passenger; $i++) {
            $passenger_options[] = JHTML::_('select.option', $i, $i);
        }

        $suitcases_options = array('0' => JText::_('SELECT_OPTION'));
        for ($i = 1; $i <= $max_suitcase; $i++) {
            $suitcases_options[] = JHTML::_('select.option', $i, $i);
        }

        $lists['passengers'] = JHTML::_('select.genericlist', $passenger_options, 'passengers', 'class="seat_options required" tabindex="1"', 'value', 'text', $passengers);
        $lists['suitcases'] = JHTML::_('select.genericlist', $suitcases_options, 'suitcases', 'class="seat_options" tabindex="1"', 'value', 'text', $suitcases);

        $infantseats_options = array('0' => JText::_('SELECT_OPTION'));
        for ($i = 1; $i <= $max_infant; $i++) {
            $infantseats_options[] = JHTML::_('select.option', $i, $i);
        }

        $chseats_options = array('0' => JText::_('SELECT_OPTION'));
        for ($i = 1; $i <= $max_child; $i++) {
            $chseats_options[] = JHTML::_('select.option', $i, $i);
        }

        $chseats_options2 = array('0' => JText::_('SELECT_OPTION'));
        for ($i = 1; $i <= 2; $i++) {
            $chseats_options2[] = JHTML::_('select.option', $i, $i);
        }

        $chseats_options3 = array('0' => JText::_('SELECT_OPTION'));
        for ($i = 1; $i <= 1; $i++) {
            $chseats_options3[] = JHTML::_('select.option', $i, $i);
        }

        $boosterseats_options = array('0' => JText::_('SELECT_OPTION'));
        for ($i = 1; $i <= $max_booster; $i++) {
            $boosterseats_options[] = JHTML::_('select.option', $i, $i);
        }
        $boosterseats_options2 = array('0' => JText::_('SELECT_OPTION'));
        for ($i = 1; $i <= 1; $i++) {
            $boosterseats_options2[] = JHTML::_('select.option', $i, $i);
        }

        $lists['has_infant_seats'] = ($max_infant > 0) ? true : false;
        $lists['has_chseats'] = ($max_child > 0) ? true : false;
        $lists['has_booster_seats'] = ($max_booster > 0) ? true : false;

        $lists['infantseats'] = JHTML::_('select.genericlist', $infantseats_options, 'infantseats', 'class="seat_options" tabindex="1"', 'value', 'text', $infantseats);
        $lists['chseats'] = JHTML::_('select.genericlist', $chseats_options, 'chseats', 'class="seat_options" tabindex="1"', 'value', 'text', $chseats);
        $lists['chseats2'] = JHTML::_('select.genericlist', $chseats_options2, 'chseats2', 'class="seat_options" tabindex="1"', 'value', 'text', $chseats2);
        $lists['chseats3'] = JHTML::_('select.genericlist', $chseats_options3, 'chseats3', 'class="seat_options" tabindex="1"', 'value', 'text', $chseats3);
        $lists['boosterseats'] = JHTML::_('select.genericlist', $boosterseats_options, 'boosterseats', 'class="seat_options" tabindex="1"', 'value', 'text', $boosterseats);
        $lists['boosterseats2'] = JHTML::_('select.genericlist', $boosterseats_options2, 'boosterseats2', 'class="seat_options" tabindex="1"', 'value', 'text', $boosterseats2);

        if( (int)$elsettings->show_hourly_tab==1 && $this->is_hourly_rate_enabled)
        {
            $query = 'SELECT MIN(hourly_hire_min_hr) AS min_hourly_hr, MAX(hourly_hire_max_hr) AS max_hourly_hr'
                    . ' FROM #__taxibooking_cars'
                    . ' WHERE hourly_hire_enabled = 1'
            ;
            $db->setQuery($query);
            $db->query();
            $max = $db->loadObject();
            $min_hourly_hr = isset($max->min_hourly_hr) ? $max->min_hourly_hr : 1;
            $max_hourly_hr = isset($max->max_hourly_hr) ? $max->max_hourly_hr : 10;

            $options = array('0' => JText::_('HRS'));
            for ($i = $min_hourly_hr; $i <= $max_hourly_hr; $i++) {
                $options[] = JHTML::_('select.option', $i, $i);
            }
            $lists['hourly_hr_list'] = JHTML::_('select.genericlist', $options, 'hourly_hr', 'class="" tabindex="1"', 'value', 'text', $hourly_hr);

            $options = array();
            $options[] = JHTML::_('select.option', 0, '00');
            $options[] = JHTML::_('select.option', 15, 15);
            $options[] = JHTML::_('select.option', 30, 30);
            $options[] = JHTML::_('select.option', 45, 45);
            $lists['hourly_min_list'] = JHTML::_('select.genericlist', $options, 'hourly_min', 'class="seat_options" tabindex="1"', 'value', 'text', $hourly_min);
        }

        // get shuttle start points
        if( (int)$elsettings->show_shuttles_tab==1 && $this->is_shuttles_enabled)
        {
            $query = 'SELECT DISTINCT p.title AS poi_title, p.id AS poiid, p.lat AS poilat, p.long AS poilng, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image'
                    . ' FROM #__taxibooking_shuttle_route_stops AS rs'
                    . ' LEFT JOIN #__taxibooking_shuttle_routes AS r ON r.id = rs.route_id'
                    . ' LEFT JOIN #__taxibooking_points AS p ON p.id = rs.poi_id'
                    . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = p.catid'
                    . ' WHERE rs.is_end = 0'
                    . ' AND r.published = 1';
            $query .= ' AND (r.language = "*" OR r.language = "'.$lang_tag.'")'
                    . ' ORDER BY p.title ASC'
            ;
            $db->setQuery($query);
            $db->query();
            $rows = $db->loadObjectList();

            $shuttle_pickup_options_html = '';

            if (!empty($rows))
            {
                $i = 0;
                foreach ($rows as $row)
                {
                    $shuttle_pickup_options_html .= '<div class="poi_link" data-poiid="'.$row->poiid.'" data-poilat="'.$row->poilat.'" data-poilng="'.$row->poilng.'">';
                    $shuttle_pickup_options_html .= ($row->cat_image!="") ? '<img src="'.JURI::base().$row->cat_image.'" alt="'.$row->cattitle.'" title="'.$row->cattitle.'" class="poicat_icon" />&nbsp;' : '';
                    $shuttle_pickup_options_html .= '<span>'.$row->poi_title.'</span></div>'."\n";

                    $i++;
                }

                $lists['shuttle_pickup_options_html'] = $shuttle_pickup_options_html;
            }
        }

        return $lists;
    }

    public function clear_session()
    {
        $session = JFactory::getSession();
        $session->clear('from_dest');
        $session->clear('to_dest');
        $session->clear('booking_type');

        $session->clear('address_from');
        $session->clear('address_from_lat');
        $session->clear('address_from_lng');
        $session->clear('address_to');
        $session->clear('address_to_lat');
        $session->clear('address_to_lng');

        $session->clear('route_category_fld');
        $session->clear('route_category');
        $session->clear('route_category_dropoff_fld');
        $session->clear('route_category_dropoff');
        $session->clear('route_from');
        $session->clear('route_to');
        $session->clear('route_from_fld');
        $session->clear('route_to_fld');
        $session->clear('route_swapped');

        $session->clear('hourly_hr');
        $session->clear('hourly_min');

        $session->clear('shuttle_pickup');
            $session->clear('shuttle_pickup_poi');
            $session->clear('shuttle_dropoff');
            $session->clear('shuttle_dropoff_poi');
            $session->clear('shuttletime');
            $session->clear('shuttle_route_id');
            $session->clear('shuttle_passengers');

        $session->clear('date1');
        $session->clear('time1');
        $session->clear('date2');
        $session->clear('time2');
        $session->clear('timestr1');
        $session->clear('timestr2');
        $session->clear('distance');
        $session->clear('duration');
        $session->clear('duration_seconds');
        $session->clear('message');

        $session->clear('begin');
        $session->clear('end');
        $session->clear('temp1');
        $session->clear('temp2');
        $session->clear('lat_long_from');
        $session->clear('lat_long_to');

        $session->clear('waypoints');
        $session->clear('waypoints_lat');
        $session->clear('waypoints_lng');
        $session->clear('waypoints_stop_duration');

        $session->clear('title');
        $session->clear('name');
        $session->clear('surname');
        $session->clear('email');
        $session->clear('phone');
        $session->clear('receive_sms');
        $session->clear('returnjurney');
        $session->clear('return_wait_hr');
            $session->clear('return_wait_discount');
        $session->clear('price');
        $session->clear('prepay');
        $session->clear('flat_cost');
        $session->clear('percentage_cost');
        $session->clear('selected_extras');
        $session->clear('total_extra_price');
        $session->clear('poi_additional_charges');

        $session->clear('passengers');
        $session->clear('infantseats');
        $session->clear('chseats');
        $session->clear('boosterseats');
        $session->clear('suitcases');
        $session->clear('selpassengers');
        $session->clear('selsuitcases');
        $session->clear('selinfantseats');
        $session->clear('selchildseats');
        $session->clear('selboosterseats');
        $session->clear('selluggage');
        $session->clear('selcarry');
        $session->clear('vehicle_id');
        $session->clear('vehicletype');
        $session->clear('tb_paymentmethod_id');

        $session->clear('PickupAddr1');
        $session->clear('PickupAddr4');
    }
}
