<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_taxibooking
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );

class TaxiBookingViewThanks extends JViewLegacy
{
    /**
     * Creates View
     *
     */
    function display($tpl = null)
    {
	//initialize variables
        $app = JFactory::getApplication();
        $document =  JFactory::getDocument();
        $menus = $app->getMenu();
        $lang =  JFactory::getLanguage();
        $lang_tag = $lang->getTag();
        $menu = $menus->getActive();
        $uri =  JFactory::getURI();
        $session =  JFactory::getSession();
	
	$last_order_id = $session->get('tb_last_order_id', 0);
	// if last order ID is not set, redirect user to booking screen
	if($last_order_id==0){
	    $redirect_url = TaxibookingHelperRoute::getBookingFormRoute($lang_tag);
	    if($session->get('tmpl','')=='component'){
		$redirect_url .= '&tmpl=component';
	    }
	    
	    $app->redirect(JRoute::_($redirect_url, false));
	}

        // Get the page/component configuration
        $params = $app->getParams();

        // right from the menu item itself
        if (is_object($menu)) {
            $menu_params = new JRegistry;
            $menu_params->loadString($menu->params);
            
            if (!$menu_params->get('page_title')) {
                $params->set('page_title', JText::_('TAXIBOOKING'));
            }
        }
        else {
            $params->set('page_title', JText::_('TAXIBOOKING'));
        }
        
        /*
         * Handle the metadata title
         */
        $document->setMetadata('keywords', $params->get('page_title'));
        if ($app->getCfg('MetaTitle') == '1') {
            $document->setTitle($params->get('page_title'));
        }
	
	$order = booking_helper::get_order_by_id($last_order_id);
	
	// There may be payment error message generated from payment gateway response
	// just show those message as warning
	$payment_error_message = $session->get('payment_error_message', '');
	if($payment_error_message!=""){
	    
	    // add Order details URL to payment error message
	    $order_url = TaxibookingHelperRoute::getBookingFormRoute($lang_tag).'&booking_type=orders&oid='.$order->order_number;
	    $payment_error_message .= '<br>'.JText::sprintf('MYORDERS_ORDER_DETAILS_PAY_NOW_BTN_LABEL', JRoute::_($order_url, false));
	    
	    $app->enqueueMessage($payment_error_message, 'error');
	    $session->clear('payment_error_message');
	}
	
	// if order total is zero, no need to process payment gateway
	if($order->cprice > 0){
	    JPluginHelper::importPlugin('tbpayment');
	    $dispatcher = JDispatcher::getInstance();
	    $returnValues = $dispatcher->trigger('plgTbProcessPayment', array($order));
	    
	    $html = JRequest::getVar('html', JText::_('COM_TAXIBOOKING_ORDER_PROCESSED'), 'default', 'STRING', JREQUEST_ALLOWRAW);
	}
	else {
	    $redirect_url = TaxibookingHelperRoute::getBookingFormRoute($lang_tag);
	    if($session->get('tmpl','')=='component'){
		$redirect_url .= '&tmpl=component';
	    }
	    
	    $html = JText::_('RECEIVE_CONFIRMATION_MAIL');
	    $html .= '<br><br>'.JText::_('THANKS_MESSAGE');
	    $html .= '&nbsp;<a href="'.JRoute::_($redirect_url, false).'">';
	    $html .=  JText::_('CONTINUE_BOOKING');
	    $html .=  '</a>';
	}
	
	$session->clear('tb_last_order_id');
        
	$this->assignRef('html', $html);
        $this->assignRef('params', $params);

        parent::display($tpl);
    }
}