jQuery(document).ready(function ($) {
    if ($('#acym__plugin__available__application').length > 0) {

        const remove = (array, pluginId) => array.filter((plugin) => plugin.id !== pluginId);

        const appVue = new Vue({
            directives: {infiniteScroll},
            el: '#acym__plugin__available__application',
            data: {
                allPlugins: [],
                displayedPlugins: [1],
                search: '',
                type: '',
                level: '',
                loading: true,
                typesColors: {
                    'Files management': 'background-color: #C5EAFF;',
                    'E-commerce solutions': 'background-color: #E7CEFF;',
                    'Content management': 'background-color: #FFC1E9;',
                    'Subscription system': 'background-color: #FFC7C7;',
                    'Others': 'background-color: #FFF1BC;',
                    'User management': 'background-color: #CAFFBA;',
                    'Events management': 'background-color: #C2FFF9;',
                },
                noPluginTodisplay: false,
                typingTimer: '',
                doneTypingInterval: 1000,
                currentLevel: '',
                downloading: {},
                allPluginsInstalled: {},
                pageDisplay: 1,
                busy: false,

            },
            mounted: function () {
                this.getAllPlugins().then((res) => {
                    res = $.acym_parseJson(res);
                    if (undefined !== res.error) {
                        $.acym_add_notification(res.error, 'error');

                        return false;
                    }
                    $.acym_config_get('level').then((resConfig) => {
                        resConfig = $.acym_parseJson(resConfig);
                        if (undefined !== resConfig.error) {
                            $.acym_add_notification(resConfig.error, 'error');

                            return false;
                        }
                        this.getAllPluginsInstalled().then((resPluginsSite) => {
                            resPluginsSite = $.acym_parseJson(resPluginsSite);
                            this.allPluginsInstalled = resPluginsSite.elements;
                            this.currentLevel = resConfig.data.toLowerCase();
                            this.allPlugins = this.handlePluginsInstalled(res);
                            res = res.map((plugin) => {
                                plugin.description = plugin.description.replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1<br />');
                            });
                            this.setDownloading();
                            this.resetDisplay();
                            $('[name="acym__plugins__level"], [name="acym__plugins__type"]').select2({
                                theme: 'foundation',
                                width: '100%',
                            });
                            if (this.displayedPlugins.length === 0) {
                                this.noPluginTodisplay = true;
                            }
                            this.loading = false;
                            setTimeout(() => {
                                this.$forceUpdate();
                                $.setTooltip();
                            }, 400);
                        });
                    });
                });
            },
            methods: {
                getAllPlugins() {
                    let ajaxUrl = AJAX_URL_UPDATEME + 'integrationv6&task=getAllPlugin&cms=' + CMS_ACYM;
                    return $.post(ajaxUrl);
                },
                getAllPluginsInstalled() {
                    let ajaxUrl = AJAX_URL_ACYM + '&ctrl=plugins&task=getAllPluginsAjax';
                    return $.post(ajaxUrl);
                },
                download(plugin) {
                    if (this.downloading[plugin.id]) return true;
                    this.downloading[plugin.id] = true;
                    this.downloading = {...this.downloading};
                    let ajaxUrl = AJAX_URL_ACYM + '&ctrl=plugins&task=download';
                    $.ajax({
                        url: ajaxUrl,
                        type: 'POST',
                        data: {'plugin': plugin},
                    }).then((res) => {
                        res = $.acym_parseJson(res);
                        if (undefined !== res.error) {
                            $.acym_add_notification(res.error, 'error');
                            this.downloading[plugin.id] = false;
                            this.downloading = {...this.downloading};
                            return false;
                        }
                        this.removeOnePluginToDownload(plugin.id);
                        $.acym_add_notification(res.message, 'info');
                        this.downloading[plugin.id] = false;
                    });
                },
                removeOnePluginToDownload(id) {
                    this.allPlugins = remove(this.allPlugins, id);
                    this.displayedPlugins = remove(this.displayedPlugins, id);
                },
                resetDisplay() {
                    this.pageDisplay = 1;
                    this.fillDisplayPlugins();
                },
                fillDisplayPlugins() {
                    this.displayedPlugins = this.filter().slice(0, 18 * this.pageDisplay);
                    this.displayedPlugins = [...this.displayedPlugins];
                },
                rightLevel(pluginLevel) {
                    if (pluginLevel === 'starter') return true;
                    if (pluginLevel === 'essential' && [
                        'essential',
                        'enterprise',
                    ].indexOf(this.currentLevel) !== -1) {
                        return true;
                    }
                    if (pluginLevel === 'enterprise' && this.currentLevel === 'enterprise') return true;
                    return false;
                },
                ucfirst(edition) {
                    if (undefined === edition) return '';
                    return edition.charAt(0).toUpperCase() + edition.slice(1);
                },
                setDownloading() {
                    for (let plugin in this.allPlugins) {
                        this.downloading[this.allPlugins[plugin].id] = false;
                    }
                },
                filter() {
                    return this.allPlugins.filter((plugin) => (plugin.level.toLowerCase().indexOf(this.level.toLowerCase()) !== -1) && (plugin.category.toLowerCase().indexOf(this.type.toLowerCase()) !== -1) && (plugin.name.toLowerCase().indexOf(this.search.toLowerCase()) !== -1));
                },
                handlePluginsInstalled(pluginsFromServer) {
                    if (undefined === this.allPluginsInstalled) {
                        return pluginsFromServer;
                    } else {
                        return pluginsFromServer.filter((plugin) => this.allPluginsInstalled.map((pluginsInstalled) => plugin.file_name.replace('.zip', '') === pluginsInstalled.folder_name).indexOf(true) === -1);
                    }
                },
                loadMorePlugins() {
                    this.pageDisplay++;
                    this.fillDisplayPlugins();
                },
                imageUrl(pluginName) {
                    if (undefined !== pluginName) {
                        pluginName = pluginName.substring(0, pluginName.indexOf('.'));
                    }
                    return AJAX_URL_UPDATEME + 'integrationv6&task=getImage&plugin=' + pluginName;
                },
                documentationUrl(pluginName) {
                    if (undefined === pluginName) return '';
                    pluginName = pluginName.replace('.zip', '');
                    return AJAX_URL_UPDATEME + 'integrationv6&task=getDocumentation&plugin=' + pluginName;
                },
                isOverflown(index) {
                    if (this.$refs.plugins === undefined || this.$refs.plugins[index] === undefined) return '';
                    return this.$refs.plugins[index].scrollHeight > this.$refs.plugins[index].clientHeight ? 'acym__plugins__card__params_desc__overflown' : '';
                },
            },
            watch: {
                displayedPlugins(newVal, oldVal) {
                    this.noPluginTodisplay = this.displayedPlugins.length === 0 && oldVal[0] !== 1;
                },
                search(newValue) {
                    clearTimeout(this.typingTimer);
                    if ('' === newValue) {
                        this.resetDisplay();
                    } else {
                        this.typingTimer = setTimeout(() => {
                            this.resetDisplay();
                        }, this.doneTypingInterval);
                    }
                },
                type() {
                    this.resetDisplay();
                },
                level() {
                    this.resetDisplay();
                },
            },
        });
    }
});

jQuery(document).ready(function ($) {

    if ($('#acym__wysid__edit__button').length > 0) {

        Vue.component('vue-prism-editor', VuePrismEditor);
        new Vue({
            el: '#acym__wysid__editor__source',
            data() {
                return {
                    code: '',
                    codeBase: '',
                    language: 'html',
                    optionIndent: {
                        indent_size: 2, // space_in_empty_paren: true,
                        wrap_line_length: '120',
                    },
                    typingTimer: '',
                    doneTypingInterval: 1000,
                };
            },
            mounted() {
                let contentBlock = document.getElementById('acym__wysid__block__html__content');
                contentBlock.addEventListener('editor_change', () => {
                    //in case the cdn is not working
                    this.changeCodeValue(undefined === html_beautify ? contentBlock.value : html_beautify(contentBlock.value, this.optionIndent));
                });
            },
            methods: {
                changeCodeValue(newValue) {
                    this.code = newValue;
                    this.codeBase = newValue;
                },
                revert() {
                    this.applyModification(this.codeBase);
                    $('#acym__wysid__editor__source, #acym__wysid__right-toolbar__overlay').removeClass('acym__wysid__visible');
                },
                keep() {
                    $('#acym__wysid__editor__source, #acym__wysid__right-toolbar__overlay').removeClass('acym__wysid__visible');
                },
                applyModification(newCodeValue) {
                    let $focusedSelector = $('.acym__wysid__row__selector--focus');
                    $focusedSelector.closest('.acym__wysid__row__element').find('> tbody').html(newCodeValue);
                    $focusedSelector.css('height', $focusedSelector.closest('.acym__wysid__row__element').css('height'));
                },
            },
            watch: {
                code(value) {
                    clearTimeout(this.typingTimer);
                    this.typingTimer = setTimeout(() => {
                        this.applyModification(value);
                    }, this.doneTypingInterval);
                },
            },
        });
    }

});
jQuery(document).ready(function ($) {
    Vue.use(infiniteScroll);
    let entityPerCalls = 500;
    let entityNumber = 0;
    let allEntities = [];
    let allEntitiesSelected = [];
    let numberOfEntities = 0;
    let numberOfCalls = 0;
    let strokeProgression = 0;

    let perScroll = 20, start = {
        'available': perScroll,
        'selected': perScroll,
    };

    //get all entities in a which aren't in b
    const diff = (a, b) => a.filter((i) => JSON.stringify(b).indexOf(JSON.stringify(i)) === -1);

    //search in array
    const search = (array, search, columns) => array.filter((entity) => columns.map((column) => entity[column].toLowerCase().indexOf(search.toLowerCase()) !== -1).indexOf(true) !== -1);

    //remove from array
    const remove = (array, entityId) => array.filter((entity) => entity.id !== entityId);

    //get one element from array
    const getOne = (array, entityId) => array.filter((entity) => entity.id === entityId);

    //get entities ids
    const getIds = (array) => array.map((entity) => parseInt(entity.id));

    //get only selected
    const getSelected = (array, columnsNotNull) => array.filter((entity) => entity[columnsNotNull] !== null);

    function addTotalRecipients(selectedLists) {
        let ajaxUrl = AJAX_URL_ACYM + '&page=acymailing_campaigns&ctrl=campaigns&task=countNumberOfRecipients';

        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: {
                listsSelected: selectedLists,
            },
            beforeSend: function () {
                $('.acym__campaign__recipients__number-recipients').hide();
                $('.acym_loader_logo').show();
            },
        }).done(function (result) {
            $('.acym__campaign__recipients__number-recipients').html(result).show();
            $('.acym_loader_logo').hide();
        }).error(function () {
            $('.acym__campaign__recipients__number-recipients').html(0);
        });
    }

    if (document.getElementById('acym__entity_select') !== null) {
        const appVue = new Vue({
            directives: {infiniteScroll},
            el: '#acym__entity_select',
            data: {
                tableJoin: '',
                entitiesUnselected: [],
                data: {},
                columnJoin: '',
                offsetBase: 5000,
                entity: '',
                displaySelected: true,
                loading: true,
                entitiesToDisplay_available: [],
                columnsToDisplay: [],
                entitiesToDisplay_selected: [],
                entitiesAvailable: [],
                entitiesSelected: [],
                join: '',
                busy: false,
                availableSearch: '',
                selectedSearch: '',
                displaySelectAll_available: true,
                displaySelectAll_selected: true,
            },
            mounted: function () {
                let entitySelectContainer = document.getElementById('acym__entity_select');
                entitySelectContainer.style.display = 'flex';
                this.entity = entitySelectContainer.getAttribute('data-entity');
                this.columnsToDisplay = entitySelectContainer.getAttribute('data-columns').split(',');
                this.join = entitySelectContainer.getAttribute('data-join');
                this.displaySelected = entitySelectContainer.getAttribute('data-display-selected') === 'true';
                this.columnJoin = entitySelectContainer.getAttribute('data-column-join');
                this.tableJoin = entitySelectContainer.getAttribute('data-table-join');

                this.data = JSON.parse(document.getElementById('acym__entity_select__data').value);
                this.handleEntities(this.data.elements);

                if (this.data.total < entityPerCalls) {
                    //If we don't have data to load anymore
                    this.loading = false;
                } else {
                    //we load every thing
                    entityNumber += entityPerCalls;
                    this.getAllEntities(this.entity);
                }
            },
            methods: {
                selectEntity(entityId) {
                    let entity = getOne(this.entitiesToDisplay_available, entityId)[0];
                    this.entitiesToDisplay_selected.push(entity);
                    this.entitiesSelected.push(entity);
                    this.entitiesToDisplay_available = remove(this.entitiesToDisplay_available, entityId);
                    this.entitiesAvailable = remove(this.entitiesAvailable, entityId);
                    this.entitiesUnselected = remove(this.entitiesUnselected, entityId);
                },
                unselectEntity(entityId) {
                    let entity = getOne(this.entitiesToDisplay_selected, entityId)[0];
                    this.entitiesToDisplay_available.push(entity);
                    this.entitiesUnselected.push(entity);
                    this.entitiesAvailable.push(entity);
                    this.entitiesToDisplay_selected = remove(this.entitiesToDisplay_selected, entityId);
                    this.entitiesSelected = remove(this.entitiesSelected, entityId);
                },
                loadMoreEntity(type) {
                    start[type] += perScroll;
                    let variableName = 'entitiesToDisplay_' + type;
                    let variableNameAll = 'entities' + type.charAt(0).toUpperCase() + type.slice(1);
                    this[variableName] = '' === this[type + 'Search'] ? this[variableNameAll].slice(0, start[type]) : search(this['entities' + type.charAt(0).toUpperCase() + type.slice(1)], this[type + 'Search'], this.columnsToDisplay[0]);
                },
                loadMoreEntityAvailable() {
                    this.loadMoreEntity('available');
                },
                loadMoreEntitySelected() {
                    this.loadMoreEntity('selected');
                },
                moveAll(type) {
                    if ('available' === type) {
                        this.entitiesSelected = this.entitiesSelected.concat(this.entitiesAvailable);
                        this.entitiesAvailable = [];
                        this.entitiesToDisplay_available = [];
                        this.entitiesToDisplay_selected = this.entitiesSelected.slice(0, start.selected);
                    } else {
                        this.entitiesAvailable = this.entitiesAvailable.concat(this.entitiesSelected);
                        this.entitiesUnselected = this.entitiesUnselected.concat(this.entitiesSelected);
                        this.entitiesSelected = [];
                        this.entitiesToDisplay_available = this.entitiesAvailable.slice(0, start.available);
                        this.entitiesToDisplay_selected = [];
                    }
                },
                doSearch(type) {
                    if ('' === this[type + 'Search']) {
                        this['displaySelectAll_' + type] = true;
                        start[type] = perScroll;
                        this['entitiesToDisplay_' + type] = this['entities' + type.charAt(0).toUpperCase() + type.slice(1)].slice(0, start[type]);
                    } else {
                        this['displaySelectAll_' + type] = false;
                        this['entitiesToDisplay_' + type] = search(this['entities' + type.charAt(0).toUpperCase() + type.slice(1)], this[type + 'Search'], this.columnsToDisplay);
                    }
                },
                handleEntities(data) {
                    allEntities = allEntities.concat(data);
                    let currentBatchSelected = [];
                    if (this.columnJoin !== null) {
                        currentBatchSelected = getSelected(data, this.columnJoin);
                        allEntitiesSelected = allEntitiesSelected.concat(currentBatchSelected);
                    }

                    //We handle the new entities available
                    this.entitiesAvailable = this.entitiesAvailable.concat(diff(data, currentBatchSelected));
                    if (this.entitiesToDisplay_available.length < 1) this.entitiesToDisplay_available = this.entitiesAvailable.slice(0, start.available);

                    //We handle the new entities selected
                    if (this.displaySelected && this.columnJoin !== null) {
                        this.entitiesSelected = this.entitiesSelected.concat(currentBatchSelected);
                        if (this.entitiesToDisplay_selected.length < 1) this.entitiesToDisplay_selected = this.entitiesSelected.slice(0, start.selected);
                    }

                },
                getAllEntities(entity) {
                    let joinColumn = '';
                    if (this.tableJoin !== undefined && this.columnJoin !== undefined) joinColumn = '&join_table=' + this.tableJoin + '.' + this.columnJoin;
                    $.get(AJAX_URL_ACYM + '&ctrl=entitySelect&task=loadEntityFront&offset=' + entityNumber + '&perCalls=' + entityPerCalls + '&entity=' + entity + '&join=' + this.join + '&columns=' + this.columnsToDisplay.join(',') + joinColumn, (res) => {
                        res = JSON.parse(res);
                        if (undefined !== res.error) {
                            console.log(res.error);
                            return false;
                        }
                        numberOfEntities = res.data.total;

                        if ('end' === res.data) {
                            this.loading = false;
                            return true;
                        }

                        this.handleEntities(res.data.elements);
                        if (entityNumber > numberOfEntities) {
                            this.loading = false;
                            return true;
                        }
                        entityNumber += entityPerCalls;

                        this.getAllEntities(entity);

                        return true;
                    });
                },
                finalLoad() {
                    this.loading = false;

                    this.loadMoreEntity('available');
                    this.loadMoreEntity('selected');
                    let buttonSubmit = document.getElementById('acym__entity_select__button__submit');
                    if (typeof buttonSubmit != 'undefined' && buttonSubmit != null && buttonSubmit.classList.contains('acy_button_submit')) $.setSubmitButtonGlobal();

                    $('.acym__entity_select__button__close').off('click').on('click', function () {
                        $(this).closest('.reveal').foundation('close');
                    });

                    $.setVerificationGenericImport();
                    $.setImportCMSLists();
                },
            },
            watch: {
                availableSearch: function () {
                    this.doSearch('available');
                },
                selectedSearch: function () {
                    this.doSearch('selected');
                },
                entitiesSelected() {
                    let idsSelected = getIds(this.entitiesSelected);
                    document.querySelector('[name="acym__entity_select__selected"]').value = JSON.stringify(idsSelected);
                    let campaignsCountRecipients = document.querySelector('.acym__campaign__recipients__number-recipients');
                    if (typeof (campaignsCountRecipients) != 'undefined' && campaignsCountRecipients != null) addTotalRecipients(idsSelected);
                },
                entitiesUnselected() {
                    document.querySelector('[name="acym__entity_select__unselected"]').value = JSON.stringify(getIds(this.entitiesUnselected));
                },
                loading(newValue) {
                    if (!newValue) {
                        this.finalLoad();
                    }
                },
            },
        });
    }
});

jQuery(document).ready(function ($) {
    Vue.component('vue-switch', {
        props: [
            'plugin',
            'ischecked',
        ],
        data: function () {
            return {
                id: 'vue-switch_',
                loading: false,
                disabled: false,
            };
        },
        mounted: function () {
            this.id += this.plugin.id;
        },
        methods: {
            toggleActive(id) {
                if (this.loading) return true;
                this.loading = true;
                this.disabled = true;
                let ajaxUrl = AJAX_URL_ACYM + '&ctrl=plugins&task=toggleActivate&id=' + id;
                $.get(ajaxUrl, (res) => {
                    res = $.acym_parseJson(res);
                    if (undefined !== res.error) {
                        $.acym_add_notification(res.error, 'error');
                        return false;
                    }
                    this.loading = false;
                    this.disabled = false;
                });
            },
        },
        template: '<div class="cell shrink grid-x"><div class="switch tiny cell shrink"> ' + '<input class="switch-input" :id="id" type="checkbox" name="exampleSwitch" :checked="ischecked"> ' + '<label class="switch-paddle" @click="toggleActive(plugin.id)" :for="id"> ' + '</label> ' + '</div>' + '<i v-show="loading" class="cell shrink acym__card__loader fa fa-circle-o-notch fa-spin"></i></div>',
    });

    if ($('#acym__plugin__installed__application').length > 0) {
        const remove = (array, pluginId) => array.filter((plugin) => plugin.id !== pluginId);

        const appVue = new Vue({
            directives: {infiniteScroll},
            el: '#acym__plugin__installed__application',
            data: {
                allPlugins: [],
                displayedPlugins: [1],
                search: '',
                type: '',
                level: '',
                loading: true,
                typesColors: {
                    'Files management': 'background-color: #C5EAFF;',
                    'E-commerce solutions': 'background-color: #E7CEFF;',
                    'Content management': 'background-color: #FFC1E9;',
                    'Subscription system': 'background-color: #FFC7C7;',
                    'Others': 'background-color: #FFF1BC;',
                    'User management': 'background-color: #CAFFBA;',
                    'Events management': 'background-color: #C2FFF9;',
                },
                noPluginTodisplay: false,
                typingTimer: '',
                doneTypingInterval: 1000,
                currentLevel: '',
                downloading: {},
                pluginToggling: {},
                updating: {},
                pageDisplay: 1,
                busy: false,
            },
            mounted: function () {
                $.acym_config_get('level').then((resConfig) => {
                    resConfig = $.acym_parseJson(resConfig);
                    if (undefined !== resConfig.error) {
                        $.acym_add_notification(resConfig.error, 'error');

                        return false;
                    }
                    let resPluginsSite = $.acym_parseJson(document.getElementById('acym__plugins__all').value);
                    this.allPlugins = resPluginsSite.elements;
                    this.currentLevel = resConfig.data.toLowerCase();
                    this.resetDisplay();
                    if (this.displayedPlugins.length === 0) {
                        this.noPluginTodisplay = true;
                    }
                    this.fillPluginToggling();
                    this.fillUpdating();
                    $.setSubmitButtonGlobal();
                    this.loading = false;
                    setTimeout(() => {
                        $.setTooltip();
                        this.$forceUpdate();
                    }, 100);
                });
            },
            methods: {
                updatePlugin(plugin) {
                    if (this.updating[plugin.id]) return true;
                    this.updating[plugin.id] = true;
                    this.updating = {...this.updating};
                    let ajaxUrl = AJAX_URL_ACYM + '&ctrl=plugins&task=update';
                    $.ajax({
                        url: ajaxUrl,
                        type: 'POST',
                        data: {'plugin': plugin},
                    }).then((res) => {
                        res = $.acym_parseJson(res);
                        if (undefined !== res.error) {
                            $.acym_add_notification(res.error, 'error');
                            this.updating[plugin.id] = false;
                            this.updating = {...this.updating};
                            return false;
                        }
                        $.acym_add_notification(res.message, 'info');
                        this.updating[plugin.id] = false;
                        this.updating = {...this.updating};
                        this.toggleUptodateCurrentApp(plugin.id);
                    });
                },
                removeOnePluginInApp(id) {
                    this.allPlugins = remove(this.allPlugins, id);
                    this.displayedPlugins = remove(this.displayedPlugins, id);
                },
                resetDisplay() {
                    this.pageDisplay = 1;
                    this.fillDisplayPlugins();
                },
                fillDisplayPlugins() {
                    this.displayedPlugins = this.filterPlugin().slice(0, 18 * this.pageDisplay);
                    this.displayedPlugins = [...this.displayedPlugins];
                },
                rightLevel(pluginLevel) {
                    if (pluginLevel === 'starter') return true;
                    if (pluginLevel === 'essential' && [
                        'essential',
                        'enterprise',
                    ].indexOf(this.currentLevel) !== -1) {
                        return true;
                    }
                    if (pluginLevel === 'enterprise' && this.currentLevel === 'enterprise') return true;
                    return false;
                },
                filterPlugin() {
                    return this.allPlugins.filter((plugin) => {
                        return (plugin.level.toLowerCase().indexOf(this.level.toLowerCase()) !== -1) && (plugin.category.toLowerCase().indexOf(this.type.toLowerCase()) !== -1) && (plugin.folder_name.toLowerCase().indexOf(this.search.toLowerCase()) !== -1);
                    });
                },
                toggleCurrentApp(pluginId) {
                    this.allPlugins.map((plugin) => {
                        if (plugin.id === pluginId) plugin.active = plugin.active === '1' ? '0' : '1';
                    });
                    this.displayedPlugins = [...this.displayedPlugins];
                },
                toggleUptodateCurrentApp(pluginId) {
                    this.allPlugins.map((plugin) => {
                        if (plugin.id === pluginId) plugin.uptodate = plugin.uptodate === '1' ? '0' : '1';
                    });
                    this.displayedPlugins = [...this.displayedPlugins];
                },
                deletePlugin(id) {
                    if ($.acym_confirm(ACYM_JS_TXT.ACYM_ARE_YOU_SURE_DELETE_ADD_ON)) {
                        let ajaxUrl = AJAX_URL_ACYM + '&ctrl=plugins&task=deletePlugin&id=' + id;
                        $.get(ajaxUrl, (res) => {
                            res = $.acym_parseJson(res);
                            if (undefined !== res.error) {
                                $.acym_add_notification(res.error, 'error');
                                return false;
                            }
                            $.acym_add_notification(res.message, 'info');
                            this.removeOnePluginInApp(id);
                            return true;
                        });
                    }
                },
                fillPluginToggling() {
                    for (let plugin in this.allPlugins) {
                        this.pluginToggling[this.allPlugins[plugin].id] = false;
                    }
                },
                fillUpdating() {
                    for (let plugin in this.allPlugins) {
                        this.updating[this.allPlugins[plugin].id] = false;
                    }
                },
                transitionDelay(index) {
                    return 'transition-delay: ' + (index * 0.1) + 's;';
                },
                isActivated(active) {
                    return active == 1 ? 'checked' : '';
                },
                loadMorePlugins() {
                    this.pageDisplay++;
                    this.fillDisplayPlugins();
                },
                imageUrl(pluginName) {
                    return AJAX_URL_UPDATEME + 'integrationv6&task=getImage&plugin=' + pluginName;
                },
                documentationUrl(pluginName) {
                    return AJAX_URL_UPDATEME + 'integrationv6&task=getDocumentation&plugin=' + pluginName;
                },
                isOverflown(index) {
                    if (this.$refs.plugins === undefined || this.$refs.plugins[index] === undefined) return '';
                    return this.$refs.plugins[index].scrollHeight > this.$refs.plugins[index].clientHeight ? 'acym__plugins__card__params_desc__overflown' : '';
                },
            },
            watch: {
                displayedPlugins(newVal, oldVal) {
                    this.noPluginTodisplay = this.displayedPlugins.length === 0 && oldVal[0] !== 1;
                },
                search(newValue) {
                    clearTimeout(this.typingTimer);
                    if ('' === newValue) {
                        this.resetDisplay();
                    } else {
                        this.typingTimer = setTimeout(() => {
                            this.resetDisplay();
                        }, this.doneTypingInterval);
                    }
                },
                type() {
                    this.resetDisplay();
                },
                level() {
                    this.resetDisplay();
                },
            },
        });
    }
});

jQuery(document).ready(function ($) {
    if ($('#requireConfirmation').length > 0) {
        let perScroll = 20, start = perScroll;
        let subPerCalls = 500;
        const columns = [
            'email',
            'name',
        ];

        const search = (array, search, columns) => array.filter((subscriber) => columns.map((column) => subscriber[column].toLowerCase().indexOf(search.toLowerCase()) !== -1).indexOf(true) !== -1);

        var subscriberVue = new Vue({
            directives: {infiniteScroll},
            el: '#acym__list__settings__subscribers',
            data: {
                subscribed: [],
                displayedSubscribers: [],
                busy: false,
                listid: 0,
                total: 0,
                loading: true,
                searchSubscribers: '',
                requireConfirmation: 0,
            },
            mounted: function () {
                this.requireConfirmation = document.getElementById('requireConfirmation').value;
                let subscriberListingContainer = document.getElementById('acym__list__settings__subscribers__listing');
                if (null !== subscriberListingContainer) subscriberListingContainer.style.display = 'flex';
                this.subscribed = JSON.parse(document.getElementById('subscribers_subscribed').value);
                this.listid = document.querySelector('[name="id"]').value;
                this.total = this.subscribed.length;
                this.displayedSubscribers = this.subscribed.slice(0, start);
                if (this.total < subPerCalls) {
                    this.loading = false;
                } else {
                    this.getAllSubscribers();
                }
            },
            methods: {
                loadMoreSubscriber() {
                    start += perScroll;
                    this.displayedSubscribers = '' === this.searchSubscribers ? this.subscribed.slice(0, start) : search(this.subscribed, this.searchSubscribers, columns);
                },
                getAllSubscribers() {
                    $.get(AJAX_URL_ACYM + '&ctrl=lists&task=loadMoreSubscribers&offset=' + this.total + '&perCalls=' + subPerCalls + '&listid=' + this.listid, (res) => {
                        res = JSON.parse(res);

                        if (undefined !== res.error) {
                            console.log(res.error);
                            return false;
                        }

                        if (0 === res.data.length) {
                            this.loading = false;
                            return true;
                        }

                        let nbLoaded = res.data.length;

                        this.subscribed = this.subscribed.concat(res.data);
                        this.total += nbLoaded;

                        if (nbLoaded < subPerCalls) {
                            this.loading = false;
                            return true;
                        }
                        this.getAllSubscribers();
                        return true;
                    });
                },
                doSearch() {
                    if ('' === this.searchSubscribers) {
                        start = perScroll;
                        this.displayedSubscribers = this.subscribed.slice(0, start);
                    } else {
                        this.displayedSubscribers = search(this.subscribed, this.searchSubscribers, columns);
                    }
                },
                unsubscribeUser(subscriberId) {
                    let form = $('#acym_form');
                    $('[name="acym__entity_select__selected"]').val('');
                    $('[name="acym__entity_select__unselected"]').val('[' + subscriberId + ']');
                    form.find('[name="task"]').attr('value', 'saveSubscribers');
                    form.submit();
                },
            },
            watch: {
                searchSubscribers() {
                    this.doSearch();
                },
            },
        });
    }
});

jQuery(document).ready(function ($) {
    $.fn.select2.defaults.set('theme', 'foundation');
    Vue.component('select2', {
        template: '<div class="cell"><select :name="name">' + '<option v-for="(option, key) in options" :value="key">{{ option }}</option>' + '</select></div>',
        props: [
            'options',
            'value',
            'name',
        ],
        mounted: function () {
            let vueComp = this;
            $('[name="' + this.name + '"]')
            // init select2
                .select2({
                    theme: 'foundation',
                    width: '100%',
                })
                .val(this.value)
                .trigger('change')
                // emit event on change.
                .on('change', function () {
                    //it allows to tells to the higher application that the value changed
                    vueComp.$emit('input', this.value);
                });
        },
        watch: {
            value: function (value) {
                // update value
                $('[name="' + this.name + '"]').val(value).trigger('change');
            },
            options: function (options) {
                // update options
                $('[name="' + this.name + '"]').select2({data: options});
            },
        },
        destroyed: function () {
            $('[name="' + this.name + '"]').off().select2('destroy');
        },
    });
});