// detect mobile devices that support touch screen feature
// including windows mobile devices
var isTouchSupported = 'ontouchstart' in window,
    isTouchSupportedIE10 = navigator.userAgent.match(/Touch/i) != null;
    
tbjQuery(document).ready(function(){
    var xhr;
    // remove base tag as suddenly whole website loads inside the tab.
    tbjQuery('base').remove();
    tbjQuery.fn.disableReturnBooking = function() {
        tbjQuery('#orderdatereturn').val(ORDER_RETURN_DATE_TXT);
	tbjQuery('#selPtHr2').selectbox('detach').val(HRS_TXT).selectbox('attach');
	tbjQuery('#selPtMn2').selectbox('detach').val(MINS_TXT).selectbox('attach');
	tbjQuery('#return_selPtHr2').val(HRS_TXT);
	tbjQuery('#return_selPtMn2').val(MINS_TXT);
	tbjQuery('#return_label').hide();
	tbjQuery('#returnjurney').attr('checked', false);		
	tbjQuery('#return_date_wrapper').hide();
	tbjQuery('div#return_extra_wrapper').html('').hide();
    }
    tbjQuery( "#verticle_booking_wrap" ).tabs({
	active: tbConfig.default_tab,
	create: function( event, ui ) {
	    var selectedTabTitle = tbjQuery(ui.tab).text();
	    if(selectedTabTitle==HOURLY_HIRE_TAB_LABEL || selectedTabTitle==SHUTTLES_TAB_LABEL){
		tbjQuery.fn.disableReturnBooking();
		if(selectedTabTitle==HOURLY_HIRE_TAB_LABEL){
		    tbjQuery('#hourly_hr').addClass('required');
		    tbjQuery('div.verticl_booking_midpart.nonshuttle, div.date_input.nonshuttle, div.separator.nonshuttle, div.date_input.hr_min.nonshuttle').show();
		    tbjQuery('div.verticl_booking_bottompart.shuttle, div.date_input.shuttle, div.date_input.hr_min.shuttle').hide();
		}
		else if(selectedTabTitle==SHUTTLES_TAB_LABEL){
		    tbjQuery('div.verticl_booking_midpart.nonshuttle, div.verticl_booking_bottompart.shuttle, div.date_input.nonshuttle, div.separator.nonshuttle, div.date_input.hr_min.nonshuttle').hide();
		    tbjQuery('div.date_input.shuttle, div.date_input.hr_min.shuttle').show();
		}
	    }
	    else {
		tbjQuery('div.verticl_booking_midpart.nonshuttle, div.separator.nonshuttle, div.date_input.nonshuttle, div.date_input.hr_min.nonshuttle').show();
		tbjQuery('div.verticl_booking_bottompart.shuttle, div.date_input.shuttle, div.date_input.hr_min.shuttle').hide();
		    
		tbjQuery('#return_label').show();
		tbjQuery('#hourly_hr').removeClass('required');
	    }
	},
	select: function(event, ui) {
	    tbjQuery('#booking_type').val(tbjQuery(ui.tab).attr('id'));
            var selectedTabTitle = tbjQuery(ui.tab).text();
	    if(selectedTabTitle==HOURLY_HIRE_TAB_LABEL || selectedTabTitle==SHUTTLES_TAB_LABEL){
		tbjQuery.fn.disableReturnBooking();
		if(selectedTabTitle==HOURLY_HIRE_TAB_LABEL){
		    tbjQuery('#hourly_hr').addClass('required');
		    tbjQuery('div.verticl_booking_midpart.nonshuttle, div.date_input.nonshuttle, div.separator.nonshuttle, div.date_input.hr_min.nonshuttle').show();
		    tbjQuery('div.verticl_booking_bottompart.shuttle, div.date_input.shuttle, div.date_input.hr_min.shuttle').hide();
		}
		else if(selectedTabTitle==SHUTTLES_TAB_LABEL){
		    tbjQuery('div.verticl_booking_midpart.nonshuttle, div.verticl_booking_bottompart.shuttle, div.date_input.nonshuttle, div.separator.nonshuttle, div.date_input.hr_min.nonshuttle').hide();
		    tbjQuery('div.date_input.shuttle, div.date_input.hr_min.shuttle').show();
		}
	    }
	    else {
		tbjQuery('div.verticl_booking_midpart.nonshuttle, div.date_input.nonshuttle, div.separator.nonshuttle, div.date_input.hr_min.nonshuttle').show();
		tbjQuery('div.verticl_booking_bottompart.shuttle, div.date_input.shuttle, div.date_input.hr_min.shuttle').hide();
		    
		tbjQuery('#return_label').show();
		tbjQuery('#hourly_hr').removeClass('required');
	    }
	}
    });
    tbjQuery(".seat_options").selectbox();
    tbjQuery(".stop_interval_options").selectbox();    
    tbjQuery(".hrs, .mins").selectbox();
    tbjQuery.fn.unsetPoiAddress = function() {
        tbjQuery('input#address_from,input#address_from_lat,input#address_from_lng').val('');
        tbjQuery('div#pickup_extra_wrapper').html('');
	tbjQuery('div#stops_wrapper').html('');
        tbjQuery('input#address_to,input#address_to_lat,input#address_to_lng').val('');
        tbjQuery('div#dropoff_extra_wrapper').html('');
	tbjQuery('input#pickup_poi,input#dropoff_poi').val(0);
    }
    tbjQuery.fn.unsetRoute = function() {
        var route_swapped = tbjQuery('#route_swapped').val();
        if(route_swapped==1){ // routes are already swapped, so normalize them
	    tbjQuery('#route_category_fld,#route_category_dropoff_fld,#route_from_fld,#route_to_fld').attr('readonly', false);
            tbjQuery('#route_swapped').val(0);
        }
	tbjQuery('#route_category_fld,#route_category_dropoff_fld,#route_from_fld,#route_to_fld').val('');
	tbjQuery('#route_category,#route_category_dropoff,#route_from,#route_to').val(0);
	if(tbjQuery('#show_poi_categories').val()==1){
	    tbjQuery('div.routes_wrapper_from div.routes_from_inner').hide();
	}
	tbjQuery('div.routes_wrapper_to,div.routes_indicator').hide();
        tbjQuery('div#routefrom_extra_wrapper,div#routeto_extra_wrapper').html('');   
    }
    tbjQuery.fn.unsetHourlyHire = function() {
	tbjQuery('#hourly_hr').selectbox('detach');
	tbjQuery('#hourly_hr').val(0);
	tbjQuery('#hourly_hr').selectbox({
	    onOpen: function (inst) {},
	    onClose: function (inst) {},
	    onChange: function (val, inst) {
		tbjQuery('#hourly_hr').selectbox('close');
		tbjQuery('#booking_type').val('hourly');
		tbjQuery.fn.unsetPoiAddress();
		tbjQuery.fn.unsetRoute();
		tbjQuery.fn.unsetShuttle();
		tbjQuery.fn.getExtras('hourly_hire');
	    }
	});
	tbjQuery('#hourly_min').selectbox('detach').val(0).selectbox('attach');
	tbjQuery('div#hourly_extra_wrapper').html('');
    }
    tbjQuery.fn.unsetShuttle = function() {
	tbjQuery('#shuttle_pickup,#shuttle_dropoff').val("");
	tbjQuery('#shuttle_pickup_poi,#shuttle_dropoff_poi').val(0);
	tbjQuery('input[name="shuttletime"]').attr('checked', false);
	tbjQuery("div.date_input.hr_min.shuttle").html('').hide();
	tbjQuery('#shuttle_passengers').val(0);
    }
    tbjQuery( 'a.field_desc, a.addstop' ).tooltip({
        track: true
    });
    tbjQuery('div#directions_panel').hide(); // hide the direction panel at first load
    // show dropdown div of poi1
    tbjQuery("div.pickup_wrap .poi_options_trigger").click(function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    tbjQuery(this).removeClass("Open");
	}
	else {
	    tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).next('.poi_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.pickup_wrap div.poi_dropdown_wrapper div.poi_link").click(function(){
	var poiObj = this;
	// first check if this POI is in Area of Operation
	areaOfOperation = new google.maps.Polygon({
	    paths: triangleCoords
	});
	if( tbConfig.pickup_in_area_operation==1 || tbConfig.pickup_dropoff_in_area_operation==1) {
	    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(tbjQuery(this).data('poilat'),tbjQuery(this).data('poilng')), areaOfOperation)) {
		tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').hide();
		tbjQuery('div.pickup_wrap .poi_options_trigger').removeClass('Open');
		showAreaOperationPopup();
		return false;
	    }
	}
        tbjQuery('#address_from').val(tbjQuery(this).children('span').html());
        tbjQuery('#address_from_lat').val(tbjQuery(this).data('poilat'));
	tbjQuery('#address_from_lng').val(tbjQuery(this).data('poilng'));
	tbjQuery('input#pickup_poi').val(tbjQuery(this).data('poiid'));
        tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').hide();
	tbjQuery('div.pickup_wrap .poi_options_trigger').removeClass('Open');
        // first unset route options
        tbjQuery.fn.unsetRoute();
        tbjQuery.fn.unsetHourlyHire();
	tbjQuery.fn.unsetShuttle();
        tbjQuery.fn.getExtras('pickup', tbjQuery(poiObj).data('poiid'));
        // set booking type
        tbjQuery('#booking_type').val('address');
    })
    // show dropdown div of poi2
    tbjQuery("div.dropoff_wrap div.nonstop_wrap .poi_options_trigger").click(function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    tbjQuery(this).removeClass("Open");
	}
	else {
	    tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).next('.poi_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.dropoff_wrap div.nonstop_wrap div.poi_dropdown_wrapper div.poi_link").click(function(){
	var poiObj = this;
	// first check if this POI is in Area of Operation
	areaOfOperation = new google.maps.Polygon({
	    paths: triangleCoords
	});
	if( tbConfig.dropoff_in_area_operation==1 || tbConfig.pickup_dropoff_in_area_operation==1) {
	    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(tbjQuery(this).data('poilat'),tbjQuery(this).data('poilng')), areaOfOperation)) {
		tbjQuery("div.dropoff_wrap div.poi_dropdown_wrapper").hide();
		tbjQuery('div.dropoff_wrap div.nonstop_wrap .poi_options_trigger').removeClass('Open');
		showAreaOperationPopup();
		return false;
	    }
	}
        tbjQuery('#address_to').val(tbjQuery(this).children('span').html());
        tbjQuery('#address_to_lat').val(tbjQuery(this).data('poilat'));
	tbjQuery('#address_to_lng').val(tbjQuery(this).data('poilng'));
	tbjQuery('input#dropoff_poi').val(tbjQuery(this).data('poiid'));
        tbjQuery("div.dropoff_wrap div.nonstop_wrap div.poi_dropdown_wrapper").hide();
        tbjQuery('div.dropoff_wrap div.nonstop_wrap .poi_options_trigger').removeClass('Open');
        // first unset route options
        tbjQuery.fn.unsetRoute();
        tbjQuery.fn.unsetHourlyHire();
	tbjQuery.fn.unsetShuttle();
        tbjQuery.fn.getExtras('dropoff', tbjQuery(poiObj).data('poiid'));
        // set booking type
        tbjQuery('#booking_type').val('address');
    })
    // show dropdown div of route category if show_poi_category is enabled
    if(tbjQuery('#show_poi_categories').val()==1)
    {
	// collect pickup route for this selected category
	tbjQuery.fn.collectRouteFrom = function() {
	    if(tbjQuery('#route_category').val() > 0)
	    {
		tbjQuery.ajax({
		    type: "POST",
		    url: 'index.php?option=com_taxibooking&task=getRouteList',
		    data: tbjQuery('#price_form').serialize(),
		    dataType: 'json',
		    async: false,
		    beforeSend: function(){
			tbjQuery('div.routes_wrapper_from div#routefrom_loader').html(tbjQuery('#route_loader').html());
			tbjQuery('div.routes_wrapper_to').hide();
			tbjQuery('div#routefrom_extra_wrapper,div#routeto_extra_wrapper').html('');   
			tbjQuery('#route_category_dropoff_fld').val('');
			tbjQuery('#route_category_dropoff').val(0);
		    },
		    complete: function(){
		    },
		    success: function(response){
			tbjQuery('div.routes_wrapper_from div#routefrom_loader').html('');
			tbjQuery('div.routes_wrapper_from').show();
			tbjQuery('div.routes_wrapper_from div.routes_from_inner').show();
			tbjQuery('div.routefrom_dropdown_wrapper').html(response.route_options_html);
			
			tbjQuery("#route_from_fld").autocomplete({
			    source: response.route_poi_data,		
			    minLength: 2,
			    open: function( event, ui ) {
				tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').hide();
			    },
			    select: function(event, ui) {
				tbjQuery('#route_from').val(ui.item.id);
				tbjQuery('#route_from_fld').val(ui.item.value);
				tbjQuery.fn.getExtras('route_pickup');
				// set booking type
				tbjQuery('#booking_type').val('offers');
			    }
			})
			
			var mouseOverRouteFrom = false;
			tbjQuery('div.routes_wrapper .routefrom_options_trigger').mouseenter(function(){
			    mouseOverRouteFrom = true; 
			}).mouseleave(function(){ 
			    mouseOverRouteFrom = false; 
			})
			tbjQuery("html").click(function(){
			    if (!mouseOverRouteFrom) {
				tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').slideUp(250);
			    }
			});
		    }
		})
	    }
	    else {
		tbjQuery('div#routefrom_extra_wrapper,div#routeto_extra_wrapper').html('');   
		tbjQuery('div.routes_wrapper_to').hide();
	    }
	}
	tbjQuery("div.routecategory_wrapper_from .routecategory_options_trigger").click(function(){
	    if(tbjQuery(this).hasClass('Open') == true){
		tbjQuery(this).removeClass("Open");
	    }
	    else {
		tbjQuery(this).addClass("Open");
	    }
	    if (tbjQuery(this).prev('.routecategory_dropdown_wrapper').is(":visible") == true){
		tbjQuery(this).prev('.routecategory_dropdown_wrapper').slideUp(250);
	    }
	    else {
		tbjQuery(this).prev('.routecategory_dropdown_wrapper').slideDown(250);
	    }        
	})
	tbjQuery("div.routecategory_wrapper_from div.routecategory_dropdown_wrapper div.poi_link").click(function(){
	    // unset routes
	    tbjQuery('#route_category_dropoff,#route_from,#route_to').val(0);
	    tbjQuery('#route_category_dropoff_fld,#route_from_fld,#route_to_fld').val('');
	    tbjQuery('div#routefrom_extra_wrapper,div#routeto_extra_wrapper').html('');
	    tbjQuery('#route_category').val(tbjQuery(this).attr('id'));
	    tbjQuery('#route_category_fld').val(tbjQuery(this).children('span').html());
	    tbjQuery('div.routecategory_wrapper_from div.routecategory_dropdown_wrapper').hide();
	    tbjQuery('div.routecategory_wrapper_from .routecategory_options_trigger').removeClass('Open');
	    // unset all the poi/address selection below
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery.fn.unsetShuttle();
	    tbjQuery.fn.collectRouteFrom();
	    // set booking type
	    tbjQuery('#booking_type').val('offers');
	})
    }
    tbjQuery("div.routes_wrapper .routefrom_options_trigger").die("click").live('click', function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    //tbjQuery(this).removeClass("Open");
	}
	else {
	    //tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).prev('.routefrom_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).prev('.routefrom_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).prev('.routefrom_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.routes_wrapper div.routefrom_dropdown_wrapper div.poi_link").die("click").live('click', function(){
	tbjQuery('#route_from').val(tbjQuery(this).attr('id'));
	tbjQuery('#route_from_fld').val(tbjQuery(this).children('span').html());
	tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').hide();
	tbjQuery('div.routes_wrapper .routefrom_options_trigger').removeClass('Open');
	// unset all the poi/address selection below
	tbjQuery.fn.unsetPoiAddress();
	tbjQuery.fn.unsetHourlyHire();
	tbjQuery.fn.unsetShuttle();
	tbjQuery.fn.getExtras('route_pickup');
	// if show_route_category enabled, collect dropoff route category
	if(tbjQuery('#show_poi_categories').val()==1) {
	    tbjQuery.fn.collectDropoffRouteCategory();
	}
	else { // if show_route_category disabled, collect dropoff routes list
	    tbjQuery.fn.collectRouteTo();
	}
	tbjQuery('#booking_type').val('offers');
    })
    // show dropdown div of route from initially if show_poi_category is disabled
    if(tbjQuery('#show_poi_categories').val()==0)
    {
	var mouseOverRouteFrom = false;
	tbjQuery('div.routes_wrapper .routefrom_options_trigger').mouseenter(function(){
	    mouseOverRouteFrom = true; 
	}).mouseleave(function(){ 
	    mouseOverRouteFrom = false; 
	})
    }
    tbjQuery.fn.collectDropoffRouteCategory = function() {
        if(tbjQuery('#route_from').val() > 0) {
            tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&task=getRouteCategory',
                data: tbjQuery('#price_form').serialize(),
                dataType: 'json',
                async: false,
                beforeSend: function(){
                    tbjQuery('div.routes_wrapper_to').hide();
                    // unset all the poi/address selection below
                    tbjQuery.fn.unsetPoiAddress();
                    tbjQuery.fn.unsetHourlyHire();
		    tbjQuery.fn.unsetShuttle();
                },
                complete: function(){
                },
                success: function(response){
                    tbjQuery('div.routes_wrapper_to').show();
		    tbjQuery('div.routes_to_inner').hide();
                    tbjQuery('div.routecategory_dropoff_dropdown_wrapper').html(response.route_categories_html);
                    tbjQuery("#route_category_dropoff_fld").autocomplete({
                        source: response.route_categories_data,		
                        minLength: 2,
                        open: function( event, ui ) {
                            tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').hide();
                        },
                        select: function(event, ui) {
                            tbjQuery('#route_category_dropoff').val(ui.item.id);
                            tbjQuery('#route_category_dropoff_fld').val(ui.item.value);
                            // unset all the poi/address selection below
                            tbjQuery.fn.unsetPoiAddress();
                            tbjQuery.fn.unsetHourlyHire();
			    tbjQuery.fn.unsetShuttle();
                            tbjQuery.fn.collectRouteTo();
                            // set booking type
                            tbjQuery('#booking_type').val('offers');
                        }
                    })
                    // show dropdown div of route from
		    var mouseOverRouteCategoryDropoff = false;
		    tbjQuery('div.routecategory_dropoff_options_trigger').mouseenter(function(){
			mouseOverRouteCategoryDropoff = true; 
		    }).mouseleave(function(){ 
			mouseOverRouteCategoryDropoff = false; 
		    })
                    var mouseOverRouteTo = false;
                    tbjQuery('div.routes_wrapper .routeto_options_trigger').mouseenter(function(){
                        mouseOverRouteTo = true; 
                    }).mouseleave(function(){ 
                        mouseOverRouteTo = false; 
                    })
                    tbjQuery("html").click(function(){
			if (!mouseOverRouteCategoryDropoff) {
			    tbjQuery('div.routecategory_dropoff_dropdown_wrapper').slideUp(250);
			}
                        if (!mouseOverRouteTo) {
                            tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').slideUp(250);
                        }
                    });
                }
            })
        }
        else {
            tbjQuery('div.routes_wrapper_to').hide();
        }
    }
    tbjQuery("div.routecategory_dropoff_options_trigger").die("click").live('click', function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    tbjQuery(this).removeClass("Open");
	}
	else {
	    tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).prev('div.routecategory_dropoff_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).prev('div.routecategory_dropoff_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).prev('div.routecategory_dropoff_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.routecategory_dropoff_dropdown_wrapper div.poi_link").die("click").live('click', function(){
	// unset routes
	tbjQuery('#route_to').val(0);
	tbjQuery('#route_to_fld').val('');
	tbjQuery('div#routeto_extra_wrapper').html('');
	tbjQuery('#route_category_dropoff').val(tbjQuery(this).attr('id'));
	tbjQuery('#route_category_dropoff_fld').val(tbjQuery(this).children('span').html());
	tbjQuery('div.routecategory_dropoff_dropdown_wrapper').hide();
	tbjQuery('div.routecategory_dropoff_options_trigger').removeClass('Open');
	
	// unset all the poi/address selection below
	tbjQuery.fn.unsetPoiAddress();
	tbjQuery.fn.unsetHourlyHire();
	tbjQuery.fn.unsetShuttle();
	tbjQuery.fn.collectRouteTo();
	// set booking type
	tbjQuery('#booking_type').val('offers');
    })
    
    tbjQuery.fn.collectRouteTo = function() {
        if(tbjQuery('#route_from').val() > 0) {
            tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&task=getRouteList',
                data: tbjQuery('#price_form').serialize(),
                dataType: 'json',
                async: false,
                beforeSend: function(){
		    tbjQuery('div.routes_wrapper_to div#routefrom_loader').html(tbjQuery('#route_loader').html());
                    // unset route to
                    tbjQuery('#route_to').val(0);
                    tbjQuery('#route_to_fld').val('');
                    tbjQuery('div#routeto_extra_wrapper').html('');
                    // unset all the poi/address selection below
                    tbjQuery.fn.unsetPoiAddress();
                    tbjQuery.fn.unsetHourlyHire();
		    tbjQuery.fn.unsetShuttle();
                },
                complete: function(){
                },
                success: function(response){
                    tbjQuery('div.routes_wrapper_to div#routefrom_loader').html('');
                    tbjQuery('div.routes_indicator').show();
		    tbjQuery('div.routes_wrapper_to').show();
		    tbjQuery('div.routes_wrapper_to div.routes_to_inner').show();
                    tbjQuery('div.routeto_dropdown_wrapper').html(response.route_options_html);
                    
                    tbjQuery("#route_to_fld").autocomplete({
                        source: response.route_poi_data,		
                        minLength: 2,
                        open: function( event, ui ) {
                            tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').hide();
                        },
                        select: function(event, ui) {
                            tbjQuery('#route_to').val(ui.item.id);
                            tbjQuery('#route_to_fld').val(ui.item.value);
                            // unset all the poi/address selection below
                            tbjQuery.fn.unsetPoiAddress();
                            tbjQuery.fn.unsetHourlyHire();
			    tbjQuery.fn.unsetShuttle();
                            tbjQuery.fn.getExtras('route_dropoff');
                            // set booking type
                            tbjQuery('#booking_type').val('offers');
                        }
                    })
                    // show dropdown div of route from
                    var mouseOverRouteTo = false;
                    tbjQuery('div.routes_wrapper .routeto_options_trigger').mouseenter(function(){
                        mouseOverRouteTo = true; 
                    }).mouseleave(function(){ 
                        mouseOverRouteTo = false; 
                    })
                    tbjQuery("html").click(function(){
                        if (!mouseOverRouteTo) {
                            tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').slideUp(250);
                        }
                    });
                }
            })
        }
        else {
            tbjQuery('div.routes_wrapper_to').hide();
            //tbjQuery('#route_to_wrap').html('');
            tbjQuery('div#routefrom_extra_wrapper').html('');   
            tbjQuery('div#routeto_extra_wrapper').html('');
        }
    }
    tbjQuery("div.routes_wrapper .routeto_options_trigger").die("click").live('click', function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    //tbjQuery(this).removeClass("Open");
	}
	else {
	    //tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).prev('.routeto_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).prev('.routeto_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).prev('.routeto_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.routes_wrapper div.routeto_dropdown_wrapper div.poi_link").die("click").live('click', function(){
        tbjQuery('#route_to').val(tbjQuery(this).attr('id'));
        tbjQuery('#route_to_fld').val(tbjQuery(this).children('span').html());
        tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').hide();
	tbjQuery('div.routes_wrapper .routeto_options_trigger').removeClass('Open');
        // unset all the poi/address selection below
        tbjQuery.fn.unsetPoiAddress();
        tbjQuery.fn.unsetHourlyHire();
	tbjQuery.fn.unsetShuttle();
        tbjQuery.fn.getExtras('route_dropoff');
        tbjQuery('#booking_type').val('offers');
    })
    
    /*tbjQuery('#route_to').live('change', function(){
        tbjQuery.fn.getExtras('route_dropoff');
    })*/

    // swap route with extras
    tbjQuery.fn.swapRoute = function() {
        var pickup_route_selected = tbjQuery('#route_from').val();
        var dropoff_route_selected = tbjQuery('#route_to').val();
        
        if(pickup_route_selected==0 || dropoff_route_selected==0){
            alert('Please choose both routes!');
            return false;
        }
        var pickup_route_html = tbjQuery('#route_from_fld').val();
        var dropoff_route_html = tbjQuery('#route_to_fld').val();
        tbjQuery('#route_from_fld').val(dropoff_route_html);
        tbjQuery('#route_to_fld').val(pickup_route_html);
        tbjQuery('#route_from').val(dropoff_route_selected);
        tbjQuery('#route_to').val(pickup_route_selected);
        return true;
    }
    tbjQuery('a.swap_routes').click(function(){
        var route_swapped = tbjQuery('#route_swapped').val();
        if(route_swapped==1){ // routes are already swapped, so normalize them
	    tbjQuery('#route_category_fld,#route_category_dropoff_fld,#route_from_fld,#route_to_fld').attr('readonly', false);
            if(tbjQuery.fn.swapRoute()){
                tbjQuery('#route_swapped').val(0);
                tbjQuery("div.routecategory_options_trigger, div.routecategory_dropoff_options_trigger, div.routefrom_options_trigger, div.routeto_options_trigger").show();
                tbjQuery.fn.getSwappedRouteExtras();
		tbjQuery.fn.getReturnExtras();
            }
        }
        else {
            if(tbjQuery.fn.swapRoute()){
                tbjQuery('#route_swapped').val(1);
		tbjQuery('#route_category_fld,#route_category_dropoff_fld,#route_from_fld,#route_to_fld').attr('readonly', true);
                tbjQuery("div.routecategory_options_trigger, div.routecategory_dropoff_options_trigger, div.routefrom_options_trigger, div.routeto_options_trigger").hide();
                tbjQuery.fn.getSwappedRouteExtras();
		tbjQuery.fn.getReturnExtras();
            }
        }
    });
    tbjQuery('#hourly_hr').selectbox({
	onOpen: function (inst) {},
	onClose: function (inst) {},
	onChange: function (val, inst) {
	    tbjQuery('#hourly_hr').selectbox('close');
	    tbjQuery('#booking_type').val('hourly');
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetRoute();
	    tbjQuery.fn.unsetShuttle();
	    tbjQuery.fn.getExtras('hourly_hire');
	}
    });
    // Shuttles booking
    tbjQuery("div.shuttle_pickup_wrap .poi_options_trigger").click(function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    tbjQuery(this).removeClass("Open");
	}
	else {
	    tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).next('.poi_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.shuttle_pickup_wrap div.poi_dropdown_wrapper div.poi_link").click(function(){
	tbjQuery('#shuttle_pickup').val(tbjQuery(this).children('span').html());
        tbjQuery('#shuttle_pickup_poi').val(tbjQuery(this).data('poiid'));
        tbjQuery('div.shuttle_pickup_wrap div.poi_dropdown_wrapper').hide();
	tbjQuery('div.shuttle_pickup_wrap .poi_options_trigger').removeClass('Open');
        // first unset route options
	tbjQuery.fn.unsetPoiAddress();
        tbjQuery.fn.unsetRoute();
        tbjQuery.fn.unsetHourlyHire();
        // set booking type
        tbjQuery('#booking_type').val('shuttle');
	tbjQuery.fn.getExtras('shuttle_pickup', tbjQuery(this).data('poiid'));
	tbjQuery('#shuttle_dropoff').val("");
	tbjQuery('#shuttle_dropoff_poi').val(0);
	tbjQuery.fn.getShuttleDropoffPOIs(tbjQuery(this).data('poiid'));
    })
    tbjQuery("div.shuttle_dropoff_wrap .poi_options_trigger").click(function(){
	if(tbjQuery(this).hasClass('Open') == true){
	    tbjQuery(this).removeClass("Open");
	}
	else {
	    tbjQuery(this).addClass("Open");
	}
	if (tbjQuery(this).next('.poi_dropdown_wrapper').is(":visible") == true){
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideUp(250);
	}
	else {
	    tbjQuery(this).next('.poi_dropdown_wrapper').slideDown(250);
	}        
    })
    tbjQuery("div.shuttle_dropoff_wrap div.poi_dropdown_wrapper div.poi_link").die("click").live('click', function(){
	tbjQuery('#shuttle_dropoff').val(tbjQuery(this).children('span').html());
        tbjQuery('#shuttle_dropoff_poi').val(tbjQuery(this).data('poiid'));
        tbjQuery('div.shuttle_dropoff_wrap div.poi_dropdown_wrapper').hide();
	tbjQuery('div.shuttle_dropoff_wrap .poi_options_trigger').removeClass('Open');
        // first unset route options
	tbjQuery.fn.unsetPoiAddress();
        tbjQuery.fn.unsetRoute();
        tbjQuery.fn.unsetHourlyHire();
        // set booking type
        tbjQuery('#booking_type').val('shuttle');
	tbjQuery.fn.getExtras('shuttle_dropoff', tbjQuery(this).data('poiid'));
	tbjQuery.fn.getShuttleTimeOptions(1);  // clear_previous_selection = 1
    })
    tbjQuery.fn.getShuttleDropoffPOIs = function(poiid) {
        // if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
        var passingData = tbjQuery('#price_form').serialize()+'&poiid='+poiid;
        xhr = tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&controller=onepage&task=getShuttleDropoffPOIs',
                data: passingData,
                dataType: 'json',
                async: false,
                beforeSend: function(){
                    // load the ajax loading image
		    tbjQuery("div.shuttle_dropoff_wrap div.poi_dropdown_wrapper").html('').hide();
		    tbjQuery("div.date_input.hr_min.shuttle").html('').hide();
		    tbjQuery('input#shuttle_passengers').val('');
		    tbjQuery('div.verticl_booking_bottompart.shuttle').hide();
                },
                complete: function(){
                },
                success: function(response){
                    if(response.error==0)
                    {
			tbjQuery("div.shuttle_dropoff_wrap div.poi_dropdown_wrapper").html(response.msg);
                    }
		    else {
			tbjQuery("div.shuttle_dropoff_wrap div.poi_dropdown_wrapper").html('');
		    }
                }
        });
    }
    tbjQuery.fn.getShuttleTimeOptions = function(clear_previous_selection) {
        // if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
        if (typeof clear_previous_selection == 'undefined') {
	    clear_previous_selection = 1;
	}
        var passingData = tbjQuery('#price_form').serialize()+'&clear_previous_selection='+clear_previous_selection;
        xhr = tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&controller=onepage&task=getShuttleTimeOptions',
                data: passingData,
                dataType: 'json',
                async: false,
                beforeSend: function(){
		    tbjQuery("div.date_input.hr_min.shuttle").html('').hide();
		    tbjQuery('input#shuttle_passengers').val('');
		    tbjQuery('div.verticl_booking_bottompart.shuttle').hide();
                },
                complete: function(){
                },
                success: function(response){
                    if(response.error==0)
                    {
			tbjQuery("div.date_input.hr_min.shuttle").html(response.msg).show();
			// prepare passenger list for selected route time if selected from module
			if(tbjQuery("#module_shuttle_passengers").val() > 0)
			{
			    tbjQuery('div.verticl_booking_bottompart.shuttle').show();
			    tbjQuery('span#selected_seat').html(tbjQuery("#module_shuttle_passengers").val());
			    tbjQuery('input#shuttle_passengers').val(tbjQuery("#module_shuttle_passengers").val());
			}
                    }
		    else {
			tbjQuery("div.date_input.hr_min.shuttle").html('').hide();
		    }
                }
        });
    }
    tbjQuery(document).on("click", 'input:radio[name="shuttletime"]', function (e) {
	tbjQuery('div.verticl_booking_bottompart.shuttle').show();
    })
    var shuttlePassengerDialog;
    tbjQuery(document).on("focus", 'input#shuttle_passengers', function (e) {
	if(tbjQuery('input:radio[name="shuttletime"]:checked').length > 0){
	    tbjQuery('div#shuttle-passengers-wrapper ul.shuttle-passengers-list').remove();
	    var available_seats = tbjQuery('input:radio[name="shuttletime"]:checked').parent().data('seats');
	    var passenger_list = tbjQuery('<ul class="shuttle-passengers-list">');
	    for(var i = 1; i <= parseInt(available_seats); i++){
		passenger_list.append(tbjQuery("<li>").html('<input type="button" class="passenger-btn" value="'+i+'" />'));
	    }
	    tbjQuery('div#shuttle-passengers-wrapper').append(passenger_list);
	    shuttlePassengerDialog = tbjQuery( "#dialog-shuttle-passengers" ).dialog({
		autoOpen: false,
		height: 300,
		width: 250,
		modal: true,
		buttons: {},
		close: function() {
		    shuttlePassengerDialog.dialog( "close" );
		}
	    });
	    shuttlePassengerDialog.dialog( "open" );
	}
    })
    tbjQuery(document).on("click", 'input:button.passenger-btn', function (e) {
	var selected_seat = tbjQuery(this).val();
	tbjQuery('input#shuttle_passengers').val(selected_seat);
	shuttlePassengerDialog.dialog( "close" );
    })
    tbjQuery(".see_price").click(function() {
	var booking_type = tbjQuery('#booking_type').val();
	
        // first validate the required field
        var err = 0;
	// address field validation if user choose address radio
	tbjQuery("#address_from").closest('div.top_ver_input_wrap').removeClass('incorrect');
	tbjQuery("#address_to").closest('div.top_ver_input_wrap').removeClass('incorrect');
	
	if(booking_type=='address')
	{
	    var address_from_lat = tbjQuery('#address_from_lat').val();
	    var address_from_lng = tbjQuery('#address_from_lng').val();
	    if(address_from_lat=="" || address_from_lng==""){
		err = err+1;
		tbjQuery("#address_from").closest('div.top_ver_input_wrap').addClass('incorrect');
	    }
	    var address_to_lat = tbjQuery('#address_to_lat').val();
	    var address_to_lng = tbjQuery('#address_to_lng').val();
	    if(address_to_lat=="" || address_to_lng==""){
		err = err+1;
		tbjQuery("#address_to").closest('div.top_ver_input_wrap').addClass('incorrect');
	    }
	}
	// other required field validation
	if(booking_type!='shuttle')
	{
	    if(tbjQuery('#passengers').val()=="0"){
		err = err+1;
		tbjQuery('#passengers').next("div.sbHolder").addClass('required incorrect');
	    }
	    else {
		tbjQuery('#passengers').next("div.sbHolder").removeClass('required incorrect');
	    }
	}
	if(booking_type=='hourly')
	{
	    if(tbjQuery('#hourly_hr').hasClass('required')){
		if(tbjQuery('#hourly_hr').val()=="0"){
		    err = err+1;
		    tbjQuery('#hourly_hr').next("div.sbHolder").addClass('required incorrect');
		}
		else {
		    tbjQuery('#hourly_hr').next("div.sbHolder").removeClass('required incorrect');
		}
	    }
	}
        tbjQuery('form#price_form').find('.required').each(function(){
            if(tbjQuery(this).is(":visible") == true && (tbjQuery(this).val()=="" || tbjQuery(this).val()=="0" || tbjQuery(this).val()=="Date")){
                err = err+1;
                if(tbjQuery(this).attr('id')=='shuttle_pickup' || tbjQuery(this).attr('id')=='shuttle_dropoff'){
		    tbjQuery(this).closest('div.top_ver_input_wrap').addClass('incorrect');
		}
		else {
		    tbjQuery(this).addClass('incorrect');
		}
            }
	    else {
                if(tbjQuery(this).attr('id')=='shuttle_pickup' || tbjQuery(this).attr('id')=='shuttle_dropoff'){
		    tbjQuery(this).closest('div.top_ver_input_wrap').removeClass('incorrect');
		}
		else {
		    tbjQuery(this).removeClass('incorrect');
		}
	    }
        })
        if(err>0){
	    tbjQuery('html, body').animate({ scrollTop: tbjQuery('#verticle_booking_wrap').offset().top }, 'fast');
        }
	else {
	    document.price_form.submit();
	}
    });
        
    // hide all the dropdown if clicked outside of the arrow
    var mouseOverPoi1 = false;
    tbjQuery('div.pickup_wrap .poi_options_trigger').mouseenter(function(){
        mouseOverPoi1 = true; 
    }).mouseleave(function(){ 
        mouseOverPoi1 = false; 
    })
    var mouseOverPoi2 = false;
    tbjQuery('div.dropoff_wrap div.nonstop_wrap .poi_options_trigger').mouseenter(function(){
        mouseOverPoi2 = true; 
    }).mouseleave(function(){ 
        mouseOverPoi2 = false; 
    })
    var mouseOverRouteCategory = false;
    tbjQuery('div.routecategory_wrapper_from .routecategory_options_trigger').mouseenter(function(){
	mouseOverRouteCategory = true; 
    }).mouseleave(function(){ 
	mouseOverRouteCategory = false; 
    })
    var mouseOverRouteFrom = false;
    tbjQuery('div.routes_wrapper .routefrom_options_trigger').mouseenter(function(){
	mouseOverRouteFrom = true; 
    }).mouseleave(function(){ 
	mouseOverRouteFrom = false; 
    })
    var mouseOverRouteCategoryDropoff = false;
    tbjQuery('div.routecategory_dropoff_options_trigger').mouseenter(function(){
	mouseOverRouteCategoryDropoff = true; 
    }).mouseleave(function(){ 
	mouseOverRouteCategoryDropoff = false; 
    })
    var mouseOverRouteTo = false;
    tbjQuery('div.routes_wrapper .routeto_options_trigger').mouseenter(function(){
	mouseOverRouteTo = true; 
    }).mouseleave(function(){ 
	mouseOverRouteTo = false; 
    })
    
    tbjQuery("html").click(function(){
        if (!mouseOverPoi1) {
            tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').slideUp(250);
        }
        if (!mouseOverPoi2) {
            tbjQuery("div.dropoff_wrap div.nonstop_wrap div.poi_dropdown_wrapper").slideUp(250);
        }
	if (!mouseOverRouteFrom) {
	    tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').slideUp(250);
	}
	if (!mouseOverRouteCategory) {
	    tbjQuery('div.routecategory_wrapper_from div.routecategory_dropdown_wrapper').slideUp(250);
	}
	if (!mouseOverRouteCategoryDropoff) {
	    tbjQuery('div.routecategory_dropoff_dropdown_wrapper').slideUp(250);
	}
	if (!mouseOverRouteTo) {
	    tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').slideUp(250);
	}
    });
    tbjQuery(document).mouseup(function (e)
    {
	var container = tbjQuery("div.dropoff_wrap div.stops_wrap div.poi_dropdown_wrapper");
	if (!container.is(e.target) // if the target of the click isn't the container...
	    && container.has(e.target).length === 0) // ... nor a descendant of the container
	{
	    container.slideUp(250);
	}
    });
    // collect extra list
    tbjQuery.fn.getExtras = function(type, poiid) {
        // if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
        if (typeof poiid == 'undefined') {
	    poiid = 0;
	}
        var passingData = tbjQuery('#price_form').serialize()+'&type='+type+'&poiid='+poiid;
        xhr = tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&controller=onepage&task=getExtraList',
                data: passingData,
                dataType: 'json',
                async: false,
                beforeSend: function(){
                    // load the ajax loading image
                    if(type=='pickup' || type=='address_pickup'){
			tbjQuery('div#pickup_extra_wrapper').html(tbjQuery('#route_loader').html());   
		    }
		    else if(type=='dropoff' || type=='address_dropoff'){
			tbjQuery('div#dropoff_extra_wrapper').html(tbjQuery('#route_loader').html());
		    }
		    else if(type=='route_pickup'){
			tbjQuery('div#routefrom_extra_wrapper').html(tbjQuery('#route_loader').html());   
		    }
		    else if(type=='route_dropoff'){
			tbjQuery('div#routeto_extra_wrapper').html(tbjQuery('#route_loader').html());
		    }
		    else if(type=='hourly_hire'){
			tbjQuery('div#hourly_extra_wrapper').html(tbjQuery('#route_loader').html());
		    }
		    else if(type=='shuttle_pickup'){
			tbjQuery('div#shuttle_pickup_extra_wrapper').html(tbjQuery('#route_loader').html());   
		    }
		    else if(type=='shuttle_dropoff'){
			tbjQuery('div#shuttle_dropoff_extra_wrapper').html(tbjQuery('#route_loader').html());
		    }
                },
                complete: function(){
                },
                success: function(response){
                    // clear out the ajax loading image
                    tbjQuery('#route_loader').hide();
                    
                    if(response.error==0)
                    {
                        if(type=='pickup' || type=='address_pickup'){
                            tbjQuery('div#pickup_extra_wrapper').html(response.msg);   
                        }
                        else if(type=='dropoff' || type=='address_dropoff'){
                            tbjQuery('div#dropoff_extra_wrapper').html(response.msg);
                        }
                        else if(type=='route_pickup'){
                            tbjQuery('div#routefrom_extra_wrapper').html(response.msg);   
                        }
                        else if(type=='route_dropoff'){
                            tbjQuery('div#routeto_extra_wrapper').html(response.msg);
                        }
			else if(type=='hourly_hire'){
                            tbjQuery('div#hourly_extra_wrapper').html(response.msg);
                        }
                        else if(type=='shuttle_pickup'){
			    tbjQuery('div#shuttle_pickup_extra_wrapper').html(response.msg);   
			}
			else if(type=='shuttle_dropoff'){
			    tbjQuery('div#shuttle_dropoff_extra_wrapper').html(response.msg);
			}
                        // show car description in tooltips
                        tbjQuery( 'a.field_desc' ).tooltip({
                            track: true
                        });
			
			tbjQuery(".seat_options").selectbox();
                    }
                }
        });
    }
    // This function collects extras fir swapped routes
    tbjQuery.fn.getSwappedRouteExtras = function(type) {
        // if there is a previous ajax search, then we abort it and then set xhr to null
        if( xhr != null ) {
            xhr.abort();
            xhr = null;
        }
        var passingData = tbjQuery('#price_form').serialize();
        
        xhr = tbjQuery.ajax({
                type: "POST",
                url: 'index.php?option=com_taxibooking&task=getSwappedExtraList',
                data: passingData,
                dataType: 'json',
                async: false,
                beforeSend: function(){
                    // load the ajax loading image
                    tbjQuery('#route_loader').show();
                    
                    tbjQuery('div#routefrom_extra_wrapper').html('');
                    tbjQuery('div#routeto_extra_wrapper').html('');
                },
                complete: function(){
                },
                success: function(response){
                    // clear out the ajax loading image
                    tbjQuery('#route_loader').hide();
                    
                    if(response.error==0)
                    {
                        tbjQuery('div#routefrom_extra_wrapper').html(response.pickupextra);   
                        tbjQuery('div#routeto_extra_wrapper').html(response.dropoffextra);
                        // show car description in tooltips
                        tbjQuery( 'a.field_desc' ).tooltip({
                            track: true
                        });
			tbjQuery(".seat_options").selectbox();
                    }
                }
        });
    }
    tbjQuery.fn.getReturnExtras = function() {
	
	if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
	    tbjQuery.ajax({
                type: "POST",
		url: 'index.php?option=com_taxibooking&controller=onepage&task=getReturnExtraList',
		data: tbjQuery('#price_form').serialize(),
		dataType: 'json',
		async: false,
		beforeSend: function(){
		    // load the ajax loading image
		    tbjQuery('div#return_extra_wrapper').show().html(tbjQuery('#route_loader').html());
		},
		complete: function(){
		},
		success: function(response){
		    // clear out the ajax loading image
		    tbjQuery('#route_loader').hide();
		    
		    if(response.error==0)
		    {
			tbjQuery('div#return_extra_wrapper').show().html(response.msg);   
			// show car description in tooltips
			tbjQuery( 'a.field_desc' ).tooltip({
			    track: true
			});
			tbjQuery(".seat_options").selectbox();
		    }
		}
	    });
	}
	else {
	    return false;
	}
    }
    // order date picker for jquery datepicker
    tbjQuery( "#orderdate_shuttle" ).datepicker({
	dateFormat: tbjQuery('#date_format').val(),
	minDate: new Date(),
	closeText: "X",
	showButtonPanel: true,
	beforeShowDay: function(date) {
	    var string = tbjQuery.datepicker.formatDate('yy-mm-dd', date);
	    var isDisabled = (disabledDates.indexOf(string) == -1); // used to disable if its an holiday or weekend
	    return [isDisabled];
	},
	onSelect: function(dateText, inst){
	    
	    // fetch available time options for shuttle booking
	    if(tbjQuery('#booking_type').val()=='shuttle'){
		tbjQuery.fn.getShuttleTimeOptions(1);  // clear_previous_selection = 0
	    }
	}
    })
    if(tbjQuery('#datepicker_type').val()=='jquery')
    {
	var locale = tbjQuery('#locale').val();
	tbjQuery.datepicker.setDefaults( tbjQuery.datepicker.regional[ locale ] );
	tbjQuery( "#orderdatereturn" ).datepicker({
	    dateFormat: tbjQuery('#date_format').val(),
	    minDate: new Date(),
	    closeText: "X",
	    showButtonPanel: true,
	    beforeShowDay: function(date) {
		var string = tbjQuery.datepicker.formatDate('yy-mm-dd', date);
		var isDisabled = (disabledDates.indexOf(string) == -1); // used to disable if its an holiday or weekend
		return [isDisabled];
	    },
	    onSelect: function(dateText, inst){
		if(!tbjQuery.fn.compareDate()) {
		    if(tbjQuery('#datepicker_type').val()=='jquery'){
			if(tbjQuery("#selPtHr1").val() >= tbjQuery("#return_selPtHr2").val()) {
			    tbjQuery("#return_selPtHr2").val(HRS_TXT);
			    tbjQuery("#return_selPtMn2").val(MINS_TXT);
			}
		    }
		    else {
			if(tbjQuery("#selPtHr1").val() >= tbjQuery("#selPtHr2").val()) {
			    tbjQuery("#selPtHr2").val('');
			    tbjQuery("#selPtMin2").val('');
			}
		    }
		}
	    }
	})
	if(tbjQuery( "#orderdate" ).val()!=""&&tbjQuery( "#orderdate" ).val()!="Date") {
	    var dateText = tbjQuery( "#orderdate" ).val();
	    if(tbjQuery('#date_format').val()=='dd-mm-yy'){
		var order_date_day = dateText.substring(0, 2);
		var order_date_month = dateText.substring(3, 5);
	    }
	    else {
		var order_date_month = dateText.substring(0, 2);
		var order_date_day  = dateText.substring(3, 5);
	    }
	    
	    var order_date_year = dateText.substring(6, 10);
	    tbjQuery( "#orderdatereturn" ).datepicker( "option", "minDate", new Date(order_date_year, parseInt(order_date_month)-1, order_date_day) );
	}
	tbjQuery( "#orderdate" ).datepicker({
	    dateFormat: tbjQuery('#date_format').val(),
	    minDate: new Date(),
	    closeText: "X",
	    showButtonPanel: true,
	    beforeShowDay: function(date) {
		var string = tbjQuery.datepicker.formatDate('yy-mm-dd', date);
		var isDisabled = (disabledDates.indexOf(string) == -1); // used to disable if its an holiday or weekend
		return [isDisabled];
	    },
	    onSelect: function(dateText, inst){
		if(tbjQuery('#date_format').val()=='dd-mm-yy'){
		    var order_date_day = dateText.substring(0, 2);
		    var order_date_month = dateText.substring(3, 5);
		}
		else {
		    var order_date_month = dateText.substring(0, 2);
		    var order_date_day  = dateText.substring(3, 5);
		}
		
		var order_date_year = dateText.substring(6, 10);
		tbjQuery( "#orderdatereturn" ).datepicker( "option", "minDate", new Date(order_date_year, parseInt(order_date_month)-1, order_date_day) ).val(ORDER_RETURN_DATE_TXT);
	    }
	})
	var hrsDialog;
	tbjQuery('input#selPtHr1').focus(function (e) {
	    tbjQuery('div#hrs-wrapper ul.hrs-list').remove();
	    var min_pickup_hr = tbjQuery('#min_pickup_hr').val();
	    var time_format = tbjQuery('#time_format').val();
	    if(time_format=='12hr'){
		var min = 1;
		var max = 12;
	    }
	    else {
		var min = 0;
		var max = 23;
	    }
	    var list = tbjQuery('<ul class="hrs-list">');
	    for(var i = min; i <= max; i++){
		var value = (i.toString().length<2) ? "0"+i : i;
		list.append(tbjQuery("<li>").html('<input type="button" class="hrs-btn" value="'+value+'" />'));
	    }
	    tbjQuery('div#hrs-wrapper').append(list);
	    hrsDialog = tbjQuery( "#dialog-hrs" ).dialog({
		autoOpen: false,
		height: 300,
		width: 250,
		modal: true,
		buttons: {},
		close: function() {
		    hrsDialog.dialog( "close" );
		}
	    });
	    hrsDialog.dialog( "open" );
	})
	tbjQuery(document).on("click", 'input:button.hrs-btn', function (e) {
	    tbjQuery('input#selPtHr1').val(tbjQuery(this).val());
	    hrsDialog.dialog( "close" );
	})
	var minsDialog;
	tbjQuery('input#selPtMn1').focus(function (e) {
	    tbjQuery('div#mins-wrapper ul.mins-list').remove();
	    var time_format = tbjQuery('#time_format').val();
	    var min = 0;
	    var max = 59;
	    var list = tbjQuery('<ul class="mins-list">');
	    for(var i = min; i <= max; i=i+5){
		var value = (i.toString().length<2) ? "0"+i : i;
		list.append(tbjQuery("<li>").html('<input type="button" class="mins-btn" value="'+value+'" />'));
	    }
	    tbjQuery('div#mins-wrapper').append(list);
	    minsDialog = tbjQuery( "#dialog-mins" ).dialog({
		autoOpen: false,
		height: 300,
		width: 250,
		modal: true,
		buttons: {},
		close: function() {
		    minsDialog.dialog( "close" );
		}
	    });
	    minsDialog.dialog( "open" );
	})
	tbjQuery(document).on("click", 'input:button.mins-btn', function (e) {
	    tbjQuery('input#selPtMn1').val(tbjQuery(this).val());
	    minsDialog.dialog( "close" );
	})
	var returnHrsDialog;
	tbjQuery('input#return_selPtHr2').focus(function (e) {
	    tbjQuery('div#return-hrs-wrapper ul.hrs-list').remove();
	    var min_pickup_hr = tbjQuery('#min_pickup_hr').val();
	    var time_format = tbjQuery('#time_format').val();
	    if(time_format=='12hr'){
		if(tbjQuery.fn.compareDate()) { // return date is greater than pickup date
		    var min = 1;
		}
		else {
		    var min = parseInt(tbjQuery('input#selPtHr1').val())+1;
		}
		var max = 12;
	    }
	    else {
		if(tbjQuery.fn.compareDate()) { // return date is greater than pickup date
		    var min = 0;
		}
		else {
		    var min = parseInt(tbjQuery('input#selPtHr1').val())+1;
		}
		var max = 23;
	    }
	    var list = tbjQuery('<ul class="hrs-list">');
	    for(var i = min; i <= max; i++){
		var value = (i.toString().length<2) ? "0"+i : i;
		list.append(tbjQuery("<li>").html('<input type="button" class="return-hrs-btn" value="'+value+'" />'));
	    }
	    tbjQuery('div#return-hrs-wrapper').append(list);
	    returnHrsDialog = tbjQuery( "#dialog-return-hrs" ).dialog({
		autoOpen: false,
		height: 300,
		width: 250,
		modal: true,
		buttons: {},
		close: function() {
		    returnHrsDialog.dialog( "close" );
		}
	    });
	    returnHrsDialog.dialog( "open" );
	})
	tbjQuery(document).on("click", 'input:button.return-hrs-btn', function (e) {
	    tbjQuery('input#return_selPtHr2').val(tbjQuery(this).val());
	    returnHrsDialog.dialog( "close" );
	})
	var returnMinsDialog;
	tbjQuery('input#return_selPtMn2').focus(function (e) {
	    tbjQuery('div#return-mins-wrapper ul.mins-list').remove();
	    var time_format = tbjQuery('#time_format').val();
	    var min = 0;
	    var max = 59;
	    var list = tbjQuery('<ul class="mins-list">');
	    for(var i = min; i <= max; i=i+5){
		var value = (i.toString().length<2) ? "0"+i : i;
		list.append(tbjQuery("<li>").html('<input type="button" class="return-mins-btn" value="'+value+'" />'));
	    }
	    tbjQuery('div#return-mins-wrapper').append(list);
	    returnMinsDialog = tbjQuery( "#dialog-return-mins" ).dialog({
		autoOpen: false,
		height: 300,
		width: 250,
		modal: true,
		buttons: {},
		close: function() {
		    returnMinsDialog.dialog( "close" );
		}
	    });
	    returnMinsDialog.dialog( "open" );
	})
	tbjQuery(document).on("click", 'input:button.return-mins-btn', function (e) {
	    tbjQuery('input#return_selPtMn2').val(tbjQuery(this).val());
	    returnMinsDialog.dialog( "close" );
	})
    }
    // Inline date functions
    tbjQuery.fn.attachPluginPickupMonth = function(){
	tbjQuery("#pickup_month").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var return_year = parseInt(tbjQuery('#return_year').val());
		var order_date_year = parseInt(tbjQuery('#pickup_year').val());
		tbjQuery.fn.setPickupDate();
		if(return_year > order_date_year){
		    tbjQuery.fn.resetReturnMonth();
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnMonth();
		    tbjQuery.fn.setReturnDay();
		}
	    }
	}).selectbox('attach');
    }
    tbjQuery.fn.attachPluginPickupDay = function(){
	tbjQuery("#pickup_day").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var order_date_month = parseInt(tbjQuery('#pickup_month').val());
		var return_month = parseInt(tbjQuery('#return_month').val());
		tbjQuery.fn.setPickupDate();
		if(return_month > order_date_month){
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnDay();
		}
	    }
	}).selectbox('attach');
    }
    tbjQuery.fn.attachPluginReturnYear = function(){
	tbjQuery("#return_year").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var return_year = parseInt(tbjQuery("#return_year").val());
		var order_date_year = parseInt(tbjQuery('#pickup_year').val());
		if(return_year > order_date_year){
		    tbjQuery.fn.resetReturnMonth();
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnMonth();
		    tbjQuery.fn.setReturnDay();
		}
	    }
	}).selectbox('attach');
    }
    tbjQuery.fn.attachPluginReturnMonth = function(){
	tbjQuery("#return_month").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var return_month = parseInt(tbjQuery("#return_month").val());
		var order_date_month = parseInt(tbjQuery('#pickup_month').val());
		if(return_month > order_date_month){
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnDay();
		}
	    }
	}).selectbox('attach');
    }
    tbjQuery.fn.setReturnYear = function() {
        var pickup_year = tbjQuery('#pickup_year').val();
	tbjQuery('#return_year').selectbox('detach');
        tbjQuery("#return_year option").each(function()
        {
            if(tbjQuery(this).val()<parseInt(pickup_year)){
                tbjQuery(this).attr('disabled', true);
            }
            else {
                tbjQuery(this).attr('disabled', false);
            }
        })
        tbjQuery('#return_year').val(pickup_year);
	tbjQuery.fn.attachPluginReturnYear();
    }
    tbjQuery.fn.setReturnMonth = function() {
        var pickup_month = tbjQuery('#pickup_month').val();
	tbjQuery('#return_month').selectbox('detach');
        tbjQuery("#return_month option").each(function()
        {
            if(tbjQuery(this).val()<parseInt(pickup_month)){
                tbjQuery(this).attr('disabled', true);
            }
            else {
                tbjQuery(this).attr('disabled', false);
            }
        })
        tbjQuery('#return_month').val(pickup_month);
	tbjQuery.fn.attachPluginReturnMonth();
    }
    tbjQuery.fn.resetReturnMonth = function() {
	tbjQuery('#return_month').selectbox('detach');
        tbjQuery("#return_month option").each(function()
        {
            tbjQuery(this).attr('disabled', false);
        })
        tbjQuery('#return_month').val(1);
	tbjQuery.fn.attachPluginReturnMonth();
    }
    tbjQuery.fn.setReturnDay = function() {
        var pickup_day = tbjQuery('#pickup_day').val();
	tbjQuery('#return_day').selectbox('detach');
        tbjQuery("#return_day option").each(function()
        {
            if(tbjQuery(this).val()<parseInt(pickup_day)){
                tbjQuery(this).attr('disabled', true);
            }
            else {
                tbjQuery(this).attr('disabled', false);
            }
        })
        tbjQuery('#return_day').val(pickup_day);
	tbjQuery('#return_day').selectbox({
	    classHolder: "sbHolder dateinline"
	}).selectbox('attach');
    }
    tbjQuery.fn.resetReturnDay = function() {
	tbjQuery('#return_day').selectbox('detach');
        tbjQuery("#return_day option").each(function()
        {
            tbjQuery(this).attr('disabled', false);
        })
        tbjQuery('#return_day').val(1);
	tbjQuery('#return_day').selectbox({
	    classHolder: "sbHolder dateinline"
	}).selectbox('attach');
    }
    tbjQuery.fn.setPickupDate = function() {
	var pickup_year = tbjQuery('#pickup_year').val();
        var pickup_month = tbjQuery('#pickup_month').val();
	var pickup_day = tbjQuery('#pickup_day').val();
	var currentDate = new Date();
        var day = currentDate.getDate();
        var month = currentDate.getMonth();
	var year = currentDate.getFullYear();
	// first detach the selectbox plugin
	tbjQuery('#pickup_month').selectbox('detach');
	tbjQuery('#pickup_day').selectbox('detach');
	
	if(pickup_year > year){
	    tbjQuery("#pickup_month option").each(function()
	    {
		tbjQuery(this).attr('disabled', false);
	    })
	    tbjQuery("#pickup_day option").each(function()
	    {
		tbjQuery(this).attr('disabled', false);
	    })
	}
	else {
	    tbjQuery("#pickup_month option").each(function()
	    {
		if(tbjQuery(this).val()<(parseInt(month)+1)){
		    tbjQuery(this).attr('disabled', true);
		}
		else {
		    tbjQuery(this).attr('disabled', false);
		}
	    })
	    if(pickup_month > (parseInt(month)+1)){
		tbjQuery("#pickup_day option").each(function()
		{
		    tbjQuery(this).attr('disabled', false);
		})
	    }
	    else {
		tbjQuery("#pickup_day option").each(function()
		{
		    if(tbjQuery(this).val()<day){
			tbjQuery(this).attr('disabled', true);
		    }
		    else {
			tbjQuery(this).attr('disabled', false);
		    }
		})
	    }
	}
	// attach the selectbox plugin again
	tbjQuery.fn.attachPluginPickupMonth();
	tbjQuery.fn.attachPluginPickupDay();
    }
    tbjQuery.fn.setReturnDate = function() {
	var pickup_day = parseInt(tbjQuery('#pickup_day').val());
	var pickup_month = parseInt(tbjQuery('#pickup_month').val());
	var pickup_year = parseInt(tbjQuery('#pickup_year').val());
	var return_day = parseInt(tbjQuery('#return_day').val());
	var return_month = parseInt(tbjQuery('#return_month').val());
	var return_year = parseInt(tbjQuery('#return_year').val());
	tbjQuery('#return_year').selectbox('detach');
	tbjQuery('#return_month').selectbox('detach');
	tbjQuery('#return_day').selectbox('detach');
	tbjQuery("#return_year option").each(function()
	{
	    if(tbjQuery(this).val()<pickup_year){
		tbjQuery(this).attr('disabled', true);
	    }
	    else {
		tbjQuery(this).attr('disabled', false);
	    }
	})
	if(return_year > pickup_year){
	    
	    tbjQuery("#return_month option").each(function()
	    {
		tbjQuery(this).attr('disabled', false);
	    })
	    tbjQuery("#return_day option").each(function()
	    {
		tbjQuery(this).attr('disabled', false);
	    })
	}
	else {
	    tbjQuery("#return_month option").each(function()
	    {
		if(tbjQuery(this).val()<pickup_month){
		    tbjQuery(this).attr('disabled', true);
		}
		else {
		    tbjQuery(this).attr('disabled', false);
		}
	    })
	    if(return_month > pickup_month){
		tbjQuery("#return_day option").each(function()
		{
		    tbjQuery(this).attr('disabled', false);
		})
	    }
	    else {
		tbjQuery("#return_day option").each(function()
		{
		    if(tbjQuery(this).val()<pickup_day){
			tbjQuery(this).attr('disabled', true);
		    }
		    else {
			tbjQuery(this).attr('disabled', false);
		    }
		})
	    }
	}
	tbjQuery.fn.attachPluginReturnYear();
	tbjQuery.fn.attachPluginReturnMonth();
	tbjQuery('#return_day').selectbox({
		classHolder: "sbHolder dateinline"
	}).selectbox('attach');
    }
    tbjQuery.fn.hidePastDays = function(){
        var currentDate = new Date();
        var day = currentDate.getDate();
        var month = currentDate.getMonth();
        
	tbjQuery('#pickup_month').selectbox('detach');
	tbjQuery('#pickup_day').selectbox('detach');
	
        tbjQuery("#pickup_day option").each(function()
        {
            if(tbjQuery(this).val()<parseInt(day)){
                tbjQuery(this).attr('disabled', true);
            }
            else {
                tbjQuery(this).attr('disabled', false);
            }
        })
        tbjQuery("#pickup_month option").each(function()
        {
            if(tbjQuery(this).val()<(parseInt(month)+1)){
                tbjQuery(this).attr('disabled', true);
            }
            else {
                tbjQuery(this).attr('disabled', false);
            }
        })
	// attach the selectbox plugin again
	tbjQuery.fn.attachPluginPickupMonth();
	tbjQuery.fn.attachPluginPickupDay();
        if(tbjQuery('#returnjurney').is(':checked'))
        {
            var pickup_day = parseInt(tbjQuery('#pickup_day').val());
            var pickup_month = parseInt(tbjQuery('#pickup_month').val());
	    var pickup_year = parseInt(tbjQuery('#pickup_year').val());
	    var return_day = parseInt(tbjQuery('#return_day').val());
            var return_month = parseInt(tbjQuery('#return_month').val());
	    var return_year = parseInt(tbjQuery('#return_year').val());
	    tbjQuery('#return_year').selectbox('detach');
	    tbjQuery('#return_month').selectbox('detach');
	    tbjQuery('#return_day').selectbox('detach');
	    
	    tbjQuery("#return_year option").each(function()
	    {
		if(tbjQuery(this).val()<pickup_year){
		    tbjQuery(this).attr('disabled', true);
		}
		else {
		    tbjQuery(this).attr('disabled', false);
		}
	    })
	    if(return_year > pickup_year){
		tbjQuery("#return_month option").each(function()
		{
		    tbjQuery(this).attr('disabled', false);
		})
		tbjQuery("#return_day option").each(function()
		{
		    tbjQuery(this).attr('disabled', false);
		})
	    }
	    else {
		tbjQuery("#return_month option").each(function()
		{
		    if(tbjQuery(this).val()<pickup_month){
			tbjQuery(this).attr('disabled', true);
		    }
		    else {
			tbjQuery(this).attr('disabled', false);
		    }
		})
		if(return_month > pickup_month){
		    tbjQuery("#return_day option").each(function()
		    {
			tbjQuery(this).attr('disabled', false);
		    })
		}
		else {
		    tbjQuery("#return_day option").each(function()
		    {
			if(tbjQuery(this).val()<pickup_day){
			    tbjQuery(this).attr('disabled', true);
			}
			else {
			    tbjQuery(this).attr('disabled', false);
			}
		    })
		}
	    }
	    tbjQuery.fn.attachPluginReturnYear();
	    tbjQuery.fn.attachPluginReturnMonth();
	    
	    tbjQuery('#return_day').selectbox({
		    classHolder: "sbHolder dateinline"
	    }).selectbox('attach');
        }
    }
    if(tbjQuery('#datepicker_type').val()=='inline')
    {
	// pickup section
	tbjQuery("#pickup_year").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		    tbjQuery.fn.setPickupDate();
		    tbjQuery.fn.setReturnYear();
		    var pickup_year = parseInt(tbjQuery('#pickup_year').val());
		    var currentDate = new Date();
		    var day = currentDate.getDate();
		    var month = currentDate.getMonth();
		    var year = currentDate.getFullYear();
		    tbjQuery('#pickup_month').selectbox('detach');
		    tbjQuery('#pickup_day').selectbox('detach');
		    if(pickup_year > year){
			tbjQuery('#pickup_day').val(1);
			tbjQuery('#pickup_month').val(1);
		    }
		    else {
			tbjQuery('#pickup_day').val(day);
			tbjQuery('#pickup_month').val(month+1);
		    }
		    tbjQuery.fn.attachPluginPickupMonth();
		    tbjQuery.fn.attachPluginPickupDay();
	    }
	});
	tbjQuery("#pickup_month").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var return_year = parseInt(tbjQuery('#return_year').val());
		var order_date_year = parseInt(tbjQuery('#pickup_year').val());
		
		tbjQuery.fn.setPickupDate();
		
		if(return_year > order_date_year){
		    tbjQuery.fn.resetReturnMonth();
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnMonth();
		    tbjQuery.fn.setReturnDay();
		}
	    }
	});
	tbjQuery("#pickup_day").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var order_date_month = parseInt(tbjQuery('#pickup_month').val());
		var return_month = parseInt(tbjQuery('#return_month').val());
		
		tbjQuery.fn.setPickupDate();
		if(return_month > order_date_month){
		    tbjQuery.fn.resetReturnDay();
		}
		else {
		    tbjQuery.fn.setReturnDay();
		}
	    }
	});
	// return section
	tbjQuery("#return_year").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		var return_year = parseInt(tbjQuery("#return_year").val());
		var order_date_year = parseInt(tbjQuery('#pickup_year').val());
		tbjQuery.fn.setReturnDate();
	    }
	});
	tbjQuery("#return_month").selectbox({
	    classHolder: "sbHolder dateinline",
	    onChange: function (val, inst) {
		    tbjQuery.fn.setReturnDate();
	    }
	});
	// hide all past dates
	tbjQuery.fn.hidePastDays();
    }
    tbjQuery("#return_wait_hr").selectbox({
	classHolder: "sbHolder medium",
	onChange: function (val, inst) {
	    if(val=='-1'){
		tbjQuery('div#return_datepicker_wrapper').show();
	    }
	    else{
		tbjQuery('div#return_datepicker_wrapper').hide();
		tbjQuery('#orderdatereturn').val(ORDER_RETURN_DATE_TXT);
		tbjQuery('#selPtHr2').selectbox('detach').val(HRS_TXT).selectbox('attach');
		tbjQuery('#selPtMn2').selectbox('detach').val(MINS_TXT).selectbox('attach');
		tbjQuery('#return_selPtHr2').val(HRS_TXT);
		tbjQuery('#return_selPtMn2').val(MINS_TXT);
	    }
	}
    });
    tbjQuery('#returnjurney').change(function(){
        if(tbjQuery(this).is(':checked'))
        {
	    if(tbjQuery('#datepicker_type').val()=='jquery')
	    {
		var orderdate = tbjQuery('#orderdate').val();
		if(orderdate=='' || orderdate=="Date")
		{
		    alert('Please select Departing Date first.');
		    tbjQuery(this).attr('checked', false);
		}
		else
		{
		    tbjQuery('div#return_date_wrapper').show();
		    if(tbjQuery('#date_format').val()=='dd-mm-yy'){
			var order_date_day = orderdate.substring(0, 2);
			var order_date_month = orderdate.substring(3, 5);
		    }
		    else {
			var order_date_month = orderdate.substring(0, 2);
			var order_date_day = orderdate.substring(3, 5);
		    }
		    var order_date_year = orderdate.substring(6, 10);
		    tbjQuery( "#orderdatereturn" ).datepicker( "option", "minDate", new Date(order_date_year, parseInt(order_date_month)-1, order_date_day) ).val(ORDER_RETURN_DATE_TXT);
		}
	    }
	    else if(tbjQuery('#datepicker_type').val()=='inline')
	    {
		tbjQuery('div#return_date_wrapper').show();
		
		tbjQuery.fn.setReturnYear();
                tbjQuery.fn.setReturnMonth();
                tbjQuery.fn.setReturnDay();
	    }
	    // collect return pickup and dropoff extras
	    if(tbjQuery('#show_return_extras').val()==1 && (tbjQuery('#booking_type').val()=='address' || tbjQuery('#booking_type').val()=='offers'))
	    {
		tbjQuery.fn.getReturnExtras();
	    }
        }
        else
        {
            tbjQuery('div#return_date_wrapper').hide();
            tbjQuery('#orderdatereturn').val(ORDER_RETURN_DATE_TXT);
            tbjQuery('#selPtHr2').selectbox('detach').val(HRS_TXT).selectbox('attach');
	    tbjQuery('#selPtMn2').selectbox('detach').val(MINS_TXT).selectbox('attach');
	    tbjQuery('#return_selPtHr2').val(HRS_TXT);
	    tbjQuery('#return_selPtMn2').val(MINS_TXT);
	    // clear out the return extras
	    tbjQuery('div#return_extra_wrapper').html('').hide();
        }
    })
    
    // This function collects extras fir swapped routes
    tbjQuery.fn.compareDate = function() {
	if(tbjQuery('#datepicker_type').val()=='jquery')
	{
	    var order_date = tbjQuery('#orderdate').val();
	    var order_return_date = tbjQuery('#orderdatereturn').val();
	    
	    if(tbjQuery('#date_format').val()=='dd-mm-yy'){
		var order_date_day = order_date.substring(0, 2);
		var order_date_month = order_date.substring(3, 5);
	    }
	    else {
		var order_date_month = order_date.substring(0, 2);
		var order_date_day = order_date.substring(3, 5);
	    }
	    var order_date_year = order_date.substring(6, 10);
	    if(tbjQuery('#date_format').val()=='dd-mm-yy'){
		var order_return_date_day = order_return_date.substring(0, 2);
		var order_return_date_month = order_return_date.substring(3, 5);
	    }
	    else {
		var order_return_date_month = order_return_date.substring(0, 2);
		var order_return_date_day = order_return_date.substring(3, 5);
	    }
	    var order_return_date_year = order_return_date.substring(6, 10);
	}
	else if(tbjQuery('#datepicker_type').val()=='inline')
	{
	    var order_date_day = tbjQuery('#pickup_day').val();
	    var order_date_month = tbjQuery('#pickup_month').val();
	    var order_date_year = tbjQuery('#pickup_year').val();
	    
	    var order_return_date_day = tbjQuery('#return_day').val();
	    var order_return_date_month = tbjQuery('#return_month').val();
	    var order_return_date_year = tbjQuery('#return_year').val();
	}
        if(order_return_date_year>order_date_year) {
            return true;
        }
        else {
            if(order_return_date_month>order_date_month) {
                return true;
            }
            else {
                if(order_return_date_day>order_date_day) {
                    return true;
                }
                else {
                    return false;
                }
            }
        }
    }
    tbjQuery("#selPtHr2").selectbox({
	onChange: function (val, inst) {
	    if(!tbjQuery.fn.compareDate()) {
		if(tbjQuery('#datepicker_type').val()=='jquery'){
		    if(tbjQuery("#selPtHr1").val() >= tbjQuery("#return_selPtHr2").val()) {
			tbjQuery("#return_selPtHr2").val(HRS_TXT);
			tbjQuery("#return_selPtMn2").val(MINS_TXT);
		    }
		}
		else {
		    if(tbjQuery("#selPtHr1").val() >= tbjQuery("#selPtHr2").val()) {
			tbjQuery("#selPtHr2").val('');
			tbjQuery("#selPtMin2").val('');
		    }
		}
	    }
	}
    });
})
function get_user_location(scope, obj)
{
    var geocoder = new google.maps.Geocoder();
    if(scope=='pickup'){
	if(navigator.geolocation) {
	    navigator.geolocation.getCurrentPosition(function(position) {
		if( tbConfig.pickup_in_area_operation==1 || tbConfig.pickup_dropoff_in_area_operation==1) {
		    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(position.coords.latitude,position.coords.longitude), areaOfOperation)) {
			showAreaOperationPopup();
			return false;
		    }
		}
		tbjQuery('#address_from_lat').val(position.coords.latitude);
		tbjQuery('#address_from_lng').val(position.coords.longitude);
		tbjQuery.fn.unsetRoute();
		tbjQuery.fn.unsetHourlyHire();
		// set booking type
		tbjQuery('div#pickup_extra_wrapper').html('');
		tbjQuery('#booking_type').val('address');
		tbjQuery("#address_from").removeClass('incorrect');
		// regenerate return route with extra if Return Journey is selected
		if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
		    tbjQuery.fn.getReturnExtras();
		}
		tbjQuery.fn.getExtras('address_pickup');
		var latlng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
		geocoder.geocode({'latLng': latlng}, function(results, status) {
		    if (status == google.maps.GeocoderStatus.OK) {
			if (results[0]) {
			    tbjQuery('#address_from').val(results[0].formatted_address);
			} else {
			    alert('We could not detect your location');
			}
		    } else {
			alert('Geocoder failed due to: ' + status);
		    }
		});
	    }, function() {
	    });
	}
    }
    if(scope=='dropoff'){
	if(navigator.geolocation) {
	    navigator.geolocation.getCurrentPosition(function(position) {
		if( tbConfig.dropoff_in_area_operation==1 || tbConfig.pickup_dropoff_in_area_operation==1) {
		    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(position.coords.latitude,position.coords.longitude), areaOfOperation)) {
			showAreaOperationPopup();
			return false;
		    }
		}
		tbjQuery('#address_to_lat').val(position.coords.latitude);
		tbjQuery('#address_to_lng').val(position.coords.longitude);
		tbjQuery.fn.unsetRoute();
		tbjQuery.fn.unsetHourlyHire();
		// set booking type
		tbjQuery('div#dropoff_extra_wrapper').html('');
		tbjQuery('#booking_type').val('address');
		tbjQuery("#address_to").removeClass('incorrect');
		// regenerate return route with extra if Return Journey is selected
		if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
		    tbjQuery.fn.getReturnExtras();
		}
		tbjQuery.fn.getExtras('address_dropoff');
		var latlng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
		geocoder.geocode({'latLng': latlng}, function(results, status) {
		    if (status == google.maps.GeocoderStatus.OK) {
			if (results[0]) {
			    tbjQuery('#address_to').val(results[0].formatted_address);
			} else {
			    alert('We could not detect your location');
			}
		    } else {
			alert('Geocoder failed due to: ' + status);
		    }
		});
	    }, function() {
	    });
	}
    }
    if(scope=='waypoints'){
	var stop_parent = tbjQuery(obj).closest('div.stops_wrap');
	if(navigator.geolocation) {
	    navigator.geolocation.getCurrentPosition(function(position) {
		tbjQuery(stop_parent).find('#waypoint_lat').val(position.coords.latitude);
		tbjQuery(stop_parent).find('#waypoint_lng').val(position.coords.longitude);
		tbjQuery.fn.unsetRoute();
		tbjQuery.fn.unsetHourlyHire();
		tbjQuery('#booking_type').val('address');
		var latlng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);
		geocoder.geocode({'latLng': latlng}, function(results, status) {
		    if (status == google.maps.GeocoderStatus.OK) {
			if (results[0]) {
			    tbjQuery(stop_parent).find('.waypoints').val(results[0].formatted_address);
			} else {
			    alert('We could not detect your location');
			}
		    } else {
			alert('Geocoder failed due to: ' + status);
		    }
		});
	    }, function() {
	    });
	}
    }
}
function showAreaOperationPopup(){
    if (isTouchSupported || isTouchSupportedIE10) {
	// this is a mobile device
	tbjQuery.fancybox({
	    fitToView	: true,
	    autoCenter	: true,
	    autoSize	: false,
	    autoHeight	: false,
	    autoWidth	: false,
	    transitionIn	: 'none',
	    transitionOut	: 'none',
	    type		: 'iframe',
	    href		: BASE_URL+'index.php?option=com_taxibooking&view=taxibooking&layout=areaoperation&tmpl=component',
	    hideOnOverlayClick	: false,
	    helpers: {
		    overlay: {
			    locked: true
		    }
	    }
	});
    } else {
	// this is desktop device
	tbjQuery.fancybox({
		width		: '100%',
		height		: '80%',
		autoScale	: false,
		transitionIn	: 'none',
		transitionOut	: 'none',
		type		: 'iframe',
		href		: BASE_URL+'index.php?option=com_taxibooking&view=taxibooking&layout=areaoperation&tmpl=component',
		hideOnOverlayClick	: false
	});
    }
}