<?php
/**
* @package		Taxi Booking
* @copyright	Copyright (C) 2011 KANEV.CO.UK All rights reserved.
* @license		GNU/GPL, see license.txt
* Taxi Booking is open source software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*This program is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*GNU General Public License for more details.
*You should have received a copy of the GNU General Public License
*along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class modTaxiBookingHelper
{
	public static function getList($params)
	{
		$app = JFactory::getApplication();

		$db = JFactory::getDbo();
		$user		= JFactory::getUser();
		$userId		= (int) $user->get('id');

                $lists = modTaxiBookingHelper::_buildEditLists($params);

		return $lists;
	}
	
	public static function _getDefaultTabIndex($lists)
	{
		$elsettings =  booking_helper::config();
		
		$available_booking_types = array();
        
		if((int)$elsettings->show_address_tab==1){
		    $available_booking_types[] = 'address';
		}
		if((int)$elsettings->show_offers_tab==1 && $lists['has_any_route']){
		    $available_booking_types[] = 'offers';
		}
		if((int)$elsettings->show_hourly_tab==1 && booking_helper::is_hourly_rate_enabled()){
		    $available_booking_types[] = 'hourly';
		}
		if((int)$elsettings->show_shuttles_tab==1 && booking_helper::is_shuttles_enabled()){
		    $available_booking_types[] = 'shuttle';
		}
		
		$default_tab_index = 0;
		$default_tab_title = 'address';
		
		if(!empty($available_booking_types)){
		    foreach($available_booking_types as $k => $v){
			    if($v==$elsettings->default_tab){
				$default_tab_index = $k;
				$default_tab_title = $v;
				break;
			    }
		    }
		}
		
		return array($default_tab_index,$default_tab_title) ;
	}
        
        /**
	* Creates the item submit form
	*
	* @since 1.0
	*/
	public static function _buildEditLists($params)
	{
		$session =  JFactory::getSession();
		$elsettings =  booking_helper::config();
	
		$db = JFactory::getDBO();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();
	
		$airports1 = $session->get('airports1', '');
		$seaports1 = $session->get('seaports1', '');
		
		$airports2 = $session->get('airports2', '');
		$seaports2 = $session->get('seaports2', '');
		
		//$hourly_hr = $session->get('hourly_hr', 0);
		//$hourly_min = $session->get('hourly_min', 0);
		$hourly_hr = $hourly_min = 0;
		
		$passengers = $elsettings->default_adult_seat;
		$infantseats = $session->get('infantseats', 0);
		$chseats = $session->get('chseats', 0);
		$boosterseats = $session->get('boosterseats', 0);
		$suitcases = $session->get('suitcases', 0);
	
		//build selectlist
		$lists = array();
		
		if((int)$elsettings->show_address_tab==1)
		{
			$pickup_poi = array();
			$pickup_poi[] = JHTML::_('select.option', '', JText::_('SELECT PLACE'));
			
			$dropoff_poi = array();
			$dropoff_poi[] = JHTML::_('select.option', '', JText::_('SELECT PLACE'));
		
			// get all the points of interest
			$query = 'SELECT poi.id, poi.title, poi.lat, poi.long, poi.show_on_pickup, poi.show_on_dropoff, poi_cat.image, poi_cat.title AS cattitle'
				. ' FROM #__taxibooking_points AS poi'
				. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
				. ' WHERE poi.published = 1'
				. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
				. ' ORDER BY poi.title ASC'
			;
			$db->setQuery($query);
			if(!$db->query()){
				JError::raiseError(500, $db->getErrorMsg());
				return false;
			}
			$places = $db->loadObjectList();
			
			$lists['all_places_data'] = $places;
		
			$pickup_poi_options_html = '';
			$dropoff_poi_options_html = '';
			
			$pickup_poi_json_arr = array();
			$dropoff_poi_json_arr = array();
			
			if (!empty($places))
			{
				foreach ($places as $place)
				{
					// enlist pickup poi
					if((int)$place->show_on_pickup==1)
					{
						$pickup_poi_options_html .= '<div class="poi_link" data-poiid="'.$place->id.'" data-poilat="'.$place->lat.'" data-poilng="'.$place->long.'">';
						$pickup_poi_options_html .= ($place->image!="") ? '<img src="'.JURI::base().$place->image.'" alt="'.$place->cattitle.'" class="poicat_icon" />&nbsp;' : '';
						$pickup_poi_options_html .= '<span>'.$place->title.'</span></div>'."\n";
						
						$pickup_poi[] = JHTML::_('select.option', $place->id, $place->title);
						
						$pickup_poi_json_arr[] = array('label' => $place->title,
									    'value' => $place->title,
									    'id' => $place->id,
									   );
					}
					// enlist dropoff poi
					if((int)$place->show_on_dropoff==1)
					{
						$dropoff_poi_options_html .= '<div class="poi_link" data-poiid="'.$place->id.'" data-poilat="'.$place->lat.'" data-poilng="'.$place->long.'">';
						$dropoff_poi_options_html .= ($place->image!="") ? '<img src="'.JURI::base().$place->image.'" alt="'.$place->cattitle.'" class="poicat_icon" />&nbsp;' : '';
						$dropoff_poi_options_html .= '<span>'.$place->title.'</span></div>'."\n";
						
						$dropoff_poi[] = JHTML::_('select.option', $place->id, $place->title);
						
						$dropoff_poi_json_arr[] = array('label' => $place->title,
									    'value' => $place->title,
									    'id' => $place->id,
									   );
					}
				}
			}
			
			$lists['pickup_poi_options_html'] = $pickup_poi_options_html;
			$lists['dropoff_poi_options_html'] = $dropoff_poi_options_html;
			
			$lists['pickup_poi_json_data'] = json_encode($pickup_poi_json_arr);
			$lists['dropoff_poi_json_data'] = json_encode($dropoff_poi_json_arr);
		}
		
		// collect route cateory list
		if( (int)$elsettings->show_offers_tab==1)
		{ 
			$sel_route_category = $session->get('route_category', 0);
			$sel_route_category_dropoff = $session->get('route_category_dropoff', 0);
			
			$route_category_arr = array();
			$route_category_dropoff_arr = array();
			
			if($elsettings->show_poi_categories==1)
			{
				$query = 'SELECT DISTINCT poi.title, poi.id, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image'
					. ' FROM #__taxibooking_points AS poi'
					. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
					. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_from'
					. ' WHERE r.published = 1'
					. ' AND poi.published = 1'
					. ' AND poi.show_on_offers_pickup = 1'
					. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
					. ' ORDER BY poi_cat.title ASC'
				;
				$db->setQuery($query);
				$db->query();
				$rows = $db->loadObjectList();
				
				if (!empty($rows))
				{
					foreach ($rows as $row)
					{
						$route_category_arr[$row->catid] = array('cattitle' => $row->cattitle,
										    'catimage' => $row->cat_image);
					}
				}
				
				// dropoff route category
				$sel_route_from = $session->get('route_from', 0);
				$query = 'SELECT DISTINCT poi.title, poi.id, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image, poi_cat.language AS cat_language'
					. ' FROM #__taxibooking_points AS poi'
					. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
					. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
					. ' WHERE r.published = 1'
					. ' AND poi.published = 1'
					. ' AND poi.show_on_offers_dropoff = 1'
					. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
					. ' AND r.route_from = '.$db->Quote($sel_route_from)
					. ' ORDER BY poi_cat.title ASC'
				;
				$db->setQuery($query);
				$db->query();
				$rows = $db->loadObjectList();
				
				if (!empty($rows))
				{
				    foreach ($rows as $row)
				    {
					if($row->cat_language=="*" || $row->cat_language==$lang_tag)
					{
					    $route_category_dropoff_arr[$row->catid] = array('cattitle' => $row->cattitle,
										'catimage' => $row->cat_image);
					}
				    }
				}
			}
			
			$route_categories_html = '';
			$route_categories_data = array();
			if(!empty($route_category_arr))
			{
				$i = 0;
				foreach($route_category_arr as $catid => $catobj)
				{
					$route_categories_html .= '<div class="poi_link" id="'.$catid.'">';
					$route_categories_html .= ($catobj['catimage']!="") ? '<img src="'.JURI::base().$catobj['catimage'].'" alt="'.$catobj['cattitle'].'" class="poicat_icon" />&nbsp;' : '';
					$route_categories_html .= '<span>'.$catobj['cattitle'].'</span></div>'."\n";
					
					$route_categories_data[$i]['label'] = $catobj['cattitle'];
					$route_categories_data[$i]['value'] = $catobj['cattitle'];
					$route_categories_data[$i]['id'] = $catid;
					
					$i++;
				}
			}
			$lists['route_categories_html'] = $route_categories_html;
			$lists['route_categories_data'] = json_encode($route_categories_data);
			
			$route_categories_dropoff_html = '';
			$route_categories_dropoff_data = array();
			if(!empty($route_category_dropoff_arr))
			{
			    $i = 0;
			    foreach($route_category_dropoff_arr as $catid => $catobj)
			    {
				$route_categories_dropoff_html .= '<div class="poi_link" id="'.$catid.'">';
				$route_categories_dropoff_html .= ($catobj['catimage']!="") ? '<img src="'.JURI::base().$catobj['catimage'].'" alt="'.$catobj['cattitle'].'" class="poicat_icon" />&nbsp;' : '';
				$route_categories_dropoff_html .= '<span>'.$catobj['cattitle'].'</span></div>'."\n";
				
				$route_categories_dropoff_data[$i]['label'] = $catobj['cattitle'];
				$route_categories_dropoff_data[$i]['value'] = $catobj['cattitle'];
				$route_categories_dropoff_data[$i]['id'] = $catid;
				
				$i++;
			    }
			}
			$lists['route_categories_dropoff_html'] = $route_categories_dropoff_html;
			$lists['route_categories_dropoff_data'] = json_encode($route_categories_dropoff_data);
			
			// get the fixed routes from option
			$query = 'SELECT DISTINCT poi.title, poi.id, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image'
				. ' FROM #__taxibooking_points AS poi'
				. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
				. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_from'
				. ' WHERE r.published = 1'
				. ' AND poi.published = 1 AND poi.show_on_offers_pickup = 1';
			
			if($sel_route_category>0) {
			    $query .= ' AND poi_cat.id = '.$db->Quote($sel_route_category);
			}
			$query .= ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
				. ' ORDER BY poi.title ASC'
			;
			$db->setQuery($query);
			if(!$db->query()){
				JError::raiseError(500, $db->getErrorMsg());
				return false;
			}
			$rows = $db->loadObjectList();
			
			$lists['has_any_route'] = false;
			$pickup_route_options_html = '';
			$pickup_route_poi_data = array();
			
			if (!empty($rows))
			{
				$lists['has_any_route'] = true;
				$i = 0;
				foreach ($rows as $row)
				{
					$pickup_route_options_html .= '<div class="poi_link" id="'.$row->id.'">';
					$pickup_route_options_html .= ($row->cat_image!="") ? '<img src="'.JURI::base().$row->cat_image.'" alt="'.$row->cattitle.'" class="poicat_icon" />&nbsp;' : '';
					$pickup_route_options_html .= '<span>'.$row->title.'</span></div>'."\n";
					
					$pickup_route_poi_data[$i]['label'] = $row->title;
					$pickup_route_poi_data[$i]['value'] = $row->title;
					$pickup_route_poi_data[$i]['id'] = $row->id;
					
					$i++;
				}
			}
			
			$sel_route_from = $session->get('route_from', 0);
			$sel_route_to = $session->get('route_to', 0);
			
			$dropoff_route_options_html = '';
			$dropoff_route_poi_data = array();
			
			// if route is swapped, pickup routes will be dropoff routes
			$route_swapped = $session->get('route_swapped', 0);
			if($route_swapped==0)
			{
				if($sel_route_from > 0)
				{
					$query = 'SELECT DISTINCT poi.id, poi.title, poi_cat.title AS cattitle, poi_cat.image AS cat_image'
						. ' FROM #__taxibooking_points AS poi'
						. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
						. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
						. ' WHERE r.published = 1'
						. ' AND poi.published = 1 AND poi.show_on_offers_dropoff = 1'
						. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
						. ' AND r.route_from = '.$db->Quote($sel_route_from)
						. ' ORDER BY poi.title ASC'
					;
					$db->setQuery($query);
					if(!$db->query()){
						JError::raiseError(500, $db->getErrorMsg());
						return false;
					}
					$rows = $db->loadObjectList();
					
					if (!empty($rows)) {
						$i = 0;
						foreach ($rows as $row)
						{
							$dropoff_route_options_html .= '<div class="poi_link">';
							$dropoff_route_options_html .= ($row->cat_image!="") ? '<img src="'.JURI::base().$row->cat_image.'" alt="'.$row->cattitle.'" class="poicat_icon" />&nbsp;' : '';
							$dropoff_route_options_html .= '<span>'.$row->title.'</span></div>'."\n";
							
							$dropoff_route_poi_data[$i]['label'] = $row->title;
							$dropoff_route_poi_data[$i]['value'] = $row->title;
							$dropoff_route_poi_data[$i]['id'] = $row->id;
							
							$i++;
						}
					}
				}
				
				$lists['pickup_route_options_html'] = $pickup_route_options_html;
				$lists['dropoff_route_options_html'] = $dropoff_route_options_html;
				$lists['pickup_route_poi_data'] = json_encode($pickup_route_poi_data);
				$lists['dropoff_route_poi_data'] = json_encode($dropoff_route_poi_data);
			}
		}
		
		// get the maximum passengers
		$query = 'SELECT MAX(passenger_no) AS max_passenger, MAX(suitcase_no) AS max_suitcase, '
			. ' MAX(booster_seat_no) AS max_booster, MAX(child_seat_no) AS max_child, MAX(infant_seat_no) AS max_infant'
			. ' FROM #__taxibooking_cars'
		;
		$db->setQuery($query);
		if(!$db->query()){
			JError::raiseError(500, $db->getErrorMsg());
			return false;
		}
		$max = $db->loadObject();
		$max_passenger = isset($max->max_passenger) ? $max->max_passenger : 8;
		$max_suitcase = isset($max->max_suitcase) ? $max->max_suitcase : 9;
		$max_booster = isset($max->max_booster) ? $max->max_booster : 5;
		$max_child = isset($max->max_child) ? $max->max_child : 5;
		$max_infant = isset($max->max_infant) ? $max->max_infant : 5;
		
		$passenger_options = array('0' => JText::_('PASSENGER_SEATS'));
		for ($i = 1; $i <= $max_passenger; $i++) {
		    $passenger_options[] = JHTML::_('select.option', $i, $i);
		}
		$lists['passengers'] = JHTML::_('select.genericlist', $passenger_options, 'passengers', 'class="seat_options required"', 'value', 'text', $passengers);
	
		$infantseats_options = array('0' => JText::_('INFANT_SEATS'));
		
		$lists['has_infant_seats'] = ($max_infant > 0) ? true : false;
		for ($i = 1; $i <= $max_infant; $i++) {
		    $infantseats_options[] = JHTML::_('select.option', $i, $i);
		}
		$lists['infantseats'] = JHTML::_('select.genericlist', $infantseats_options, 'infantseats', 'class="seat_options"', 'value', 'text', 0);
		
		$chseats_options = array('0' => JText::_('CHILD_SEATS'));
		$lists['has_chseats'] = ($max_child > 0) ? true : false;
		for ($i = 1; $i <= $max_child; $i++) {
		    $chseats_options[] = JHTML::_('select.option', $i, $i);
		}
		$lists['chseats'] = JHTML::_('select.genericlist', $chseats_options, 'chseats', 'class="seat_options"', 'value', 'text', 0);
		
		$boosterseats_options = array('0' => JText::_('BOOSTER_SEATS'));
		$lists['has_booster_seats'] = ($max_booster > 0) ? true : false;
		for ($i = 1; $i <= $max_booster; $i++) {
		    $boosterseats_options[] = JHTML::_('select.option', $i, $i);
		}
		$lists['boosterseats'] = JHTML::_('select.genericlist', $boosterseats_options, 'boosterseats', 'class="seat_options"', 'value', 'text', 0);
	
		$suitcases_options = array('0' => JText::_('SUITCASE_NO'));
		for ($i = 1; $i <= $max_suitcase; $i++) {
		    $suitcases_options[] = JHTML::_('select.option', $i, $i);
		}
		$lists['suitcases'] = JHTML::_('select.genericlist', $suitcases_options, 'suitcases', 'class="seat_options"', 'value', 'text', 0);
		
		if( (int)$elsettings->show_hourly_tab==1 && booking_helper::is_hourly_rate_enabled())
		{
			$query = 'SELECT MIN(hourly_hire_min_hr) AS min_hourly_hr, MAX(hourly_hire_max_hr) AS max_hourly_hr'
				. ' FROM #__taxibooking_cars'
				. ' WHERE hourly_hire_enabled = 1'
			;
			$db->setQuery($query);
			$db->query();
			$max = $db->loadObject();
			$min_hourly_hr = isset($max->min_hourly_hr) ? $max->min_hourly_hr : 1;
			$max_hourly_hr = isset($max->max_hourly_hr) ? $max->max_hourly_hr : 10;
			
			$options = array('0' => JText::_('HR'));
			for ($i = $min_hourly_hr; $i <= $max_hourly_hr; $i++) {
			    $options[] = JHTML::_('select.option', $i, $i);
			}
			$lists['hourly_hr_list'] = JHTML::_('select.genericlist', $options, 'hourly_hr', 'class=""', 'value', 'text', $hourly_hr);
			
			$options = array();
			$options[] = JHTML::_('select.option', 0, '00');
			$options[] = JHTML::_('select.option', 15, 15);
			$options[] = JHTML::_('select.option', 30, 30);
			$options[] = JHTML::_('select.option', 45, 45);
			$lists['hourly_min_list'] = JHTML::_('select.genericlist', $options, 'hourly_min', 'class="seat_options"', 'value', 'text', $hourly_min);
		}
		// get shuttle start points
		if( (int)$elsettings->show_shuttles_tab==1 && booking_helper::is_shuttles_enabled())
		{
		    $query = 'SELECT DISTINCT p.title AS poi_title, p.id AS poiid, p.lat AS poilat, p.long AS poilng, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image'
			    . ' FROM #__taxibooking_shuttle_route_stops AS rs'
			    . ' LEFT JOIN #__taxibooking_shuttle_routes AS r ON r.id = rs.route_id'
			    . ' LEFT JOIN #__taxibooking_points AS p ON p.id = rs.poi_id'
			    . ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = p.catid'
			    . ' WHERE rs.is_end = 0'
			    . ' AND r.published = 1';
		    $query .= ' AND (r.language = "*" OR r.language = "'.$lang_tag.'")'
			    . ' ORDER BY p.title ASC'
		    ;
		    $db->setQuery($query);
		    $db->query();
		    $rows = $db->loadObjectList();
		    
		    $shuttle_pickup_options_html = '';
		    
		    if (!empty($rows))
		    {
			$i = 0;
			foreach ($rows as $row)
			{
			    $shuttle_pickup_options_html .= '<div class="poi_link" data-poiid="'.$row->poiid.'" data-poilat="'.$place->lat.'" data-poilng="'.$place->long.'">';
			    $shuttle_pickup_options_html .= ($row->cat_image!="") ? '<img src="'.JURI::base().$row->cat_image.'" alt="'.$row->cattitle.'" class="poicat_icon" />&nbsp;' : '';
			    $shuttle_pickup_options_html .= '<span>'.$row->poi_title.'</span></div>'."\n";
			    
			    $i++;
			}
			
			$lists['shuttle_pickup_options_html'] = $shuttle_pickup_options_html;
		    }
		}

		return $lists;
	}
}
