<?php 
/**
* @package		Taxi Booking
* @copyright	Copyright (C) 2011 KANEV.CO.UK All rights reserved.
* @license		GNU/GPL, see license.txt
* Taxi Booking is open source software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*This program is distributed in the hope that it will be useful,
*but WITHOUT ANY WARRANTY; without even the implied warranty of
*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*GNU General Public License for more details.
*You should have received a copy of the GNU General Public License
*along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$session =  JFactory::getSession();
$document = JFactory::getDocument();
$elsettings =  booking_helper::config();

$routes_json_data = booking_helper::get_routes();

// get country 2 code for google autocomplete
$country_2_code = booking_helper::get_country_field($elsettings->default_country, 'country_2_code');
$default_country = ($country_2_code == '') ? 'US' : $country_2_code;

$lang =  JFactory::getLanguage();
$lang_tag = $lang->getTag();

$max_width = $params->get('max_width', 0);

// get disabled dates text from cache file
$filename = JPATH_ROOT.DS.'plugins'.DS.'system'.DS.'tbschedules'.DS.'cache.txt';
if (file_exists($filename)) {
    $contents = file_get_contents($filename);
    $disabled_dates = array();
    if(explode(',', $contents)){
	$disabled_dates = explode(',', $contents);
    }
}
?>

<link rel="stylesheet" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery-ui.css" />
<link rel="stylesheet" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/jquery.selectbox.css" />

<?php
$bgcolor = substr($elsettings->booking_form_bgcolor, 1);
$acttab = substr($elsettings->booking_form_active_tab_color, 1);
$inacttab = substr($elsettings->booking_form_inactive_tab_color, 1);
$boxcolor = substr($elsettings->booking_form_boxcolor, 1);
$fontcolor = substr($elsettings->booking_form_fontcolor, 1);
$headers_fontcolor = substr($elsettings->booking_form_header_tabs_fontcolor, 1);
$boxes_fontcolor = substr($elsettings->booking_form_boxes_fontcolor, 1);
$btncolor = substr($elsettings->booking_form_btncolor, 1);
$highlightscolor = substr($elsettings->highlights_color, 1);
$otherfontcolor = substr($elsettings->other_steps_fontcolor, 1);

$max_stop_time = $elsettings->max_stop_time;
$stop_duration_interval = $elsettings->stop_duration_interval;

$is_hourly_rate_enabled = booking_helper::is_hourly_rate_enabled();
$is_shuttles_enabled = booking_helper::is_shuttles_enabled();
?>

<?php if(($max_width > 0) AND ($max_width <= 250)){ ?>
<link rel="stylesheet" type="text/css" media="screen" href="<?php echo JURI::root();?>modules/mod_taxibooking/assets/css/modbooking_narrow.css.php?bgcolor=<?php echo $bgcolor;?>&acttab=<?php echo $acttab;?>&inacttab=<?php echo $inacttab;?>&btncolor=<?php echo $btncolor;?>&boxcolor=<?php echo $boxcolor;?>&headers_fontcolor=<?php echo $headers_fontcolor;?>&fontcolor=<?php echo $fontcolor;?>&boxes_fontcolor=<?php echo $boxes_fontcolor;?>&otherfontcolor=<?php echo $otherfontcolor;?>&highlightscolor=<?php echo $highlightscolor;?>" >

<?php } else { ?>

<?php if(version_compare(JVERSION,'3.1.5','ge')) {?>
<link rel="stylesheet" type="text/css" media="screen" href="<?php echo JURI::root();?>modules/mod_taxibooking/assets/css/modbooking.css.php?bgcolor=<?php echo $bgcolor;?>&acttab=<?php echo $acttab;?>&inacttab=<?php echo $inacttab;?>&btncolor=<?php echo $btncolor;?>&boxcolor=<?php echo $boxcolor;?>&headers_fontcolor=<?php echo $headers_fontcolor;?>&fontcolor=<?php echo $fontcolor;?>&boxes_fontcolor=<?php echo $boxes_fontcolor;?>&otherfontcolor=<?php echo $otherfontcolor;?>&highlightscolor=<?php echo $highlightscolor;?>" >
<?php } else { ?>
<link rel="stylesheet" type="text/css" media="screen" href="<?php echo JURI::root();?>modules/mod_taxibooking/assets/css/modbooking_none.css.php?bgcolor=<?php echo $bgcolor;?>&acttab=<?php echo $acttab;?>&inacttab=<?php echo $inacttab;?>&btncolor=<?php echo $btncolor;?>&boxcolor=<?php echo $boxcolor;?>&headers_fontcolor=<?php echo $headers_fontcolor;?>&fontcolor=<?php echo $fontcolor;?>&boxes_fontcolor=<?php echo $boxes_fontcolor;?>&otherfontcolor=<?php echo $otherfontcolor;?>&highlightscolor=<?php echo $highlightscolor;?>" >
<?php } ?>

<?php } ?>

<link rel="stylesheet" type="text/css" media="screen" href="<?php echo JURI::root();?>components/com_taxibooking/assets/css/font-awesome.css" />
    
<div class="modulebooking clearfix" id="verticle_booking_wrap_outer">
    <form name="price_form" id="price_form" method="POST" action="<?php echo JRoute::_('index.php?option=com_taxibooking&task=getDistancePrice');?>">
    
    <input type="hidden" id="date_format" value="<?php echo $elsettings->date_format;?>" />
    <input type="hidden" id="time_format" value="<?php echo $elsettings->time_format;?>" />
    <input type="hidden" id="locale" value="<?php echo $lang_tag;?>" />
    <input type="hidden" id="route_swapped" name="route_swapped" value="<?php echo $session->get('route_swapped', 0);?>" />
    <input type="hidden" id="booking_type" name="booking_type" value="<?php echo $session->get('booking_type', $default_tab_title);?>" />
    <input type="hidden" id="datepicker_type" name="datepicker_type" value="<?php echo $elsettings->datepicker_type;?>" />
    <input type="hidden" id="show_poi_categories" name="show_poi_categories" value="<?php echo $elsettings->show_poi_categories;?>" />
    <input type="hidden" id="show_return_extras" name="show_return_extras" value="<?php echo $elsettings->show_return_extras;?>" />
    
    <div id="verticle_booking_wrap" class="clearfix">
	<ul>
	    <?php if( (int)$elsettings->show_address_tab==1 && ($elsettings->show_from_poi==1 || $elsettings->show_from_address==1)
			     && ($elsettings->show_to_poi==1 || $elsettings->show_to_address==1)) { ?>
	    <li><a id="address" href="#tabs_address"><?php echo JText::_('ADDRESS_SEARCH_TAB_LABEL'); ?></a></li>
	    <?php } ?>
	    
	    <?php if( (int)$elsettings->show_offers_tab==1 && $lists['has_any_route']){ ?>
	    <li><a id="offers" href="#tabs_special_routes"><?php echo JText::_('SPECIAL_OFFERS_TAB_LABEL'); ?></a></li>
	    <?php } ?>
	    
	    <?php if( (int)$elsettings->show_hourly_tab==1 && booking_helper::is_hourly_rate_enabled()){ ?>
	    <li><a id="hourly" href="#tabs_hourly_hire"><?php echo JText::_('HOURLY_HIRE_TAB_LABEL'); ?></a></li>
	    <?php } ?>
	    
	    <?php if( (int)$elsettings->show_shuttles_tab==1 && booking_helper::is_shuttles_enabled()){ ?>
	    <li><a id="shuttle" href="#tabs_shuttles"><?php echo JText::_('SHUTTLES_TAB_LABEL'); ?></a></li>
	    <?php } ?>
	</ul>
	
	<?php if( (int)$elsettings->show_address_tab==1 && ($elsettings->show_from_poi==1 || $elsettings->show_from_address==1)
			     && ($elsettings->show_to_poi==1 || $elsettings->show_to_address==1)) { ?>
	<div class="verticl_booking_toppart clearfix" id="tabs_address">
	    
	    <?php if ($elsettings->show_from_poi==1 || $elsettings->show_from_address==1) { ?>
	    <div class="topouterWrap left pickup_wrap clearfix">
		<div class="topinnerWrap clearfix">
		    <label><?php echo JText::_('TAXI_FROM'); ?></label>
		    <div class="top_ver_input_wrap clearfix">
		    
		    <?php if($elsettings->show_from_address==1) { ?>
		    <div class="getlocationField">
			    <a class="pickup_direction" href="javascript:void(0);" onclick="get_user_location('pickup', this);"><?php echo JText::_('GET_LOCATION'); ?></a>
		    </div>
		    <?php } ?>
		    
		    <?php
		    $additional_class = '';
		    $additional_class .= ($elsettings->show_from_poi==0) ? ' poi_disabled' : '';
		    $additional_class .= ($elsettings->show_from_address==0) ? ' address_disabled' : '';
		    ?>
		    <div class="inputField<?php echo $additional_class;?>">
			<input type="text" class="inputbox" name="address_from" id="address_from" value="" placeholder="<?php echo ($elsettings->show_from_address==1)?JText::_('ENTER_ADDRESS'):JText::_('SELECT_PLACE'); ?>" />
			<input type="hidden" name="address_from_lat" id="address_from_lat" value="" />
			<input type="hidden" name="address_from_lng" id="address_from_lng" value="" />
			<input type="hidden" name="pickup_poi" id="pickup_poi" value="" />
		    </div>
		    
		    <?php if($elsettings->show_from_poi==1) { ?>
		    <div class="selectField-wrap">
			<div class="selectField">
			    <div class="arrow_wrapper poi_options_trigger">trigger_icon</div>
			    <div class="poi_dropdown_wrapper" style="display:none;">
			    <?php echo $lists['pickup_poi_options_html']; ?>
			    </div>
			</div>
		    </div>
		    <?php } ?>
		    </div>
		    
		    <!-- From Extras -->
		    <div class="ver_pickup_extra_wrapper" id="pickup_extra_wrapper">
			    <?php echo booking_helper::get_selected_extras('pickup');?>
		    </div>
		    <!-- From Extras -->
		</div>
	    </div>
	    <?php } ?>
	    
	    <div class="topouterWrap right dropoff_wrap clearfix">
			
		<?php if($elsettings->enable_stops==1) { ?>
		<div id="stops_wrapper">
		    
		</div>
		<?php } ?>
		
		<?php if ($elsettings->show_to_poi==1 || $elsettings->show_to_address==1) { ?>
		<div class="topinnerWrap nonstop_wrap clearfix">
		    <label><?php echo JText::_('TAXI_TO'); ?></label>
		    <div class="top_ver_input_wrap clearfix">
		    <?php if($elsettings->show_to_address==1) { ?>
		    <div class="getlocationField">
			    <a class="dropoff_direction" href="javascript:void(0);" onclick="get_user_location('dropoff', this);"><?php echo JText::_('GET_LOCATION'); ?></a>
		    </div>
		    <?php } ?>
		    
		    <?php
		    $additional_class = '';
		    $additional_class .= ($elsettings->show_to_poi==0) ? ' poi_disabled' : '';
		    $additional_class .= ($elsettings->show_to_address==0) ? ' address_disabled' : '';
		    ?>
		    
		    <div class="inputField<?php echo $additional_class;?>">
			<input type="text" class="inputbox" name="address_to" id="address_to" value="" placeholder="<?php echo ($elsettings->show_to_address==1)?JText::_('ENTER_ADDRESS'):JText::_('SELECT_PLACE'); ?>" />
			<input type="hidden" name="address_to_lat" id="address_to_lat" value="" />
			<input type="hidden" name="address_to_lng" id="address_to_lng" value="" />
			<input type="hidden" name="dropoff_poi" id="dropoff_poi" value="" />
		    </div>
		    
		    <?php if($elsettings->show_to_poi==1) { ?>
		    <div class="selectField-wrap">
			<div class="selectField">
			    <div class="arrow_wrapper poi_options_trigger">trigger_icon</div>
			    <div class="poi_dropdown_wrapper" style="display:none;">
			    <?php echo $lists['dropoff_poi_options_html']; ?>
			    </div>
			</div>
		    </div>
		    <?php } ?>
		    </div>
		    
		    <!-- To Extras -->
		    <div class="ver_dropoff_extra_wrapper" id="dropoff_extra_wrapper">
			    <?php echo booking_helper::get_selected_extras('dropoff');?>
		    </div>
		    <!-- To Extras -->
		</div>
		<?php } ?>
		
		<?php if($elsettings->enable_stops==1) { ?>
		<div class="topinnerWrap clearfix">
			<a href="javascript:void(0);" class="addstop" title="<?php echo JText::_('MAXIMUM_NUMBER_STOPS');?>"><?php echo JText::_('ADD_STOPS'); ?></a>
		</div>
		<?php } ?>
	    </div>
	    
	</div>    
	<?php } ?>
	
	<?php if( (int)$elsettings->show_offers_tab==1 && $lists['has_any_route']){ ?>
	<div class="verticl_booking_toppart clearfix" id="tabs_special_routes">
		
	    <div class="ver_input_wrap clearfix">
		
		<div class="routes_wrapper_from">
		
		    <?php
		    $show_route_pickup = true;
		    if($elsettings->show_poi_categories==1){
			
			if($session->get('route_category', 0) > 0){
			    $show_route_pickup = true;
			}
			else {
			    $show_route_pickup = false;
			}
		    ?>
		    <div class="routecategory_wrapper_from clearfix" style="width: 100%;">
			<div class="routes_wrapper">
			    <label><?php echo JText::_('PICKUP_ROUTE_CATEGORY'); ?></label>
			    <div class="routestestWrap">
				<div class="routestest clearfix">
				    <input type="text" class="ver_inputbox required" id="route_category_fld" name="route_category_fld" value="" />
				    <input type="hidden" id="route_category" name="route_category" value="" />
				    <div class="routecategory_dropdown_wrapper" style="display:none;">
					<?php echo $lists['route_categories_html']; ?>
				    </div>
				    <div class="arrow_wrapper routecategory_options_trigger"></div>
				</div>
			    </div>
			</div>
		    </div>
		    <div id="routefrom_loader"></div>
		    <?php }  ?>
		    
		    <div class="routes_from_inner clearfix" style="<?php echo ($show_route_pickup) ? 'display:block':'display:none';?>">
			<label><?php echo JText::_('TAXI_FROM'); ?></label>
			<div class="routes_wrapper">
			    <div class="routestest clearfix" style="position: relative; width: 100%; float: left;">
				<input type="text" class="ver_inputbox required" id="route_from_fld" name="route_from_fld" value="" />
				<input type="hidden" id="route_from" name="route_from" value="" />
				<div class="routefrom_dropdown_wrapper" style="display:none;">
					<?php echo $lists['pickup_route_options_html']; ?>
				</div>
				<div class="arrow_wrapper routefrom_options_trigger"></div>
			    </div>
			</div>
		    </div>			
			
			
		    <div class="clearfix"></div>
		    
		    <!-- From Extras -->
		    <div class="ver_dropoff_extra_wrapper" id="routefrom_extra_wrapper">
			    <?php echo booking_helper::get_selected_extras('route_pickup');?>
		    </div>
		    <!-- From Extras -->
		</div>
		
		<div class="routes_wrapper_to" style="<?php echo ($session->get('route_from', 0)>0) ? 'display:block;':'display:none;';?>">
		    <?php
		    $show_route_dropoff = true;
		    if($elsettings->show_poi_categories==1){
			
			if($session->get('route_category_dropoff', 0) > 0){
			    $show_route_dropoff = true;
			}
			else {
			    $show_route_dropoff = false;
			}
		    ?>
		    <div class="routecategory_wrapper_from clearfix" style="width: 100%;">
			<div class="routes_wrapper">
			    <label><?php echo JText::_('DROPOFF_ROUTE_CATEGORY'); ?></label>
			    <div class="routestestWrap drop">
				<div class="routestest clearfix">
				    <input type="text" class="ver_inputbox required" id="route_category_dropoff_fld" name="route_category_dropoff_fld" value="" />
				    <input type="hidden" id="route_category_dropoff" name="route_category_dropoff" value="" />
				    <div class="routecategory_dropoff_dropdown_wrapper" style="display:none;">
					<?php echo $lists['route_categories_dropoff_html']; ?>
				    </div>
				    <div class="arrow_wrapper routecategory_dropoff_options_trigger"></div>
				</div>
			    </div>
			</div>
		    </div>
		    <div id="routefrom_loader"></div>
		    <?php } ?>
		    
		    <div class="routes_to_inner clearfix" style="<?php echo ($show_route_dropoff) ? 'display:block':'display:none';?>">
			<label><?php echo JText::_('TAXI_TO'); ?></label>
			<div class="routes_wrapper" id="route_to_wrap">
			    <div class="routestest clearfix" style="position: relative; width: 100%; float: left;">
				    
				<div class="routes_indicator" style="<?php echo ($session->get('route_from', 0)>0) ? 'display:block;':'display:none;';?>">
				    <div class="routes_wrapper_change" style="">
					    <?php if($elsettings->enable_route_swap==1){?>
						    <a href="javascript:void(0);" class="swap_routes">
							    <i class="icon-exchange"></i><!--span><img src="<?php // echo JURI::base(); ?>components/com_taxibooking/assets/images/swap_border.jpg" alt="Border" /></span-->
						    </a>
					    <?php } ?>
				    </div>	
				    <div class="routes_wrapper_loader" id="route_loader" style="margin-left:-8px;display:none;">
					    <img src="<?php echo JURI::base(); ?>components/com_taxibooking/assets/images/ajax-loader2.gif" alt="Loading" />
				    </div>
				</div>			
			    
				<input type="text" class="ver_inputbox required" id="route_to_fld" name="route_to_fld" value="" />
				<input type="hidden" id="route_to" name="route_to" value="" />
				<div class="routeto_dropdown_wrapper" style="display:none;">
					<?php echo $lists['dropoff_route_options_html']; ?>
				</div>
				<div class="arrow_wrapper routeto_options_trigger"></div>
			    </div>
			</div>
		    </div>			
			
		    <div class="clearfix"></div>
		    
		    <!-- To Extras -->
		    <div class="ver_dropoff_extra_wrapper" id="routeto_extra_wrapper">
			<?php echo booking_helper::get_selected_extras('route_dropoff');?>
		    </div>
		    <!-- To Extras -->
		</div>
	    </div>
	    
	</div>
	<?php } ?>
    
	<?php if( (int)$elsettings->show_hourly_tab==1 && $is_hourly_rate_enabled){ ?>
	<div class="verticl_booking_toppart clearfix" id="tabs_hourly_hire">
		
	    <div class="ver_input_wrap hourly clearfix">
		<div class="controls hourly clearfix" style="">
			<div class="houtly_inner clearfix">
				<label><?php echo JText::_('HOURLY_HIRE_HR_LABEL');?></label>
				<?php echo $lists['hourly_hr_list']; ?>
			</div>
		</div>
		<!--div class="clearfix"></div-->
		<div class="controls hourly clearfix" style="">
			<div class="houtly_inner clearfix">
				<label><?php echo JText::_('HOURLY_HIRE_MIN_LABEL');?></label>
				<?php echo $lists['hourly_min_list']; ?>
			</div>
		</div>
	    </div>
	    
	    <div class="ver_dropoff_extra_wrapper" id="hourly_extra_wrapper">
		<?php echo booking_helper::get_selected_extras('hourly_hire');?>
	    </div>
	    
	</div>
	<?php } ?>
	
	<?php if( (int)$elsettings->show_shuttles_tab==1 && $is_shuttles_enabled){ ?>
	<div class="verticl_booking_toppart clearfix" id="tabs_shuttles">
		
	    <div class="topouterWrap left shuttle_pickup_wrap clearfix">
		
		<div class="topinnerWrap clearfix">
		    <label><?php echo JText::_('TAXI_FROM'); ?></label>
		    <div class="top_ver_input_wrap clearfix">
		    
		    <?php
		    $additional_class = ' address_disabled';
		    ?>
		    <div class="inputField<?php echo $additional_class;?>">
			<input type="text" class="inputbox required" name="shuttle_pickup" id="shuttle_pickup" value="" placeholder="<?php echo JText::_('SELECT_PLACE'); ?>" />
			<input type="hidden" name="shuttle_pickup_poi" id="shuttle_pickup_poi" value="" />
		    </div>
		    
		    <div class="selectField-wrap">
			<div class="selectField">
			    <div class="arrow_wrapper poi_options_trigger">trigger_icon</div>
			    <div class="poi_dropdown_wrapper" style="display:none;">
			    <?php echo $lists['shuttle_pickup_options_html']; ?>
			    </div>
			</div>
		    </div>
		    </div>
		    
		    <div class="ver_pickup_extra_wrapper" id="shuttle_pickup_extra_wrapper">
			<?php echo booking_helper::get_selected_extras('shuttle_pickup');?>
		    </div>
		</div>
	    </div>
	    
	    <div class="topouterWrap right shuttle_dropoff_wrap clearfix">
		
		<div class="topinnerWrap clearfix">
		    <label><?php echo JText::_('TAXI_TO'); ?></label>
		    <div class="top_ver_input_wrap clearfix">
		   
		    <?php
		    $additional_class = ' address_disabled';
		    ?>
		    
		    <div class="inputField<?php echo $additional_class;?>">
			<input type="text" class="inputbox required" name="shuttle_dropoff" id="shuttle_dropoff" value="" placeholder="<?php echo JText::_('SELECT_PLACE'); ?>" />
			<input type="hidden" name="shuttle_dropoff_poi" id="shuttle_dropoff_poi" value="" />
		    </div>
		    
		    <div class="selectField-wrap">
			<div class="selectField">
			    <div class="arrow_wrapper poi_options_trigger">trigger_icon</div>
			    <div class="poi_dropdown_wrapper" style="display:none;">
			    </div>
			</div>
		    </div>
		    </div>
		    
		    <div class="ver_pickup_extra_wrapper" id="shuttle_dropoff_extra_wrapper">
			<?php echo booking_helper::get_selected_extras('shuttle_dropoff');?>
		    </div>
		</div>
		
	    </div>
	</div>
	<?php } ?>


	<div class="separator nonshuttle"><!-- --></div>
	
	<div class="verticl_booking_midpart nonshuttle clearfix">
	    <div class="seats_wrap left">
		    <div class="seat_input_wrap passengers clearfix">
			    <label><?php echo JText::_('PASSENGER_SEATS');?></label>
			    <?php echo $lists['passengers']; ?>
		    </div>
		    
		    <?php if((int)$elsettings->show_suitcase_select==1){ ?>
		    <div class="seat_input_wrap suitcases clearfix">
			    <label><?php echo JText::_('SUITCASE_NO');?></label>
			    <?php echo $lists['suitcases']; ?>
		    </div>
		    <?php } ?>
	    </div>
	    
	    <div class="seats_wrap right">
		
		    <?php if((int)$elsettings->show_booster_select==1 && $lists['has_booster_seats']){ ?>
		    <div class="seat_input_wrap boosterseats clearfix">
			    <label><?php echo JText::_('BOOSTER_SEATS');?></label>
			    <?php echo $lists['boosterseats']; ?>
		    </div>
		    <?php } ?>
		    
		    <?php if((int)$elsettings->show_infant_select==1 && $lists['has_infant_seats']){ ?>
		    <div class="seat_input_wrap infantseats clearfix">
			    <label><?php echo JText::_('INFANT_SEATS');?></label>
			    <?php echo $lists['infantseats']; ?>
		    </div>
		    <?php } ?>
		    
		    <?php if((int)$elsettings->show_child_select==1 && $lists['has_chseats']){ ?>
		    <div class="seat_input_wrap childseats clearfix">
			    <label><?php echo JText::_('CHILD_SEATS');?></label>
			    <?php echo $lists['chseats']; ?>
		    </div>
		    <?php } ?>
	    </div>
	</div>
	
        <div class="separator"><!-- --></div>
	
	<?php
	// prepare hr and min dropdown data
	if($elsettings->date_format=='mm-dd-yy') {
	    $date_format = 'm-d-Y';
	}
	else {
	    $date_format = 'd-m-Y';
	}
	
	$config   = JFactory::getConfig();
	$siteOffset = $config->get('offset');
	$dtnow = JFactory::getDate('now', $siteOffset);
	$now = strtotime($dtnow->format('Y-m-d H:i:s', true));
	
	if($elsettings->load_current_date){
	    
	    $minimum_time_allowed = $now+($elsettings->restrict_time+1)*3600;
	    
	    $pickup_date = date($date_format, $minimum_time_allowed);
	
	    if($elsettings->time_format=='24hr') {
		$pickup_hr = date('H', $minimum_time_allowed);
		$pickup_min = '00';
	    }
	    else {
		$pickup_hr = date('h', $minimum_time_allowed);
		$pickup_min = '00';
		$pickup_ampm = date('A', $minimum_time_allowed);
	    }
	}
	else {
	    $pickup_date = JText::_('ORDER_DATE');
	    $pickup_hr = '';
	    $pickup_min = '';
	    $pickup_ampm = 'AM';
	}
	
	$return_date = JText::_('ORDER_RETURN_DATE');
	
	$hr_options = array();
	$hr_options[] = JHTML::_('select.option', '', JText::_('HRS'));
	if($elsettings->time_format=='24hr') {
	    $hr_start = '0';
	    $hr_end_limit = '24';
	}
	else {
	    $hr_start = '1';
	    $hr_end_limit = '13';
	}
	
	for($i = $hr_start; $i < $hr_end_limit; $i++)
	{
	    $i = ($i < 10) ? "0$i" : $i;
	    $hr_options[] = JHTML::_('select.option', $i, $i);
	}
	
	$min_options = array();
	$min_options[] = JHTML::_('select.option', '', JText::_('MINS'));
	for ($i = 0; $i <= 55; $i = $i + 5)
	{
	    $i = ($i < 10) ? "0$i" : $i;
	    $min_options[] = JHTML::_('select.option', $i, $i);
	}
	
	if($session->get('booking_type')=='shuttle'){
	    $shuttle_display = 'display:block';
	    $nonshuttle_display = 'display:none';
	}
	else {
	    $shuttle_display = 'display:none';
	    $nonshuttle_display = 'display:block';
	}
	?>
	
	<div class="verticl_booking_bottompart clearfix">
	    <label><?php echo JText::_('BOOKING_FORM_SELECT_DATE_LABEL');?></label>
	    <div class="date_Wrap left">
		<?php
		if($elsettings->datepicker_type=='inline'){
		?>
		<div class="date_input nonshuttle clearfix">
		<?php
		    $day_options = array();
		    for($i=1;$i<=31;$i++){
			$day_options[$i] = $i;
		    }
		    $month_options = array(1=> JText::_('JANUARY'),
					   2=> JText::_('FEBRUARY'),
					   3=> JText::_('MARCH'),
					   4=> JText::_('APRIL'),
					   5=> JText::_('MAY'),
					   6=> JText::_('JUNE'),
					   7=> JText::_('JULY'),
					   8=> JText::_('AUGUST'),
					   9=> JText::_('SEPTEMBER'),
					   10=> JText::_('OCTOBER'),
					   11=> JText::_('NOVEMBER'),
					   12=> JText::_('DECEMBER')
					);
		    $year_options = array();
		    for($i=date('Y');$i<date('Y')+10;$i++){
			$year_options[$i] = $i;
		    }
		    
		    $date1 = $session->get('date1', '');
		    if($date1!=''){
			$date1_arr = explode('-',$date1);
			$sel_pickup_day = $date1_arr[0];
			$sel_pickup_month = $date1_arr[1];
			$sel_pickup_year = $date1_arr[2];
		    }
		    else {
			$sel_pickup_day = date('d');
			$sel_pickup_month = date('m');
			$sel_pickup_year = date('Y');
		    }
		    
		    if($elsettings->date_format=='mm-dd-yy') {
			echo JHTML::_('select.genericlist', $month_options, 'pickup_month', 'class="month inline required" tabindex="1"', 'value', 'text', $sel_pickup_month);
			echo JHTML::_('select.genericlist', $day_options, 'pickup_day', 'class="day inline required" tabindex="1"', 'value', 'text', $sel_pickup_day);
		    }
		    else {
			echo JHTML::_('select.genericlist', $day_options, 'pickup_day', 'class="day inline required" tabindex="1"', 'value', 'text', $sel_pickup_day);
			echo JHTML::_('select.genericlist', $month_options, 'pickup_month', 'class="month inline required" tabindex="1"', 'value', 'text', $sel_pickup_month);
		    }
		    echo JHTML::_('select.genericlist', $year_options, 'pickup_year', 'class="year inline required" tabindex="1"', 'value', 'text', $sel_pickup_year);
		?>
		</div>
		
		<?php if( (int)$elsettings->show_shuttles_tab==1 && $is_shuttles_enabled){ ?>
		<div class="date_input shuttle clearfix">
		    <input type="text" name="orderdate_shuttle" id="orderdate_shuttle" readonly="readonly" class="date_inputbox required" value="<?php echo $pickup_date; ?>" />
		</div>
		<?php } ?>
		
		<div class="date_input hr_min nonshuttle clearfix" style="<?php echo $nonshuttle_display;?>">
		    <?php
		    echo JHTML::_('select.genericlist', $hr_options, 'selPtHr1', 'class="hrs required" tabindex="1"', 'value', 'text', $pickup_hr);
		    echo JHTML::_('select.genericlist', $min_options, 'selPtMn1', 'class="mins required" tabindex="1"', 'value', 'text', $pickup_min);
		    if($elsettings->time_format=='12hr') {
			echo JHTML::_('select.genericlist', array('AM'=>JText::_('AM'),'PM'=>JText::_('PM')), 'seltimeformat1', 'class="mins" tabindex="1"', 'value', 'text', $pickup_ampm);
		    }
		    ?>
		</div>
		
		<?php
		}
		else {
		?>
		<div class="date_input nonshuttle clearfix">
		    <input type="text" name="orderdate" id="orderdate" readonly="readonly" class="date_inputbox required" value="<?php echo $pickup_date; ?>" />
		</div>
		
		<?php if( (int)$elsettings->show_shuttles_tab==1 && $is_shuttles_enabled){ ?>
		<div class="date_input shuttle clearfix">
		    <input type="text" name="orderdate_shuttle" id="orderdate_shuttle" readonly="readonly" class="date_inputbox required" value="<?php echo $pickup_date; ?>" />
		</div>
		<?php } ?>
		
		<div class="date_input hr_min nonshuttle clearfix" style="<?php echo $nonshuttle_display;?>">
		    <input type="text" name="selPtHr1" id="selPtHr1" readonly="readonly" class="date_inputbox required" value="<?php echo $pickup_hr; ?>" style="width: 48px; margin-right: 5px;"  />
		    <input type="text" name="selPtMn1" id="selPtMn1" readonly="readonly" class="date_inputbox required" value="<?php echo $pickup_min; ?>" style="width: 48px; margin-right: 5px;" />
		    <?php 
		    if($elsettings->time_format=='12hr') {
			echo JHTML::_('select.genericlist', array('AM'=>JText::_('AM'),'PM'=>JText::_('PM')), 'seltimeformat1', 'class="mins" tabindex="1" style="margin-right: 0px;"', 'value', 'text', $pickup_ampm);
		    }
		    ?>
		</div>
		<?php } ?>
		
		<?php if( (int)$elsettings->show_shuttles_tab==1 && $is_shuttles_enabled){ ?>
		<div class="date_input hr_min shuttle clearfix" style="<?php echo $shuttle_display;?>"></div>
		<?php } ?>
	    </div>
	    
	    <?php if((int)$elsettings->show_return_option==1){ // show return option if set to Yes ?>
	    
	    <div class="date_Wrap right" id="return_label">
		
		<div class="return">
		    <input name="returnjurney" value="returnjurney" type="checkbox" id="returnjurney" <?php echo ($session->get('returnjurney', 0) == 1) ? 'checked="checked"' : ""; ?> />
		    <?php echo JText::_('BOOK_RETURN'); ?>
		    <?php if($elsettings->discount > 0) {                           
			echo JText::sprintf('BOOK_RETURN_DISCOUNT_MESSAGE', $elsettings->discount.'%');                            
		    } ?>
		</div>
		
		<?php
		if($session->get('returnjurney', 0) == 1){
		    $return_wrapper_style = 'block';
		} else {
		    $return_wrapper_style = 'none';
		}
		?>
		<div id="return_date_wrapper" class="wait_time" style="display:<?php echo $return_wrapper_style;?>">
		    
		    <?php if($elsettings->wait_time_return_discount=="1"){ ?>
		    <div class="date_input clearfix">
			<label><?php echo JText::_('WAIT_TIME_HRS');?></label>
			<?php 
			$return_options = array();
			$return_discounts_arr = $elsettings->return_discounts;
			if(!empty($return_discounts_arr))
			{
			    foreach($return_discounts_arr as $key => $val){
				$hr = (int) $val[0];
				$return_options[$hr] = $val[0];
			    }
			    $return_options['-1'] = JText::_('LOAD_MORE_WAIT_TIME');
			}
			
			echo JHTML::_('select.genericlist', $return_options, 'return_wait_hr', 'class="wait_time_options required" tabindex="1"', 'value', 'text', $session->get('return_wait_hr', ''));
			?>
		    </div>
		    <?php } ?>
		    
		    <div id="return_datepicker_wrapper" style="<?php echo ($elsettings->wait_time_return_discount=='1') ? 'display:none':'display:block';?>">
			<?php
			$time2 = $session->get('time2', '');
			if($time2!=""){
			    $time2Arr = explode(':', $time2);
			    $return_hr = $time2Arr[0];
			    if(isset($time2Arr[1])){
				$return_min = substr($time2Arr[1], 0, 2);
				$return_meridian = substr($time2Arr[1], 2);
			    }
			    else {
				$return_min = '00';
				$return_meridian = 'AM';
			    }
			}
			else {
			    $return_hr = $pickup_hr;
			    $return_min = $pickup_min;
			    $return_meridian = $pickup_ampm;
			}
			
			if($elsettings->datepicker_type=='inline')
			{
			    ?>
			<div class="date_input clearfix">
			    <?php 
			    $day_options = array();
			    for($i=1;$i<=31;$i++){
				$day_options[$i] = $i;
			    }
			    $month_options = array(1=> JText::_('JANUARY'),
						   2=> JText::_('FEBRUARY'),
						   3=> JText::_('MARCH'),
						   4=> JText::_('APRIL'),
						   5=> JText::_('MAY'),
						   6=> JText::_('JUNE'),
						   7=> JText::_('JULY'),
						   8=> JText::_('AUGUST'),
						   9=> JText::_('SEPTEMBER'),
						   10=> JText::_('OCTOBER'),
						   11=> JText::_('NOVEMBER'),
						   12=> JText::_('DECEMBER')
						);
			    $year_options = array();
			    for($i=date('Y');$i<date('Y')+10;$i++){
				$year_options[$i] = $i;
			    }
			    
			    $date2 = $session->get('date2', '');
			    if($date2!=''){
				$date2_arr = explode('-',$date2);
				$sel_return_day = $date2_arr[0];
				$sel_return_month = $date2_arr[1];
				$sel_return_year = $date2_arr[2];
			    }
			    else {
				$sel_return_day = date('d');
				$sel_return_month = date('m');
				$sel_return_year = date('Y');
			    }
			    
			    if($elsettings->date_format=='mm-dd-yy') {
				echo JHTML::_('select.genericlist', $month_options, 'return_month', 'class="month inline required" tabindex="1"', 'value', 'text', $sel_return_month);
				echo JHTML::_('select.genericlist', $day_options, 'return_day', 'class="day inline required" tabindex="1"', 'value', 'text', $sel_return_day);
			    }
			    else {
				echo JHTML::_('select.genericlist', $day_options, 'return_day', 'class="day inline required" tabindex="1"', 'value', 'text', $sel_return_day);
				echo JHTML::_('select.genericlist', $month_options, 'return_month', 'class="month inline required" tabindex="1"', 'value', 'text', $sel_return_month);
			    }
			    echo JHTML::_('select.genericlist', $year_options, 'return_year', 'class="year inline required" tabindex="1"', 'value', 'text', $sel_return_year);
			    ?>
			</div>
			
			<div class="date_input clearfix">
			    <?php
			    echo JHTML::_('select.genericlist', $hr_options, 'selPtHr2', 'class="hrs required" tabindex="1"', 'value', 'text', $return_hr);
			    echo JHTML::_('select.genericlist', $min_options, 'selPtMn2', 'class="mins required" tabindex="1"', 'value', 'text', $return_min);
			    if($elsettings->time_format=='12hr') {
				echo JHTML::_('select.genericlist', array('AM'=>JText::_('AM'),'PM'=>JText::_('PM')), 'seltimeformat2', 'class="mins" tabindex="1"', 'value', 'text', $return_meridian);
			    }
			    ?>
			</div>
			<?php
			} 
			else { ?>
			<div class="date_input clearfix">
			    <input type="text" name="orderdatereturn" id="orderdatereturn" readonly="readonly" class="date_inputbox" value="<?php echo $return_date; ?>" />
			</div>
			
			<div class="date_input clearfix">
			    <input type="text" name="selPtHr2" id="return_selPtHr2" readonly="readonly" class="date_inputbox required" value="<?php echo $return_hr; ?>" style="width: 48px; margin-right: 5px;" />
			    <input type="text" name="selPtMn2" id="return_selPtMn2" readonly="readonly" class="date_inputbox required" value="<?php echo $return_min; ?>" style="width: 48px; margin-right: 5px;" />
			    <?php
			    if($elsettings->time_format=='12hr') {
				echo JHTML::_('select.genericlist', array('AM'=>JText::_('AM'),'PM'=>JText::_('PM')), 'seltimeformat2', 'class="mins" tabindex="1" style="margin-right: 0px;"', 'value', 'text', $return_meridian);
			    }
			    ?>
			</div>
			<?php } ?>
		    </div>
		</div>
	    </div>
	    
	    <?php
	    if((int)$elsettings->show_return_extras==1 )
	    {
		$show_return_extra_wrapper = ' display:none;';
		if($session->get('returnjurney', 0) == 1 ){
		    $show_return_extra_wrapper = ' display:block;';
		}
		$template_dir = JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'templates'.DS.'return_extras.tpl.php';
		?>
		<div class="ver_input_wrap clearfix bottom" id="return_extra_wrapper" style="<?php echo $show_return_extra_wrapper;?>">
		    <?php echo booking_helper::get_selected_return_extras($template_dir);?>
		</div>
	    <?php } ?>
	    <?php } ?>
	    
	</div>
	
	<?php if( (int)$elsettings->show_shuttles_tab==1 && $is_shuttles_enabled){ ?>
	<div class="verticl_booking_bottompart shuttle clearfix">
	    <div class="date_Wrap left">
		<div class="date_input clearfix">
		    <label><?php echo JText::_('SHUTTLES_AVAILABLE_SEATS');?></label>
		    <input type="text" name="shuttle_passengers" id="shuttle_passengers" readonly="readonly" class="date_inputbox" value="" />
		</div>
	    </div>
	</div>
	<?php } ?>
	
	<input type="button" class="submit see_price" value="<?php echo JText::_('SEE_PRICE'); ?>" />
    </div>
    
    </form>
</div>

<div id="dialog-hrs" title="<?php echo JText::_('HRS');?>" style="display:none;">
   <div id="hrs-wrapper"></div>
</div>
<div id="dialog-mins" title="<?php echo JText::_('MINS');?>" style="display:none;">
   <div id="mins-wrapper"></div>
</div>
<div id="dialog-return-hrs" title="<?php echo JText::_('HRS');?>" style="display:none;">
   <div id="return-hrs-wrapper"></div>
</div>
<div id="dialog-return-mins" title="<?php echo JText::_('MINS');?>" style="display:none;">
   <div id="return-mins-wrapper"></div>
</div>
<div id="dialog-shuttle-passengers" title="<?php echo JText::_('SHUTTLES_AVAILABLE_SEATS');?>" style="display:none;">
   <div id="shuttle-passengers-wrapper"></div>
</div>

<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-1.8.3.min.js"></script>
<script type="text/javascript">
var tbjQuery = $.noConflict( true );
var BASE_URL = '<?php echo JURI::root();?>';
var HOURLY_HIRE_TAB_LABEL = "<?php echo JText::_('HOURLY_HIRE_TAB_LABEL');?>";
var SHUTTLES_TAB_LABEL = "<?php echo JText::_('SHUTTLES_TAB_LABEL');?>";
var ORDER_RETURN_DATE_TXT = "<?php echo JText::_('ORDER_RETURN_DATE');?>";
var HRS_TXT="<?php echo JText::_('HRS');?>";
var MINS_TXT="<?php echo JText::_('MINS');?>";

var geocoder, map, mapOptions, areaOfOperation;

var selectedAreaVerticesStr = '<?php echo $elsettings->operation_area_vertices; ?>';
var triangleCoords = new Array();
var selectedAreaVerticesArr = JSON.parse(selectedAreaVerticesStr);

var disabledDates = [];
<?php
if(!empty($disabled_dates)){
    $js_array = json_encode($disabled_dates);
    echo "disabledDates = ". $js_array . ";\n";
}
?>

var tbConfig = {
    default_tab: <?php echo $default_tab_index;?>,
    pickup_in_area_operation: <?php echo (int)$elsettings->pickup_in_area;?>,
    dropoff_in_area_operation:<?php echo (int)$elsettings->dropoff_in_area;?>,
    pickup_dropoff_in_area_operation:<?php echo (int)$elsettings->pickup_dropoff_in_area;?>	
};
</script>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery-ui.js"></script>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.ui.datepicker-<?php echo $lang_tag;?>.js"></script>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/js/jquery.selectbox-0.2.min.js"></script>
<script type="text/javascript" src="<?php echo JURI::root();?>components/com_taxibooking/assets/fancybox/jquery.fancybox-1.3.4.pack.js"></script>
<link rel="stylesheet" type="text/css" href="<?php echo JURI::root();?>components/com_taxibooking/assets/fancybox/jquery.fancybox-1.3.4.css" media="screen" />

<script type="text/javascript" src="<?php echo JURI::root();?>modules/mod_taxibooking/assets/js/modtaxibooking.js"></script>

<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAwlZ4dHSNsz5fNCiVuWkJZ0C8T5F11z6o&v=3.exp&libraries=places"></script>
<script type="text/javascript">
tbjQuery(document).ready(function(){
    // route autocomplete
    <?php if( (int)$elsettings->show_offers_tab==1 && $lists['has_any_route']){ ?>
    <?php if($session->get('route_swapped', 0)==0){ ?>
    tbjQuery("#route_category_fld").autocomplete({
        source: <?php echo $lists['route_categories_data'];?>,		
        minLength: 2,
        open: function( event, ui ) {
            tbjQuery('div.routes_wrapper div.routecategory_dropdown_wrapper').hide();
        },
        select: function(event, ui) {
            tbjQuery('#route_category').val(ui.item.id);
	    tbjQuery('#route_category_fld').val(ui.item.value);
	    tbjQuery('div.routes_wrapper div.routecategory_dropdown_wrapper').hide();
	    // unset routes
	    tbjQuery('#route_from').val(0);
	    tbjQuery('#route_from_fld').val('');
	    tbjQuery('#route_to').val(0);
	    tbjQuery('#route_to_fld').val('');
	    // unset all the poi/address selection below
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery.fn.collectRouteFrom();
	    tbjQuery('#booking_type').val('offers');
        }
    })
    tbjQuery("#route_category_dropoff_fld").autocomplete({
        source: <?php echo $lists['route_categories_dropoff_data'];?>,		
        minLength: 2,
        open: function( event, ui ) {
            tbjQuery('div.routes_wrapper div.routecategory_dropoff_dropdown_wrapper').hide();
        },
        select: function(event, ui) {
            tbjQuery('#route_category_dropoff').val(ui.item.id);
	    tbjQuery('#route_category_dropoff_fld').val(ui.item.value);
	    tbjQuery('div.routes_wrapper div.routecategory_dropoff_dropdown_wrapper').hide();
	    // unset routes
	    tbjQuery('#route_to').val(0);
	    tbjQuery('#route_to_fld').val('');
	    // unset all the poi/address selection below
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery.fn.collectRouteTo();
	    tbjQuery('#booking_type').val('offers');
        }
    })
    tbjQuery("#route_from_fld").autocomplete({
        source: <?php echo $lists['pickup_route_poi_data'];?>,		
        minLength: 2,
        open: function( event, ui ) {
            tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').hide();
        },
        select: function(event, ui) {
            tbjQuery('#route_from').val(ui.item.id);
	    tbjQuery('#route_from_fld').val(ui.item.value);
	    tbjQuery('div.routes_wrapper div.routefrom_dropdown_wrapper').hide();
	    // unset all the poi/address selection below
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery.fn.getExtras('route_pickup');
	    // collect route to
	    tbjQuery.fn.collectRouteTo();
	    tbjQuery('#booking_type').val('offers');
        }
    })
    tbjQuery("#route_to_fld").autocomplete({
        source: <?php echo $lists['dropoff_route_poi_data'];?>,		
        minLength: 2,
        open: function( event, ui ) {
            tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').hide();
        },
        select: function(event, ui) {
            tbjQuery('#route_to').val(ui.item.id);
	    tbjQuery('#route_to_fld').val(ui.item.value);
	    tbjQuery('div.routes_wrapper div.routeto_dropdown_wrapper').hide();
	    // unset all the poi/address selection below
	    tbjQuery.fn.unsetPoiAddress();
	    tbjQuery.fn.unsetHourlyHire();
	    tbjQuery.fn.getExtras('route_dropoff');
	    tbjQuery('#booking_type').val('offers');
        }
    })
    <?php } ?>
    <?php } ?>
    
    <?php if((int)$elsettings->show_from_poi==1 && (int)$elsettings->show_from_address==0){ ?>
    tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').css('top','49px');
    <?php } ?>
    
    <?php if((int)$elsettings->show_to_poi==1 && (int)$elsettings->show_to_address==0){ ?>
    tbjQuery('div.dropoff_wrap div.poi_dropdown_wrapper').css('top','49px');
    <?php } ?>
    
    // customer can't choose return date previous to the pickup date
    <?php if($session->get('timestr2', '')=='' && $session->get('returnjurney', 0) == 0){ ?>
    var order_date_day = tbjQuery('#pickup_day').val();
    tbjQuery('#return_day').val(order_date_day);
    
    var order_date_month = tbjQuery('#pickup_month').val();
    tbjQuery('#return_month').val(order_date_month);
    
    var order_date_year = tbjQuery('#pickup_year').val();
    tbjQuery('#return_year').val(order_date_year);
    <?php } ?>
    
    <?php if($elsettings->enable_stops==1) { ?>
    tbjQuery('a.addstop').click(function(){
	
	var stops_counter = tbjQuery('div.stops_wrap').length;
	if(stops_counter > 7){
	    alert("<?php echo JText::_('MAXIMUM_NUMBER_STOPS');?>");
	    return false;
	}
	
	var html = '<div class="topinnerWrap stops_wrap last clearfix">'+
			'<div class="top_ver_input_wrapOuter clearfix">'+
			    '<div class="top_ver_input_wrap clearfix">';
	
	<?php if($elsettings->show_stop_address==1) { ?>
	html 	+= 	'<div class="getlocationField">'+
				'<a class="dropoff_direction" href="javascript:void(0);" onclick="get_user_location(\'waypoints\', this);">'+"<?php echo JText::_('GET_LOCATION'); ?>"+'</a>'+
			'</div>';
	<?php } ?>
	
	<?php
	$additional_class = '';
	$additional_class .= ($elsettings->show_stop_poi==0) ? ' poi_disabled' : '';
	$additional_class .= ($elsettings->show_stop_address==0) ? ' address_disabled' : '';
	?>
	
	html 	+= 	'<div class="inputField<?php echo $additional_class;?>">'+
			    '<input type="text" class="inputbox waypoints" name="waypoints['+stops_counter+']" id="waypoint_'+stops_counter+'" value="" placeholder="'+"<?php echo ($elsettings->show_stop_address==1)?JText::_('ENTER_ADDRESS'):JText::_('SELECT_PLACE'); ?>"+'" />'+
			    '<input type="hidden" name="waypoints_lat['+stops_counter+']" id="waypoint_lat" value="" />'+
			    '<input type="hidden" name="waypoints_lng['+stops_counter+']" id="waypoint_lng" value="" />'+
			'</div>';
	
	<?php if($elsettings->show_stop_poi==1) { ?>
	html   	+=	'<div class="selectField-wrap">'+
			    '<div class="selectField">'+
				'<div class="arrow_wrapper poi_options_trigger stop_'+stops_counter+'">trigger_icon</div>'+
				'<div class="poi_dropdown_wrapper stop_'+stops_counter+'" style="display:none;">';
	<?php
	if(!empty($lists['all_places_data'])){
	    foreach($lists['all_places_data'] as $place){    
	?>
	html	+=	'<div class="poi_link" data-poiid="<?php echo $place->id;?>" data-poilat="<?php echo $place->lat;?>" data-poilng="<?php echo $place->long;?>">';
	html	+=	'<?php echo ($place->image!="") ? '<img src="'.JURI::base().$place->image.'" alt="" class="poicat_icon" />&nbsp;' : '';?>';
	html	+=	"<span><?php echo $place->title;?></span></div>";
	<?php
	    }
	}
	?>
	html   	+=		'</div>'+
			    '</div>'+
			'</div>';
	<?php } ?>
	html 	+= '</div>';
	html += 	'<div class="time_at_stop clearfix">';
	html += 		'<div class="title_stops">'+"<?php echo JText::_('TIME_AT_STOP'); ?>"+'</div><select name="waypoints_stop_duration['+stops_counter+']" class="stop_interval_options" tabindex="1">';
	<?php 
	for($i = $stop_duration_interval; $i <= ($max_stop_time*60); $i = $i + $stop_duration_interval){
	?>
	html 	+= '<option value="<?php echo $i;?>"><?php echo $i;?> mins</option>';
	<?php } ?>
	html += '</select></div><a href="javascript:void(0);" class="remove_stops">'+"<?php echo JText::_('REMOVE_STOP');?>"+'</a>';
				
	html 	+= 	'</div>'+
		    '</div>';
	
	tbjQuery('#stops_wrapper').append(html);
	tbjQuery(".stop_interval_options").selectbox();
	
	// bind place autocomplete to this waypoint
	<?php  if($elsettings->default_country!="") {?>
	var options = {
	    componentRestrictions: {country: '<?php echo $default_country;?>'}
	};
	<?php } else { ?>
	var options = {};
	<?php } ?>
	
	<?php if($elsettings->show_stop_address==1) { ?>
	var waypoint_field = document.getElementById('waypoint_'+stops_counter);
	var waypoint_autocomplete = new google.maps.places.Autocomplete(waypoint_field, options);
	google.maps.event.addListener(waypoint_autocomplete, 'place_changed', function() {
	    var place = waypoint_autocomplete.getPlace();
	    if (place.geometry) {
		tbjQuery(waypoint_field).siblings('#waypoint_lat').val(place.geometry.location.lat());
		tbjQuery(waypoint_field).siblings('#waypoint_lng').val(place.geometry.location.lng());
	    }
	});
	<?php } ?>
	
	<?php if($elsettings->show_stop_poi==1) { ?>
	tbjQuery('div.dropoff_wrap div.stops_wrap div.poi_options_trigger.stop_'+stops_counter).click(function(){
	    if(tbjQuery(this).hasClass('Open') == true){
		tbjQuery(this).removeClass("Open");
	    }
	    else {
		tbjQuery(this).addClass("Open");
	    }
	    if (tbjQuery(this).next('div.poi_dropdown_wrapper.stop_'+stops_counter).is(":visible") == true){
		tbjQuery(this).next('div.poi_dropdown_wrapper.stop_'+stops_counter).slideUp(250);
	    }
	    else {
		tbjQuery(this).next('div.poi_dropdown_wrapper.stop_'+stops_counter).slideDown(250);
	    }        
	})
	tbjQuery("div.dropoff_wrap div.stops_wrap div.poi_dropdown_wrapper div.poi_link").click(function(){
	    tbjQuery(this).closest('div.stops_wrap').find('.waypoints').val(tbjQuery(this).children('span').html());
	    tbjQuery(this).closest('div.stops_wrap').find('#waypoint_lat').val(tbjQuery(this).data('poilat'));
	    tbjQuery(this).closest('div.stops_wrap').find('#waypoint_lng').val(tbjQuery(this).data('poilng'));
	    tbjQuery(this).closest('div.stops_wrap').find("div.poi_dropdown_wrapper").hide();
	    tbjQuery(this).closest('div.stops_wrap').find('.poi_options_trigger.stop_'+stops_counter).removeClass('Open');
	})
	<?php } ?>
    })
    tbjQuery('div.dropoff_wrap').on('click', '.remove_stops', function() { // code
	tbjQuery(this).closest('div.stops_wrap').remove();
    });
    <?php } ?>
})

function initialize() {
    for (var i =0; i < selectedAreaVerticesArr.length; i++) {
	triangleCoords.push(new google.maps.LatLng(selectedAreaVerticesArr[i][0],selectedAreaVerticesArr[i][1]));
    }
    areaOfOperation = new google.maps.Polygon({
	paths: triangleCoords
    });
    
    <?php  if($elsettings->default_country!="") {?>
    var options = {
        componentRestrictions: {country: '<?php echo $default_country;?>'}
    };
    <?php } else { ?>
    var options = {};
    <?php } ?>
    
    <?php if($elsettings->show_from_address==1){ ?>
    var address_from_input = document.getElementById('address_from');
    var address_from_autocomplete = new google.maps.places.Autocomplete(address_from_input, options);
    
    tbjQuery("#address_from").change(function(){
	tbjQuery('#address_from_lat').val("");
	tbjQuery('#address_from_lng').val("");
	tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').hide();
    });
    google.maps.event.addListener(address_from_autocomplete, 'place_changed', function() {
	tbjQuery('div.pickup_wrap div.poi_dropdown_wrapper').hide();
	var place = address_from_autocomplete.getPlace();
	if (place.geometry) {
	    // first check if this Address is in Area of Operation
	    <?php if( (int)$elsettings->pickup_in_area==1 || (int)$elsettings->pickup_dropoff_in_area==1) { ?>
	    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(place.geometry.location.lat(),place.geometry.location.lng()), areaOfOperation)) {
		showAreaOperationPopup();
		return false;
	    }
	    <?php }?>
	    
	    tbjQuery('#address_from_lat').val(place.geometry.location.lat());
	    tbjQuery('#address_from_lng').val(place.geometry.location.lng());
	    tbjQuery.fn.unsetRoute();
	    tbjQuery.fn.unsetHourlyHire();
	    // set booking type
	    tbjQuery('div#pickup_extra_wrapper').html('');
	    tbjQuery('#booking_type').val('address');
	    tbjQuery("#address_from").removeClass('incorrect');
	    tbjQuery.fn.getExtras('address_pickup');
	    
	    // regenerate return route with extra if Return Journey is selected
	    if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
		tbjQuery.fn.getReturnExtras();
	    }
	}
    });
    <?php } ?>
    
    <?php if($elsettings->show_to_address==1){ ?>
    var address_to_input = document.getElementById('address_to');
    var address_to_autocomplete = new google.maps.places.Autocomplete(address_to_input, options);
    
    tbjQuery("#address_to").change(function(){
	tbjQuery('#address_to_lat').val("");
	tbjQuery('#address_to_lng').val("");
	tbjQuery('div.dropoff_wrap div.poi_dropdown_wrapper').hide();
    });
    google.maps.event.addListener(address_to_autocomplete, 'place_changed', function() {
	tbjQuery('div.dropoff_wrap div.poi_dropdown_wrapper').hide();
	var place = address_to_autocomplete.getPlace();
	if (place.geometry) {
	    <?php if( (int)$elsettings->dropoff_in_area==1 || (int)$elsettings->pickup_dropoff_in_area==1) { ?>
	    if (!google.maps.geometry.poly.containsLocation(new google.maps.LatLng(place.geometry.location.lat(),place.geometry.location.lng()), areaOfOperation)) {
		showAreaOperationPopup();
		return false;
	    }
	    <?php }?>
	    
	    tbjQuery('#address_to_lat').val(place.geometry.location.lat());
	    tbjQuery('#address_to_lng').val(place.geometry.location.lng());
	    tbjQuery.fn.unsetRoute();
	    tbjQuery.fn.unsetHourlyHire();
	    // set booking type
	    tbjQuery('div#dropoff_extra_wrapper').html('');
	    tbjQuery('#booking_type').val('address');
	    tbjQuery("#address_to").removeClass('incorrect');
	    tbjQuery.fn.getExtras('address_dropoff');
	    // regenerate return route with extra if Return Journey is selected
	    if(tbjQuery('#returnjurney').is(':checked') && tbjQuery('#show_return_extras').val()==1){
		tbjQuery.fn.getReturnExtras();
	    }
	}
    });
    <?php } ?>
    
    tbjQuery('.waypoints').each(function(){
	var waypoint_field = this;
	var waypoint_autocomplete = new google.maps.places.Autocomplete(waypoint_field, options);
	google.maps.event.addListener(waypoint_autocomplete, 'place_changed', function() {
	    var place = waypoint_autocomplete.getPlace();
	    if (place.geometry) {
		tbjQuery(waypoint_field).siblings('#waypoint_lat').val(place.geometry.location.lat());
		tbjQuery(waypoint_field).siblings('#waypoint_lng').val(place.geometry.location.lng());
	    }
	});
    })
}

google.maps.event.addDomListener(window, 'load', initialize);
</script>