<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Availability Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class TaxibookingApiResourceAvailability extends ApiResource
{

	/**
	 * Function post for availability 
	 *
	 *
	 * @return void
	 */
	public function post()
	{
		$app = JFactory::getApplication();
		$userIdentifier = $app->input->get('id');
		$formData = $app->input->getArray();
		$params = JComponentHelper::getParams("com_users");
		$response = new stdClass;
		
		if (empty($formData['days'])) {
			ApiError::raiseError(400, 'Incorrect post request, missing fields');
			return;
		}

		if (!$user = $this->getUser($userIdentifier)) {
			ApiError::raiseError(400, 'User not found');
			return;
		}
		
		$this->deleteAllDates($userIdentifier); // todo: check if date is there and only delete dates that are not there.
		$days = explode(",", $formData['days']);

		foreach ($days as $day) {
			if (!$this->addAvailability($userIdentifier, $day, $formData['message'])) {
				ApiError::raiseError(400, 'Problem saving to the db');
				return;
			}
		}

		$this->plugin->setResponse('Calendar saved successfully, thank you!');

	}

	private function addAvailability($userid, $day, $message = '') 
	{
		$avail = new stdClass();
		$avail->driver_id = $userid;
		$avail->day = $day;
		if (!empty($message)) {
			$avail->message = $message;
		}

		if ($this->getAvailability($avail)) {
			return true;
		}

		return JFactory::getDbo()->insertObject('#__taxibooking_driver_unavailable', $avail);
	}

	private function deleteAllDates($id) 
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$conditions = array(
		$db->quoteName('driver_id') . ' = ' . $db->quote($id)
		);
		$query->delete($db->quoteName('#__taxibooking_driver_unavailable'))
			->where($conditions);

		$db->setQuery($query);
		$db->execute();
	}

	private function getUser($id) 
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('name', 'username', 'email', 'id')));
		$query->from($db->quoteName('#__users'));
		$query->where($db->quoteName('id')." = ".$db->quote($id));
		$db->setQuery($query);
		
		return $db->loadObject();
	}

	private function getAvailability($avail) 
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id');
		$query->from($db->quoteName('#__taxibooking_driver_unavailable'));
		$query->where($db->quoteName('driver_id')." = ".$db->quote($avail->driver_id));
		$query->where($db->quoteName('day')." = ".$db->quote($avail->day));
		$db->setQuery($query);
		$db->execute();
		if ($db->getNumRows() > 0) {
			return true;
		}
		return false;
	}

	/**
	 * Function get for availability 
	 *
	 *
	 * @return void
	 */
	public function get()
	{
		$app = JFactory::getApplication();
		$userIdentifier = $app->input->get('id');

		$this->plugin->setResponse($this->getAvailabilityDays($userIdentifier));
	}

	private function getAvailabilityDays($id)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('day');
		$query->from($db->quoteName('#__taxibooking_driver_unavailable'));
		$query->where($db->quoteName('driver_id')." = ".$db->quote($id));
		$db->setQuery($query);

		$query->order('id DESC');
		$query->setLimit(50);

		$db->setQuery($query);

		$res = $db->loadObjectList();
		if (count($res) < 1) {
			return array();
		}
		return $this->fixDays($res);
	}

	private function fixDays($arr) 
	{
		$fixed = [];
		foreach ($arr as $key => $value) {
			$fixed[] = $value->day;
		}
		
		return $fixed;
	}
	
}
