<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Messages Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class TaxibookingApiResourceMessages extends ApiResource
{

	/**
	 * Function get for messages 
	 *
	 * @return void
	 */
	public function get()
	{

		$input = JFactory::getApplication()->input;
		$id = $input->get('id');
		if ($input->get('unread')) {
			$res = $this->getUnread($id);
			$this->plugin->setResponse($res);
		} elseif ($mid = $input->get('markRead')) {
			if ($this->markAsRead($mid)) {
				$this->plugin->setResponse(['OK', $mid]);
			} else {
				ApiError::raiseError(400, 'Could not update message state');
				return;
			}
		} elseif ($id) {
			$res = $this->getMessages($id);
			$this->plugin->setResponse($res);
		}
	}

	/**
	 * Function post for messages 
	 *
	 * @return void
	 */
	public function post()
	{
		$app = JFactory::getApplication();
		$formData = $app->input->getArray();
		
	}

	private function markAsRead($mid) 
	{
		$message = new stdClass();
		$message->message_id = $mid;
		$message->state = 1;
		$result = JFactory::getDbo()->updateObject('#__messages', $message, 'message_id');
		return $result;
	}
	
	private function getMessages($id)
	{
		$db = JFactory::getDbo();

		$query = $db->getQuery(true);

		$query->select('*')->from($db->quoteName('#__messages'));
		$query->where($db->quoteName('user_id_to')." = ".$db->quote($id));
		$query->order('date_time DESC');
		$query->setLimit(20);

		$db->setQuery($query);

		$res = $db->loadObjectList();
		if (count($res) < 1) {
			return array('No results!');
		}
		
		return $this->addSenders($res);
	}

	private function getUnread($id)
	{
		$db = JFactory::getDbo();

		$query = $db->getQuery(true);

		$query->select('message_id')->from($db->quoteName('#__messages'));
		$query->where(array($db->quoteName('state')." = ".$db->quote('0'), $db->quoteName('user_id_to')." = ".$db->quote($id)));
		$db->setQuery($query);
		$db->execute();
		return $db->getNumRows();
	}

	private function addSenders($results)
	{
		foreach ($results as $key => $value) {
			$results[$key]->from_name = $this->getName($value->user_id_from);
		}
		return $results;
	}

	private function getName($id) 
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select('name')->from($db->quoteName('#__users'));
		$query->where($db->quoteName('id')." = ".$db->quote($id));

		$db->setQuery($query);

		return $db->loadResult();
	}
	
}
