<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Order Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class TaxibookingApiResourceOrder extends ApiResource
{

	/**
	 * Function get for orders 
	 *
	 * @return void
	 */
	public function get()
	{

		$input = JFactory::getApplication()->input;

		// If we have an id try to fetch the user
		if ($id = $input->get('id'))
		{
			if ($input->get('driver') == 'yes') {
				$res = $this->getOrdersbyIdforDriver($id);
				$this->plugin->setResponse($res);
			} else {
				$res = $this->getOrdersbyId($id);
				$this->plugin->setResponse($res);
			}
			
		}
	}

	private function getOrdersbyId($id)
	{
		$id_user = $this->getTaxiUser($id);
		$email_user = $this->getEmailforUser($id);
		// return $email_user;
		$db = JFactory::getDbo();

		$query = $db->getQuery(true);

		// $query->select('*');
		// $query->select($db->quoteName(array('names', 'begin', 'end', 'invoice_title', 'custom_car', 'custom_payment', 'cprice', 'state', 'datetime1', 'id', 'pickup_lat', 'pickup_lng', 'dropoff_lat', 'dropoff_lng')));
		$query->select($db->quoteName(array('names', 'begin', 'end', 'invoice_title', 'cprice', 'state', 'datetime1', 'id', 'driver_id', 'message')));
		$query->from($db->quoteName('#__taxibooking_orders'));
		// $query->where($db->quoteName('created_by')." = ".$db->quote($id_user));
		$query->where($db->quoteName('email')." = ".$db->quote($email_user));
		// $query->where($db->quoteName('email') . ' LIKE ' . $db->quote($email_user));
		$query->order('datetime1 DESC');
		$query->setLimit(20);

		// return $query->__toString();

		$db->setQuery($query);

		$res = $db->loadObjectList();
		if (count($res) < 1) {
			return array('No results!');
		}
		$res2 = $this->fixDates($res);
		return $this->getDrivers($res2);
	}


	private function getOrdersbyIdforDriver($id)
	{
		/* taxibooking component. users will have a different username for taxibooking, but drivers not. point of it? reasons... */
		// $id_user = $this->getTaxiUser($id);
		$db = JFactory::getDbo();

		$query = $db->getQuery(true);

		// $query->select('*')->from($db->quoteName('#__taxibooking_orders'));
		$query->select($db->quoteName(array('names', 'begin', 'end', 'invoice_title', 'cprice', 'state', 'datetime1', 'id', 'message')));
		$query->from($db->quoteName('#__taxibooking_orders'));
		$query->where($db->quoteName('driver_id')." = ".$db->quote($id));
		$query->order('datetime1 DESC');
		$query->setLimit(20);

		$db->setQuery($query);

		// return $query->__toString();

		$res = $db->loadObjectList();
		return $this->fixDates($res);
	}

	private function getDrivers($results)
	{
		$clean = [];
		foreach ($results as $key => $value) {
			foreach ($value as $key2 => $value2) {
				if ($key2 == 'driver_id' && !empty($value2)) {
					$clean[$key][$key2] = $this->getDriverName($value2);
				} elseif ($key2 == 'driver_id' && empty($value2)) {
					$clean[$key][$key2] = 'no driver assigned yet';
				} else {
					$clean[$key][$key2] = $value2;
				}
			}
		}

		return $clean;
	}

	private function getEmailforUser($id)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select('email');
		$query->from($db->quoteName('#__users'));
		$query->where($db->quoteName('id')." = ".$db->quote($id));

		$db->setQuery($query);

		return $result = $db->loadResult();
	}

	private function getDriverName($id)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select('name');
		$query->from($db->quoteName('#__users'));
		$query->where($db->quoteName('id')." = ".$db->quote($id));

		$db->setQuery($query);

		return $result = $db->loadResult();
	}

	
}
