<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Orders Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class TaxibookingApiResourceOrders extends ApiResource
{

	/**
	 * Function get for orders 
	 *
	 * @return void
	 */
	public function get()
	{

		$input = JFactory::getApplication()->input;

		// If we have an id try to fetch the user
		if ($id = $input->get('id'))
		{
			if ($input->get('driver') == 'yes') {
				if ($input->get('pay') == 'yes') {
					$res = $this->getOrdersbyIdforDriver($id, true);
					$this->plugin->setResponse($res);
				} else {
					$res = $this->getOrdersbyIdforDriver($id, false);
					$this->plugin->setResponse($res);
				}
			
			} elseif ($input->get('removeDriverFromOrder')) {
				$res = $this->removeDriver($id);
				$this->plugin->setResponse($res);
			} else {
				$res = $this->getOrdersbyId($id);
				$this->plugin->setResponse($res);
			}
		}
	}
	/*
	 * order state: 1 - accepted, -1 - archived, 0 - rejected
	 * invoice path kabsky.co.uk/administrator/components/com_taxibooking/documents/kabsky_751.pdf
	 * datetime1 is pick-up (hopefully): 1549688700 - date('m/d/Y', 1549688700);
	 */
	private function getOrdersbyId($id)
	{
		$id_user = $this->getTaxiUser($id);
		$email_user = $this->getEmailforUser($id);
		$db = JFactory::getDbo();

		$query = $db->getQuery(true);

		$query->select($db->quoteName(array('names', 'begin', 'end', 'invoice_title', 'cprice', 
		'state', 'datetime1', 'id', 'driver_id', 'message', 'stops')));
		$query->from($db->quoteName('#__taxibooking_orders'));
		$query->where($db->quoteName('email')." = ".$db->quote($email_user));
		$query->order('datetime1 DESC');
		$query->setLimit(20);

		$db->setQuery($query);

		$res = $db->loadObjectList();
		if (count($res) < 1) {
			return [];
		}
		$resultsNoStops = $this->fixDates($res);
        $results = $this->fixStops($resultsNoStops);
		return $this->getDrivers($results);
	}


	private function getOrdersbyIdforDriver($id, $pay)
	{
		/* taxibooking component. users will have a different username for taxibooking, but drivers not. point of it? reasons... */
		$db = JFactory::getDbo();

		$query = $db->getQuery(true);

		$query->select($db->quoteName(array(
			'names', 'begin', 'end', 'invoice_title', 'cprice', 'state', 'datetime1', 
			'id', 'message', 'returntrip', 'datetime2', 'stops' )));
		$query->from($db->quoteName('#__taxibooking_orders'));
		$query->where($db->quoteName('driver_id')." = ".$db->quote($id));
		$query->order('datetime1 DESC');
		$query->setLimit(20);

		$db->setQuery($query);

		$res = $db->loadObjectList();
		
		if ($pay) {
			$res2 = $this->addWeeklyPrices($res);
			$res3 = $this->fixDates($res);
			return $this->addDailyPrices($res3, $res2);
		}

		$resultsNoStops = $this->fixDates($res);
        $results = $this->fixStops($resultsNoStops);
		return $this->addReturns($results);
	}

	private function fixDates($results) 
	{
		$clean = [];
		foreach ($results as $key => $value) {
			foreach ($value as $key2 => $value2) {
				if ($key2 == 'datetime1') {
					$date = date('d F Y, G:i', $value2);
					$clean[$key][$key2] = $date;
				} elseif ($key2 == 'datetime2') {
					$date2 = date('d F Y, G:i', $value2);
					$clean[$key][$key2] = $date2;
				} else {
					$clean[$key][$key2] = $value2;
				}
			}
		}

		return $clean;
	}

	private function fixStops($results)
	{
		$clean = [];
		foreach ($results as $key => $value) {
			foreach ($value as $key2 => $value2) {
				if ($key2 == 'stops') {
					$stops = unserialize($value2);
					$clean[$key][$key2] = $stops;
				} else {
					$clean[$key][$key2] = $value2;
				}
			}
		}

		return $clean;
	}

	private function addWeeklyPrices($clean)
	{
		$lastWeek = date('d F Y', strtotime('-7 days'));
		$prices = 0;
		foreach ($clean as $key => $value) {
			if ($value->datetime1 > strtotime($lastWeek) && $value->state != 0) {
					$prices += $value->cprice * 0.8;
			}
		}
		return $prices;
	}

	private function addDailyPrices($clean, $weeklyPrice)
	{
		$prices = 0;
		foreach ($clean as $key => $value) {
			if (strpos($value['datetime1'], date('d F Y')) !== false && $value['state'] != 0) {
					$prices += $value['cprice'] * 0.8;
			}
		}

		return ['daily' => $prices, 'weekly' => $weeklyPrice];
	}

	private function getTaxiUser($id)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select('id');
		$query->from($db->quoteName('#__taxibooking_users'));
		$query->where($db->quoteName('user_id')." = ".$db->quote($id));

		$db->setQuery($query);

		return $result = $db->loadResult();
	}

	private function getDrivers($results)
	{
		$clean = [];
		foreach ($results as $key => $value) {
			foreach ($value as $key2 => $value2) {
				if ($key2 == 'driver_id' && !empty($value2)) {
					$clean[$key][$key2] = $this->getDriverName($value2);
				} elseif ($key2 == 'driver_id' && empty($value2)) {
					$clean[$key][$key2] = 'no driver assigned yet';
				} else {
					$clean[$key][$key2] = $value2;
				}
			}
		}

		return $clean;
	}

	private function getEmailforUser($id)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select('email');
		$query->from($db->quoteName('#__users'));
		$query->where($db->quoteName('id')." = ".$db->quote($id));

		$db->setQuery($query);

		return $result = $db->loadResult();
	}

	private function getDriverName($id)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select('name');
		$query->from($db->quoteName('#__users'));
		$query->where($db->quoteName('id')." = ".$db->quote($id));

		$db->setQuery($query);

		return $result = $db->loadResult();
	}

	private function addReturns($orders)
	{
		foreach($orders as $order) 
		{
			if ($order['returntrip'] == 1) {
				$orders[] = [
						'names' => $order['names'], 'begin' => $order['end'], 'end' => $order['begin'], 
						'datetime1' => $order['datetime2'], 'id' => $order['id'], 'message' => $order['message'],
						'return' => 1
					];
			}
		}

		return $orders;
	}

	private function removeDriver($id) 
	{
		if (!$this->removeDriverFromOrder($id) or !$this->notifyAdminDriverRemoved($id)) {
			return false;
		}
		return true;
	}

	private function notifyAdminDriverRemoved($order_id)
	{
		// Get all "operator" users / group 10
		// Email all operator users about driver removed from job - stop on any error.
		$operators = $this->getUsersFromUserGroup('10');
		foreach($operators as $key => $value) {
			if (!$this->sendEmailtoOperator($value, $order_id)) {
				return false;
			}
		}
		return true;
	}

	private function getUsersFromUserGroup($group_id)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('user_id')));
		$query->from($db->quoteName('#__user_usergroup_map'));
		$query->where($db->quoteName('group_id')." = ".$db->quote($group_id));
		$db->setQuery($query);

		$operators = $db->loadAssocList();

		$cleanResultsOperators = [];
		foreach ($operators as $key => $value) {
			$cleanResultsOperators[] = $value['user_id'];
		}

		return $cleanResultsOperators;
	}

	private function removeDriverFromOrder($id)
	{
		$orderObj = new stdClass();
		$orderObj->id = $id;
		$orderObj->driver_id = '0';
		$result = JFactory::getDbo()->updateObject('#__taxibooking_orders', $orderObj, 'id');
		return $result;
	}

	private function sendEmailtoOperator($user_id, $order_id) 
	{
		$mailer = JFactory::getMailer();
		$config = JFactory::getConfig();
		$sender = array( 
			$config->get( 'mailfrom' ),
			$config->get( 'fromname' ) 
		);

		$mailer->setSender($sender);
		$recipient = $this->getEmailForUser($user_id);
		$mailer->addRecipient($recipient);

		$body   = '<h2>Hello there!</h2>
					<p>The driver assigned to the job ' . $order_id . ' removed itself from the job. A new driver will have to be allocated to this job.</p> 
					<p>Please go to the <a href="https://kabsky.co.uk/administrator/index.php?option=com_taxibooking&view=order&layout=default&id=' . $order_id . '">order</a> and assign a new driver.</p>
					<br><br><p>Kabsky</p>';
		$mailer->setSubject('Driver refused job Id ' . $order_id);
		$mailer->setBody($body);
		$mailer->isHtml(true);
		$mailer->Encoding = 'base64';
		$mailer->setBody($body);

		$send = $mailer->Send();
		if ( $send !== true ) {
			return false;
		}

		return true;

	}

	
}
