<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Payment Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class TaxibookingApiResourcePayment extends ApiResource
{

	/**
	 * Function post for payment from apps 
	 *
	 *
	 * @return void
	 */
	public function post()
	{
		$app = JFactory::getApplication();
		$userIdentifier = $app->input->get('id');
		$formData = $app->input->getArray();
		$params = JComponentHelper::getParams("com_users");
		$response = new stdClass;
		if (empty($formData['source'])) {
			ApiError::raiseError(400, 'Incorrect post request, missing fields');
			return;
		}
		(int)$amount = $formData['amount'] * 100;
		
		if ($this->processPayment($userIdentifier, $formData['source'], $amount, $formData['from'], $formData['to'])) {
			$this->plugin->setResponse('Payment saved succesfully');
		}

	}

	private function processPayment($uid, $source, $amount, $from, $to) 
	{
	  
	  $ch = curl_init();
	  curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/charges');
	  curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
	  curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	  curl_setopt($ch, CURLOPT_HEADER, FALSE);
	  curl_setopt($ch, CURLOPT_POST, TRUE);
	  curl_setopt($ch, CURLOPT_POSTFIELDS, 'amount=' . $amount . '&currency=gbp&source=' . $source . '&description="Trip from "' . $from . '" to "' . $to . '" - Order on Kabsky App"');
	  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	  curl_setopt($ch, CURLOPT_USERPWD, 'sk_live_91bOWUJeEArYQ8TYJMCFVmlC' . ':' . '');
  
	  $result = curl_exec($ch);
	  $res = json_decode($result);

	  if (!isset($res->error)) {
		  return true;
	  } else {
		ApiError::raiseError(400, $res->error->message);
		return;
	  }
	}

}
