<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Position Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class TaxibookingApiResourcePosition extends ApiResource
{

	/**
	 * Function post for position 
	 *
	 *
	 * @return void
	 */
	public function post()
	{
		$app = JFactory::getApplication();
		$formData = $app->input->getArray();
		$params = JComponentHelper::getParams("com_users");
		$response = new stdClass;
		
		if ($this->addPosition($formData['driver_id'], $formData['latitude'], $formData['longitude'])) {
			$this->plugin->setResponse('Position saved succesfully.');
		}
	}

	public function get()
	{
		$app = JFactory::getApplication();
		$order_id = $app->input->get('order_id');
		// echo $order_id;
		$position = $this->getPosition($order_id);
		// print_r($position);
		// die('here');
		$this->plugin->setResponse(['lat' => $position->latitude, 'long' => $position->longitude]);
	}

	private function addPosition($driver_id, $latitude, $longitude) 
	{
		$old_position = $this->getPositionDriver($driver_id);
		$position = new stdClass();
		$position->driver_id = $driver_id;
		$position->latitude = $latitude;
		$position->longitude = $longitude;

		$result = JFactory::getDbo()->insertObject('#__driver_position', $position);
		if ($old_position->id) {
			$this->deletePosition($old_position->id);
		}
		return $result;
	}

	private function getPosition($order_id) 
	{
		$driver_id = $this->getDriverForOrder($order_id);
		// print_r($driver_id);
		// die('driverid');
		if ($driver_id) {
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('id', 'latitude', 'longitude')));
			$query->from($db->quoteName('#__driver_position'));
			$query->where($db->quoteName('driver_id')." = ".$db->quote($driver_id));
			$db->setQuery($query);
			
			return $db->loadObject();
		}

		return [];
	}

	private function getPositionDriver($driver_id) 
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'latitude', 'longitude')));
		$query->from($db->quoteName('#__driver_position'));
		$query->where($db->quoteName('driver_id')." = ".$db->quote($driver_id));
		$db->setQuery($query);
		
		return $db->loadObject();
	}


	private function getDriverForOrder($order_id) 
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('driver_id')));
		$query->from($db->quoteName('#__taxibooking_orders'));
		$query->where($db->quoteName('id')." = ".$db->quote($order_id));
		$db->setQuery($query);
		
		return $db->loadResult();
	}

	private function deletePosition($id)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->delete($db->quoteName('#__driver_position'));
		$query->where($db->quoteName('id') . ' = ' . $db->quote($id));
		$db->setQuery($query);
		$result = $db->execute();
	}
	
}
