<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Reviews Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class TaxibookingApiResourceReviews extends ApiResource
{

	/**
	 * Function post for reviews 
	 *
	 *
	 * @return void
	 */
	public function post()
	{
		$app = JFactory::getApplication();
		$userIdentifier = $app->input->get('id');
		$formData = $app->input->getArray();
		$params = JComponentHelper::getParams("com_users");
		$response = new stdClass;
		
		if (empty($formData['title']) || empty($formData['message']) || empty($formData['avg_rate'])) {
			ApiError::raiseError(400, 'Incorrect post request, missing fields');
			return;
		}

		if (!$user = $this->getUser($userIdentifier)) {
			ApiError::raiseError(400, 'User not found');
			return;
		}

		if ($this->addReview($user, $formData)) {
			$this->plugin->setResponse('Review added succesfully, thank you!');
		}

	}

	private function addReview($user, $formData) 
	{
		$review = new stdClass();
		$review->object_type = 'com_content.article';
		$review->object_id = 1;
		$review->rating_group_id = 1;
		$review->user_name = $user->name;
		$review->user_login = $user->username;
		$review->email = $user->email;
		$review->ip = '10.10.10.10';
		$review->title = $formData['title'];
		$review->message = $formData['message'];
		$review->published = $formData['published'];
		$review->avg_rate = $formData['avg_rate'];
		$review->created_by = $user->id;
		$review->created = date("Y-m-d H:i:s");

		return JFactory::getDbo()->insertObject('#__djrevs_reviews', $review);
	}

	private function getUser($id) 
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('name', 'username', 'email', 'id')));
		$query->from($db->quoteName('#__users'));
		$query->where($db->quoteName('id')." = ".$db->quote($id));
		$db->setQuery($query);
		
		return $db->loadObject();
	}
	
}
