<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Tokens Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class TaxibookingApiResourceTokens extends ApiResource
{

	/**
	 * Function post for reviews 
	 *
	 *
	 * @return void
	 */
	public function post()
	{
		$app = JFactory::getApplication();
		$userIdentifier = $app->input->get('id');
		$formData = $app->input->getArray();
		$params = JComponentHelper::getParams("com_users");
		$response = new stdClass;
		if (empty($formData['token'])) {
			ApiError::raiseError(400, 'Incorrect post request, missing fields');
			return;
		}
		
		if ($this->addToken($userIdentifier, $formData['token'])) {
			$this->plugin->setResponse('Token saved succesfully');
		}

	}

	private function addToken($user, $tokencode) 
	{
		if ($this->tokenDoesntExist($user, $tokencode)) {
			$token = new stdClass();
			$token->user_id = $user;
			$token->token = $tokencode;
			
			return JFactory::getDbo()->insertObject('#__user_tokens', $token);
		}
		return true;
	}

	private function tokenDoesntExist($user, $token)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id');
		$query->from($db->quoteName('#__user_tokens'));
		$query->where($db->quoteName('user_id')." = ".$db->quote($user));
		$query->where($db->quoteName('token')." = ".$db->quote($token));
		$db->setQuery($query);
		$db->execute();
		if ($db->getNumRows() > 0) {
			return false;
		}
		return true;
	}
	
}
