<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Position Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class TaxibookingApiResourceUpcoming extends ApiResource
{

	/**
	 * Function get for upcoming 
	 *
	 *
	 * @return void
	 */
	public function get()
	{
		$app = JFactory::getApplication();
		$driver_id = $app->input->get('driver_id');
		$user_id = $app->input->get('user_id');
		if ($driver_id) {
			$order = $this->getUpcomingOrdersDriver($driver_id);
			if ($order) {
				$this->plugin->setResponse(true);
			}
		} elseif ($user_id) {
			$order = $this->getUpcomingOrdersUser($user_id);
			if ($order) {
				$this->plugin->setResponse($order->id);
			}
		} else {
			ApiError::raiseError(400, 'Incorrect request, missing fields');
			return;
		}
	}

	private function getUpcomingOrdersDriver($driver_id) 
	{
		$now = time() - 14400; // 4 hours ago >> 14.400 seconds
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'names', 'email', 'driver_id', 'message', 'begin', 'extras', 'driver_notified', 'datetime1')));
		$query->from($db->quoteName('#__taxibooking_orders'));
		$query->where($db->quoteName('datetime1')." >= ".$db->quote($now));
		$query->where($db->quoteName('driver_id')." = " . $db->quote($driver_id));
		$query->order('datetime1 DESC');
		$db->setQuery($query);

		return $db->loadObjectList();
	}

	private function getUpcomingOrdersUser($user_id) 
	{
		$user_email = $this->getEmailById($user_id);

		$now = time() - 14400; // 4 hours ago >> 14.400 seconds
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('id', 'names', 'email', 'driver_id', 'message', 'begin', 'extras', 'driver_notified', 'datetime1')));
		$query->from($db->quoteName('#__taxibooking_orders'));
		$query->where($db->quoteName('datetime1')." >= ".$db->quote($now));
		$query->where($db->quoteName('email')." = " . $db->quote($user_email));
		$query->order('datetime1 DESC');
		$db->setQuery($query);

		return $db->loadObject();
	}

	private function getEmailById($user_id) 
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select($db->quoteName(array('email')));
		$query->from($db->quoteName('#__users'));
		$query->where($db->quoteName('id')." = ".$db->quote($user_id));
		$db->setQuery($query);
		
		return $db->loadResult();
	}

	
}
