<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Userdelete Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class UsersApiResourceUserdelete extends ApiResource
{

	/**
	 * Function get
	 *
	 *
	 * @return bool
	 */

	public function get()
	{

		$input = JFactory::getApplication()->input;
		$id = $input->get('id'); // the userid to delete
		$result = $this->deleteUser($id);
		$this->plugin->setResponse($result);
	}

	private function deleteUser($id)
	{
		$userObj = new stdClass();
		$userObj->id = $id;
		$userObj->block = 1;
		$result = JFactory::getDbo()->updateObject('#__users', $userObj, 'id');
		return $result;
	}
	
}
