<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Userexists Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class UsersApiResourceUserexists extends ApiResource
{

	/**
	 * Function get
	 *
	 *
	 * @return bool
	 */
	public function get()
	{
		$app = JFactory::getApplication();
		$formData = $app->input->getArray();
		$this->plugin->setResponse(false);
		if ($formData['email'])
        	{
            	$exists = $this->getUserExists($formData['email']);
                $this->plugin->setResponse($this->getUserExists($formData['email']));
            }
		
	}

	private function getUserExists($email)
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('email');
		$query->from($db->quoteName('#__users'));
		$query->where($db->quoteName('email')." = ".$db->quote($email));
		$db->setQuery($query);
		$db->execute();
		if ($db->getNumRows() > 0) {
			return true;
		}
		return false;
	}
	
}
