<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_trading
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access.
defined('_JEXEC') or die;

jimport('joomla.user.user');
jimport('joomla.plugin.plugin');
jimport('joomla.user.helper');
jimport('joomla.application.component.helper');
jimport('joomla.application.component.model');
jimport('joomla.database.table.user');

// Load com_users language file
$language = JFactory::getLanguage();
$language->load('com_users');
$language->load('com_users', JPATH_SITE, 'en-GB', true);
$language->load('com_users', JPATH_ADMINISTRATOR, 'en-GB', true);
// require_once JPATH_SITE . '/libraries/joomla/filesystem/folder.php';
require_once JPATH_ROOT . '/administrator/components/com_users/models/users.php';

/**
 * Userexists Api.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_api
 *
 * @since       1.1
 */
class UsersApiResourceUserreset extends ApiResource
{

	/**
	 * Function get
	 *
	 *
	 * @return bool
	 */

	public function post()
	{
		$app = JFactory::getApplication();
		$userIdentifier = $app->input->get('email');
		$formData = $app->input->getArray();
		$params = JComponentHelper::getParams("com_users");
		$response = new stdClass;

		if (!$formData['token'] || $formData['token'] != '709637732774517651694328') {
			ApiError::raiseError(400, 'Missing security token');
			return;
		}
		
		if ($user = $this->changePassword($formData)) {
			$this->plugin->setResponse('Password changed.');
		}

		return;

	}

	private function changePassword($user)
	{
		$userObj = new stdClass();
		$userObj->email = $user['email'];
		$userObj->password = password_hash($user['password'],  PASSWORD_BCRYPT);
		$result = JFactory::getDbo()->updateObject('#__users', $userObj, 'email');
		return $result;
	}
	
}
