<?php
/** 
	* @package		Custom Canonical
	* @version		1.2.1
	* @copyright	Copyright (C) 2018 DanielMorell.com. All rights reserved. 
	* @license		http://www.gnu.org/licenses/gpl-3.0.html GNU/GPLv3 or later
*/

// Check to ensure this file is included in Joomla!
defined( '_JEXEC' ) or die( 'Restricted access' );

// Include the helper functions only once
require_once dirname(__FILE__) . '/helper.php';

// Set the separator as some idiot removed it from the core
if(!defined('DS')) define('DS', DIRECTORY_SEPARATOR);

jimport( 'joomla.plugin.plugin' );

class plgSystemCustomCanonical extends JPlugin {
	
	protected $autoloadLanguage = true;

	protected $canonical = null;
	
	function plgSystemCanonical (&$subject, $config) {
		parent::__construct($subject, $config);
		$this->_plugin = JPluginHelper::getPlugin('system', 'CustomCanonical');
		$this->_params = new JRegistry($plugin->params);

	}
	
	//Add canonical fields to Joomla back-end
	public function onContentPrepareForm($form, $data) {
		$helper = new PlgCustomCanonicalHelper();
		$plg_path  = \JURI::root(true).'/plugins/system/customcanonical';
		$article   = $this->params->get('article', '');
		$category  = $this->params->get('category', '');
		$tag       = $this->params->get('tag', '');
		$menu_item = $this->params->get('menu_item', '');

		\JForm::addFormPath(\JPATH_PLUGINS.'/system/customcanonical/params');
		
		//Article canonical
		if ($article == '1' && $form->getName()=='com_content.article') {
			$form->loadFile('article', false);
			$helper->autoLoadCanonicalBtn('article', $data);
		}
		
		//Category canonical
		if ($category == '1' && $form->getName()=='com_categories.categorycom_content') {
			$form->loadFile('category', false);
			$helper->autoLoadCanonicalBtn('category', $data);
		}
		
		//Tag canonical
		if ($tag == '1' && $form->getName()=='com_tags.tag') {
			$form->loadFile('tag', false);
			$test = $helper->autoLoadCanonicalBtn('tag', $data);
		}
		
		//Menu item canonical
		if ($menu_item == '1' && $form->getName() == 'com_menus.item') {
			$form->loadFile('menu_item', false);
			$test = $helper->autoLoadCanonicalBtn('menu', $data);
		}
	}
	
	//Remove Joomla's canonical
	function onBeforeCompileHead() {
		$app = JFactory::getApplication();
		if ($app->isAdmin()) {
			return;
		}
		
		if ($this->params->get('remove_core_canonical') == '1'){
			$doc = JFactory::getDocument();
			foreach ( $doc->_links as $k => $array ) {
				if ( $array['relation'] == 'canonical' ) {
					unset($doc->_links[$k]);
				}
			}
		}
	}
	
	//Place custom canonical on Joomla front-end
	public function onContentPrepare($context, &$item, &$params, $page) {

		$helper = new PlgCustomCanonicalHelper();

		static $is_set = false;
		if ($is_set) {
			return;
		}
		$is_set = true;
		
		$doc     = JFactory::getDocument();
		$app     = JFactory::getApplication();
		if ($app->isAdmin()) {
			return;
		}
		$option = $app->input->get('option');
		$view   = $app->input->get('view');
		
		//Get article canonical
		if ($context == "com_content.article" && ($option == "com_content" && $view == "article") && $this->params->get('article') == '1') {

			$attribs = json_decode($item->attribs);

			if(isset($attribs->canonical_url) && ($attribs->canonical_url !== '')) {

				$canonical = trim($attribs->canonical_url);

				if ($page > 0){
					$canonical = ''. $canonical .'?showall=&start='.$page.'';
				}
			}
		}

		//Get category canonical
		if ($context == "com_content.category" && ($option == "com_content" && $view == "category") && $this->params->get('category') == '1') {

			$page = $app->input->get('limitstart', 0, 'uint');

			$catid =  $app->input->get('id');

			$basePath = JPATH_ADMINISTRATOR . '/components/com_categories';
			require_once $basePath . '/models/category.php';
			$category = new CategoriesModelCategory(array('table_path' => $basePath . '/tables'));
			$category_params = $category->getItem($catid)->params;

			if (isset($category_params['canonical_url']) && ($category_params['canonical_url'] !== '')) {

				$canonical = trim($category_params['canonical_url']);

				if ($page > 0){
					$canonical = ''. $canonical .'?start='.$page.'';
				}
			}
		}
		
		//Get tag canonical
		if ($context == "com_tags.tag" && ($option == "com_tags" && $view == "tag") && $this->params->get('tag') =='1') {

			$tagid = $app->input->getInt('id');
			$basePath = JPATH_BASE . '/components/com_tags';
			require_once $basePath . '/models/tag.php';
			$tag = new TagsModelTag(array('table_path' => $basePath . '/tables'));
			$tag_details = $tag->getItem($tagid)['0'];
			$tag_params = json_decode($tag_details->params);

			if (isset($tag_params->canonical_url) && ($tag_params->canonical_url !== '')) {

				$canonical = trim($tag_params->canonical_url);
			}
		}

		//Get menu item canonical
		if (($this->params->get('menu_item') =='1')) {
			
			$currentMenuItem = $app->getMenu()->getActive();
			$item_params = json_decode($currentMenuItem->params);
			
			if (isset($item_params->canonical_url) && ($item_params->canonical_url !== '') && !isset($canonical)) {

				$canonical = trim($item_params->canonical_url);
			}
		}

		// Add canonical link to document
		if (isset($canonical) && $canonical != '') {

			$canonical = $helper->buildUrl($canonical,$this->params);

			$canonicalLink = '<link href="' . $canonical . '" rel="canonical" />';
			$doc->addCustomTag($canonicalLink);
		}
	}
}