<?php
/**
 * @author          Tassos Marinos <info@tassos.gr>
 * @link            http://www.tassos.gr
 * @copyright       Copyright © 2018 Tassos Marinos All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
 */

// No direct access to this file
defined('_JEXEC') or die;

require_once dirname(__DIR__) . '/helpers/field.php';

class JFormFieldNR_Time extends NRFormField
{

	/**
	 * Sets the time value
	 * 
	 * @var  string  $time_value
	 */
	private $time_value = null;

	/**
	 * Method to get the field input markup.
	 *
	 * @return  string  The field input markup.
	 */
	public function getInput()
	{
		// Setup properties
		$this->hint      = $this->get('hint', '00:00');
		$this->class     = $this->get('class', 'input-mini');
		$this->placement = $this->get('placement', 'top');
		$this->align     = $this->get('align', 'left');
		$this->autoclose = $this->get('autoclose', 'true');
		$this->default   = $this->get('default', 'now');
		$this->donetext  = $this->get('donetext', 'Done');

		/**
		 * When an object is created using this class, it cannot set $this->value
		 * So we set $time_value and then use it's value to display the time
		 */
		$value = !is_null($this->time_value) ? $this->time_value : $this->value;

		// Add styles and scripts to DOM
		JHtml::_('jquery.framework');
		JHtml::script('plg_system_nrframework/vendor/jquery-clockpicker.min.js', ['relative' => true, 'version' => true]);
		JHtml::stylesheet('plg_system_nrframework/vendor/jquery-clockpicker.min.css', ['relative' => true, 'version' => true]);

		static $run;
		// Run once to initialize it
		if (!$run)
		{
			$this->doc->addScriptDeclaration('
				document.addEventListener("mouseover", function(evt) {
					if (evt.target.closest(".clockpicker")) {
						var clockpicker = evt.target.closest(".clockpicker");
						jQuery(clockpicker).clockpicker();
					}
				});
        	');

			// Increase the font-size a little bit on Joomla 4
			if (defined('nrJ4'))
			{
				$this->doc->addStyleDeclaration('
			      	.clockpicker-popover {
			        	font-size: .93rem;
			        }
				');	
			}

			// Fix a CSS conflict caused by the template.css on Joomla 3
			if (!defined('nrJ4'))
			{
				// Fuck you template.css
				$this->doc->addStyleDeclaration('
					.clockpicker-align-left.popover > .arrow {
					    left: 25px;
					}
				');
			}

			$run = true;
		}

		return '
			<div class="input-group input-append clockpicker" data-donetext="' . $this->donetext . '" data-default="' . $this->default . '" data-placement="' . $this->placement . '" data-align="' . $this->align . '" data-autoclose="' . $this->autoclose . '">
				<input class="' . $this->class . ' form-control" placeholder="' . $this->hint . '" name="' . $this->name . '" type="text" class="form-control" value="' . $value . '">
				
				<span class="input-group-addon input-group-append">
					<span class="btn btn-secondary">
						<span class="icon-clock"></span>
					</span>
				</span>
			</div>';
	}

	/**
	 * Sets the $time_value of the time when created as an object
	 * due to not being able to set the $this->value byitself
	 * 
	 * @param   string  $value
	 * 
	 * @return  void
	 */
	public function setValue($value)
	{
		$this->time_value = $value;
	}
}