<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  System.Tbapp
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

class PlgSystemTbapp extends JPlugin
{
	public function onAfterInitialise()
	{
		$app = JFactory::getApplication();
		
		$json_data = array();

		// No remember me for admin
		if ($app->isAdmin())
		{
			return false;
		}
		
		$security_token = $this->params->get('security_token', '');
		$scope = JRequest::getString('scope', '');
		$action = JRequest::getString('action', '');
		$token = JRequest::getString('token', '');
		
		if($scope!='tbapp' || $action == '' || $token != $security_token)
		{
			return false;
		}
		
		if(!defined('DS')){
			define('DS',DIRECTORY_SEPARATOR);
		}
		
		if(!defined('JPATH_COMPONENT')){
			define('JPATH_COMPONENT',JPATH_ROOT.DS.'components'.DS.'com_taxibooking');
		}
		if(!defined('JPATH_ADMINISTRATOR')){
			define('JPATH_ADMINISTRATOR',JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_taxibooking');
		}
		if(!defined('JPATH_COMPONENT_SITE')){
			define('JPATH_COMPONENT_SITE',JPATH_ROOT.DS.'components'.DS.'com_taxibooking');
		}
		if(!defined('JPATH_COMPONENT_ADMINISTRATOR')){
			define('JPATH_COMPONENT_ADMINISTRATOR',JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_taxibooking');
		}
		
		switch($action){
			
			case 'getBookingFormData':
				PlgSystemTbapp::_getBookingFormData();
				break;
			
			case 'getAvailableCars':
				PlgSystemTbapp::_getAvailableCars();
				break;
			
			case 'getPaymentMethods':
				PlgSystemTbapp::_getAvailablePaymentMethods();
				break;
			
			case 'submitOrder':
				PlgSystemTbapp::_submitOrder();
				break;
			
			case 'userAuthenticate':
				PlgSystemTbapp::_userAuthenticate();
				break;
			
			case 'paypalNotification':
				PlgSystemTbapp::_paypalNotification();
				break;
			
			case 'fetchSettings':
				PlgSystemTbapp::_fetchSettings();
				break;
			
			case 'applyCoupon':
				PlgSystemTbapp::_applyCoupon();
				break;
			
			default:
				return false;
				break;
		}
	}
	
	private function _getBookingFormData()
	{
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();
		$lang_tag = 'en-GB';
		
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = strtotime($dtnow->format('Y-m-d H:i:s', true));
		
		$json_data = array('err' => 0);
		
		// Get the component configuration
		require_once (JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'booking.helper.php');
		$elsettings =  booking_helper::config();
		
		$country_2_code = booking_helper::get_country_field($elsettings->default_country, 'country_2_code');
		
		if($elsettings->date_format=='mm-dd-yy') {
			$format = 'm-d-Y';
		}
		else {
			$format = 'd-m-Y';
		}
		
		$minimum_time_allowed = $now+($elsettings->restrict_time+1)*3600;
		$first_available_pickup_date = date("$format H", $minimum_time_allowed).':00';
		
		// glean language specific header and footer info
		$terms_conditions = $elsettings->terms_conditions;
		$terms_text = isset($terms_conditions[$lang_tag]) ? $terms_conditions[$lang_tag] : '';
		
		if($elsettings->date_format=='dd-mm-yy'){
			$date_format = 'dd-mm-yyyy';
		}
		else {
			$date_format = 'mm-dd-yyyy';
		}
		
		$json_data['general'] = array('default_city' => $elsettings->default_city,
						'default_country' => $country_2_code,
						'distance_unit' => $elsettings->distance_unit,
						'currency' => $elsettings->currency,
						'currency_symbol' => $elsettings->currency_symbol,
						'default_adult_seat' => $elsettings->default_adult_seat,
						'load_current_date' => $elsettings->load_current_date,
						'date_format' => $date_format,
						'local_timezone' => $siteOffset,
						'minimum_hours_for_booking' => $elsettings->restrict_time,
						'first_available_booking_date' => $first_available_pickup_date,
						'gmap_api_key' => $elsettings->api_key,
						'gmap_api_client_id' => $elsettings->api_client_id,
						'gmap_api_client_signature' => $elsettings->api_client_signature,
						'return_discount' => $elsettings->discount,
						'show_return_wait_time' => $elsettings->wait_time_return_discount,
						'return_wait_time_hrs_discounts' => $elsettings->return_discounts,
						'send_user_booking_sms' => $elsettings->send_user_sms,
						'terms_text' => $terms_text,
						'operation_area_vertices' => $elsettings->operation_area_vertices,
						'pickup_in_area' => ((int)$elsettings->pickup_in_area==1 || (int)$elsettings->pickup_dropoff_in_area==1 ) ? 1 : 0,
						'dropoff_in_area' => ((int)$elsettings->dropoff_in_area==1 || (int)$elsettings->pickup_dropoff_in_area==1 ) ? 1 : 0
						);

		$json_data['dynamic_colors'] = array('booking_form_bgcolor' => !empty($elsettings->booking_form_bgcolor) ? $elsettings->booking_form_bgcolor : '#006599',
						     'booking_form_active_tab_color' => !empty($elsettings->booking_form_active_tab_color) ? $elsettings->booking_form_active_tab_color : '#006599',
						     'booking_form_inactive_tab_color' => !empty($elsettings->booking_form_inactive_tab_color) ? $elsettings->booking_form_inactive_tab_color : '#1aa1bf',
						     'booking_form_boxcolor' => !empty($elsettings->booking_form_boxcolor) ? $elsettings->booking_form_boxcolor : '#2D2D2D',
						     'booking_form_fontcolor' => !empty($elsettings->booking_form_fontcolor) ? $elsettings->booking_form_fontcolor : '#FFFFFF',
						     'booking_form_boxes_fontcolor' => !empty($elsettings->booking_form_boxes_fontcolor) ? $elsettings->booking_form_boxes_fontcolor : '#FFFFFF',
						     'booking_form_buttoncolor' => !empty($elsettings->booking_form_btncolor) ? $elsettings->booking_form_btncolor : '#1aa1bf',
						     'highlights_color' => !empty($elsettings->highlights_color) ? $elsettings->highlights_color : '#1aa1bf',
						     'other_steps_fontcolor' => !empty($elsettings->other_steps_fontcolor) ? $elsettings->other_steps_fontcolor : '#999999'
						     );
		
		$json_data['active_tabs'] = array('address_search' => 0,
						  'special_offers' => 0,
						  'hourly_hire' => 0
						  );
		
		if( (int)$elsettings->show_address_tab==1 &&
		   ($elsettings->show_from_poi==1 || $elsettings->show_from_address==1) &&
		   ($elsettings->show_to_poi==1 || $elsettings->show_to_address==1))
		{
			$json_data['active_tabs']['address_search'] = 1;
		}
		
		$pickup_poi = array();
		$dropoff_poi = array();
		
		// get all the points of interest
		$query = 'SELECT poi.*, poi_cat.image, poi_cat.id AS catid'
			. ' FROM #__taxibooking_points AS poi'
			. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
			. ' WHERE poi.published = 1'
			. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
			. ' ORDER BY poi.title ASC'
		;
		$db->setQuery($query);
		$db->query();
		$places = $db->loadObjectList();
		
		if (!empty($places))
		{
			foreach ($places as $place)
			{
				// enlist pickup poi
				if((int)$place->show_on_pickup==1)
				{
					$pickup_poi[] = array('id' => $place->id,
							      'catid' => $place->catid,
							  'title' => $place->title,
							  'image' => ($place->image!="") ? JURI::base().$place->image : '',
							  'coords' => array($place->lat, $place->long)
							  );
				    
				}
				// enlist dropoff poi
				if((int)$place->show_on_dropoff==1)
				{
					$dropoff_poi[] = array('id' => $place->id,
							       'catid' => $place->catid,
							  'title' => $place->title,
							  'image' => ($place->image!="") ? JURI::base().$place->image : '',
							  'coords' => array($place->lat, $place->long)
							  );
				}
			}
		}
		
		$json_data['tab_data']['address_search'] = array('show_pickup_poi' => $elsettings->show_from_poi,
								 'show_pickup_address' => $elsettings->show_from_address,
								 'show_dropoff_poi' => $elsettings->show_to_poi,
								 'show_dropoff_address' => $elsettings->show_to_address,
								 'show_stops' => $elsettings->enable_stops,
								 'show_stop_poi' => $elsettings->show_stop_poi,
								 'show_stop_address' => $elsettings->show_stop_address,
								 'max_stop_time_hrs' => $elsettings->max_stop_time,
								 'stop_duration_interval_mins' => $elsettings->stop_duration_interval,
								 'pickup_poi' => $pickup_poi,
								'dropoff_poi' => $dropoff_poi
								);
		
		// collect route cateory list
		$pickup_route_category_arr = array();
		$dropoff_route_category_arr = array();
		$pickup_route_poi = array();
		$dropoff_route_poi = array();
		$has_any_route = false;
		
		$query = 'SELECT poi.*, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image, poi_cat.language AS cat_language'
			. ' FROM #__taxibooking_points AS poi'
			. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
			. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_from'
			. ' WHERE r.published = 1'
			. ' AND poi.published = 1 AND poi.show_on_offers_pickup = 1'
			. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
			. ' ORDER BY poi.title ASC'
		;
		$db->setQuery($query);
		$db->query();
		$rows = $db->loadObjectList();
		
		if (!empty($rows))
		{
			$route_category_arr_temp = array();
			$pickup_route_poi_temp = array();
			
			$has_any_route = true;
			foreach ($rows as $row)
			{
				if($row->catid==""){
					$row->catid = 0;
				}
				
				// only english or all language
				if($row->cat_language=='*' || $row->cat_language=='en-GB')
				{
					$route_category_arr_temp[$row->catid] = array('catid' => $row->catid,
									 'cattitle' => $row->cattitle,
									'catimage' => ($row->cat_image!="") ? JURI::base().$row->cat_image : ''
									);
				}
				
				$pickup_route_poi_temp[$row->id] = array('id' => $row->id,
								    'catid' => $row->catid,
								'title' => $row->title,
								'image' => ($row->cat_image!="") ? JURI::base().$row->cat_image : '',
								'coords' => array($row->lat, $row->long)
								);			
			}
			
			if(!empty($route_category_arr_temp))
			{
				foreach($route_category_arr_temp as $arr)
				{
					$pickup_route_category_arr[] = $arr;
				}
			}
			if(!empty($pickup_route_poi_temp))
			{
				foreach($pickup_route_poi_temp as $arr)
				{
					$pickup_route_poi[] = $arr;
				}
			}
		}
		
		// collect dropoff route
		$query = 'SELECT poi.*, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image, poi_cat.language AS cat_language, r.route_from, r.route_to'
			. ' FROM #__taxibooking_points AS poi'
			. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
			. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_to'
			. ' WHERE r.published = 1'
			. ' AND poi.published = 1 AND poi.show_on_offers_dropoff = 1'
			. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
			. ' ORDER BY poi.title ASC'
		;
		$db->setQuery($query);
		$db->query();
		$rows = $db->loadObjectList();
		
		if (!empty($rows))
		{
			$route_category_arr_temp = array();
			$dropoff_route_poi_temp = array();
			
			foreach ($rows as $row)
			{
				if($row->catid==""){
					$row->catid = 0;
				}
				
				// only english or all language
				if($row->cat_language=='*' || $row->cat_language=='en-GB')
				{
					$route_category_arr_temp[$row->catid] = array('catid' => $row->catid,
									 'cattitle' => $row->cattitle,
									'catimage' => ($row->cat_image!="") ? JURI::base().$row->cat_image : ''
									);
				}
				
				$dropoff_route_poi_temp[] = array('id' => $row->id,
								    'catid' => $row->catid,
								    'pick_poi' => $row->route_from,
								'title' => $row->title,
								'image' => ($row->cat_image!="") ? JURI::base().$row->cat_image : '',
								'coords' => array($row->lat, $row->long)
								);
			}
			
			if(!empty($route_category_arr_temp))
			{
				foreach($route_category_arr_temp as $arr)
				{
					$dropoff_route_category_arr[] = $arr;
				}
			}
			if(!empty($dropoff_route_poi_temp))
			{
				foreach($dropoff_route_poi_temp as $arr)
				{
					$dropoff_route_poi[] = $arr;
				}
			}
		}
		
		$json_data['active_tabs']['special_offers'] = ((int)$elsettings->show_offers_tab==1 && $has_any_route) ? 1 : 0;
		$json_data['tab_data']['special_offers'] = array('show_route_categories' => $elsettings->show_poi_categories,
								 'pickup_route_category' => $pickup_route_category_arr,
								'pickup_poi' => $pickup_route_poi,
								'dropoff_route_category' => $dropoff_route_category_arr,
								'dropoff_poi' => $dropoff_route_poi
								);
		
		if((int)$elsettings->show_hourly_tab==1 && booking_helper::is_hourly_rate_enabled()){
			$json_data['active_tabs']['hourly_hire'] = 1;
		}
		
		// get the maximum passengers
		$query = 'SELECT MIN(hourly_hire_min_hr) AS min_hourly_hr, MAX(hourly_hire_max_hr) AS max_hourly_hr'
			. ' FROM #__taxibooking_cars'
			. ' WHERE hourly_hire_enabled = 1'
		;
		$db->setQuery($query);
		$db->query();
		$max = $db->loadObject();
		$min_hourly_hr = isset($max->min_hourly_hr) ? $max->min_hourly_hr : 1;
		$max_hourly_hr = isset($max->max_hourly_hr) ? $max->max_hourly_hr : 10;
		
		$hourly_hr_options = array(0);
		for ($i = $min_hourly_hr; $i <= $max_hourly_hr; $i++) {
			$hourly_hr_options[] = $i;
		}
		
		$hourly_min_options = array(0, 15, 30, 45);
	
		$json_data['tab_data']['hourly_hire'] = array('hourly_hrs' => $hourly_hr_options,
								 'hourly_mins' => $hourly_min_options
								);
		
		
		// collect custom fields
		$pickup_fields = array();
		$dropoff_fields = array();
		$hourly_fields = array();
		$user_fields = array();
		
		$query = 'SELECT f.*'
			. ' FROM #__taxibooking_fields AS f'
			. ' WHERE f.published = 1'
			. ' AND f.show_on_user_details = 0'
			. ' AND (f.language = "*" OR f.language = "'.$lang_tag.'")'
			. ' ORDER BY f.ordering ASC'
		;
		$db->setQuery($query);
		$db->query();
		$fields = $db->loadObjectList();
		
		if(!empty($fields))
		{
			foreach($fields as $field)
			{
				$field_options = array();
				if($field->field_type=='extra'){
					$start = ($field->allow_zero==1) ? 0 : 1;
					for($i = $start; $i <= $field->quantity; $i++){
						$field_options[] = $i;
					}
				}
				elseif($field->field_type=='optionlist'){
					$temp = unserialize($field->field_options);
					for($i = 0; $i < count($temp); $i++){
					    $field_options[] = htmlspecialchars($temp[$i]);
					}
				}
				
				$field_categories = explode(',', $field->catid);
				
				foreach($field_categories as $catid)
				{
					if($field->show_on_pickup==1)
					{
						$pickup_fields[] = array('id' => $field->id,
								'catid' => $catid,
								'title' => $field->title,
								'field_type' => $field->field_type,
								'is_mandatory' => $field->is_mandatory,
								'price' => $field->price,
								'quantity' => $field->quantity,
								'allow_zero' => $field->allow_zero,
								'field_options' => $field_options
								);
						
					}
					
					if($field->show_on_dropoff==1)
					{
						$dropoff_fields[] = array('id' => $field->id,
									'catid' => $catid,
									'title' => $field->title,
									'field_type' => $field->field_type,
									'is_mandatory' => $field->is_mandatory,
									'price' => $field->price,
									'quantity' => $field->quantity,
									'allow_zero' => $field->allow_zero,
									'field_options' => $field_options
									);
					}
				}
			}
		}
		
		// collect hourly hire custom fields
		$query = 'SELECT f.*'
			. ' FROM #__taxibooking_fields AS f'
			. ' WHERE f.published = 1'
			. ' AND f.show_on_hourly = 1'
			. ' AND f.show_on_user_details = 0'
			. ' AND (f.language = "*" OR f.language = "'.$lang_tag.'")'
			. ' ORDER BY f.ordering ASC'
		;
		$db->setQuery($query);
		$db->query();
		$fields = $db->loadObjectList();
		
		if(!empty($fields))
		{
			foreach($fields as $field)
			{
				$field_options = array();
				if($field->field_type=='extra'){
					$start = ($field->allow_zero==1) ? 0 : 1;
					for($i = $start; $i <= $field->quantity; $i++){
						$field_options[] = $i;
					}
				}
				elseif($field->field_type=='optionlist'){
					$temp = unserialize($field->field_options);
					for($i = 0; $i < count($temp); $i++){
					    $field_options[] = htmlspecialchars($temp[$i]);
					}
				}
				
				$hourly_fields[] = array('id' => $field->id,
							'catid' => $field->catid,
							'title' => $field->title,
							'field_type' => $field->field_type,
							'is_mandatory' => $field->is_mandatory,
							'price' => $field->price,
							'quantity' => $field->quantity,
							'allow_zero' => $field->allow_zero,
							'field_options' => $field_options
							);
			}
		}
		
		// collect user details custom fields
		$query = 'SELECT f.*'
			. ' FROM #__taxibooking_fields AS f'
			. ' WHERE f.published = 1'
			. ' AND f.show_on_user_details = 1'
			. ' AND (f.language = "*" OR f.language = "'.$lang_tag.'")'
			. ' ORDER BY f.ordering ASC'
		;
		$db->setQuery($query);
		$db->query();
		$fields = $db->loadObjectList();
		
		if(!empty($fields))
		{
			foreach($fields as $field)
			{
				$field_options = array();
				if($field->field_type=='extra'){
					$start = ($field->allow_zero==1) ? 0 : 1;
					for($i = $start; $i <= $field->quantity; $i++){
						$field_options[] = $i;
					}
				}
				elseif($field->field_type=='optionlist'){
					$temp = unserialize($field->field_options);
					for($i = 0; $i < count($temp); $i++){
					    $field_options[] = htmlspecialchars($temp[$i]);
					}
				}
				
				$user_fields[] = array('id' => $field->id,
							'catid' => $field->catid,
							'title' => $field->title,
							'field_type' => $field->field_type,
							'is_mandatory' => $field->is_mandatory,
							'price' => $field->price,
							'quantity' => $field->quantity,
							'allow_zero' => $field->allow_zero,
							'field_options' => $field_options
							);
			}
		}
		$json_data['custom_fields'] = array(
					'pickup_fields' => $pickup_fields,
					'dropoff_fields' => $dropoff_fields,
					'hourly_fields' => $hourly_fields,
					'user_fields' => $user_fields
				       );
		
		// get the maximum passengers
		$query = 'SELECT MAX(passenger_no) AS max_passenger, MAX(suitcase_no) AS max_suitcase, '
			. ' MAX(booster_seat_no) AS max_booster, MAX(child_seat_no) AS max_child, MAX(infant_seat_no) AS max_infant'
			. ' FROM #__taxibooking_cars'
		;
		$db->setQuery($query);
		$db->query();
		$max = $db->loadObject();
		$max_passenger = isset($max->max_passenger) ? $max->max_passenger : 8;
		$max_suitcase = isset($max->max_suitcase) ? $max->max_suitcase : 9;
		$max_booster = isset($max->max_booster) ? $max->max_booster : 5;
		$max_child = isset($max->max_child) ? $max->max_child : 5;
		$max_infant = isset($max->max_infant) ? $max->max_infant : 5;
		
		$passenger_options = array();
		for ($i = 1; $i <= $max_passenger; $i++) {
		    $passenger_options[] = $i;
		}
		
		$suitcases_options = array();
		$has_suitcases = ((int)$elsettings->show_suitcase_select==1) ? true : false;
		for ($i = 1; $i <= $max_suitcase; $i++) {
			$suitcases_options[] = $i;
		}
		
		$infantseats_options = array();
		$has_infant_seats = ($max_infant > 0 && (int)$elsettings->show_infant_select==1) ? true : false;
		for ($i = 1; $i <= $max_infant; $i++) {
			$infantseats_options[] =  $i;
		}
		
		$childseats_options = array();
		$has_child_seats = ($max_child > 0 && (int)$elsettings->show_child_select==1) ? true : false;
		for ($i = 1; $i <= $max_child; $i++) {
			$childseats_options[] = $i;
		}
		
		$boosterseats_options = array();
		$has_booster_seats = ($max_booster > 0 && (int)$elsettings->show_booster_select==1) ? true : false;
		for ($i = 1; $i <= $max_booster; $i++) {
			$boosterseats_options[] = $i;
		}
		
		$json_data['seats'] = array(
					'passenger_options' => $passenger_options,
					'has_suitcases' => $has_suitcases,
					'suitcases_options' => $suitcases_options,
					'has_infant_seats' => $has_infant_seats,
					'infantseats_options' => $infantseats_options,
					'has_child_seats' => $has_child_seats,
					'childseats_options' => $childseats_options,
					'has_booster_seats' => $has_booster_seats,
					'boosterseats_options' => $boosterseats_options
				       );
		/*echo '<pre>';
		print_r($json_data);*/
		echo json_encode($json_data);
		exit();
	}
	
	private function _getAvailableCars()
	{
		$json_data = array('err' => 0, 'msg' => '', 'total' => 0, 'available_cars' => array());
		$db = JFactory::getDBO();
		
		$lang = JFactory::getLanguage();
		$lang->load('com_taxibooking');
		
		// Get the component configuration
		require_once (JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'booking.helper.php');
		$elsettings =  booking_helper::config();
		
		$post = JRequest::get('post');
		
		$booking_type = JRequest::getVar('booking_type', 'address');
		$pickup_poi = JRequest::getInt('pickup_poi', 0);
		$dropoff_poi = JRequest::getInt('dropoff_poi', 0);
		$route_from = JRequest::getInt('route_from', 0);
		$route_to = JRequest::getInt('route_to', 0);
		$pickup_coords = JRequest::getVar('pickup_coords', array(), 'post', 'array');
		$dropoff_coords = JRequest::getVar('dropoff_coords', array(), 'post', 'array');
		$route_swapped = JRequest::getInt('route_swapped', 0);
		$adultseats = JRequest::getInt('passengers', 0);
		$suitcases = JRequest::getInt('suitcases', 0);
		$boosterseats = JRequest::getInt('boosterseats', 0);
		$infantseats = JRequest::getInt('infantseats', 0);
		$chseats = JRequest::getInt('chseats', 0);
		$extras = JRequest::getVar('extras', array(), 'post', 'array');
		$hourly_hr = JRequest::getInt('hourly_hr', 0);
		$hourly_min = JRequest::getInt('hourly_min', 0);
		$distance = JRequest::getVar('distance', '');
		$duration = JRequest::getVar('duration', '');
		$return_wait_hr = JRequest::getInt('return_wait_hr', -1);
		
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		date_default_timezone_set($siteOffset);
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = strtotime($dtnow->format('Y-m-d H:i:s', true));
		
		// waypoints
		$waypoints_post = JRequest::getVar('stops_arr', array(), 'post', 'array');
		
		$total_waypoint_duration = 0;
		for($i=0;$i<count($waypoints_post);$i++)
		{
			if(!empty($waypoints_post[$i]['text']) & !empty($waypoints_post[$i]['lat']) && !empty($waypoints_post[$i]['lng']) && !empty($waypoints_post[$i]['duration']))
			{
				$total_waypoint_duration += (int) $waypoints_post[$i]['duration'];
			}
		}
		
		$from_dest = -1;
		$to_dest = -1;
		if($booking_type=='address'){
			$from_dest = ($pickup_poi>0) ? 0 : 1;
			$to_dest = ($dropoff_poi>0) ? 0 : 1;
		}
		
		$date1 = "";
		$time1 = "";
		
		if(!empty($post["orderdate"]))
		{
			if($post["orderdate"]!='' && $post["orderdate"]!='Date')
			{
				$date1 = $post["orderdate"];
			    
				if($elsettings->date_format=='mm-dd-yy') {
				    $date1_arr = explode('-',$date1);
				    $date1 =  $date1_arr[1].'-'.$date1_arr[0].'-'.$date1_arr[2];
				}
			}
		}
		
		if(isset($post["selPtHr1"]) && ($post["selPtHr1"]!='') && isset($post["selPtMn1"]) && ($post["selPtMn1"]!=''))
		{
			$time1 = $post['selPtHr1'] . ":" . $post['selPtMn1'];
		}
		
		if (isset($post['returnjurney']) && $post['returnjurney']==1) {
		    $returnjurney = 1;
		}
		else {
		    $returnjurney = 0;
		}
		if(in_array($booking_type, array('hourly', 'shuttle'))){
			$returnjurney = 0;
		}
		
		// consider return discount hour
		$return_wait_discount = 0;
		if($return_wait_hr > 0)
		{
			$return_wait_discount = booking_helper::calculate_wait_time_discount($return_wait_hr);
		}
		
		$date2 = "";
		$time2 = "";
		
		if(!empty($post["orderdatereturn"]))
		{
			if ($post["orderdatereturn"]!='' && $post["orderdatereturn"]!='Return Date')
			{
				$date2 = $post["orderdatereturn"];
				
				if($elsettings->date_format=='mm-dd-yy') {
				    $date2_arr = explode('-',$date2);
				    $date2 =  $date2_arr[1].'-'.$date2_arr[0].'-'.$date2_arr[2];
				}
			}
		}
		
		if (isset($post["selPtHr2"]) && ($post["selPtHr2"]!='') && isset($post["selPtMn2"]) && ($post["selPtMn2"]!='')) {
			$time2 = $post['selPtHr2'] . ":" . $post['selPtMn2'];
			
			if($elsettings->time_format=='12hr') {
				    $time2 .=  $post["seltimeformat2"];
			}
		}
		
		if($date1!="" && $time1!="")
		{
		    $order_date_time_str = strtotime($date1.' '.$time1);
		    $order_date_time = date("Y-m-d H:i:s", $order_date_time_str);
		}
		
		if($date2!="" && $time2!="")
		{
		    $orderreturn_date_time_str = strtotime($date2.' '.$time2);
		    $orderreturn_date_time = date("Y-m-d H:i:s", $orderreturn_date_time_str);
		}
		//echo $now.'<br>';
		//echo $order_date_time.'<br>';
		
		if($adultseats == 0)
		{
		    $json_data['err'] = 1;
		    $json_data['msg'] = JText::_('COM_TAXIBOOKING_NO_VEHICLE');
		}
		elseif($date1 == '' || $time1 == '' )
		{
		    $json_data['err'] = 1;
		    $json_data['msg'] = JText::_('ENTER_DEPARTING_DATE_WARN_MSG');
		}
		elseif(booking_helper::calculate_time_difference($dtnow, $order_date_time, 'hr') < $elsettings->restrict_time)
		{
		    $json_data['err'] = 1;
		    $json_data['msg'] = $date1 .' '.$time1 . ' ('.JText::sprintf('INSUFFICIENT_TIME', $elsettings->restrict_time).')';
		}
		elseif ($returnjurney==1 && ($return_wait_hr==-1) &&  ($date2 == '' || $time2 == '' ))
		{
			$json_data['err'] = 1;
			$json_data['msg'] = JText::_('ENTER_RETURN_DATE_WARN_MSG');
		}
		elseif($booking_type=='offers' && $route_from > 0 && $route_to <= 0)  // customer selected fixed route
		{
		    $json_data['err'] = 1;
		    $json_data['msg'] = JText::_('CHOOSE_ROUTE_TO');
		}
		
		if($json_data['err']==0)
		{
			$price = 0;
			
			// calculate extras price
			list($selected_extras, $total_extra_price) = booking_helper::process_extras($extras, $booking_type);
			
			$separate_car_price = 0;
			$route_price = 0;
			$fixed_car_prices = '';
			if($booking_type=='offers' && $route_from > 0 && $route_to > 0)  // customer selected fixed route
			{
				$query = $db->getQuery(true);
				$query->select('price, separate_car_price, car_prices');
				$query->from('#__taxibooking_routes');
				
				if($route_swapped==1){ // if route swapped, then interchange the route
				    $query->where('route_from = '.(int) $route_to.' AND route_to = '.(int) $route_from);
				}
				else {
				    $query->where('route_from = '.(int) $route_from.' AND route_to = '.(int) $route_to);
				}
				$query->where('published = 1');
				$db->setQuery((string)$query);
				$route_obj = $db->loadObject();
				
				$route_price = $route_obj->price;
				$separate_car_price = $route_obj->separate_car_price;
				$fixed_car_prices = $route_obj->car_prices;
				
				// check whether this fixed route has separate car price enabled and has a set of car with price
				// if yes, the just show the list of cars with price - no calculation requried
				// if not, then route price will be considered
				if($separate_car_price==0)  
				{
				    $price += $route_price;
				}
			}
			
			if($booking_type=='hourly'){
				$duration = $hourly_hr*3600 + $hourly_min*60;
			}
			
			// collect additional charge for POIs if booking type is not HOURLY_HIRE
			if($booking_type!='hourly')
			{
				$app_data = array('booking_type' => $booking_type,
					'pickup_poi' => $pickup_poi,
					'dropoff_poi' => $dropoff_poi,
					'route_from' => $route_from,
					'route_to' => $route_to,
					'from_dest' => $from_dest,
					'to_dest' => $to_dest,
					'lat_long_from' => $pickup_coords,
					'lat_long_to' => $dropoff_coords,
					'adultseats' => $adultseats,
					'suitcases' => $suitcases,
					'boosterseats' => $boosterseats,
					'infantseats' => $infantseats,
					'chseats' => $chseats,
					'hourly_hr' => $hourly_hr,
					'hourly_min' => $hourly_min
					);
				
				$poi_additional_charges = booking_helper::get_poi_additional_charge($app_data);
				$price += $poi_additional_charges['total_additional_price'];
			}
			
			if ($infantseats > 0) {
				$price += $infantseats * $elsettings->infant_seat_price;
			}
			if ($chseats > 0) {
				$price += $chseats * $elsettings->child_seat_price;
			}
			if ($boosterseats > 0) {
				$price += $boosterseats * $elsettings->booster_seat_price;
			}
			    
			if($booking_type=='offers' && $separate_car_price==1)
			{
				$cars = booking_helper::get_fixed_route_car_set($fixed_car_prices, $app_data);
			}
			else // usual car price calculation for POI and address
			{
				// now list cars
				$query = $db->getQuery(true);
				$query->select('*');
				$query->from('#__taxibooking_cars');
				$query->where('published = "1"');
				$query->where('use_as_shuttle != 2'); // cars used only as shuttle will not be listed in other booking types
				
				if($booking_type=='address'){
					$query->where('use_in_address = 1');
				}
				if($booking_type=='offers'){
					$query->where('use_in_offers = 1');
				}
		    
				if($adultseats > 0)
				{
				    $query->where('passenger_no >= '.(int)$adultseats);
				}
				if($suitcases > 0)
				{
				    $query->where('suitcase_no >= '.(int)$suitcases);
				}
				if($boosterseats > 0)
				{
				    $query->where('booster_seat_no >= '.(int)$boosterseats);
				}
				if($infantseats > 0)
				{
				    $query->where('infant_seat_no >= '.(int)$infantseats);
				}
				if($chseats > 0)
				{
				    $query->where('child_seat_no  >= '.(int)$chseats);
				}
				
				if($booking_type=='hourly')
				{
				    $query->where('hourly_hire_enabled  = 1');
				    $query->where('hourly_hire_min_hr <= '.($hourly_hr+($hourly_min/100)) );
				    $query->where('hourly_hire_max_hr >= '.($hourly_hr+($hourly_min/100)) );
				}
				
				// adult + booster + child + infant must be less than the maximum passenger seats for a car
				$total_passengers = (int)$adultseats+(int)$infantseats+(int)$boosterseats+(int)$chseats;
				
				//Hourly and Shuttle have no use of Min passengers.
				if($booking_type!='hourly'){
					$query->where('min_passenger_no <= '.$total_passengers);
				}
				
				$query->where('passenger_no >= '.$total_passengers);
				
				$query->order('price ASC');
				$db->setQuery((string)$query);
				$cars = $db->loadObjectList();
			}
			
			// consider base
			list($base_pickup_distance,
			     $base_pickup_duration,
			     $base_pickup_price,
			     $base_pickup_price_calc,
			     $dropoff_base_distance,
			     $dropoff_base_duration,
			     $dropoff_base_price,
			     $dropoff_base_price_calc) = booking_helper::considerBase($elsettings, $app_data);
			
			// collect all available tariffs for pickup
			$tariffs = array();
			if($booking_type=='address'){
				$tariffs = booking_helper::getCurrentTariffs($order_date_time_str);
			}
			
			if(!empty($cars))
			{
				foreach($cars as $key => $car)
				{
					// first check today is a blocked date or not for this car
					if(booking_helper::check_car_block_dates($car, $order_date_time_str)===FALSE){
					    unset($cars[$key]);
					}
					elseif(booking_helper::check_todays_availability($car, $order_date_time_str)===FALSE) { // check todays opening/closing time and compare with current time
					    unset($cars[$key]);
					}
					elseif(booking_helper::check_car_previous_bookings($car, $order_date_time_str,0,$duration)===FALSE) { // check this car previous booking journey
					    unset($cars[$key]);
					}
					elseif(booking_helper::check_car_shuttle_route($car, $time1, $elsettings)===FALSE) { // check if this car is assigned to any shuttle route between the booking time
					    unset($cars[$key]);
					}
					else {
						$car_price = 0;
                        
						// every car has it's own price model, but that own price will not be applied for fixed route
						if($booking_type!='offers')
						{
							if($booking_type=='hourly')
							{
								$car_price += $car->hourly_rate*($hourly_hr+($hourly_min/60));
								
								if((float)$car->hourly_hire_fee > 0){
									$car_price += (float)$car->hourly_hire_fee;
								}
							}
							else {
								if($car->price_calculation_cumulative==1 || $elsettings->price_calculation_cumulative==1) // if car has cumulative price enabled
								{
									list($cum_car_price,$unit_price,$price_calculation_debug_str,$applied_tariff) = booking_helper::get_car_cumulative_price($car, $distance, $tariffs);
									$car_price += $cum_car_price;
								}
								else {  // non-cumulative price calculation
								    list($unit_price, $applied_tariff) = booking_helper::get_car_unit_price($car, $distance, $tariffs);
								    $car_price += $distance * $unit_price;
								    if($applied_tariff){
									$car_price += (float)$applied_tariff->initial_price;
								    }
								}
								
								// we have 2 conditions for min distance
								// first if minimum distance > 0, price will be min.price if journey distance is less than min distance
								// if Minimum distance 0 or empty, then Price will be Min price if calculated price is less than Min price
								if((float)$elsettings->minmil > 0){
								    if($distance < (float)$elsettings->minmil && $car_price < (float)$elsettings->minprice){
									    $car_price = (float)$elsettings->minprice;
								    }
								}
								else {
								    if ((float)$elsettings->minprice > 0 && $car_price < (float)$elsettings->minprice){
									    $car_price = (float)$elsettings->minprice;
								    }
								}
							}
						}
						
						$car_price += $elsettings->cost_per_call; // initial call charge
						
						// add car flat price
						if($booking_type!='hourly')
						{
							 // If separate car price = NO, addiotnal car charge/car price will not be added
							if($booking_type=='offers' && $separate_car_price==0){
								$car->price = 0;
							}
							$car_price += $car->price;
						}
						
						// waypoint time charge
						if($elsettings->stops_charge_per_min!="")
						{
							$car_price += $total_waypoint_duration* (int) $elsettings->stops_charge_per_min;
						}
						
						// add seats price
						$car_price += $price;
						
						// add extra price
						$car_price += $total_extra_price;
						
						// add base price
						$car_price += ($base_pickup_price+$dropoff_base_price);
						
						// charge per min will be applied for Address booking only
						if($booking_type=='address'){
						    list($duration_charge,$unit_charge) = booking_helper::calculate_charge_per_min($duration, $car, $elsettings,$applied_tariff);
						    $car_price += $duration_charge;
						}
						
						// calculate distance sectors discounts for Address booking only
						$distance_sector_outbound_discount = 0;
						$distance_sector_return_discount = 0;
						if($booking_type=='address'){
							list($distance_sector_outbound_discount,$distance_sector_return_discount) = booking_helper::get_distance_sector_discounts($car, $elsettings, $distance);
							if($distance_sector_outbound_discount!=0){
								$car_price -= $distance_sector_outbound_discount;
							}
						}
						
						$outbound_price = $car_price;
						
						if ($returnjurney == 1)
						{
							// For Address Search booking, additional car type charge will not be applied for return journey
							// For special route (if separate car price is enabled for a route) and Hourly Hire bookings,
							// outbound price will be doubled, no need to deduce additional car type charge
							// If add_price_return = NO, additional car type charge will not be applied for return journey
							if(($booking_type=='address') || ($booking_type=='offers' && $separate_car_price==0)) {
							    if($car->add_price_return==0) {
								    $outbound_price -= (float)$car->price;
							    }
							}
							
							// initial charge will be applied once per order
							$outbound_price -= (float)$elsettings->cost_per_call;
							
							$discounts = array('return_wait_discount' => $return_wait_discount,
								'distance_sector_return_discount' => $distance_sector_return_discount
							);
							list($return_price,$return_discounts,$return_discounts_calc) = booking_helper::calculate_return_price($outbound_price, $elsettings, $discounts);
							$car_price += $return_price;
						}
						
						// round price based on configuration
						$car_price = booking_helper::round_price($car_price, $elsettings);
						$car->car_price = $car_price;
					}
				}
			}
			
			// combine cars by type
			if($elsettings->combine_car_type==1)
			{
				// first sort cars array by lowest id first
				require_once (JPATH_COMPONENT.DS.'helpers'.DS.'sort_helper.php');
				$cars = sort_stack($cars, 'itemid', 'ASC');
				
				$temp = array();
				$car_available_counter = array();
				foreach($cars as $key => $car)
				{
				    if(isset($car_available_counter[$car->car_price] )){
					$car_available_counter[$car->car_price]++;
				    }
				    else {
					$car_available_counter[$car->car_price] = 1;
				    }
				}
				
				for($i=0;$i<count($cars);$i++)
				{
				    $found = false;
				    for($j=0;$j< count($temp);$j++)
				    {
					if( ($temp[$j]->alias==$cars[$i]->alias)
					   && ($temp[$j]->passenger_no==$cars[$i]->passenger_no)
					   && ($temp[$j]->suitcase_no==$cars[$i]->suitcase_no)
					   && ($temp[$j]->booster_seat_no==$cars[$i]->booster_seat_no)
					   && ($temp[$j]->infant_seat_no==$cars[$i]->infant_seat_no)
					   && ($temp[$j]->child_seat_no==$cars[$i]->child_seat_no)
					   && ($temp[$j]->car_price==$cars[$i]->car_price)
					){
					    $found = true;
					    break;
					}
				    }
				    
				    if(!$found){
					$temp[] = $cars[$i];
				    }
				}
				
				$cars = $temp;
			}
			
			// sort car
			$sort_by = JRequest::getVar('sort_by', 'car_price');
			$sort_dir = JRequest::getVar('sort_dir', 'ASC');
			
			require_once (JPATH_COMPONENT.DS.'helpers'.DS.'sort_helper.php');
			$cars = sort_stack($cars, $sort_by, $sort_dir);
			
			// now generate car list
			$available_cars = array();
			$counter = 0;
			if(!empty($cars))
			{
			    foreach($cars as $car)
			    {
				$available_cars[] = array('id' => $car->id,
							  'title' => $car->title,
							  'image' => ($car->image!="") ? JURI::base().$car->image : '',
							  'text' => strip_tags($car->text),
							  'min_passenger' => $car->min_passenger_no,
							  'passenger' => $car->passenger_no,
							  'price' => $car->car_price
							  );
				
				$counter++;
				}
			}
			else {
				$json_data['err'] = 1;
				$json_data['msg'] = JText::_('COM_TAXIBOOKING_NO_VEHICLE_DATETIME');
			}
		    
			$json_data['total'] = $counter;
			$json_data['msg'] = "$counter cars found";
			$json_data['available_cars'] = $available_cars;
		}
		echo json_encode($json_data);
		exit();
	}
	
	private function _getAvailablePaymentMethods()
	{
		$app = JFactory::getApplication();
		$session = JFactory::getSession();
		$db = JFactory::getDBO();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		$lang->load('com_taxibooking');
		
		$json_data = array('err' => 0, 'msg' => '', 'methods' => array());
		
		$post = JRequest::get('post');
		$cart_price = JRequest::getVar('price', 0);
		
		if($cart_price==0){
			$json_data['err'] = 1;
			$json_data['msg'] = 'Booking price cannot be 0!';
		}
		else{
			// Get the component configuration
			require_once (JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'booking.helper.php');
			$elsettings =  booking_helper::config();
			
			$payment_methods = array();
			
			$query = 'SELECT f.*'
				. ' FROM #__taxibooking_paymentmethods AS f'
				. ' WHERE f.published = 1'
				. ' ORDER BY f.ordering ASC'
			;
			$db->setQuery($query);
			$methods = $db->loadAssocList();
			
			$temp = array();
			if(!empty($methods))
			{
				$counter = 0;
				foreach ($methods as $method)
				{
					$params = explode('|', $method['payment_params']);
					foreach($params as $item){
			
						$item = explode('=',$item);
						$key = $item[0];
						unset($item[0]);
			
						$item = implode('=',$item);
			
						if(!empty($item)){
							$method[$key] = json_decode($item);
						}
					}
					
					// method with use_in_app will be available
					if($method['use_in_app']===NULL OR $method['use_in_app']==="0"){
						continue;
					}
					
					// check amount condition
					$method['min_amount'] = (float)$method['min_amount'];
					$method['max_amount'] = (float)$method['max_amount'];
					
					$amount_cond = ((float)$cart_price >= $method['min_amount'] AND (float)$cart_price <= $method['max_amount']
						OR
						($method['min_amount'] <= (float)$cart_price AND ($method['max_amount'] == 0)));
					
					if (!$amount_cond) {
						continue;
					}
					
					// calculate payment cost
					if (preg_match ('/%$/', $method['cost_percent_total'])) {
						$cost_percent_total = substr ($method['cost_percent_total'], 0, -1);
					} else {
						$cost_percent_total = $method['cost_percent_total'];
					}
					
					$method['flat_cost'] = (float)number_format($method['cost_per_transaction'],2,'.','');
					$method['percentage_cost'] = (float)number_format(($cart_price * $cost_percent_total * 0.01),2,'.','');
					
					$total_price = $cart_price + $method['cost_per_transaction'] + ($cart_price * $cost_percent_total * 0.01);
					$method['total_price'] = (float)number_format($total_price,2,'.','');
					$method['text'] = strip_tags($method['text']);
					
					$prepay = ($method['prepayment_percent']=='' ) ? 100 : $method['prepayment_percent'];
					$due_now = $total_price * $prepay / 100;
					$due_later = $total_price - $due_now;
					
					if($prepay<100){
						$method['title'] .= ' (Deposit '.$prepay. '%)';
					}
					
					$method['deposit_amount'] = (float)number_format($due_now,2,'.','');
					$method['due_later'] = (float)number_format($due_later,2,'.','');
					
					$temp[$counter] = $method;
					$counter++;
				}
			}
			
			$json_data['methods'] = $temp;
		}
		
		echo json_encode($json_data);
		exit();
	}
	
	private function _submitOrder()
	{
		$json_data = array('err' => 0, 'msg' => '');
		
		// Get the component configuration
		require_once (JPATH_COMPONENT.DS.'classes'.DS.'booking.helper.php');
		require_once (JPATH_COMPONENT.DS.'helpers'.DS.'common.php');
		require_once (JPATH_COMPONENT.DS.'helpers'.DS.'route.php');
		$elsettings =  booking_helper::config();
		
		$app = JFactory::getApplication();
		$lang = JFactory::getLanguage();
		$lang->load('com_taxibooking');
		$db =  JFactory::getDBO();
		$user =  JFactory::getUser();
		$session =  JFactory::getSession();
		
		$post = JRequest::get('post');
		
		$booking_type = JRequest::getVar('booking_type', 'address');
		$pickup_poi = JRequest::getInt('pickup_poi', 0);
		$dropoff_poi = JRequest::getInt('dropoff_poi', 0);
		$pickup_coords = JRequest::getVar('pickup_coords', array(), 'post', 'array');
		$dropoff_coords = JRequest::getVar('dropoff_coords', array(), 'post', 'array');
		$route_swapped = JRequest::getInt('route_swapped', 0);
		$route_from = JRequest::getInt('route_from', 0);
		$route_to = JRequest::getInt('route_to', 0);
		$hourly_hr = JRequest::getInt('hourly_hr', 0);
		$hourly_min = JRequest::getInt('hourly_min', 0);
		$adultseats = JRequest::getInt('passengers', 0);
		$suitcases = JRequest::getInt('suitcases', 0);
		$boosterseats = JRequest::getInt('boosterseats', 0);
		$infantseats = JRequest::getInt('infantseats', 0);
		$chseats = JRequest::getInt('childseats', 0);
		$extras = JRequest::getVar('extras', array(), 'post', 'array');
		$paymentmethod_id = JRequest::getInt('paymentmethod_id', 0);
		$vehicle_id = JRequest::getInt('car_id', 0);
		$returnjurney = JRequest::getInt('returnjurney', 0);
		$return_wait_hr = JRequest::getInt('return_wait_hr', -1);
		$sub_total = JRequest::getVar('sub_total', 0);
		$price = JRequest::getVar('total_price', 0);
		$flat_cost = JRequest::getVar('flat_cost', 0);
		$percentage_cost = JRequest::getVar('percentage_cost', 0);
		
		$user_name = JRequest::getVar("user_name", "");
		$email = JRequest::getVar("email", "");
		$phone = JRequest::getVar("phone", "");
		$begin = JRequest::getVar("begin", "");
		$end = JRequest::getVar("end", "");
		$PickupAddr1 = JRequest::getVar("PickupAddr1", "");
		$PickupAddr4 = JRequest::getVar("PickupAddr4", "");
		$distance = JRequest::getVar("distance", "");
		$duration_seconds = JRequest::getVar("duration_seconds", "");
		$message = JRequest::getVar("message", "");
		$send_booking_sms = JRequest::getInt("send_booking_sms", 0);
		
		$from_dest = -1;
		$to_dest = -1;
		if($booking_type=='address'){
			$from_dest = ($pickup_poi>0) ? 0 : 1;
			$to_dest = ($dropoff_poi>0) ? 0 : 1;
		}
		
		// Get the page/component configuration
		$elsettings = booking_helper::config();
		
		$config   = JFactory::getConfig();
		$siteOffset = $config->get('offset');
		date_default_timezone_set($siteOffset);
		$dtnow = JFactory::getDate('now', $siteOffset);
		$now = strtotime($dtnow->format('Y-m-d H:i:s', true));
		
		$date1 = "";
		$time1 = "";
		
		if(!empty($post["orderdate"]))
		{
			if($post["orderdate"]!='' && $post["orderdate"]!='Date')
			{
				$date1 = $post["orderdate"];
			    
				if($elsettings->date_format=='mm-dd-yy') {
				    $date1_arr = explode('-',$date1);
				    $date1 =  $date1_arr[1].'-'.$date1_arr[0].'-'.$date1_arr[2];
				}
			}
		}
		
		if(isset($post["selPtHr1"]) && ($post["selPtHr1"]!='') && isset($post["selPtMn1"]) && ($post["selPtMn1"]!=''))
		{
			$time1 = $post['selPtHr1'] . ":" . $post['selPtMn1'];
		}
		
		$date2 = "";
		$time2 = "";
		
		if(!empty($post["orderdatereturn"]))
		{
			if ($post["orderdatereturn"]!='' && $post["orderdatereturn"]!='Return Date')
			{
				$date2 = $post["orderdatereturn"];
				
				if($elsettings->date_format=='mm-dd-yy') {
				    $date2_arr = explode('-',$date2);
				    $date2 =  $date2_arr[1].'-'.$date2_arr[0].'-'.$date2_arr[2];
				}
			}
		}
		
		if (isset($post["selPtHr2"]) && ($post["selPtHr2"]!='') && isset($post["selPtMn2"]) && ($post["selPtMn2"]!='')) {
			$time2 = $post['selPtHr2'] . ":" . $post['selPtMn2'];
		}
		
		if($date1!="" && $time1!="")
		{
		    $order_date_time_str = strtotime($date1.' '.$time1);
		    $order_date_time = date("Y-m-d H:i:s", $order_date_time_str);
		}
		
		if($date2!="" && $time2!="")
		{
		    $orderreturn_date_time_str = strtotime($date2.' '.$time2);
		    $orderreturn_date_time = date("Y-m-d H:i:s", $orderreturn_date_time_str);
		}
		
		if ($paymentmethod_id==0)
		{
			$json_data['err'] = 1;
			$json_data['msg'] = 'No payment method is set!';
		}
		elseif ($vehicle_id==0)
		{
			$json_data['err'] = 1;
			$json_data['msg'] = 'No vehicle is set!';
		}
		elseif ($email=="")
		{
			$json_data['err'] = 1;
			$json_data['msg'] = 'User email is empty!';
		}
		elseif(booking_helper::calculate_time_difference($dtnow, $order_date_time, 'hr') < $elsettings->restrict_time)
		{
			$json_data['err'] = 1;
			$json_data['msg'] = JText::sprintf('INSUFFICIENT_TIME', $elsettings->restrict_time);
		}
		else
		{
			if($booking_type=='hourly'){
				$begin = $end = '';
				$duration_seconds = $hourly_hr*3600 + $hourly_min*60;
			}
			
			// waypoints
			$stops = array();
			$waypoints_post = JRequest::getVar('stops_arr', array(), 'post', 'array');
			
			$total_waypoint_duration = 0;
			for($i=0;$i<count($waypoints_post);$i++)
			{
				if(!empty($waypoints_post[$i]['text']) & !empty($waypoints_post[$i]['lat']) && !empty($waypoints_post[$i]['lng']) && !empty($waypoints_post[$i]['duration']))
				{
					$stops[$i] = array('stop' => $waypoints_post[$i]['text'],
							   'stop_lat' => $waypoints_post[$i]['lat'],
							   'stop_lng' => $waypoints_post[$i]['lng'],
							   'stop_interval' => $waypoints_post[$i]['duration']
							   );
				}
			}
			
			// calculate extras price
			list($selected_extras, $total_extra_price) = booking_helper::process_extras($extras, $booking_type);
			
			// process user custom fields price
			list($selected_user_details_extras, $total_user_details_extra_price) = booking_helper::process_user_details_extras($extras, $booking_type);
			$selected_extras = array_merge($selected_extras, $selected_user_details_extras);
			
			// collect additional charge for POIs if booking type is not HOURLY_HIRE
			$app_data = array('booking_type' => $booking_type,
					'pickup_poi' => $pickup_poi,
					'dropoff_poi' => $dropoff_poi,
					'route_from' => $route_from,
					'route_to' => $route_to,
					'from_dest' => $from_dest,
					'to_dest' => $to_dest,
					'lat_long_from' => $pickup_coords,
					'lat_long_to' => $dropoff_coords
					);
			$poi_additional_charges = booking_helper::get_poi_additional_charge($app_data);
			
			$duration_text = booking_helper::secondsToTime($duration_seconds);
			
			// consider return discount hour
			$return_wait_discount = 0;
			if($return_wait_hr > 0)
			{
				$return_wait_discount = booking_helper::calculate_wait_time_discount($return_wait_hr);
			}
		
			// total cost
			$grand_total = $sub_total+$flat_cost+$percentage_cost;
			
			// apply coupon code discount if any
			$coupon_used = 0;
			$coupon_code = JRequest::getVar('coupon_code', '');
			if($coupon_code != "")
			{
				$booking_data = array('booking_type' => $booking_type,
							'email' => $email,
							'route_from' => $route_from,
							'route_to' => $route_to,
							'grand_total' => $grand_total,
							'selected_payment' => $paymentmethod_id,
							'lang_tag' => 'en-GB',
							'pickup_date' => date("Y-m-d", $order_date_time_str)
						      );
							  
				require_once (JPATH_COMPONENT.DS.'classes'.DS.'coupon_code.php');
				$cc = new CouponCode($coupon_code,0);
				list($is_valid, $msg) = $cc->validate($booking_data);
				
				if($is_valid)
				{
					$grand_total = $cc->apply($booking_data);
					$coupon_used = $cc->_coupon->id;
				}
			}
			
			// auto approve free orders if backend setting is set to YES
			if(((int)$elsettings->show_price==0) || ($grand_total<=0 && (int)$elsettings->auto_approve_free_order==1) ){
				$new_order_status = 1;
			}
			else {
				$new_order_status = -2; // WAITING
			}
			
			if($booking_type=='offers'){
				$pickup_poi = $route_from;
				$dropoff_poi = $route_to;
			}
			
			$order = new stdClass();
			$order->order_number = uniqid();
			$order->names = $user_name;
			$order->email = $email;
			$order->phone = $phone;
			$order->booking_type = $booking_type;
			$order->returntrip = $returnjurney;
			$order->return_wait_hr = $return_wait_hr;
			$order->return_wait_discount = $return_wait_discount;
			$order->sub_total = $sub_total;
			$order->flat_cost = $flat_cost;
			$order->percentage_cost = $percentage_cost;
			$order->poi_additional_charges = serialize($poi_additional_charges);
			$order->cprice = $grand_total;
			$order->extras = serialize($selected_extras);
			$order->selpassengers = $adultseats;
			$order->selinfantseats = $infantseats;
			$order->selchildseats = $chseats;
			$order->selboosterseats = $boosterseats;
			$order->selluggage = $suitcases;
			$order->hourly_hr = $hourly_hr;
			$order->hourly_min = $hourly_min;
			$order->PickupAddr1 = $PickupAddr1;
			$order->PickupAddr4 = $PickupAddr4;
			$order->datetime1 = $order_date_time_str;
			$order->datetime2 = $orderreturn_date_time_str;
			$order->distance = $distance;
			$order->duration = $duration_seconds;
			$order->duration_text = $duration_text;  
			$order->message = $message;
			$order->begin = $begin;
			$order->end = $end;
			$order->stops = serialize($stops);
			$order->from_dest = $from_dest;
			$order->to_dest = $to_dest;
			$order->state = $new_order_status;
			$order->driver_id = '';
			$order->payment = $paymentmethod_id;
			$order->vehicletype = $vehicle_id;
			$order->created = $dtnow->toSql(true);
			$order->coupon_used = $coupon_used;
			$order->source = 'drivenot';
			$order->pickup_poi = $pickup_poi;
			$order->pickup_lat = !empty($pickup_coords[0]) ? $pickup_coords[0] : 0;
			$order->pickup_lng = !empty($pickup_coords[1]) ? $pickup_coords[1] : 0;
			$order->dropoff_poi = $dropoff_poi;
			$order->dropoff_lat = !empty($dropoff_coords[0]) ? $dropoff_coords[0] : 0;
			$order->dropoff_lng = !empty($dropoff_coords[1]) ? $dropoff_coords[1] : 0;
			
			if (!$db->insertObject('#__taxibooking_orders', $order)) {
			    exit($db->stderr());
			}
			$order_id = $db->insertid();
			$order = booking_helper::get_order_by_id($order_id);
			
			// store order vehicle booking time data if track_availability is set YES for the booked car
			$car = booking_helper::get_car_details($order->vehicletype);
			$track_availability = $car->track_availability;
			
			if((int)$track_availability==1)
			{
				// store order vehicle booking time data
				$booking_time_start = $order_date_time_str;
				$booking_time_end = $order_date_time_str+$duration_seconds;
				
				// consider base
				list($base_pickup_distance,
				     $base_pickup_duration,
				     $base_pickup_price,
				     $dropoff_base_distance,
				     $dropoff_base_duration,
				     $dropoff_base_price) = booking_helper::considerBase($elsettings, $app_data);
				
				$booking_time_end += (int) $elsettings->time_after_each_booking;
				
				if($elsettings->calculate_base_pickup==1)
				{
				    $booking_time_start -= $base_pickup_duration;
				}
				if($elsettings->calculate_dropoff_base==1)
				{
				    $booking_time_end += $dropoff_base_duration;
				}
				
				$order_car = new stdClass();
				$order_car->order_id = $order_id;
				$order_car->vehicle_id = $vehicle_id;
				$order_car->journey_type = 'outbound';
				$order_car->booking_time_start = $booking_time_start;
				$order_car->booking_time_end = $booking_time_end;
				$order_car->created_date = $dtnow->toSql(true);
				
				if ($db->insertObject('#__taxibooking_order_car_rel', $order_car))
				{
					$order_car_rel_id = $db->insertid();
					if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
					{
					    $event_id = booking_helper::createCalendarEvent($order,$car,$order_car_rel_id,$booking_time_start,$booking_time_end);
					}
				}
				
				// enter another entry for return journey
				if($returnjurney==1 && $orderreturn_date_time_str!="")
				{
					$booking_time_start = $orderreturn_date_time_str;
					$booking_time_end = $orderreturn_date_time_str+$duration_seconds;
					
					$order_car = new stdClass();
					$order_car->order_id = $order_id;
					$order_car->vehicle_id = $vehicle_id;
					$order_car->journey_type = 'return';
					$order_car->booking_time_start = $booking_time_start;
					$order_car->booking_time_end = $booking_time_end;
					$order_car->created_date = $dtnow->toSql(true);
					
					if ($db->insertObject('#__taxibooking_order_car_rel', $order_car))
					{
						$order_car_rel_id = $db->insertid();
						if($car->google_calendar_enabled==1 && $car->use_as_shuttle!=2)
						{
							$event_id = booking_helper::createCalendarEvent($order,$car,$order_car_rel_id,$booking_time_start,$booking_time_end);
						}
					}
				}
			}
			
			// trigger order submit action for payment gateways
			JPluginHelper::importPlugin('tbpayment');
			$dispatcher = JDispatcher::getInstance();
			$returnValues = $dispatcher->trigger('plgTbOrderSubmit', array($order));
			
			// if this is user is not registered yet, create an account silently
			$juserObj = $this->_createUserAccount($order);
			$this->_createUserProfile($order, $juserObj);
			
			// if selected payment method has send email for Pending status to YES,
			// then send email for new orders
			$paymentObj = booking_helper::get_payment_details($order->payment);
			if(isset($paymentObj->send_email_pending_status) && isset($paymentObj->send_email_approved_status)){
				if( ($new_order_status == -2 && $paymentObj->send_email_pending_status==1)
				   || ($new_order_status == 1 && $paymentObj->send_email_approved_status==1)
				){
					$this->_sendMailDetailsToOwner($order);
				}
			}
			else {
				$this->_sendMailDetailsToOwner($order);
			}
			
			// send sms
			if((int)$elsettings->send_user_sms==1 && $send_booking_sms==1 && $phone!="")
			{
				$response = booking_helper::send_order_sms($order, $elsettings);
			}
			
			// confirm booked seats if this is shuttle booking
			if($order->booking_type=='shuttle'){
			    booking_helper::confirm_shuttle_booking($order);
			}
			
			// track user coupon record
			if($coupon_used > 0 ){
				booking_helper::track_user_coupon($order, $elsettings);
			}
			
			$json_data['msg'] = $order;
		}
		
		echo json_encode($json_data);
		exit();
	}
	
	/**
	* Create user account silently
	*/
	private function _createUserAccount($order)
	{
		//initialise variables
		$app = JFactory::getApplication();
		$db =  JFactory::getDBO();
		$elsettings =  booking_helper::config();
		$config = JFactory::getConfig();
		$user_params	= JComponentHelper::getParams('com_users');
		$lang = JFactory::getLanguage();
		$lang->load('com_taxibooking');
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__users');
		$query->where('email = '.$db->Quote($order->email));
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		if($row){
			return $row;
		}
		else {
			// Initialise the table with JUser.
			$user = new JUser;
			
			// Prepare the data for the user object.
			$data = array();
			$data['name']	        = $order->names;
			$data['username']	= $order->email;
			$data['email']		= $order->email;
			$data['password']	= JUserHelper::genRandomPassword();
			$data['activation'] = '';
			$data['block'] = 0;
			
			// Get the groups the user should be added to after registration.
			$data['groups'] = array();
		
			// Get the default new user group, Registered if not specified.
			$data['groups'][] = $user_params->get('new_usertype', 2);
			
			// Bind the data.
			if (!$user->bind($data)) {
			    return false;
			}
			
			// Store the data.
			if (!$user->save()) {
			    return false;
			}
			
			// Compile the notification mail values.
			$data['fromname']	= $config->get('fromname');
			$data['mailfrom']	= $config->get('mailfrom');
			$data['sitename']	= $config->get('sitename');
			$data['siteurl']	= JUri::root();
			$data['password_clear']	= $user->password_clear;
		
			$emailSubject	= JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_ACCOUNT_DETAILS',
				$data['name'],
				$data['sitename']
			);
		
			$emailBody = JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_REGISTERED_BODY',
				$data['name'],
				$data['sitename'],
				$data['siteurl'],
				$data['username'],
				$data['password_clear']
			);
			
			// Send the registration email.
			$return = JFactory::getMailer()->sendMail($data['mailfrom'], $data['fromname'], $data['email'], $emailSubject, $emailBody);
		
			//Send Notification mail to administrators
			$emailSubject = JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_ACCOUNT_DETAILS',
				$data['name'],
				$data['sitename']
			);
		
			$emailBodyAdmin = JText::sprintf(
				'COM_TAXIBOOKING_EMAIL_REGISTERED_NOTIFICATION_TO_ADMIN_BODY',
				$data['name'],
				$data['username'],
				$data['siteurl']
			);
		
			// get all admin users
			$query = 'SELECT name, email, sendEmail' .
				' FROM #__users' .
				' WHERE sendEmail=1';
			$db->setQuery( $query );
			$rows = $db->loadObjectList();
			
			// Send mail to all superadministrators id
			foreach( $rows as $row )
			{
			    $return = JFactory::getMailer()->sendMail($data['mailfrom'], $data['fromname'], $row->email, $emailSubject, $emailBodyAdmin);
			}
			
			return $user;
		}
	}
	
	/**
	* Create user entry in Appregulator database
	*
	* @access	public
	*/
	private function _createUserProfile($order, $jUserObj = false)
	{
		//initialise variables
		$app = JFactory::getApplication();
		$db =  JFactory::getDBO();
		$date = JFactory::getDate();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_users');
		$query->where('email = '.$db->Quote($order->email));
		$db->setQuery((string)$query);
		$tbUser = $db->loadObject();
		
		if($tbUser){
			$tbUserId = $tbUser->id;
		}
		else {
			if($jUserObj){
				$temp = new stdClass();
				$temp->user_id = $jUserObj->id;
				$temp->name = $order->names;
				$temp->email = $order->email;
				$temp->phone = $order->phone;
				$temp->created = $date->toSql();
				$temp->published = 1;
				
				$db->insertObject('#__taxibooking_users', $temp);
				$tbUserId = $db->insertid();
			}
		}
		
		return true;
	}
   
	/**
	* Send Email to owner of the order
	*/
	private function _sendMailDetailsToOwner($row_queue)
	{
		//initialise variables
		$app = JFactory::getApplication();
		$site_name = $app->getCfg('sitename');
		$db =  JFactory::getDBO();
		$elsettings =  booking_helper::config();
		$lang = JFactory::getLanguage();
		$lang->load('com_taxibooking');
		$lang_tag = 'en-GB';
		
		if ($row_queue->state == '1') {
			$row_queue->order_status .= '<span style="color:green;">'.JText::_('NEW_ORDER_STATUS_ACCEPTED').'</span>';
		}
		elseif ($row_queue->state == '0') {
			$row_queue->order_status .= '<span style="color:red;">'.JText::_('NEW_ORDER_STATUS_REJECTED').'</span>';
		}
		elseif ($row_queue->state == '-1') {
			$row_queue->order_status .= '<span style="color:yellow;">'.JText::_('NEW_ORDER_STATUS_ARCHIVED').'</span>';
		}
		elseif ($row_queue->state == '-2') {
			$row_queue->order_status .= '<span style="color:green;">'.JText::_('NEW_ORDER_STATUS_WAITING').'</span>';
		}
	   
		$payment_data = '';
		JPluginHelper::importPlugin('tbpayment');
		$_dispatcher = JDispatcher::getInstance();
		$_returnValues = $_dispatcher->trigger('plgTbOnShowOrderEmailsInvoice',array( $row_queue->id,$row_queue->payment));
		foreach ($_returnValues as $_returnValue) {
			if ($_returnValue !== null) {
				$payment_data .= $_returnValue;
			}
		}
		
		// glean language specific header and footer info
		require_once (JPATH_COMPONENT.DS.'helpers'.DS.'common.php');
		$header_info = $elsettings->header_info;
		$header_info = isset($header_info[$lang_tag]) ? changeEditorImageUrl($header_info[$lang_tag]) : '';
		
		$contact_info = $elsettings->contact_info;
		$contact_info = isset($contact_info[$lang_tag]) ? changeEditorImageUrl($contact_info[$lang_tag]) : '';
	   
		$order_source = 'drivenotapp';

		// now get the email template
		ob_start();
		include( JPATH_ROOT.DS .'components'.DS .'com_taxibooking'.DS .'templates'.DS.'order_emails'.DS.'confirmation_email.tpl.php' );
		$mailbody = ob_get_contents();
		ob_end_clean();
		
		$pdf_file = '';
		if ($row_queue->state==1)
		{
			// confirm booked seats if this is shuttle booking
			if($row_queue->booking_type=='shuttle'){
			    booking_helper::confirm_shuttle_booking($row_queue);
			}

			// glean language specific header and footer info
			$header_info = $elsettings->header_info;
			$header_info_pdf = changeEditorImagePath($header_info[$lang_tag]);
			
			$contact_info = $elsettings->contact_info;
			$contact_info_pdf = changeEditorImagePath($contact_info[$lang_tag]);
			    
			ob_start();
			include( JPATH_ROOT.DS .'components'.DS .'com_taxibooking'.DS .'templates'.DS.'order_invoice.tpl.php' );
			$invoice_template = ob_get_contents();
			ob_end_clean();
			
			require_once(JPATH_ROOT.DS .'administrator'.DS .'components'.DS .'com_taxibooking'."/classes/dompdf_lib.php");
			$dompdf_lib = new Dompdf_lib;
			$dompdf_lib->set_custom_paper('A4');
			$pdfoutput = $dompdf_lib->convert_html_to_pdf($invoice_template, '', false);
			
			$invoice_title = ($elsettings->invoice_title!="") ? $elsettings->invoice_title."_".$row_queue->id.".pdf" : "taxi_reservation_$row_queue->id.pdf";
		    
			$pdf_file = JPATH_ROOT.DS .'administrator'.DS .'components'.DS .'com_taxibooking' . DS . "documents".DS.$invoice_title;
			file_put_contents($pdf_file, $pdfoutput);
			
			// update order invoice title
			$query = 'UPDATE #__taxibooking_orders SET'
				.' invoice_title = ' . $db->Quote($invoice_title)
				.' WHERE id = ' . $row_queue->id;
			$db->setQuery($query);
			$db->execute();
		}
   
		// now send the email
		$mail =  JFactory::getMailer();
		$jconfig = new JConfig();
		$MailFrom = $jconfig->mailfrom;
		$FromName = JText::sprintf("NEW_ORDER_EMAIL_YOUR_WEBSITE_NAME", $jconfig->fromname);
		$mail->setSender(array($MailFrom, $FromName));
		$mail->setSubject(JText::sprintf('NEW_ORDER_EMAIL_SUBJECT_ORDER_NUMBER', $row_queue->id));
		$mail->setBody($mailbody);
		$mail->IsHTML(true);
		$mail->addRecipient($row_queue->email);
		
		if($pdf_file!=""&&$elsettings->show_price==1)
		{
		    $mail->addAttachment($pdf_file);
		}
		
		if(explode(',',$elsettings->additional_emails)){
		     $additional_emails = explode(',',$elsettings->additional_emails);
		     if(!empty($additional_emails)){
			     $mail->addBCC($additional_emails);
		     }
		}
		
		// send a copy to Parent User
		$parentClient = booking_helper::getParentClient($row_queue->email);
		if($parentClient){
			$mail->addBCC($parentClient->email);
		}
	
		$sent = $mail->Send();
		
		// send emails to all admin
		$query = 'SELECT u.id, u.email, u.name' .
			' FROM #__users AS u' .
			' LEFT JOIN #__user_usergroup_map AS gu ON gu.user_id = u.id' .
			' WHERE (gu.group_id = 8 OR gu.group_id = 7) ' .
			' AND u.sendEmail = 1 AND u.block = 0';
		$db->setQuery($query);
		$adminRows = $db->loadObjectList();
	
		// send email notification to admins
		$admin_emails = array();
		foreach ($adminRows as $adminRow) {
			
			$admin_emails[] = $adminRow->email;
	
			$mail =  JFactory::getMailer();
			$mail->setSender(array($MailFrom, $FromName));
			$mail->setSubject(JText::sprintf('NEW_ORDER_EMAIL_SUBJECT_ORDER_NUMBER', $row_queue->id));
			$mail->setBody($mailbody);
			$mail->IsHTML(true);
			$mail->addRecipient($adminRow->email);
			$mail->addReplyTo($row_queue->email, $row_queue->names);
	    
			$sent = $mail->Send();
		}
		
		// Booking notification email will also receive a copy if it is not any admins email
		if($elsettings->booking_notification_email!="" && !in_array($elsettings->booking_notification_email, $admin_emails)){
			$mail =  JFactory::getMailer();
			$mail->setSender(array($MailFrom, $FromName));
			$mail->setSubject(JText::sprintf('NEW_ORDER_EMAIL_SUBJECT_ORDER_NUMBER', $row_queue->id));
			$mail->setBody($mailbody);
			$mail->IsHTML(true);
			$mail->addRecipient($elsettings->booking_notification_email);
			$mail->addReplyTo($row_queue->email, $row_queue->names);
	    
			$sent = $mail->Send();
		}
	
		return true;
	}
	
	/**
	* Login user based on username/password provided from external source
	*/
	private function _userAuthenticate()
	{
		$json_result = array('err' => 0, 'msg' => '', 'userinfo' => array(), 'my_orders' => array());
		$app = JFactory::getApplication();
		
		$username = JRequest::getVar( 'username', '' );   
		$password = JRequest::getVar( 'password', '' );
		
		// Joomla does not like blank passwords
		if (empty($password))
		{
			$json_result['msg'] = 'Password is blank';
			$json_result['err'] = 1;
		}
		else {
			$credentials = array( "username" => $username, "password" => $password);
			$options = array("silent" => true);
			
			// Get a database object
			$db = JFactory::getDBO();
		      
			$query = 'SELECT *'
			 . ' FROM `#__users`'
			 . ' WHERE username=' . $db->Quote( $credentials['username'] )
			 ;
			$db->setQuery( $query );
			$result = $db->loadObject();
			
			if ($result)
			{
				// Get the global JAuthentication object
				jimport( 'joomla.user.authentication');
				$auth = JAuthentication::getInstance();
				$response = $auth->authenticate($credentials, $options);
			     
				// success
				if ($response->status === 1) {
					$user = array('name' => $result->name,
						      'username' => $result->username,
						      'email' => $result->email
						      );
					$json_result['msg'] = 'success';
					$json_result['userinfo'] = $user;
					
					// collect user orders
					$query = $db->getQuery(true);
 
					// Select the required fields from the table.
					$query->select('a.*' );
					$query->from($db->quoteName('#__taxibooking_orders') . ' AS a');
					
					 // Join over the driver 
					$query->select('u.name AS drivername')
						->join('LEFT', $db->quoteName('#__users') . ' AS u ON u.id = a.driver_id');
						
					// Join over the payment methods 
					$query->select('pm.title AS payment_method')
						->join('LEFT', $db->quoteName('#__taxibooking_paymentmethods') . ' AS pm ON pm.id = a.payment');
						
					// Join over the payment methods 
					$query->select('car.title AS car_title')
						->join('LEFT', $db->quoteName('#__taxibooking_cars') . ' AS car ON car.id = a.vehicletype');
						
					$query->where('a.email = '.$db->Quote($result->email));
					
					// Add the list ordering clause.
					$orderCol = 'a.datetime1';
					$orderDirn = 'DESC';
					$query->order($db->escape($orderCol . ' ' . $orderDirn));
					$db->setQuery((string)$query);
					$user_orders = $db->loadObjectList();
					
					// process order data
					$order_states = array('1' => 'Accepted',
							      '0' => 'Rejected',
							      '-1' => 'Archived',
							      '-2' => 'Waiting'
							      );
					
					if(!empty($user_orders))
					{
						foreach($user_orders as $user_order)
						{
							$user_order->pickup_date = '';
							$user_order->return_date = '';
							$user_order->order_state_text = $order_states[$user_order->state];
							
							if($user_order->poi_additional_charges != '')
							{
								$user_order->poi_additional_charges = unserialize($user_order->poi_additional_charges);
							}
							if($user_order->extras != '')
							{
								$extras = unserialize($user_order->extras);
								
								$order_extras = array();
								if(!empty($extras['pickup']))
								{
									foreach($extras['pickup'] as $extra)
									{
										//if($extra['value']!="" && $extra['value']>0){
											$order_extras['pickup'][] = $extra;
										//}
									}
								}
								if(!empty($extras['dropoff']))
								{
									foreach($extras['dropoff'] as $extra)
									{
										//if($extra['value']!="" && $extra['value']>0){
											$order_extras['dropoff'][] = $extra;
										//}
									}
								}
								if(!empty($extras['hourly_hire']))
								{
									foreach($extras['hourly_hire'] as $extra)
									{
										//if($extra['value']!="" && $extra['value']>0){
											$order_extras['hourly_hire'][] = $extra;
										//}
									}
								}
								if(!empty($extras['return_pickup']))
								{
									foreach($extras['return_pickup'] as $extra)
									{
										//if($extra['value']!="" && $extra['value']>0){
											$order_extras['return_pickup'][] = $extra;
										//}
									}
								}
								if(!empty($extras['return_dropoff']))
								{
									foreach($extras['return_dropoff'] as $extra)
									{
										//if($extra['value']!="" && $extra['value']>0){
											$order_extras['return_dropoff'][] = $extra;
										//}
									}
								}
								
								$user_order->extras = $order_extras;
							}
							if($user_order->datetime1!="")
							{
								$user_order->pickup_date = date("Y-m-d H:i:s", $user_order->datetime1);
							}
							if($user_order->datetime2!="")
							{
								$user_order->return_date = date("Y-m-d H:i:s", $user_order->datetime2);
							}
						}
					}
					
					$json_result['user_orders'] = $user_orders;
				}
				else {
					$json_result['msg'] = $response->error_message;
					$json_result['err'] = 1;
				}
			}
			else
			{
				$json_result['msg'] = 'Username and password do not match or you do not have an account yet.';
				$json_result['err'] = 1;
			}
		}
		
		echo json_encode($json_result);
		exit();
	}
	
	/*
	*   This event is fired by Offline Payment. It can be used to validate the payment data as entered by the user.
	*/
	private function _paypalNotification () {
		
		$json_result = array('err' => 0, 'msg' => '');
		$app = JFactory::getApplication();
		
		require_once (JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'booking.helper.php');
		$paypal_data = JRequest::get('post');
		
		if (!isset($paypal_data['custom'])) {
			$json_result = array('err' => 1, 'msg' => 'Invoice not found!');
			echo json_encode($json_result);
			exit();
		}
		
		$order_number = $paypal_data['custom'];
		if (!($order = booking_helper::get_order_by_order_number($order_number))) {
			$json_result = array('err' => 1, 'msg' => 'Order not found!');
			echo json_encode($json_result);
			exit();
		}
		$tablename = '#__taxibooking_payment_plg_paypal';
		if (!($payments = $this->getDataByOrderId($order->id, $tablename))) {
			$json_result = array('err' => 1, 'msg' => 'Payment information not found!');
			echo json_encode($json_result);
			exit();
		}
		
		$name = 'paypal';
		$method = $this->getPluginMethod ($payments->paymentmethod_id, $name);
		if (!$this->selectedThisElement ($method->payment_element, $name)) {
			$json_result = array('err' => 1, 'msg' => 'This payment is not selected!');
			echo json_encode($json_result);
			exit();
		}
		
		$order_data = array();
		
		$payment_status = $paypal_data['payment_status'];
		if (empty($payment_status) || ($payment_status != 'Completed' && $payment_status != 'Pending')) {
			$json_result = array('err' => 1, 'msg' => 'Unknown payment status!');
			echo json_encode($json_result);
			exit();
		}
		
		$lang = JFactory::getLanguage();
		$lang->load('plg_tbpayment_' . $name,JPATH_ADMINISTRATOR);

		// 1. check the payment_status is Completed
		if (strcmp ($payment_status, 'Completed') == 0) {
			
			// 2. check that txn_id has not been previously processed
			if ($this->_check_txn_id_already_processed ($payments, $paypal_data['txn_id'])) {
				$json_result = array('err' => 1, 'msg' => 'Transaction already processed!');
				echo json_encode($json_result);
				exit();
			}
			// 3. check email and amount currency is correct
			if (!$this->_check_email_amount_currency ($payments, $this->_getMerchantEmail ($method), $paypal_data)) {
				$json_result = array('err' => 1, 'msg' => 'Amount and currency mismatch!');
				echo json_encode($json_result);
				exit();
			}
			
			// now we can process the payment
			$order_data['order_status'] = $method->status_success;
		}
		elseif (strcmp ($payment_status, 'Pending') == 0) {
			$key = 'TBPAYMENT_PAYPAL_PENDING_REASON_FE_' . strtoupper ($paypal_data['pending_reason']);
			if (!$lang->hasKey ($key)) {
				$key = 'TBPAYMENT_PAYPAL_PENDING_REASON_FE_DEFAULT';
			}
			$order_data['order_status'] = $method->status_pending;
		}
		elseif (isset ($paypal_data['payment_status'])) {
			$order_data['order_status'] = $method->status_canceled;
		}
		else {
			
		}
		
		$response_fields['order_id'] = $order->id;
		$response_fields['order_number'] = $order_number;
		$response_fields['paymentmethod_id'] = $payments->paymentmethod_id;
		$response_fields['payment_name'] = $this->renderPluginName ($method);
		
		$db = JFactory::getDBO ();
		
		$columns = array();
		$db->setQuery('SHOW COLUMNS FROM '.$db->quoteName($tablename));
		$rows = $db->loadObjectList();
		if(!empty($rows)){
			foreach($rows as $row){
				$columns[] = $row->Field;
			}
		}
		
		foreach ($paypal_data as $key => $value) {
			$table_key = 'paypal_response_' . $key;
			if (in_array ($table_key, $columns)) {
				$response_fields[$table_key] = $value;
			}
		}
		
		require_once (JPATH_COMPONENT.DS.'classes'.DS.'tbtabledata.php');
		
		$table = new TbTableData($tablename, 'id', $db);
		
		// Bind the data.
		if (!$table->bind($response_fields))
		{
			$json_result = array('err' => 1, 'msg' => $table->getError());
			echo json_encode($json_result);
			exit();
		}

		// Check the data.
		if (!$table->check())
		{
			$json_result = array('err' => 1, 'msg' => $table->getError());
			echo json_encode($json_result);
			exit();
		}
		
		// Store the data.
		if (!$table->store())
		{
			$json_result = array('err' => 1, 'msg' => $table->getError());
			echo json_encode($json_result);
			exit();
		}
		booking_helper::update_order_status($order->id, $order_data);
		
		echo json_encode($json_result);
		exit();
	}
	
	private function _getMerchantEmail ($method) {

		return $method->sandbox ? $method->sandbox_merchant_email : $method->paypal_merchant_email;
	}
	
	private function _check_txn_id_already_processed ($payments, $txn_id) {

		foreach ($payments as $payment) {
			if ($payment->paypal_response_txn_id == $txn_id) {
				return TRUE;
			}
		}

		return FALSE;
	}
	private function _check_email_amount_currency ($payments, $email, $paypal_data) {

		/*
		 * TODO Not checking yet because config do not have primary email address
		* Primary email address of the payment recipient (that is, the merchant).
		* If the payment is sent to a non-primary email address on your PayPal account,
		* the receiver_email is still your primary email.
		*/
		/*
		if ($payments[0]->payment_order_total==$email) {
			return true;
		}
		*/
		$prepay = $payments->prepayment_percent;
		if($prepay<100){
			$payments->payment_order_total = $payments->payment_order_total*$prepay/100;
		}
		
		if ($payments->payment_order_total == $paypal_data['mc_gross']) {
			return TRUE;
		}
		if ($payments->payment_currency == $paypal_data['mc_currency']) {
			return TRUE;
		}
		return FALSE;
	}
	/**
	 * check if it is the correct element
	 *
	 * @param string $element either standard or paypal
	 * @return boolean
	 */
	protected function selectedThisElement ($element, $name = 'paypal') {

		if ($name <> $element) {
			return FALSE;
		} else {
			return TRUE;
		}
	}
	/**
	 * Get Method Data for a given Payment ID
	 * @param int $order_id The order ID
	 * @return  $methodData
	 */
	protected function getDataByOrderId ($order_id, $tablename = '') {

		$db = JFactory::getDBO ();
		$q = 'SELECT * FROM `' . $tablename . '` '
			. 'WHERE `order_id` = ' . $order_id;

		$db->setQuery ($q);
		$methodData = $db->loadObject ();

		return $methodData;
	}
	/**
	 * Get Plugin Data for a go given plugin ID
	 *
	 * @param int $pluginmethod_id The method ID
	 * @return  method data
	 */
	protected function getPluginMethod ($method_id, $name = 'paypal') {
		
		$method = $this->selectedThisByMethodId ($method_id, $name);
		if (!$method) {
			return NULL; // Another method was selected, do nothing
		}
		else {
			return $method;
		}
	}
	/**
	 * Checks if this plugin should be active by the trigger
	 *
	 * @param int/array $id the registered plugin id(s) of the joomla table
	 */
	protected function selectedThisByMethodId ($id = 'type', $name = 'paypal') {

		if ($id === 'type') {
			return TRUE;
		}
		else {
			$db = JFactory::getDBO ();
			$configTable = '#__taxibooking_paymentmethods';

			$q = 'SELECT tb.* FROM `' . $configTable . '` AS tb,
				#__extensions AS j WHERE tb.`id` = "' . $id . '"
				AND tb.payment_plugin_id = j.extension_id
				AND j.element = "'.$name.'"
				AND j.folder = "tbpayment"';

			$db->setQuery ($q);
			if (!$res = $db->loadObject ()) {
				return FALSE;
			}
			else {
				// process params
				$params = explode('|', $res->payment_params);
				foreach($params as $item){
		
					$item = explode('=',$item);
					$key = $item[0];
					unset($item[0]);
		
					$item = implode('=',$item);
		
					if(!empty($item)){
						$res->$key = json_decode($item);
					}
				}
				return $res;
			}
		}
	}
	/**
	 * @param $plugin plugin
	 */
	protected function renderPluginName ($plugin) {

		$return = '';
		$plugin_name = 'title';
		$plugin_desc = 'text';
		$description = '';
		
		if (!empty($plugin->$plugin_desc)) {
			$description = '<span class="payment_description">' . $plugin->$plugin_desc . '</span>';
		}
		
		$pluginName = $return . '<span class="payment_name">' . $plugin->$plugin_name .'</span>' . $description;
		return $pluginName;
	}
	
	/**
	 * Method to fetch Taxibooking settings for Appregulator component
	**/
	private function _fetchSettings()
	{
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();
		$lang_tag = 'en-GB';
		
		$json_data = array('err' => 0, 'msg' => 'configuration fetched', 'config' => array());
		
		// Get the component configuration
		require_once (JPATH_COMPONENT.DS.'classes'.DS.'booking.helper.php');
		$elsettings =  booking_helper::config();
		
		$country_2_code = booking_helper::get_country_field($elsettings->default_country, 'country_2_code');
		
		$services_provided = array();
		
		if( (int)$elsettings->show_address_tab==1 &&
		   ((int)$elsettings->show_from_poi==1 || (int)$elsettings->show_from_address==1) &&
		   ((int)$elsettings->show_to_poi==1 || (int)$elsettings->show_to_address==1))
		{
			$services_provided[] = 'address';
		}
		
		// collect route cateory list
		$has_any_route = false;
		
		$query = 'SELECT poi.*, poi_cat.id AS catid, poi_cat.title AS cattitle, poi_cat.image AS cat_image, poi_cat.language AS cat_language'
			. ' FROM #__taxibooking_points AS poi'
			. ' LEFT JOIN #__taxibooking_poicats AS poi_cat ON poi_cat.id = poi.catid'
			. ' LEFT JOIN #__taxibooking_routes AS r ON poi.id = r.route_from'
			. ' WHERE r.published = 1'
			. ' AND (poi.language = "*" OR poi.language = "'.$lang_tag.'")'
			. ' ORDER BY poi.title ASC'
		;
		$db->setQuery($query);
		$db->query();
		$rows = $db->loadObjectList();
		
		if (!empty($rows)){
			$has_any_route = true;
		}
		
		if((int)$elsettings->show_offers_tab==1 && $has_any_route){
			$services_provided[] = 'offers';
		}
		
		if((int)$elsettings->show_hourly_tab==1 && booking_helper::is_hourly_rate_enabled()){
			$services_provided[] = 'hourly';
		}
		
		$operation_area_vertices = json_decode($elsettings->operation_area_vertices);
		
		// pull app sharing coupon code
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_coupons');
		$query->where('published = 1');
		$query->where('for_company_share = 1');
		$db->setQuery((string)$query);
		$couponObj = $db->loadObject();
		
		$app_coupon_code = $app_coupon_discount_type = $app_coupon_discount_value = '';
		if($couponObj){
			$app_coupon_code = $couponObj->code;
			$app_coupon_discount_type = $couponObj->discount_type;
			$app_coupon_discount_value = $couponObj->discount_value;
		}
		
		$json_data['config'] = array('tbversion' => booking_helper::getTBVersion(),
					     'default_city' => $elsettings->default_city,
						'default_country' => $elsettings->default_country,
						'services_provided' => $services_provided,
						'operation_area_vertices' => $operation_area_vertices,
						'app_sharing_coupon_code' => $app_coupon_code,
						'app_coupon_discount_type' => $app_coupon_discount_type,
						'app_coupon_discount_value' => $app_coupon_discount_value,
					);
		
		echo json_encode($json_data);
		exit();
	}
	
	private function _applyCoupon()
	{
		$app = JFactory::getApplication();
		$db = JFactory::getDBO();
		$user =  JFactory::getUser();
		$lang =  JFactory::getLanguage();
		$lang->load('com_taxibooking');
		$lang_tag = $lang->getTag();
		$lang_tag = 'en-GB';
		
		$json_result = array('error'=>0,'msg'=>'','old_total'=>0,'new_total'=>0,'prepayment'=>100,'due_now'=>0,'due_later'=>0,'code'=>'');
		
		// Get the component configuration
		require_once (JPATH_COMPONENT.DS.'classes'.DS.'booking.helper.php');
		$elsettings =  booking_helper::config();
	
		$coupon_id= JRequest::getInt( 'coupon_id', 0 );
		$code	= JRequest::getVar( 'code', '' );
		$grand_total	= JRequest::getVar( 'grand_total', 0 );
		$booking_type = JRequest::getVar('booking_type', 'address');
		$user_email = JRequest::getVar('email', '');
		$route_from = JRequest::getInt('route_from', 0);
		$route_to = JRequest::getInt('route_to', 0);
		$payment_id = JRequest::getInt('paymentmethod_id', 0);
		
		$date1 = $time1 = $order_date_time_str = "";
		
		if(!empty($post["orderdate"]))
		{
			if($post["orderdate"]!='' && $post["orderdate"]!='Date')
			{
				$date1 = $post["orderdate"];
			    
				if($elsettings->date_format=='mm-dd-yy') {
				    $date1_arr = explode('-',$date1);
				    $date1 =  $date1_arr[1].'-'.$date1_arr[0].'-'.$date1_arr[2];
				}
			}
		}
		
		if(isset($post["selPtHr1"]) && ($post["selPtHr1"]!='') && isset($post["selPtMn1"]) && ($post["selPtMn1"]!=''))
		{
			$time1 = $post['selPtHr1'] . ":" . $post['selPtMn1'];
		}
		
		if($date1!="" && $time1!="")
		{
			$order_date_time_str = strtotime($date1.' '.$time1);
		}
		
		if($coupon_id==0 && $code==""){
			$json_result['error'] = 1;
			$json_result['msg'] = JText::_( 'COUPON_VALIDATE_CODE_NOT_FOUND');
		}
		elseif($grand_total==0) {
			$json_result['error'] = 1;
			$json_result['msg'] = JText::_( 'APP_COUPON_VALIDATE_GRAND_TOTAL_ZERO');
		}
		elseif($payment_id==0) {
			$json_result['error'] = 1;
			$json_result['msg'] = JText::_( 'APP_COUPON_VALIDATE_NO_PAYMENT_SELECTED');
		}
		else {
			$booking_data = array('booking_type' => $booking_type,
						'email' => $user_email,
						'route_from' => $route_from,
						'route_to' => $route_to,
						'grand_total' => $grand_total,
						'selected_payment' => $payment_id,
						'lang_tag' => $lang_tag,
						'pickup_date' => date("Y-m-d", $order_date_time_str)
					      );
			$json_result['old_total'] = (float)number_format($grand_total,2,'.','');
			
			// fetch 
			$payment_method = booking_helper::get_payment_details($booking_data['selected_payment']);
			$prepayment = isset($payment_method->prepayment_percent) ? $payment_method->prepayment_percent : 0;
			$json_result['prepayment'] = $prepayment;
			
			require_once (JPATH_COMPONENT.DS.'classes'.DS.'coupon_code.php');
			$cc = new CouponCode($code, $coupon_id);
			list($is_valid, $msg) = $cc->validate($booking_data);
			
			if($is_valid)
			{
				$json_result['code'] = $cc->_coupon->code;
				
				// last of all, check this code if it is App Sharing
				if($cc->_coupon->for_company_share==1){
					$new_total = $cc->apply($booking_data);
					$json_result['new_total'] = (float)number_format($new_total,2,'.','');
					list($due_now, $due_later) = $this->_calculatePrepayment($new_total, $prepayment);
					
					$json_result['msg'] = 'Coupon applied successfully';
				}
				else {
					$json_result['error'] = 1;
					$json_result['msg'] = JText::_( 'APP_COUPON_VALIDATE_NOT_APP_SHARING');
					
					$json_result['new_total'] = (float)number_format($grand_total,2,'.','');
					list($due_now, $due_later) = $this->_calculatePrepayment($grand_total, $prepayment);
				}
			}
			else {
				$json_result['error'] = 1;
				$json_result['msg'] = $msg;
				
				$json_result['new_total'] = (float)number_format($grand_total,2,'.','');
				list($due_now, $due_later) = $this->_calculatePrepayment($grand_total, $prepayment);
			}
			
			$json_result['due_now'] = (float)number_format($due_now,2,'.','');
			$json_result['due_later'] = (float)number_format($due_later,2,'.','');
		}
		
		echo json_encode($json_result);
		exit();
	}
	
	private function _calculatePrepayment($total, $prepayment)
	{
		if(is_null($prepayment)){
		    $prepayment = 100;
		}
		if($prepayment < 100)
		{
		    $due_now = $total * $prepayment / 100;
		    $due_later = $total - $due_now;
		}
		else {
		    $due_now = $total;
		    $due_later = 0;
		}
		
		return array($due_now, $due_later);
	}
}
