<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  System.Tbschedules
 *
 * @copyright   Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

if(!defined('APPREGULATOR_URL')){
	define('APPREGULATOR_URL',    '#'); // without trailing slash
}

class PlgSystemTbschedules extends JPlugin
{
	public function onAfterInitialise()
	{
		$app = JFactory::getApplication();
		
		if(!defined('DS')){
			define('DS',DIRECTORY_SEPARATOR);
		}
		
		// check if sharecost component has been installed
		if(!file_exists(JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'taxibooking.php')){
			return;
		}
		
		require_once JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'booking.helper.php';
		
		// Collect disabled dates
		if ($this->params->get('disable_dates_collect_enabled', 0) == 1)
		{
			$this->_disabledDatesCollector();
		}
		
		// Archive Orders 24 hrs after Dropoff time
		if ($this->params->get('archive_orders_enabled', 0) == 1)
		{
			$this->_ordersArchivers();
		}
		
		if ($this->params->get('send_tbcorporate_invoice_enabled', 0) == 1)
		{
			$this->_tbcorporateInvoiceSenders();
		}
		
		if ($this->params->get('new_orders_reminder_enabled', 0) == 1)
		{
			$this->_newOrdersReminder();
		}
	}
	
	private function _disabledDatesCollector()
	{
		$minutes = (int)$this->params->get('collect_disabled_dates_freq', 0);

		if ($minutes <= 0)
		{
			return;
		}

		$lastJob = $this->_tbgetTimestamp('collect_disabled_dates');
		$nextJob = $lastJob + $minutes * 60;
		
		$now = time();

		if ($now >= $nextJob)
		{
			$this->_tbSetTimestamp('collect_disabled_dates');
			$this->_collectDisabledDates();
		}
	}
	
	private function _ordersArchivers()
	{
		$minutes = (int)$this->params->get('archive_orders_freq', 0);

		if ($minutes <= 0)
		{
			return;
		}

		$lastJob = $this->_tbgetTimestamp('archive_orders');
		$nextJob = $lastJob + $minutes * 60;

		$now = time();

		if ($now >= $nextJob)
		{
			$this->_tbSetTimestamp('archive_orders');
			$this->_archiveOrders();
		}
	}
	
	private function _tbcorporateInvoiceSenders()
	{
		// check if the TaxiBooking Corporate extension is installed and enabled
		$path = JPATH_ROOT.DS."components".DS."com_tbcorporate";
		if(!file_exists ( $path.DS.'tbcorporate.php' ))
		{
			return;
		}
		
		$minutes = (int)$this->params->get('tbcorporate_invoice_sending_freq', 0);
		
		if ($minutes <= 0)
		{
			return;
		}

		$lastJob = $this->_tbgetTimestamp('tbcorporate_invoice_send');
		$nextJob = $lastJob + $minutes * 60;
		
		$now = time();
		if ($now >= $nextJob)
		{
			$this->_tbSetTimestamp('tbcorporate_invoice_send');
			$this->_sendTbcorporateInvoice();
		}
	}
	
	private function _newOrdersReminder()
	{
		$minutes = (int)$this->params->get('new_orders_reminder_freq', 0);

		if ($minutes <= 0)
		{
			return;
		}

		$lastJob = $this->_tbgetTimestamp('new_orders_reminder');
		$nextJob = $lastJob + $minutes * 60;

		$now = time();

		if ($now >= $nextJob)
		{
			$this->_tbSetTimestamp('new_orders_reminder');
			$this->_sendNewOrdersReminder();
		}		
	}
	
	private function _collectDisabledDates()
	{
		$db = JFactory::getDBO();
		$user =  JFactory::getUser();
		
		//$siteOffset = booking_helper::set_tbtimezone();
		//$dtnow = JFactory::getDate('now', $siteOffset);
		//$now = $dtnow->format('Y-m-d', true);
		$now = date('Y-m-d');
		
		$current_month_last_date = date('Y-m-t', strtotime($now));
		$end_date = date('Y-m-t', strtotime('+2 month'));  // next 2 months
		
		$date_arr = $this->date_range($now, $end_date);
		
		// now collect blocked dates of all cars
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_cars');
		$query->where('published = 1');
		$db->setQuery((string)$query);
		$cars = $db->loadObjectList();
		
		$disabled_dates = array();
		
		// check each date if that is unavailable for all cars
		foreach($date_arr as $k=>$date)
		{
			$date_week_day = date("N", strtotime($date));  //1 (for Monday) through 7 (for Sunday)
			
			$cars_available = array(); // collect available cars on this date
			
			foreach($cars as $car)
			{
				$blocked_dates = unserialize($car->blocked_dates);
				
				// if this date is blocked for this car
				if(!empty($blocked_dates) && in_array($date, $blocked_dates)){
					$is_available=0;
				}
				else {
					$registry = new JRegistry;
					$registry->loadString($car->days_availability);
					$car_availability_arr = $registry->toArray();
					
					$todays_availabilty = !empty($car_availability_arr[$date_week_day-1]) ? $car_availability_arr[$date_week_day-1] : array();
				
					if(empty($car_availability_arr))  // if availability is not set yet, car is not available
					{
						$is_available=0;
					}
					elseif(empty($todays_availabilty) || empty($todays_availabilty['is_available']) || $todays_availabilty['is_available']==0 ) // if today's availability is not set, car is not available today
					{
						$is_available=0;
					}
					else {
						$is_available=1;
					}
				}
				
				if($is_available==1){
					$cars_available[] = $car->id;
				}
			}
			
			// if no car is available on this date, this date will be disabled
			if(empty($cars_available)){
				$disabled_dates[] = $date;
			}
		}
		
		$disabled_dates = array_intersect($date_arr, $disabled_dates);
		
		$fp = fopen(JPATH_ROOT.DS.'plugins'.DS.'system'.DS.'tbschedules'.DS.'cache.txt', 'w');
		fwrite($fp, implode(',', $disabled_dates));
		fclose($fp);
		
		return;
	}
	
	private function date_range($first, $last, $step = '+1 day', $output_format = 'Y-m-d' ) {

		$dates = array();
		$current = strtotime($first);
		$last = strtotime($last);
	    
		while( $current <= $last ) {
	    
		    $dates[] = date($output_format, $current);
		    $current = strtotime($step, $current);
		}
	    
		return $dates;
	}
	
	private function _archiveOrders()
	{
		$db = JFactory::getDBO();
		$user =  JFactory::getUser();
		$config = JFactory::getConfig();
		
		$FromName	= $config->get('fromname');
		$MailFrom	= $config->get('mailfrom');
		$SiteName	= $config->get('sitename');
		
		$elsettings =  booking_helper::config();
		
		$lang = JFactory::getLanguage();
		$lang->load('com_taxibooking', JPATH_SITE, 'en-GB', true);
		$lang->load('com_taxibooking', JPATH_SITE, null, true);
		
		$emailSubject = JText::sprintf(
			'TBSCHEDULES_ARCHIVE_ORDER_EMAIL_SUBJECT',
			$SiteName
		);
		
		jimport( 'joomla.html.html' );
		$now =  JHtml::date('now', 'Y-m-d H:i:s'); 
		$checking_time = strtotime($now) - 86400;
		
		// now collect orders for which dropoff just passes 24 hour
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_orders');
		$query->where('(datetime1+duration) < '.$db->Quote($checking_time));
		$query->where('state != -1');
		$db->setQuery((string)$query);
		$orders = $db->loadObjectList();
		
		if(!empty($orders))
		{
			require_once JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'security.php';
			$security = new TaxibookingSecurity();

			foreach($orders as $row_queue)
			{
				// convert distance to mile if it is in KM
				if($elsettings->distance_unit=="kM"){
					$distance_miles = (float)$row_queue->distance * 0.621371;
				}
				else {
					$distance_miles = (float)$row_queue->distance;
				}
				
				$duration_seconds = (int)$row_queue->duration;
				$tb_order_id = (int)$row_queue->id;
				
				$string = rtrim(JURI::root(), '/')."||".$row_queue->names."||".$row_queue->email."||".$distance_miles."||".$duration_seconds."||".$tb_order_id."||".$row_queue->language;
				
				$publicKey = $security->genRandString(32);
				$encryptedData = $security->encrypt($string, $publicKey);
				$encodedData = rawurlencode($encryptedData);
				
				$review_url = 'https://kabsky.co.uk/reviews';
				//$review_url = '#';
				//$review_url .= "public={$publicKey}&data={$encodedData}";
				
				//Only archive if the time passed for the pickup or return
				if (empty($row_queue->datetime2) || $row_queue->datetime2 < $checking_time)
				{
				$temp = new stdClass();
				$temp->id = $row_queue->id;
				$temp->state = -1; // Archived
				$temp->modified = $now;
				
				$db->updateObject('#__taxibooking_orders', $temp, 'id');
				}
				
				// Rejected orders will be archived only, but review email will not be sent
				if((int)$row_queue->state!=0)
				{
					ob_start();
					include( JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'templates'.DS.'order_emails'.DS.'archive_email.tpl.php' );
					$emailBody = ob_get_contents();
					ob_end_clean();
					
					$mailer = JFactory::getMailer();
					$mailer->setSender(array($MailFrom, $FromName));
					$mailer->setSubject($emailSubject);
					$mailer->setBody($emailBody);
					$mailer->IsHTML(true);
					$mailer->addRecipient($row_queue->email);
					$rs	= $mailer->Send();
				}
			}
		}
		
		return;
	}
	
	/**
	 * Method to send email everyone 5 days before Item end date
	 */
	private function _sendTbcorporateInvoice()
	{
		//initialise variables
		$app = JFactory::getApplication();
		$config = JFactory::getConfig();
		$db =  JFactory::getDBO();
		$uri	= JURI::getInstance();
		$base	= $uri->toString(array('scheme', 'host', 'port'));
		$lang = JFactory::getLanguage();
		$lang_tag = $lang->getTag();
		$lang->load('com_tbcorporate', JPATH_SITE, 'en-GB', true);
		$lang->load('com_tbcorporate', JPATH_SITE, null, true);
		
		$days_before_send_invoice = $this->params->get('tbcorporate_invoice_send_days', 5);
		
		// Compile the notification mail values.
		$data = array();
		$data['fromname']	= $config->get('fromname');
		$data['mailfrom']	= $config->get('mailfrom');
		$data['sitename']	= $config->get('sitename');
		$data['siteurl']	= JUri::root();
		
		$sql = 'SELECT *, DATEDIFF(LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 0 MONTH)),now()) days_left 
			FROM #__tbcorporate_client_invoices  
			WHERE DATEDIFF(LAST_DAY(DATE_SUB(CURDATE(), INTERVAL 0 MONTH)),now()) = '.(int)$days_before_send_invoice;
		$db->setQuery($sql);
		$rows = $db->loadObjectList();
		
		if(!empty($rows))
		{
			require_once JPATH_ROOT.DS.'components'.DS.'com_tbcorporate'.DS.'helpers'.DS.'tbcorporate.php';
			require_once JPATH_ROOT.DS.'components'.DS.'com_tbcorporate'.DS.'helpers'.DS.'route.php';
			
			$tbcorporate_config = TbcorporateHelperFront::getSettings();
			
			// glean language specific header and footer info
			$header_info = $tbcorporate_config->header_info;
			$header_info = TbcorporateHelperFront::changeEditorImageUrl($header_info[$lang_tag]);
			
			$footer_info = $tbcorporate_config->footer_info;
			$footer_info = TbcorporateHelperFront::changeEditorImageUrl($footer_info[$lang_tag]);
			
			foreach($rows as $row)
			{
				$clientObj = TbcorporateHelperFront::getClient($row->client_id);
				
				$first_date = $row->invoice_year.'-'.str_pad($row->invoice_month, 2, '0', STR_PAD_LEFT).'-01';
				$due_date = date("Y-m-t", strtotime($first_date));
				
				if($row->front_url!=""){
					$item_url = $row->front_url;
				}
				else {
					$item_url = JURI::root().TbcorporateHelperRoute::getInvoiceRoute($row->id);
				}
				
				$emailSubject	= JText::sprintf(
					'COM_TBCORPORATE_INVOICE_EMAIL_SUBJECT',
					$row->invoice_number,
					$data['sitename']
				);
				
				$emailBody = $header_info.'<br/>';
				$emailBody .= JText::sprintf(
					'COM_TBCORPORATE_INVOICE_EMAIL_BODY',					
					$clientObj->name,
					$row->invoice_number,
					$due_date,
					$item_url,
					$data['sitename']
				);
				$emailBody .= '<br/>'.$footer_info;
				
				$mail =  JFactory::getMailer();
				$mail->setSender(array($data['mailfrom'], $data['fromname']));
				$mail->setSubject($emailSubject);
				$mail->setBody($emailBody);
				$mail->IsHTML(true);
				$mail->addRecipient($clientObj->email, $clientObj->name);
				$sent = $mail->Send();
			}
		}
		
		return;
	}
	
	// Method to send tomorrow orders reminder
	private function _sendNewOrdersReminder()
	{
		$db = JFactory::getDBO();
		$user =  JFactory::getUser();
		$config = JFactory::getConfig();
		
		$FromName	= $config->get('fromname');
		$MailFrom	= $config->get('mailfrom');
		$SiteName	= $config->get('sitename');
		
		$elsettings =  booking_helper::config();
		
		$lang = JFactory::getLanguage();
		$lang->load('com_taxibooking', JPATH_SITE, 'en-GB', true);
		$lang->load('com_taxibooking', JPATH_SITE, null, true);
		$lang->load('plg_system_tbschedules',JPATH_ADMINISTRATOR);
		
		$emailSubject = JText::_('COM_TAXIBOOKING_NEW_ORDERS_REMINDER_SUBJECT');
		
		jimport( 'joomla.html.html' );
		$tomorrow =  JHtml::date(strtotime("+1 day"), 'Y-m-d');
		
		// now collect orders for which dropoff just passes 24 hour
		$query = $db->getQuery(true);
		$query->select('o.*');
		$query->from('#__taxibooking_orders AS o');
		
		// Join over the payment methods 
		$query->select('pm.title AS payment_method')
			->join('LEFT', $db->quoteName('#__taxibooking_paymentmethods') . ' AS pm ON pm.id = o.payment');
		$query->where('(o.state = 1 OR o.state = -2)'); // Apporved OR Pending
		$query->where('o.reminder_sent = 0 OR o.return_reminder_sent = 0'); //Reminder is not sent already for either the original or return trip
		$query->order('o.datetime1 ASC');
		$db->setQuery((string)$query);
		$orders = $db->loadObjectList();
		
		//echo '<pre>';
		//print_r($orders);
		
		$tomorrow_orders = $order_customers = $order_drivers = array();
		if(!empty($orders))
		{
			foreach($orders as $order)
			{
				// check Pickup time for this order
				// if it is not tomorrow, skip
				
				
				if(($tomorrow == date('Y-m-d', $order->datetime1) && $order->reminder_sent == 0) or $tomorrow == date('Y-m-d', intval($order->datetime2))){
				    
				    
					$tomorrow_orders[] = $order;
					
					$query = $db->getQuery(true);
					$query->select('user_id');
					$query->from('#__taxibooking_users');
					$query->where('email = '.$db->Quote($order->email));
					$db->setQuery((string)$query);
					$tbUser = $db->loadObject();
					
					if(isset($order_customers[$tbUser->user_id])){
						$order_customers[$tbUser->user_id][] = $order;
					}
					else {
						$order_customers[$tbUser->user_id] = array();
						$order_customers[$tbUser->user_id][] = $order;
					}
					
					if($order->driver_id > 0)
					{
						if(isset($order_drivers[$order->driver_id])){
							$order_drivers[$order->driver_id][] = $order;
						}
						else {
							$order_drivers[$order->driver_id] = array();
							$order_drivers[$order->driver_id][] = $order;
						}
					}
				}
				else {
					continue;
				}
			}
		}
		
		// collect company wise Admins, Drivers and Users list
		if(!empty($tomorrow_orders))
		{
			$tableHeader = '<table border="0" width="100%">';
			$tableFooter = '</table>';
			
			require_once JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'helpers'.DS.'route.php';
			
			// first admins, admins will get all tomorrow orders
			$query = 'SELECT u.id, u.email, u.name' .
				' FROM #__users AS u' .
				' LEFT JOIN #__user_usergroup_map AS gu ON gu.user_id = u.id' .
				' WHERE (gu.group_id = 8 OR gu.group_id = 7) ' .
				' AND u.sendEmail = 1 AND u.block = 0';
			$db->setQuery($query);
			$adminRows = $db->loadObjectList();
			
			// now generate email template for order
			$adminEmailBody = $tableHeader;
			
			foreach($tomorrow_orders as $order)
			{
				$adminEmailBody .= $this->_generateEmailTemplate($order, true);
				
				// update reminder sent for this order
				$dataObj = new stdClass();
				$dataObj->id = $order->id;
				$dataObj->reminder_sent = 1;
				if ($tomorrow == date('Y-m-d', intval($order->datetime2)))
						{
						    $dataObj->return_reminder_sent = 1;
						}
				$db->updateObject('#__taxibooking_orders', $dataObj, 'id');					
			}
			
			$adminEmailBody .= $tableFooter;
			
			$admin_emails = array();
			if(!empty($adminRows))
			{
				foreach($adminRows as $adminRow)
				{
					$admin_emails[] = $adminRow->email;
					
					$emailBody = 'Hi '.$adminRow->name.',<br/>';
					$emailBody .= 'here is a list of Orders for tomorrow ('.$tomorrow.'):<br/><br/>';
					$emailBody .= $adminEmailBody;
					//print $emailBody;
					
					$mail =  JFactory::getMailer();
					$mail->setSender(array($MailFrom, $FromName));
					$mail->setSubject($emailSubject);
					$mail->setBody($emailBody);
					$mail->IsHTML(true);
					$mail->addRecipient($adminRow->email);
					$sent = $mail->Send();
				}
			}
			
			// drivers will get orders only assigned to him
			if(!empty($order_drivers))
			{
				foreach($order_drivers as $driver_id => $driver_orders)
				{
					$query = $db->getQuery(true);
					$query->select('name, email');
					$query->from('#__taxibooking_users');
					$query->where('user_id = '.(int)$driver_id);
					$db->setQuery((string)$query);
					$driverRow = $db->loadObject();
					
					// email template for driver
					$userEmailBody = $tableHeader;
					
					foreach($driver_orders as $driver_order)
					{
						$userEmailBody .= $this->_generateEmailTemplate($driver_order);
						
						// update reminder sent for this order
						$dataObj = new stdClass();
						$dataObj->id = $driver_order->id;
						$dataObj->reminder_sent = 1;
						if ($tomorrow == date('Y-m-d', intval($order->datetime2)))
						{
						    $dataObj->return_reminder_sent = 1;
						}
						$db->updateObject('#__taxibooking_orders', $dataObj, 'id');					
					}
					
					$userEmailBody .= $tableFooter;
					
					$driver_emails[] = $driverRow->email;
					
					$emailBody = 'Hi '.$driverRow->name.',<br/>';
					$emailBody .= 'here is a list of Orders for tomorrow ('.$tomorrow.'):<br/><br/>';
					$emailBody .= $userEmailBody;
					//print $emailBody;
					
					$mail =  JFactory::getMailer();
					$mail->setSender(array($MailFrom, $FromName));
					$mail->setSubject($emailSubject);
					$mail->setBody($emailBody);
					$mail->IsHTML(true);
					$mail->addRecipient($driverRow->email);
					$sent = $mail->Send();
				}
			}
			
			
			// drivers will get orders only assigned to him
			if(!empty($order_customers))
			{
				foreach($order_customers as $customer_id => $customer_orders)
				{
					$query = $db->getQuery(true);
					$query->select('name, email');
					$query->from('#__taxibooking_users');
					$query->where('user_id = '.$db->Quote($customer_id));
					$db->setQuery((string)$query);
					$customer = $db->loadObject();
					
					// email template for driver
					$userEmailBody = $tableHeader;
					
					foreach($customer_orders as $customer_order)
					{
						$userEmailBody .= $this->_generateEmailTemplate($customer_order);
						
						// update reminder sent for this order
						$dataObj = new stdClass();
						$dataObj->id = $customer_order->id;
						$dataObj->reminder_sent = 1;
						if ($tomorrow == date('Y-m-d', intval($order->datetime2)))
						{
						    $dataObj->return_reminder_sent = 1;
						}
						$db->updateObject('#__taxibooking_orders', $dataObj, 'id');					
					}
					
					$userEmailBody .= $tableFooter;
					
					$emailBody = 'Hi '.$customer->name.',<br/>';
					$emailBody .= 'here is a list of Orders for tomorrow ('.$tomorrow.'):<br/><br/>';
					$emailBody .= $userEmailBody;
					//print $emailBody;
					
					$mail =  JFactory::getMailer();
					$mail->setSender(array($MailFrom, $FromName));
					$mail->setSubject($emailSubject);
					$mail->setBody($emailBody);
					$mail->IsHTML(true);
					$mail->addRecipient($customer->email);
					$sent = $mail->Send();
				}
			}
		}
		return;
	}
	
	private function _generateEmailTemplate($order, $is_admin = false)
	{
		$elsettings =  booking_helper::config();
		
		$order_html = '';
		$order_html .= '<tr width="100%"><td>Order number:</td><td>'.$order->order_number.'</td></tr>';
		$order_html .= '<tr width="100%"><td>Order status:</td><td>'.booking_helper::get_order_status_text($order).'</td></tr>';
		$order_html .= '<tr width="100%"><td>By:</td><td>'.$order->names.'</td></tr>';
		$order_html .= '<tr width="100%"><td>Telephone:</td><td>'.$order->phone.'</td></tr>';
		$order_html .= '<tr width="100%"><td><strong>Date/Time:</strong></td><td><strong>'.booking_helper::get_order_pickup_date($order, $elsettings).'</strong></td></tr>';
		
		if($order->booking_type=='hourly'){
		    $order_html .= '<tr width="100%"><td>'.JText::_('HOURLY_HIRE_VEHICLE_HIRED_FOR').':</td><td>'.$order->hourly_hr.':'.$order->hourly_min.' hrs</td></tr>';
		}
		else {
		    if ($order->returntrip == 1)
		    {
		    $order_html .= '<tr width="100%"><td>'.JText::_('FROM').':</td><td>'.$order->begin.'</td></tr>';
		    $order_html .= '<tr width="100%"><td>'.JText::_('TO').':</td><td>'.$order->end.'</td></tr>';
		    $order_html .= '<tr width="100%"><td>'.JText::_('Return?').':</td><td>'.JText::_('Yes').'</td></tr>';
		    $order_html .= '<tr width="100%"><td><strong>Return Date/Time:</strong></td><td><strong>'.booking_helper::get_order_pickup_return_date($order, $elsettings).'</strong></td></tr>';
		    }
		    else
		    {
		    $order_html .= '<tr width="100%"><td>'.JText::_('FROM').':</td><td>'.$order->begin.'</td></tr>';
		    $order_html .= '<tr width="100%"><td>'.JText::_('TO').':</td><td>'.$order->end.'</td></tr>';
		    $order_html .= '<tr width="100%"><td>'.JText::_('Return?').':</td><td>'.JText::_('No').'</td></tr>';
		    }
		}
		
		$order_html .= '<tr width="100%"><td>Payment method:</td><td>'.booking_helper::get_order_payment($order).'</td></tr>';
		$order_html .= '<tr width="100%"><td>Total:</td><td>'.booking_helper::price_display($order->cprice, $elsettings).'</td></tr>';
		
		if($is_admin){
			$order_url = JURI::root().'administrator/index.php?option=com_taxibooking&controller=orders&task=show&cid[]='.$order->id;
		}
		else {
			// In future, this should recirect user to Iframe booking form in My Orders tab instead of Order list view
			//$order_url = JURI::root().TaxibookingHelperRoute::getBookingFormRoute().'&booking_type=orders&oid='.$order->order_number;
			$order_url = JURI::root().'index.php?option=com_taxibooking&view=order&cid='.$order->id.'&Itemid='.TaxibookingHelperRoute::getOrdersItemid();
		}
		
		
		
		$order_html .= '<tr width="100%"><td colspan="2"><a href="'.$order_url.'" target="_blank">More details</a></td></tr>
			    <tr width="100%"><td colspan="2">&nbsp;</td></tr>';
			    
		return $order_html;
	}
	
	/**
	 * Sets the timestamp for a specific scheduling task
	 *
	 * @param $key string The scheduling task key to set the timestamp parameter for
	 */
	private function _tbSetTimestamp($key)
	{
		$pk = 'timestamp_' . $key;
		$db = JFactory::getDbo();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_settings');
		$query->where('id = 1');
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		
		if($row)
		{
			$params = unserialize($row->params);
			$params[$pk] = time();
			
			$object = new stdClass();
			$object->id = 1;
			$object->params = serialize($params);
			
			$result = $db->updateObject('#__taxibooking_settings', $object, 'id');
		}
	}

	/**
	 * Gets the last recorded timestamp for a specific scheduling task
	 *
	 * @param $key string The scheduling task key to retrieve the timestamp parameter
	 *
	 * @return int UNIX timestamp
	 */
	private function _tbgetTimestamp($key)
	{
		$db = JFactory::getDbo();
		
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__taxibooking_settings');
		$query->where('id = 1');
		$db->setQuery((string)$query);
		$row = $db->loadObject();
		$tbsettings = unserialize($row->params);
		
		$pk = 'timestamp_' . $key;

		if (!isset($tbsettings[$pk]))
		{
			return 0;
		}

		return $tbsettings[$pk];
	}
}
