<?php

defined ('_JEXEC') or die('Restricted access');

if(!class_exists('tbPaymentPlugin')) {
	require(JPATH_ROOT.DS.'components'.DS.'com_taxibooking'.DS.'classes'.DS.'tbpayment_plugin_helper.php');
}

class plgTbPaymentCash extends tbPaymentPlugin {
	
	var $_name = 'cash';
	
	function __construct (& $subject, $config) {

		parent::__construct ($subject, $config);
		
		$this->_loggable = TRUE;
		$this->tableFields = array_keys ($this->getTableSQLFields ());
	}
	
	/**
	 * Create the table for this plugin if it does not yet exist.
	 */
	public function getTbPluginCreateTableSQL () {

		return $this->createTableSQL ('Payment Cash Table');
	}

	/**
	 * Fields to create the payment table
	 *
	 * @return string SQL Fileds
	 */
	function getTableSQLFields () {

		$SQLfields = array(
			'id'                          => 'int(1) UNSIGNED NOT NULL AUTO_INCREMENT',
			'order_id'         		=> 'int(1) UNSIGNED',
			'order_number'                => 'char(64)',
			'paymentmethod_id' 		=> 'mediumint(1) UNSIGNED',
			'payment_name'                => 'varchar(5000)',
			'payment_order_total'         => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
			'payment_currency'            => 'char(3)',
			'cost_per_transaction'        => 'decimal(10,2)',
			'cost_percent_total'          => 'decimal(10,2)'
		);

		return $SQLfields;
	}
	
	/**
	 * plgTbDisplayListFEPayment
	 * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
	 *
	 * @param integer $selected ID of the method selected
	 * @return boolean True on succes, false on failures, null when this plugin was not selected.
	 * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
	 */
	public function plgTbDisplayListFEPayment ($selected = 0, &$htmlIn) {
		return $this->displayListFE ($selected, $htmlIn);
	}
	
	/**
	 * @param                $method
	 * @param                $cart_prices
	 * @return int
	 */
	function getCosts ($method, $cart_price) {

		if (preg_match ('/%$/', $method->cost_percent_total)) {
			$cost_percent_total = substr ($method->cost_percent_total, 0, -1);
		} else {
			$cost_percent_total = $method->cost_percent_total;
		}
		return ($method->cost_per_transaction + ($cart_price * $cost_percent_total * 0.01));
	}
	/**
	 * Check if the payment conditions are fulfilled for this payment method
	 *
	 */
	protected function checkConditions ($method, $cart_price) {

		$this->convert ($method);

		$amount = $cart_price;
		
		$amount_cond = ($amount >= $method->min_amount AND $amount <= $method->max_amount
			OR
			($method->min_amount <= $amount AND ($method->max_amount == 0)));
		
		if (!$amount_cond) {
			return FALSE;
		}
		
		return TRUE;
	}

	function convert ($method) {

		$method->min_amount = (float)$method->min_amount;
		$method->max_amount = (float)$method->max_amount;
	}
	
	/**
	 * @param array          $cart_prices
	 * @param                $cart_prices_name
	 * @return bool|null
	 */
	public function plgTbonSelectedCalculatePricePayment($method_id, $cart_prices, &$cart_prices_name) {

		return $this->onSelectedCalculatePrice($method_id, $cart_prices, $cart_prices_name);
	}
	
	/**
	 * This event triggers after order submit
	 */
	public function plgTbOrderSubmit ($order) {

		if (!($method = $this->getPluginMethod ($order->payment))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}

		// Get the page/component configuration
		$elsettings = booking_helper::config();
		
		$dbValues['payment_name'] = $this->renderPluginName ($method);
		$dbValues['order_id'] = $order->id;
		$dbValues['order_number'] = $order->order_number;
		$dbValues['paymentmethod_id'] = $order->payment;
		$dbValues['cost_per_transaction'] = $method->cost_per_transaction;
		$dbValues['cost_percent_total'] = $method->cost_percent_total;
		$dbValues['payment_currency'] = $elsettings->currency;
		$dbValues['payment_order_total'] = $order->cprice;
		
		$this->storePluginInternalData ($dbValues);
		
		return TRUE;
	}
	
	/**
	 * This event triggers after order submit, redrects user to payment gateway
	 */
	public function plgTbProcessPayment($order){
		
		$session =  JFactory::getSession();
		$lang =  JFactory::getLanguage();
		$lang_tag = $lang->getTag();
		$redirect_url = TaxibookingHelperRoute::getBookingFormRoute($lang_tag);
		if($session->get('tmpl','')=='component'){
		    $redirect_url .= '&tmpl=component';
		}
		
		$html = JText::_('RECEIVE_CONFIRMATION_MAIL');
		$html .= '<br><br>'.JText::_('THANKS_MESSAGE');
		$html .= '&nbsp;<a href="'.JRoute::_($redirect_url, false).'">';
                $html .=  JText::_('CONTINUE_BOOKING');
                $html .=  '</a>';

		JRequest::setVar ('html', $html);
		
		return TRUE;
	}
	
	/**
	 * Display stored payment data for an order
	 */
	function plgTbOnShowOrderBEPayment ($order_id, $payment_id) {

		if (!$this->selectedThisByMethodId ($payment_id)) {
			return NULL; // Another method was selected, do nothing
		}

		if (!($paymentTable = $this->getDataByOrderId ($order_id))) {
			return NULL;
		}

		$html = '<table class="adminlist">' . "\n";
		$html .= '<thead>
<tr>
<th class="key" colspan="2" style="text-align: center;">Payment Method</th>
</tr>
</thead>';
		$html .= '<tr>
<td class="key">' . JText::_ ('TBPAYMENT_CASH_PAYMENT_NAME') . '</td>
<td align="left">
<span class="payment_name">'.$paymentTable->payment_name.'</span>
<br>
</td>
</tr>';
		$html .= '<tr>
<td class="key">' . JText::_ ('TBPAYMENT_CASH_PAYMENT_TOTAL_CURRENCY') . '</td>
<td align="left">'.$paymentTable->payment_order_total . ' ' . $paymentTable->payment_currency.'</td>
</tr>';
		$html .= '</table>' . "\n";
		return $html;
	}
	
	/**
	 * Display stored payment data in confirmation emails and invoice
	 */
	function plgTbOnShowOrderEmailsInvoice ($order_id, $payment_id) {

		if (!$this->selectedThisByMethodId ($payment_id)) {
			return NULL; // Another method was selected, do nothing
		}

		if (!($payment = $this->getDataByOrderId ($order_id))) {
			return NULL;
		}
		
		$html = '';
		 
		$html .= '<tr>
<td width="35%">' . JText::_ ('TBPAYMENT_CASH_PAYMENT_NAME') . ':</td>
<td width="35%">'.$payment->payment_name.'</td>
</tr>';
		
		return $html;
	}
}